/*! elementor - v3.31.0 - 09-09-2025 */
/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "../app/assets/js/utils/utils.js":
/*!***************************************!*\
  !*** ../app/assets/js/utils/utils.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.stringToRemValues = exports.rgbToHex = exports.pxToRem = exports.isOneOf = exports.arrayToObjectByKey = exports.arrayToClassName = void 0;
var _typeof2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js"));
var pxToRem = exports.pxToRem = function pxToRem(pixels) {
  if (!pixels) {
    return;
  } else if ('string' !== typeof pixels) {
    pixels = pixels.toString();
  }
  return pixels.split(' ').map(function (value) {
    return "".concat(value * 0.0625, "rem");
  }).join(' ');
};
var arrayToClassName = exports.arrayToClassName = function arrayToClassName(array, action) {
  return array.filter(function (item) {
    return 'object' === (0, _typeof2.default)(item) ? Object.entries(item)[0][1] : item;
  }).map(function (item) {
    var value = 'object' === (0, _typeof2.default)(item) ? Object.entries(item)[0][0] : item;
    return action ? action(value) : value;
  }).join(' ');
};
var stringToRemValues = exports.stringToRemValues = function stringToRemValues(string) {
  return string.split(' ').map(function (value) {
    return pxToRem(value);
  }).join(' ');
};
var rgbToHex = exports.rgbToHex = function rgbToHex(r, g, b) {
  return '#' + [r, g, b].map(function (x) {
    var hex = x.toString(16);
    return 1 === hex.length ? '0' + hex : hex;
  }).join('');
};
var isOneOf = exports.isOneOf = function isOneOf(filetype, filetypeOptions) {
  return filetypeOptions.some(function (type) {
    return filetype.includes(type);
  });
};
var arrayToObjectByKey = exports.arrayToObjectByKey = function arrayToObjectByKey(array, key) {
  var finalObject = {};
  array.forEach(function (item) {
    return finalObject[item[key]] = item;
  });
  return finalObject;
};

/***/ }),

/***/ "../assets/dev/js/editor/command-bases/command-container-base.js":
/*!***********************************************************************!*\
  !*** ../assets/dev/js/editor/command-bases/command-container-base.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _commandBase = _interopRequireDefault(__webpack_require__(/*! elementor-api/modules/command-base */ "../modules/web-cli/assets/js/modules/command-base.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/**
 * @name $e.modules.editor.CommandContainerBase
 */
var CommandContainerBase = exports["default"] = /*#__PURE__*/function (_CommandBase) {
  function CommandContainerBase() {
    (0, _classCallCheck2.default)(this, CommandContainerBase);
    return _callSuper(this, CommandContainerBase, arguments);
  }
  (0, _inherits2.default)(CommandContainerBase, _CommandBase);
  return (0, _createClass2.default)(CommandContainerBase, [{
    key: "requireContainer",
    value:
    /**
     * Function requireContainer().
     *
     * Validate `arg.container` & `arg.containers`.
     *
     * @param {{}} args
     *
     * @throws {Error}
     */
    function requireContainer() {
      var _this = this;
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.args;
      if (!args.container && !args.containers) {
        throw Error('container or containers are required.');
      }
      if (args.container && args.containers) {
        throw Error('container and containers cannot go together please select one of them.');
      }
      var containers = args.containers || [args.container];
      containers.forEach(function (container) {
        _this.requireArgumentInstance('container', elementorModules.editor.Container, {
          container: container
        });
      });
    }
  }], [{
    key: "getInstanceType",
    value: function getInstanceType() {
      return 'CommandContainerBase';
    }
  }]);
}(_commandBase.default);

/***/ }),

/***/ "../assets/dev/js/editor/component-base.js":
/*!*************************************************!*\
  !*** ../assets/dev/js/editor/component-base.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _componentBase = _interopRequireDefault(__webpack_require__(/*! elementor-api/modules/component-base */ "../modules/web-cli/assets/js/modules/component-base.js"));
var _editor = _interopRequireDefault(__webpack_require__(/*! elementor-panel/pages/editor */ "../assets/dev/js/editor/regions/panel/pages/editor.js"));
var _baseData = _interopRequireDefault(__webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var ComponentBase = exports["default"] = /*#__PURE__*/function (_ApiComponentBase) {
  function ComponentBase() {
    (0, _classCallCheck2.default)(this, ComponentBase);
    return _callSuper(this, ComponentBase, arguments);
  }
  (0, _inherits2.default)(ComponentBase, _ApiComponentBase);
  return (0, _createClass2.default)(ComponentBase, [{
    key: "activateControl",
    value:
    /**
     * Call the activate of the control's view
     *
     * @param {string} controlPath
     */
    function activateControl(controlPath) {
      var _controlView$activate;
      if (!controlPath) {
        return;
      }
      var editor = elementor.getPanelView().getCurrentPageView();
      var currentView = editor.content ? editor.content.currentView : editor;
      var controlView = this.getControlViewByPath(currentView, controlPath);
      (_controlView$activate = controlView.activate) === null || _controlView$activate === void 0 || _controlView$activate.call(controlView);
    }

    /**
     * Get the control's view by path
     *
     * @param {EditorView} currentView
     * @param {string}     controlPath
     *
     * @return {ControlBaseDataView}
     */
  }, {
    key: "getControlViewByPath",
    value: function getControlViewByPath(currentView, controlPath) {
      var controls = controlPath.split('/');
      var controlView = currentView.getControlViewByName(controls[0]);
      controls.slice(1).forEach(function (control) {
        var _controlView$getChild, _controlView;
        controlView = (_controlView$getChild = (_controlView = controlView).getChildControlView) === null || _controlView$getChild === void 0 ? void 0 : _controlView$getChild.call(_controlView, control);
      });
      return controlView;
    }
  }]);
}(_componentBase.default);

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/commands-internal/index.js":
/*!************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/commands-internal/index.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Validate", ({
  enumerable: true,
  get: function get() {
    return _validate.Validate;
  }
}));
var _validate = __webpack_require__(/*! ./validate */ "../assets/dev/js/editor/components/browser-import/commands-internal/validate.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/commands-internal/validate.js":
/*!***************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/commands-internal/validate.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Validate = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Validate = exports.Validate = /*#__PURE__*/function (_$e$modules$CommandBa) {
  function Validate() {
    (0, _classCallCheck2.default)(this, Validate);
    return _callSuper(this, Validate, arguments);
  }
  (0, _inherits2.default)(Validate, _$e$modules$CommandBa);
  return (0, _createClass2.default)(Validate, [{
    key: "apply",
    value:
    /**
     * @inheritDoc
     */
    function apply(args) {
      var input = args.input,
        _args$options = args.options,
        options = _args$options === void 0 ? {} : _args$options;
      return this.component.manager.createSession(input, elementor.getPreviewContainer(), options).then(function (session) {
        return session.validate();
      });
    }
  }]);
}($e.modules.CommandBase);
var _default = exports["default"] = Validate;

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/commands/import.js":
/*!****************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/commands/import.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Import = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Import = exports.Import = /*#__PURE__*/function (_$e$modules$CommandBa) {
  function Import() {
    (0, _classCallCheck2.default)(this, Import);
    return _callSuper(this, Import, arguments);
  }
  (0, _inherits2.default)(Import, _$e$modules$CommandBa);
  return (0, _createClass2.default)(Import, [{
    key: "validateArgs",
    value:
    /**
     * @inheritDoc
     */
    function validateArgs() {
      this.requireArgumentInstance('target', elementorModules.editor.Container);
    }

    /**
     * @inheritDoc
     */
  }, {
    key: "apply",
    value: function apply(args) {
      var _this = this;
      var _args$targets = args.targets,
        targets = _args$targets === void 0 ? [args.target] : _args$targets,
        input = args.input,
        _args$options = args.options,
        options = _args$options === void 0 ? {} : _args$options,
        result = [];
      targets.forEach(function (target) {
        result.push(_this.component.manager.createSession(input, target, options).then(/*#__PURE__*/function () {
          var _ref = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(session) {
            return _regenerator.default.wrap(function (_context) {
              while (1) switch (_context.prev = _context.next) {
                case 0:
                  _context.next = 1;
                  return session.validate();
                case 1:
                  if (!_context.sent) {
                    _context.next = 2;
                    break;
                  }
                  session.apply();
                case 2:
                case "end":
                  return _context.stop();
              }
            }, _callee);
          }));
          return function (_x) {
            return _ref.apply(this, arguments);
          };
        }()));
      });
      return Promise.all(result);
    }
  }]);
}($e.modules.CommandBase);
var _default = exports["default"] = Import;

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/commands/index.js":
/*!***************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/commands/index.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Import", ({
  enumerable: true,
  get: function get() {
    return _import.Import;
  }
}));
var _import = __webpack_require__(/*! ./import */ "../assets/dev/js/editor/components/browser-import/commands/import.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/component.js":
/*!**********************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/component.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var commands = _interopRequireWildcard(__webpack_require__(/*! ./commands */ "../assets/dev/js/editor/components/browser-import/commands/index.js"));
var commandsInternal = _interopRequireWildcard(__webpack_require__(/*! ./commands-internal */ "../assets/dev/js/editor/components/browser-import/commands-internal/index.js"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Component = exports["default"] = /*#__PURE__*/function (_$e$modules$Component) {
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _callSuper(this, Component, arguments);
  }
  (0, _inherits2.default)(Component, _$e$modules$Component);
  return (0, _createClass2.default)(Component, [{
    key: "getNamespace",
    value: function getNamespace() {
      return 'editor/browser-import';
    }
  }, {
    key: "defaultCommands",
    value: function defaultCommands() {
      return this.importCommands(commands);
    }
  }, {
    key: "defaultCommandsInternal",
    value: function defaultCommandsInternal() {
      return this.importCommands(commandsInternal);
    }
  }]);
}($e.modules.ComponentBase);

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/container-factory.js":
/*!******************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/container-factory.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _element = _interopRequireDefault(__webpack_require__(/*! elementor-elements/models/element */ "../assets/dev/js/editor/elements/models/element.js"));
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
/**
 * @typedef {import('../../container/container')} Container
 */
var ContainerFactory = exports["default"] = /*#__PURE__*/function () {
  function ContainerFactory() {
    (0, _classCallCheck2.default)(this, ContainerFactory);
  }
  return (0, _createClass2.default)(ContainerFactory, null, [{
    key: "createElementContainer",
    value:
    /**
     * Create an element container.
     *
     * @param {*} element
     * @return {Container} element container
     */
    function createElementContainer(element) {
      var model = new _element.default(this.regenerateIds([Object.assign({
        elType: (element === null || element === void 0 ? void 0 : element.elType) || 'widget'
      }, element)])[0]);
      return new elementorModules.editor.Container({
        id: model.get('id'),
        type: model.get('elType'),
        settings: model.get('settings'),
        model: model,
        parent: false
      });
    }
  }, {
    key: "regenerateIds",
    value: function regenerateIds(elements) {
      var _iterator = _createForOfIteratorHelper(elements),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var element = _step.value;
          element.id = elementorCommon.helpers.getUniqueId().toString();
          if (element.elements) {
            this.regenerateIds(element.elements);
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      return elements;
    }
  }]);
}();

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/default-config.js":
/*!***************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/default-config.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof3 = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _typeof2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js"));
var readers = _interopRequireWildcard(__webpack_require__(/*! ./files/readers */ "../assets/dev/js/editor/components/browser-import/files/readers/index.js"));
var parsers = _interopRequireWildcard(__webpack_require__(/*! ./files/parsers */ "../assets/dev/js/editor/components/browser-import/files/parsers/index.js"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof3(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
/**
 * Recursively convert objects to arrays of values.
 *
 * @param {*} object
 * @return {[]} values
 */
var recursiveValues = function recursiveValues(object) {
  return Object.values(object).map(function (value) {
    return 'object' === (0, _typeof2.default)(value) ? Object.values(value) : value;
  });
};
var _default = exports["default"] = {
  readers: recursiveValues(readers),
  parsers: recursiveValues(parsers).flat()
};

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/file-parser-base.js":
/*!***********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/file-parser-base.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
/**
 * @typedef {import('../../../container/container')} Container
 */
/**
 * @typedef {import('./file-reader-base')} FileReaderBase
 */
/**
 * @abstract
 */
var FileParserBase = exports["default"] = /*#__PURE__*/function () {
  /**
   * FileParseBase constructor.
   *
   * @param {FileReaderBase} reader
   */
  function FileParserBase(reader) {
    (0, _classCallCheck2.default)(this, FileParserBase);
    /**
     * The file-reader instance.
     *
     * @type {FileReaderBase}
     */
    (0, _defineProperty2.default)(this, "reader", void 0);
    /**
     * Tasks to complete, even after parsing completed.
     *
     * @type {[]}
     */
    (0, _defineProperty2.default)(this, "tasks", []);
    this.reader = reader;
  }

  /**
   * Get the file-parser name.
   *
   * @abstract
   * @return {string} name
   */
  return (0, _createClass2.default)(FileParserBase, [{
    key: "parse",
    value: (
    /**
     * Parse the the input as needed by this parser, and return Container objects to be processed.
     *
     * @abstract
     * @return {Container[]} containers
     */
    function () {
      var _parse = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
        return _regenerator.default.wrap(function (_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      function parse() {
        return _parse.apply(this, arguments);
      }
      return parse;
    }()
    /**
     * Here parsers can validate that an input from a reader can be handled by the parser. This validation has to be
     * very accurate and specific so if the parser can't handle the file for sure, the next parsers will have the
     * opportunity to do so.
     *
     * @param {*} reader
     *
     * @abstract
     * @return {boolean} is valid
     */
    )
  }], [{
    key: "getName",
    value: function getName() {
      return '';
    }

    /**
     * Get all readers the parser can handle with.
     *
     * @abstract
     * @return {string[]} readers
     */
  }, {
    key: "getReaders",
    value: function getReaders() {
      return [];
    }
  }, {
    key: "validate",
    value: (function () {
      var _validate = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee2(reader) {
        return _regenerator.default.wrap(function (_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              return _context2.abrupt("return", false);
            case 1:
            case "end":
              return _context2.stop();
          }
        }, _callee2);
      }));
      function validate(_x) {
        return _validate.apply(this, arguments);
      }
      return validate;
    }())
  }]);
}();

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/file-reader-base.js":
/*!***********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/file-reader-base.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
/**
 * @abstract
 */
var FileReaderBase = exports["default"] = /*#__PURE__*/function () {
  /**
   * FileReaderBase constructor.
   *
   * @param {File} file
   */
  function FileReaderBase(file) {
    (0, _classCallCheck2.default)(this, FileReaderBase);
    /**
     * The File instance.
     *
     * @type {File}
     */
    (0, _defineProperty2.default)(this, "file", void 0);
    this.file = file;
  }

  /**
   * Get the file-reader name.
   *
   * @abstract
   * @return {string} name
   */
  return (0, _createClass2.default)(FileReaderBase, [{
    key: "getFile",
    value:
    /**
     * Get the file-reader File object.
     *
     * @return {*} file
     */
    function getFile() {
      return this.file;
    }

    /**
     * Get the file-reader File object content as string.
     *
     * @return {Promise<string>} handler
     */
  }, {
    key: "getContent",
    value: (function () {
      var _getContent = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
        var fileReader, handler;
        return _regenerator.default.wrap(function (_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              fileReader = new FileReader(), handler = new Promise(function (resolve) {
                fileReader.onloadend = function () {
                  return resolve(fileReader.result);
                };
              });
              fileReader.readAsText(this.getFile());
              return _context.abrupt("return", handler);
            case 1:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function getContent() {
        return _getContent.apply(this, arguments);
      }
      return getContent;
    }()
    /**
     * Get the file-reader File object data url string.
     *
     * @return {Promise<string>} data URI
     */
    )
  }, {
    key: "getDataUrl",
    value: (function () {
      var _getDataUrl = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee2() {
        var fileReader, handler;
        return _regenerator.default.wrap(function (_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              fileReader = new FileReader(), handler = new Promise(function (resolve) {
                fileReader.onloadend = function () {
                  return resolve(fileReader.result);
                };
              });
              fileReader.readAsDataURL(this.getFile());
              return _context2.abrupt("return", handler);
            case 1:
            case "end":
              return _context2.stop();
          }
        }, _callee2, this);
      }));
      function getDataUrl() {
        return _getDataUrl.apply(this, arguments);
      }
      return getDataUrl;
    }())
  }], [{
    key: "getName",
    value: function getName() {
      return '';
    }

    /**
     * Check if the reader is currently active.
     *
     * @abstract
     * @return {boolean}
     */
  }, {
    key: "isActive",
    value: function isActive() {
      return true;
    }

    /**
     * Each file-reader can register the mime-types it supports in this method, so later a File object can be matched
     * to it accordingly.
     *
     * @abstract
     * @return {string[]} mime types
     */
  }, {
    key: "mimeTypes",
    get: function get() {
      return [];
    }

    /**
     * If the file-reader supports an input that's received without an explicit mime-type (such as strings or JavasScript
     * objects), here it can decide whether it can handle it and eventually return a suitable mime-type.
     *
     * @abstract
     * @param {*} input
     * @return {string|boolean} mime type
     */
  }, {
    key: "resolve",
    value: (function () {
      var _resolve = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee3(input) {
        return _regenerator.default.wrap(function (_context3) {
          while (1) switch (_context3.prev = _context3.next) {
            case 0:
              return _context3.abrupt("return", false);
            case 1:
            case "end":
              return _context3.stop();
          }
        }, _callee3);
      }));
      function resolve(_x) {
        return _resolve.apply(this, arguments);
      }
      return resolve;
    }()
    /**
     * Validate that a file can be handled by the file-reader, according to its mime-type.
     *
     * @param {File} file
     */
    )
  }, {
    key: "validate",
    value: (function () {
      var _validate = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee4(file) {
        return _regenerator.default.wrap(function (_context4) {
          while (1) switch (_context4.prev = _context4.next) {
            case 0:
              if (!this.validator) {
                this.validator = new RegExp(this.mimeTypes.join('|'), 'i');
              }
              return _context4.abrupt("return", this.validator.test(file.type));
            case 1:
            case "end":
              return _context4.stop();
          }
        }, _callee4, this);
      }));
      function validate(_x2) {
        return _validate.apply(this, arguments);
      }
      return validate;
    }())
  }]);
}();

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/parsers/base/index.js":
/*!*************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/parsers/base/index.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "MediaParser", ({
  enumerable: true,
  get: function get() {
    return _mediaParser.MediaParser;
  }
}));
var _mediaParser = __webpack_require__(/*! ./media-parser */ "../assets/dev/js/editor/components/browser-import/files/parsers/base/media-parser.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/parsers/base/media-parser.js":
/*!********************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/parsers/base/media-parser.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.MediaParser = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _fileParserBase = _interopRequireDefault(__webpack_require__(/*! elementor-editor/components/browser-import/files/file-parser-base */ "../assets/dev/js/editor/components/browser-import/files/file-parser-base.js"));
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/**
 * @abstract
 */
var MediaParser = exports.MediaParser = /*#__PURE__*/function (_FileParserBase) {
  function MediaParser() {
    (0, _classCallCheck2.default)(this, MediaParser);
    return _callSuper(this, MediaParser, arguments);
  }
  (0, _inherits2.default)(MediaParser, _FileParserBase);
  return (0, _createClass2.default)(MediaParser, [{
    key: "upload",
    value:
    /**
     * Upload a media file to the wordpress media library using the `wp/media` command.
     *
     * @param {*} file
     * @param {*} options
     * @return {{}} result
     */
    function upload(file) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      return $e.data.run('create', 'wp/media', {
        file: file,
        options: _objectSpread({
          progress: true
        }, options)
      }).catch(function (result) {
        elementor.notifications.showToast({
          message: result.message
        });
        return Promise.reject(result);
      });
    }
  }]);
}(_fileParserBase.default);

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/parsers/image/index.js":
/*!**************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/parsers/image/index.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Widget", ({
  enumerable: true,
  get: function get() {
    return _widget.Widget;
  }
}));
var _widget = __webpack_require__(/*! ./widget */ "../assets/dev/js/editor/components/browser-import/files/parsers/image/widget.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/parsers/image/widget.js":
/*!***************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/parsers/image/widget.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Widget = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _containerFactory = _interopRequireDefault(__webpack_require__(/*! ../../../container-factory */ "../assets/dev/js/editor/components/browser-import/container-factory.js"));
var _base = __webpack_require__(/*! ../base */ "../assets/dev/js/editor/components/browser-import/files/parsers/base/index.js");
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Widget = exports.Widget = /*#__PURE__*/function (_MediaParser) {
  function Widget() {
    (0, _classCallCheck2.default)(this, Widget);
    return _callSuper(this, Widget, arguments);
  }
  (0, _inherits2.default)(Widget, _MediaParser);
  return (0, _createClass2.default)(Widget, [{
    key: "parse",
    value: (
    /**
     * @inheritDoc
     */
    function () {
      var _parse = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
        var file, container, _t, _t2, _t3, _t4, _t5, _t6;
        return _regenerator.default.wrap(function (_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              file = this.reader.getFile();
              _t = _containerFactory.default;
              _context.next = 1;
              return this.reader.getDataUrl();
            case 1:
              _t2 = _context.sent;
              _t3 = file.name.split('.')[0];
              _t4 = {
                url: _t2,
                alt: _t3,
                source: 'library'
              };
              _t5 = {
                image: _t4
              };
              _t6 = {
                widgetType: 'image',
                settings: _t5
              };
              container = _t.createElementContainer.call(_t, _t6);
              this.upload(file).then(function (_ref) {
                var data = _ref.data;
                $e.internal('document/elements/set-settings', {
                  // The reason we use the container id and not the container instance itself is that the container
                  // created above is just a placeholder, which later recreated using the same id.
                  container: elementor.getContainer(container.id),
                  settings: {
                    image: {
                      url: data.source_url,
                      id: data.id
                    }
                  }
                });
              }).catch(function () {
                elementor.documents.getCurrent().history.setActive(false);
                $e.run('document/elements/reset-settings', {
                  container: elementor.getContainer(container.id),
                  options: {
                    external: true
                  }
                });
                elementor.documents.getCurrent().history.setActive(true);
              });
              return _context.abrupt("return", container);
            case 2:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function parse() {
        return _parse.apply(this, arguments);
      }
      return parse;
    }()
    /**
     * @inheritDoc
     */
    )
  }], [{
    key: "getName",
    value:
    /**
     * @inheritDoc
     */
    function getName() {
      return 'widget';
    }

    /**
     * @inheritDoc
     */
  }, {
    key: "getReaders",
    value: function getReaders() {
      return ['image'];
    }
  }, {
    key: "validate",
    value: (function () {
      var _validate = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee2() {
        return _regenerator.default.wrap(function (_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              return _context2.abrupt("return", true);
            case 1:
            case "end":
              return _context2.stop();
          }
        }, _callee2);
      }));
      function validate() {
        return _validate.apply(this, arguments);
      }
      return validate;
    }())
  }]);
}(_base.MediaParser);

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/parsers/index.js":
/*!********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/parsers/index.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.video = exports.json = exports.image = exports.base = void 0;
var _base = _interopRequireWildcard(__webpack_require__(/*! ./base */ "../assets/dev/js/editor/components/browser-import/files/parsers/base/index.js"));
exports.base = _base;
var _image = _interopRequireWildcard(__webpack_require__(/*! ./image */ "../assets/dev/js/editor/components/browser-import/files/parsers/image/index.js"));
exports.image = _image;
var _json = _interopRequireWildcard(__webpack_require__(/*! ./json */ "../assets/dev/js/editor/components/browser-import/files/parsers/json/index.js"));
exports.json = _json;
var _video = _interopRequireWildcard(__webpack_require__(/*! ./video */ "../assets/dev/js/editor/components/browser-import/files/parsers/video/index.js"));
exports.video = _video;
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/parsers/json/elements.js":
/*!****************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/parsers/json/elements.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Elements = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _fileParserBase = _interopRequireDefault(__webpack_require__(/*! ../../file-parser-base */ "../assets/dev/js/editor/components/browser-import/files/file-parser-base.js"));
var _containerFactory = _interopRequireDefault(__webpack_require__(/*! ../../../container-factory */ "../assets/dev/js/editor/components/browser-import/container-factory.js"));
var _filesUploadHandler = _interopRequireDefault(__webpack_require__(/*! ../../../../../utils/files-upload-handler */ "../assets/dev/js/editor/utils/files-upload-handler.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Elements = exports.Elements = /*#__PURE__*/function (_FileParserBase) {
  function Elements() {
    (0, _classCallCheck2.default)(this, Elements);
    return _callSuper(this, Elements, arguments);
  }
  (0, _inherits2.default)(Elements, _FileParserBase);
  return (0, _createClass2.default)(Elements, [{
    key: "parse",
    value: (
    /**
     * @inheritDoc
     */
    function () {
      var _parse = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
        return _regenerator.default.wrap(function (_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 1;
              return this.reader.getData();
            case 1:
              return _context.abrupt("return", _context.sent.content.map(function (element) {
                return _containerFactory.default.createElementContainer(element);
              }));
            case 2:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function parse() {
        return _parse.apply(this, arguments);
      }
      return parse;
    }()
    /**
     * @inheritDoc
     */
    )
  }], [{
    key: "getName",
    value:
    /**
     * @inheritDoc
     */
    function getName() {
      return 'elements';
    }

    /**
     * @inheritDoc
     */
  }, {
    key: "getReaders",
    value: function getReaders() {
      return ['json'];
    }
  }, {
    key: "validate",
    value: (function () {
      var _validate = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee3(reader) {
        var _this = this;
        return _regenerator.default.wrap(function (_context3) {
          while (1) switch (_context3.prev = _context3.next) {
            case 0:
              if (elementorCommon.config.filesUpload.unfilteredFiles) {
                _context3.next = 1;
                break;
              }
              return _context3.abrupt("return", new Promise(function (resolve) {
                var enableUnfilteredDialog = _filesUploadHandler.default.getUnfilteredFilesNotEnabledImportTemplateDialog(/*#__PURE__*/(0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee2() {
                  var result;
                  return _regenerator.default.wrap(function (_context2) {
                    while (1) switch (_context2.prev = _context2.next) {
                      case 0:
                        _context2.next = 1;
                        return _this.validateData(reader);
                      case 1:
                        result = _context2.sent;
                        resolve(result);
                      case 2:
                      case "end":
                        return _context2.stop();
                    }
                  }, _callee2);
                })));
                enableUnfilteredDialog.show();
              }));
            case 1:
              _context3.next = 2;
              return this.validateData(reader);
            case 2:
              return _context3.abrupt("return", _context3.sent);
            case 3:
            case "end":
              return _context3.stop();
          }
        }, _callee3, this);
      }));
      function validate(_x) {
        return _validate.apply(this, arguments);
      }
      return validate;
    }())
  }, {
    key: "validateData",
    value: function () {
      var _validateData = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee4(reader) {
        var data;
        return _regenerator.default.wrap(function (_context4) {
          while (1) switch (_context4.prev = _context4.next) {
            case 0:
              _context4.next = 1;
              return reader.getData();
            case 1:
              data = _context4.sent;
              return _context4.abrupt("return", data.version && data.type && Array.isArray(data.content));
            case 2:
            case "end":
              return _context4.stop();
          }
        }, _callee4);
      }));
      function validateData(_x2) {
        return _validateData.apply(this, arguments);
      }
      return validateData;
    }()
  }]);
}(_fileParserBase.default);

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/parsers/json/index.js":
/*!*************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/parsers/json/index.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Elements", ({
  enumerable: true,
  get: function get() {
    return _elements.Elements;
  }
}));
var _elements = __webpack_require__(/*! ./elements */ "../assets/dev/js/editor/components/browser-import/files/parsers/json/elements.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/parsers/video/index.js":
/*!**************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/parsers/video/index.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Widget", ({
  enumerable: true,
  get: function get() {
    return _widget.Widget;
  }
}));
var _widget = __webpack_require__(/*! ./widget */ "../assets/dev/js/editor/components/browser-import/files/parsers/video/widget.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/parsers/video/widget.js":
/*!***************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/parsers/video/widget.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Widget = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _containerFactory = _interopRequireDefault(__webpack_require__(/*! ../../../container-factory */ "../assets/dev/js/editor/components/browser-import/container-factory.js"));
var _base = __webpack_require__(/*! ../base */ "../assets/dev/js/editor/components/browser-import/files/parsers/base/index.js");
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Widget = exports.Widget = /*#__PURE__*/function (_MediaParser) {
  function Widget() {
    (0, _classCallCheck2.default)(this, Widget);
    return _callSuper(this, Widget, arguments);
  }
  (0, _inherits2.default)(Widget, _MediaParser);
  return (0, _createClass2.default)(Widget, [{
    key: "parse",
    value: (
    /**
     * @inheritDoc
     */
    function () {
      var _parse = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
        var file, container, _t, _t2, _t3, _t4, _t5, _t6;
        return _regenerator.default.wrap(function (_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              file = this.reader.getFile();
              _t = _containerFactory.default;
              _context.next = 1;
              return this.reader.getDataUrl();
            case 1:
              _t2 = _context.sent;
              _t3 = file.name.split('.')[0];
              _t4 = {
                url: _t2,
                alt: _t3,
                source: 'library'
              };
              _t5 = {
                video_type: 'hosted',
                hosted_url: _t4
              };
              _t6 = {
                widgetType: 'video',
                settings: _t5
              };
              container = _t.createElementContainer.call(_t, _t6);
              this.upload(file).then(function (_ref) {
                var data = _ref.data;
                $e.internal('document/elements/set-settings', {
                  // The reason we use the container id and not the container instance itself is that the container
                  // created above is just a placeholder, which later recreated using the same id.
                  container: elementor.getContainer(container.id),
                  settings: {
                    hosted_url: {
                      url: data.source_url,
                      id: data.id
                    }
                  }
                });
              }).catch(function () {
                elementor.documents.getCurrent().history.setActive(false);
                $e.run('document/elements/reset-settings', {
                  container: elementor.getContainer(container.id),
                  options: {
                    external: true
                  }
                });
                elementor.documents.getCurrent().history.setActive(true);
              });
              return _context.abrupt("return", container);
            case 2:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function parse() {
        return _parse.apply(this, arguments);
      }
      return parse;
    }()
    /**
     * @inheritDoc
     */
    )
  }], [{
    key: "getName",
    value:
    /**
     * @inheritDoc
     */
    function getName() {
      return 'widget';
    }

    /**
     * @inheritDoc
     */
  }, {
    key: "getReaders",
    value: function getReaders() {
      return ['video'];
    }
  }, {
    key: "validate",
    value: (function () {
      var _validate = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee2() {
        return _regenerator.default.wrap(function (_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              return _context2.abrupt("return", true);
            case 1:
            case "end":
              return _context2.stop();
          }
        }, _callee2);
      }));
      function validate() {
        return _validate.apply(this, arguments);
      }
      return validate;
    }())
  }]);
}(_base.MediaParser);

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/readers/image.js":
/*!********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/readers/image.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Image = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _fileReaderBase = _interopRequireDefault(__webpack_require__(/*! ../file-reader-base */ "../assets/dev/js/editor/components/browser-import/files/file-reader-base.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Image = exports.Image = /*#__PURE__*/function (_FileReaderBase) {
  function Image() {
    (0, _classCallCheck2.default)(this, Image);
    return _callSuper(this, Image, arguments);
  }
  (0, _inherits2.default)(Image, _FileReaderBase);
  return (0, _createClass2.default)(Image, null, [{
    key: "getName",
    value:
    /**
     * @inheritDoc
     */
    function getName() {
      return 'image';
    }

    /**
     * @inheritDoc
     */
  }, {
    key: "mimeTypes",
    get: function get() {
      return ['image\\/\\w+'];
    }
  }]);
}(_fileReaderBase.default);

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/readers/index.js":
/*!********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/readers/index.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Image", ({
  enumerable: true,
  get: function get() {
    return _image.Image;
  }
}));
Object.defineProperty(exports, "Json", ({
  enumerable: true,
  get: function get() {
    return _json.Json;
  }
}));
Object.defineProperty(exports, "Video", ({
  enumerable: true,
  get: function get() {
    return _video.Video;
  }
}));
var _image = __webpack_require__(/*! ./image */ "../assets/dev/js/editor/components/browser-import/files/readers/image.js");
var _video = __webpack_require__(/*! ./video */ "../assets/dev/js/editor/components/browser-import/files/readers/video.js");
var _json = __webpack_require__(/*! ./json */ "../assets/dev/js/editor/components/browser-import/files/readers/json.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/readers/json.js":
/*!*******************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/readers/json.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Json = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _fileReaderBase = _interopRequireDefault(__webpack_require__(/*! ../file-reader-base */ "../assets/dev/js/editor/components/browser-import/files/file-reader-base.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Json = exports.Json = /*#__PURE__*/function (_FileReaderBase) {
  function Json() {
    (0, _classCallCheck2.default)(this, Json);
    return _callSuper(this, Json, arguments);
  }
  (0, _inherits2.default)(Json, _FileReaderBase);
  return (0, _createClass2.default)(Json, [{
    key: "getData",
    value: (
    /**
     * Returns the file content as Json object.
     *
     * @return {{}} file content
     */
    function () {
      var _getData = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
        return _regenerator.default.wrap(function (_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              if (this._data) {
                _context.next = 2;
                break;
              }
              _context.next = 1;
              return this.getContent().then(function (content) {
                return JSON.parse(content);
              });
            case 1:
              this._data = _context.sent;
            case 2:
              return _context.abrupt("return", this._data);
            case 3:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function getData() {
        return _getData.apply(this, arguments);
      }
      return getData;
    }())
  }], [{
    key: "getName",
    value:
    /**
     * @inheritDoc
     */
    function getName() {
      return 'json';
    }
  }, {
    key: "isActive",
    value: function isActive() {
      var _elementor$config$use, _elementor$config$use2;
      return elementor.config.user.is_administrator || ((_elementor$config$use = (_elementor$config$use2 = elementor.config.user.restrictions) === null || _elementor$config$use2 === void 0 ? void 0 : _elementor$config$use2.includes('json-upload')) !== null && _elementor$config$use !== void 0 ? _elementor$config$use : false);
    }

    /**
     * @inheritDoc
     */
  }, {
    key: "mimeTypes",
    get: function get() {
      return ['application/json'];
    }

    /**
     * @inheritDoc
     */
  }, {
    key: "resolve",
    value: (function () {
      var _resolve = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee2(input) {
        var _t;
        return _regenerator.default.wrap(function (_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              _context2.prev = 0;
              JSON.parse(input);
              return _context2.abrupt("return", 'application/json');
            case 1:
              _context2.prev = 1;
              _t = _context2["catch"](0);
              return _context2.abrupt("return", false);
            case 2:
            case "end":
              return _context2.stop();
          }
        }, _callee2, null, [[0, 1]]);
      }));
      function resolve(_x) {
        return _resolve.apply(this, arguments);
      }
      return resolve;
    }())
  }]);
}(_fileReaderBase.default);

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/files/readers/video.js":
/*!********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/files/readers/video.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Video = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _fileReaderBase = _interopRequireDefault(__webpack_require__(/*! ../file-reader-base */ "../assets/dev/js/editor/components/browser-import/files/file-reader-base.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Video = exports.Video = /*#__PURE__*/function (_FileReaderBase) {
  function Video() {
    (0, _classCallCheck2.default)(this, Video);
    return _callSuper(this, Video, arguments);
  }
  (0, _inherits2.default)(Video, _FileReaderBase);
  return (0, _createClass2.default)(Video, null, [{
    key: "getName",
    value:
    /**
     * @inheritDoc
     */
    function getName() {
      return 'video';
    }

    /**
     * @inheritDoc
     */
  }, {
    key: "mimeTypes",
    get: function get() {
      return ['video\\/\\w+'];
    }
  }]);
}(_fileReaderBase.default);

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/items/item-collection.js":
/*!**********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/items/item-collection.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _item = _interopRequireDefault(__webpack_require__(/*! ./item */ "../assets/dev/js/editor/components/browser-import/items/item.js"));
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
var ItemCollection = exports["default"] = /*#__PURE__*/function () {
  /**
   * ItemCollection constructor.
   *
   * @param {Array<*>} items
   */
  function ItemCollection() {
    var items = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
    (0, _classCallCheck2.default)(this, ItemCollection);
    /**
     * The Item objects list.
     */
    (0, _defineProperty2.default)(this, "items", void 0);
    this.setItems(items);
  }

  /**
   * Set the Item objects list.
   *
   * @param {Array<*>} items
   */
  return (0, _createClass2.default)(ItemCollection, [{
    key: "setItems",
    value: function setItems() {
      var items = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var _iterator = _createForOfIteratorHelper(items),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var item = _step.value;
          if (!(item instanceof _item.default)) {
            throw new Error('ItemCollection can only contain Item objects');
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      this.items = items;
    }

    /**
     * Get the Item objects list.
     *
     * @return {[]} items
     */
  }, {
    key: "getItems",
    value: function getItems() {
      return this.items;
    }

    /**
     * Get files of all items.
     *
     * @return {[]} files
     */
  }, {
    key: "getFiles",
    value: function getFiles() {
      return this.items.map(function (item) {
        return item.getFile();
      });
    }
  }]);
}();

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/items/item.js":
/*!***********************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/items/item.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _isInstanceof = _interopRequireDefault(__webpack_require__(/*! ../../../utils/is-instanceof */ "../assets/dev/js/editor/utils/is-instanceof.js"));
var _mime = _interopRequireDefault(__webpack_require__(/*! mime */ "../node_modules/mime/index.js"));
/**
 * @typedef {import('../files/file-parser-base')} FileParserBase
 * @typedef {import('../files/file-reader-base')} FileReaderBase
 */
var Item = exports["default"] = /*#__PURE__*/function () {
  /**
   * The Item constructor.
   *
   * @param {*} input
   * @param {*} options
   */
  function Item(input) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    (0, _classCallCheck2.default)(this, Item);
    /**
     * The item File object.
     *
     * @type {File}
     */
    (0, _defineProperty2.default)(this, "file", void 0);
    /**
     * The Item options list.
     *
     * @type {{}}
     */
    (0, _defineProperty2.default)(this, "options", {});
    this.file = this.toFile(input);
    this.options = options;
  }

  /**
   * Convert the input into a File object.
   *
   * @param {*} input
   * @return {File} file
   */
  return (0, _createClass2.default)(Item, [{
    key: "toFile",
    value: function toFile(input) {
      if (!(0, _isInstanceof.default)(input, File)) {
        var _this$options = this.options,
          fileName = _this$options.fileName,
          type = _this$options.type,
          options = {
            type: type || input.type
          };

        // When the input is not a Blob object, use the mime-type from the options to generate the file.
        input = new File(Array.isArray(input) ? input : [input], fileName || this.constructor.createFileName(options), options);
      }
      return input;
    }

    /**
     * Create a random file name from a Blob/File object while using the suitable extension for the blob mime-type.
     *
     * @param {*} blob
     * @return {string} file name
     */
  }, {
    key: "getFile",
    value:
    /**
     * Get the item File object.
     *
     * @return {File} file
     */
    function getFile() {
      return this.file;
    }

    /**
     * Get the file-reader of the Item.
     *
     * @return {FileReaderBase} reader
     */
  }, {
    key: "getReader",
    value: function getReader() {
      return this.options.reader;
    }

    /**
     * Get the file-parser of the Item.
     *
     * @return {FileParserBase} parser
     */
  }, {
    key: "getParser",
    value: function getParser() {
      return this.options.parser;
    }

    /**
     * Set the file-reader of the Item.
     *
     * @param {FileReaderBase} reader
     */
  }, {
    key: "setReader",
    value: function setReader(reader) {
      this.options.reader = reader;
    }

    /**
     * Set the file-parser of the Item.
     *
     * @param {FileParserBase} parser
     */
  }, {
    key: "setParser",
    value: function setParser(parser) {
      this.options.parser = parser;
    }
  }], [{
    key: "createFileName",
    value: function createFileName(blob) {
      return [elementorCommon.helpers.getUniqueId(), _mime.default.getExtension(blob.type)].join('.');
    }
  }]);
}();

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/manager.js":
/*!********************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/manager.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _component = _interopRequireDefault(__webpack_require__(/*! ./component */ "../assets/dev/js/editor/components/browser-import/component.js"));
var _defaultConfig = _interopRequireDefault(__webpack_require__(/*! ./default-config */ "../assets/dev/js/editor/components/browser-import/default-config.js"));
var _itemCollection = _interopRequireDefault(__webpack_require__(/*! elementor-editor/components/browser-import/items/item-collection */ "../assets/dev/js/editor/components/browser-import/items/item-collection.js"));
var _normalizer = _interopRequireDefault(__webpack_require__(/*! ./normalizer */ "../assets/dev/js/editor/components/browser-import/normalizer.js"));
var _session = _interopRequireDefault(__webpack_require__(/*! elementor-editor/components/browser-import/session */ "../assets/dev/js/editor/components/browser-import/session.js"));
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/**
 * @typedef {import('../../container/container')} Container
 */
/**
 * @typedef {import('./files/file-reader-base')} FileReaderBase
 */
/**
 * @typedef {import('./files/file-parser-base')} FileParserBase
 */
var Manager = exports["default"] = /*#__PURE__*/function (_elementorModules$edi) {
  /**
   * Manager constructor.
   */
  function Manager() {
    var _this;
    (0, _classCallCheck2.default)(this, Manager);
    _this = _callSuper(this, Manager);
    /**
     * File-readers list.
     *
     * @type {{}}
     */
    (0, _defineProperty2.default)(_this, "readers", {});
    /**
     * File-parsers list according to their readers.
     *
     * @type {{}}
     */
    (0, _defineProperty2.default)(_this, "parsers", {});
    _this.normalizer = new _normalizer.default(_this);
    $e.components.register(new _component.default({
      manager: _this
    }));
    _this.parseConfig(_defaultConfig.default);
    return _this;
  }

  /**
   * Parse the config for the Manager.
   *
   * @param {*} config
   */
  (0, _inherits2.default)(Manager, _elementorModules$edi);
  return (0, _createClass2.default)(Manager, [{
    key: "parseConfig",
    value: function parseConfig() {
      var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var _iterator = _createForOfIteratorHelper(config.readers || {}),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var _reader$isActive, _reader$isActive2;
          var reader = _step.value;
          var isActive = (_reader$isActive = (_reader$isActive2 = reader.isActive) === null || _reader$isActive2 === void 0 ? void 0 : _reader$isActive2.call(reader)) !== null && _reader$isActive !== void 0 ? _reader$isActive : true;
          if (isActive) {
            this.registerFileReader(reader);
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      var _iterator2 = _createForOfIteratorHelper(config.parsers || {}),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var parser = _step2.value;
          this.registerFileParser(parser);
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }

    /**
     * Create a new Session instance and normalize input if needed.
     *
     * @param {*}              input
     * @param {Container|null} target
     * @param {{}}             options
     * @return {Session} session
     */
  }, {
    key: "createSession",
    value: (function () {
      var _createSession = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(input, target) {
        var options,
          _args = arguments;
        return _regenerator.default.wrap(function (_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              options = _args.length > 2 && _args[2] !== undefined ? _args[2] : {};
              if (input instanceof _itemCollection.default) {
                _context.next = 2;
                break;
              }
              _context.next = 1;
              return this.getNormalizer().normalize(input);
            case 1:
              input = _context.sent;
            case 2:
              return _context.abrupt("return", new _session.default(this, input, target, options));
            case 3:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function createSession(_x, _x2) {
        return _createSession.apply(this, arguments);
      }
      return createSession;
    }()
    /**
     * Register a new file-reader.
     *
     * @param {{}} reader
     */
    )
  }, {
    key: "registerFileReader",
    value: function registerFileReader(reader) {
      this.readers[reader.getName()] = reader;
    }

    /**
     * Register a new file-parser.
     *
     * @param {*} parser
     */
  }, {
    key: "registerFileParser",
    value: function registerFileParser(parser) {
      var _iterator3 = _createForOfIteratorHelper(parser.getReaders()),
        _step3;
      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var readerName = _step3.value;
          if (!this.readers[readerName]) {
            continue;
          } else if (!this.parsers[readerName]) {
            this.parsers[readerName] = {};
          }
          this.parsers[readerName][parser.getName()] = parser;
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }
    }

    /**
     * Get the file-handler that can handle the File of the given Item.
     *
     * @param {*}       item
     * @param {boolean} instantiate
     * @return {FileReaderBase|boolean} file handler
     */
  }, {
    key: "getReaderOf",
    value: (function () {
      var _getReaderOf = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee2(item) {
        var instantiate,
          file,
          readerName,
          readers,
          _i,
          _Object$values,
          reader,
          _args2 = arguments;
        return _regenerator.default.wrap(function (_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              instantiate = _args2.length > 1 && _args2[1] !== undefined ? _args2[1] : false;
              file = item.getFile(), readerName = item.getReader(), readers = this.getReaders(readerName);
              _i = 0, _Object$values = Object.values(readers);
            case 1:
              if (!(_i < _Object$values.length)) {
                _context2.next = 4;
                break;
              }
              reader = _Object$values[_i];
              _context2.next = 2;
              return reader.validate(file);
            case 2:
              if (!_context2.sent) {
                _context2.next = 3;
                break;
              }
              if (!readerName) {
                item.setReader(reader.getName());
              }
              return _context2.abrupt("return", instantiate ? new reader(file) : reader);
            case 3:
              _i++;
              _context2.next = 1;
              break;
            case 4:
              return _context2.abrupt("return", false);
            case 5:
            case "end":
              return _context2.stop();
          }
        }, _callee2, this);
      }));
      function getReaderOf(_x3) {
        return _getReaderOf.apply(this, arguments);
      }
      return getReaderOf;
    }()
    /**
     * Get the file-parser that can handle the File of the given Item.
     *
     * @param {*}       item
     * @param {boolean} instantiate
     * @return {Promise<FileParserBase|boolean>} file parser
     */
    )
  }, {
    key: "getParserOf",
    value: (function () {
      var _getParserOf = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee3(item) {
        var instantiate,
          reader,
          parserName,
          parsers,
          _i2,
          _Object$values2,
          parser,
          _args3 = arguments;
        return _regenerator.default.wrap(function (_context3) {
          while (1) switch (_context3.prev = _context3.next) {
            case 0:
              instantiate = _args3.length > 1 && _args3[1] !== undefined ? _args3[1] : false;
              _context3.next = 1;
              return this.getReaderOf(item, true);
            case 1:
              reader = _context3.sent;
              parserName = item.getParser();
              if (!reader) {
                _context3.next = 5;
                break;
              }
              parsers = this.getParsers(reader.constructor.getName(), parserName);
              _i2 = 0, _Object$values2 = Object.values(parsers);
            case 2:
              if (!(_i2 < _Object$values2.length)) {
                _context3.next = 5;
                break;
              }
              parser = _Object$values2[_i2];
              _context3.next = 3;
              return parser.validate(reader);
            case 3:
              if (!_context3.sent) {
                _context3.next = 4;
                break;
              }
              if (!parserName) {
                item.setParser(parser.getName());
              }
              return _context3.abrupt("return", instantiate ? new parser(reader) : parser);
            case 4:
              _i2++;
              _context3.next = 2;
              break;
            case 5:
              return _context3.abrupt("return", false);
            case 6:
            case "end":
              return _context3.stop();
          }
        }, _callee3, this);
      }));
      function getParserOf(_x4) {
        return _getParserOf.apply(this, arguments);
      }
      return getParserOf;
    }()
    /**
     * Resolve the mime-type for an input using the registered parsers.
     *
     * @param {*} input
     * @return {Promise<string|boolean>} mime type, or false if not found
     */
    )
  }, {
    key: "getMimeTypeOf",
    value: (function () {
      var _getMimeTypeOf = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee4(input) {
        var _i3, _Object$values3, reader, mimeType;
        return _regenerator.default.wrap(function (_context4) {
          while (1) switch (_context4.prev = _context4.next) {
            case 0:
              _i3 = 0, _Object$values3 = Object.values(this.getReaders());
            case 1:
              if (!(_i3 < _Object$values3.length)) {
                _context4.next = 4;
                break;
              }
              reader = _Object$values3[_i3];
              _context4.next = 2;
              return reader.resolve(input);
            case 2:
              mimeType = _context4.sent;
              if (!mimeType) {
                _context4.next = 3;
                break;
              }
              return _context4.abrupt("return", mimeType);
            case 3:
              _i3++;
              _context4.next = 1;
              break;
            case 4:
              return _context4.abrupt("return", false);
            case 5:
            case "end":
              return _context4.stop();
          }
        }, _callee4, this);
      }));
      function getMimeTypeOf(_x5) {
        return _getMimeTypeOf.apply(this, arguments);
      }
      return getMimeTypeOf;
    }()
    /**
     * Get the Normalizer instance.
     *
     * @return {Normalizer} normalizer
     */
    )
  }, {
    key: "getNormalizer",
    value: function getNormalizer() {
      return this.normalizer;
    }

    /**
     * Get all registered file-readers.
     *
     * @param {*|Array<*>} readers
     * @return {{}} registered file readers
     */
  }, {
    key: "getReaders",
    value: function getReaders() {
      var _this2 = this;
      var readers = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      readers = Array.isArray(readers) ? readers : [readers];
      if (!readers.length) {
        return this.readers;
      }
      return Object.fromEntries(readers.filter(function (reader) {
        return reader in _this2.readers;
      }).map(function (reader) {
        return [reader, _this2.readers[reader]];
      }));
    }

    /**
     * Get all registered file-parsers, unless a reader name is specified, in which case its parsers are returned.
     *
     * @param {*} reader
     * @param {*} parsers
     * @return {{}} parsers
     */
  }, {
    key: "getParsers",
    value: function getParsers(reader) {
      var _this3 = this;
      var parsers = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
      parsers = Array.isArray(parsers) ? parsers : [parsers];
      if (!parsers.length) {
        return this.parsers[reader] || {};
      }
      return Object.fromEntries(parsers.filter(function (parser) {
        return parser in _this3.parsers[reader];
      }).map(function (parser) {
        return [parser, _this3.parsers[reader][parser]];
      }));
    }
  }]);
}(elementorModules.editor.utils.Module);

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/normalizer.js":
/*!***********************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/normalizer.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _isInstanceof = _interopRequireDefault(__webpack_require__(/*! ../../utils/is-instanceof */ "../assets/dev/js/editor/utils/is-instanceof.js"));
var _item = _interopRequireDefault(__webpack_require__(/*! ./items/item */ "../assets/dev/js/editor/components/browser-import/items/item.js"));
var _itemCollection = _interopRequireDefault(__webpack_require__(/*! ./items/item-collection */ "../assets/dev/js/editor/components/browser-import/items/item-collection.js"));
/**
 * @typedef {import('../modules/component-base')} ComponentBase
 */
/**
 * @typedef {import('./manager')} Manager
 */
var Normalizer = exports["default"] = /*#__PURE__*/function () {
  /**
   * Normalizer constructor.
   *
   * @param {Manager} manager
   */
  function Normalizer(manager) {
    (0, _classCallCheck2.default)(this, Normalizer);
    this.manager = manager;
  }

  /**
   * Normalize input to an ItemCollection, where each item is an Item object. This method can be used to normalize a
   * vast spectrum of input types - from data url strings to blob objects, and array of them. Other kind of parsers
   * can be registered to the Manager.
   *
   * @param {*} input
   * @return {Promise<ItemCollection>} result
   */
  return (0, _createClass2.default)(Normalizer, [{
    key: "normalize",
    value: (function () {
      var _normalize = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(input) {
        return _regenerator.default.wrap(function (_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              if (!(input instanceof _itemCollection.default)) {
                input = this.toItemCollection(input);
              }
              return _context.abrupt("return", input);
            case 1:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function normalize(_x) {
        return _normalize.apply(this, arguments);
      }
      return normalize;
    }()
    /**
     * Convert an single or multiple input subjects into a ItemCollection object. To learn more about the way each
     * subject is treated, please refer the 'toItem' method.
     *
     * @param {*} subjects
     * @return {Promise<ItemCollection>} result
     */
    )
  }, {
    key: "toItemCollection",
    value: (function () {
      var _toItemCollection = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee2(subjects) {
        var _this = this;
        return _regenerator.default.wrap(function (_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              if (!Array.isArray(subjects)) {
                subjects = (0, _isInstanceof.default)(subjects, FileList) || (0, _isInstanceof.default)(subjects, DataTransferItemList) ? Array.from(subjects) : [subjects];
              }
              return _context2.abrupt("return", Promise.all(subjects.map(function (subject) {
                // Creating a ItemCollection can only be made with an array of Item objects. Therefore, unless the
                // subject is an Item object, we should transform it into one.
                if (!(subject instanceof _item.default)) {
                  subject = _this.toItem(subject);
                }
                return subject;
              })).then(function (items) {
                return new _itemCollection.default(items);
              }));
            case 1:
            case "end":
              return _context2.stop();
          }
        }, _callee2);
      }));
      function toItemCollection(_x2) {
        return _toItemCollection.apply(this, arguments);
      }
      return toItemCollection;
    }()
    /**
     * Convert a single subject into an Item object.
     *
     * @param {*} subject
     * @return {Promise<Item>} result
     */
    )
  }, {
    key: "toItem",
    value: (function () {
      var _toItem = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee3(subject) {
        var mimeType, _t;
        return _regenerator.default.wrap(function (_context3) {
          while (1) switch (_context3.prev = _context3.next) {
            case 0:
              if ((0, _isInstanceof.default)(subject, [Blob, File, DataTransferItem])) {
                _context3.next = 7;
                break;
              }
              _context3.prev = 1;
              // In order to check whether it's a data url string, we're trying to decode it. If it is a data url,
              // we can extract the blob later using `fetch`.
              window.atob(subject.split(',')[1]);
              _context3.next = 5;
              break;
            case 2:
              _context3.prev = 2;
              _t = _context3["catch"](1);
              _context3.next = 3;
              return this.manager.getMimeTypeOf(subject);
            case 3:
              mimeType = _context3.sent;
              if (!mimeType) {
                _context3.next = 4;
                break;
              }
              subject = this.constructor.createDataUrl(subject, mimeType);
              _context3.next = 5;
              break;
            case 4:
              throw new Error('The input provided cannot be resolved');
            case 5:
              _context3.next = 6;
              return fetch(subject).then(function (res) {
                return res.blob();
              });
            case 6:
              subject = _context3.sent;
            case 7:
              return _context3.abrupt("return", new _item.default(subject));
            case 8:
            case "end":
              return _context3.stop();
          }
        }, _callee3, this, [[1, 2]]);
      }));
      function toItem(_x3) {
        return _toItem.apply(this, arguments);
      }
      return toItem;
    }()
    /**
     * A utility for creating a data url string functionally.
     *
     * @param {string}           data
     * @param {string|undefined} mimeType
     * @param {boolean}          base64
     * @return {string} data URI
     */
    )
  }], [{
    key: "createDataUrl",
    value: function createDataUrl(data) {
      var mimeType = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      var base64 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
      if (base64) {
        data = "base64,".concat(btoa(data));
      }
      if (mimeType) {
        mimeType += ';';
      }
      return "data:".concat(mimeType || '').concat(data);
    }
  }]);
}();

/***/ }),

/***/ "../assets/dev/js/editor/components/browser-import/session.js":
/*!********************************************************************!*\
  !*** ../assets/dev/js/editor/components/browser-import/session.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
/**
 * @typedef {import('../../container/container')} Container
 */
/**
 * @typedef {import('./manager')} Manager
 */
/**
 * @typedef {import('./items/item-collection')} ItemCollection
 */
var Session = exports["default"] = /*#__PURE__*/function () {
  /**
   * Session constructor.
   *
   * @param {Manager}             manager
   * @param {ItemCollection|null} itemCollection
   * @param {Container|null}      target
   * @param {{}}                  options
   */
  function Session(manager) {
    var itemCollection = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    var target = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
    var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
    (0, _classCallCheck2.default)(this, Session);
    /**
     * The Manager instance.
     *
     * @type {Manager}
     */
    (0, _defineProperty2.default)(this, "manager", void 0);
    /**
     * The ItemCollection instance.
     *
     * @type {ItemCollection}
     */
    (0, _defineProperty2.default)(this, "itemCollection", void 0);
    /**
     * The Target instance.
     *
     * @type {Container}
     */
    (0, _defineProperty2.default)(this, "target", void 0);
    /**
     * The Session options.
     *
     * @type {{}}
     */
    (0, _defineProperty2.default)(this, "options", {
      target: {}
    });
    this.manager = manager;
    this.itemCollection = itemCollection;
    this.target = target;
    Object.assign(this.options, options);
  }

  /**
   * Validate all files in this session can be handled.
   *
   * @return {boolean} true if all items are valid
   */
  return (0, _createClass2.default)(Session, [{
    key: "validate",
    value: (function () {
      var _validate = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
        var _iterator, _step, item, _t;
        return _regenerator.default.wrap(function (_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _iterator = _createForOfIteratorHelper(this.itemCollection.getItems());
              _context.prev = 1;
              _iterator.s();
            case 2:
              if ((_step = _iterator.n()).done) {
                _context.next = 5;
                break;
              }
              item = _step.value;
              _context.next = 3;
              return this.manager.getReaderOf(item);
            case 3:
              if (_context.sent) {
                _context.next = 4;
                break;
              }
              return _context.abrupt("return", false);
            case 4:
              _context.next = 2;
              break;
            case 5:
              _context.next = 7;
              break;
            case 6:
              _context.prev = 6;
              _t = _context["catch"](1);
              _iterator.e(_t);
            case 7:
              _context.prev = 7;
              _iterator.f();
              return _context.finish(7);
            case 8:
              return _context.abrupt("return", true);
            case 9:
            case "end":
              return _context.stop();
          }
        }, _callee, this, [[1, 6, 7, 8]]);
      }));
      function validate() {
        return _validate.apply(this, arguments);
      }
      return validate;
    }()
    /**
     * Handle files with a suitable file-parser.
     *
     * @return {Container[]} result
     */
    )
  }, {
    key: "apply",
    value: (function () {
      var _apply = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee2() {
        var _this = this;
        var parsed, _iterator2, _step2, item, parser, _t2;
        return _regenerator.default.wrap(function (_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              parsed = [];
              _iterator2 = _createForOfIteratorHelper(this.itemCollection.getItems());
              _context2.prev = 1;
              _iterator2.s();
            case 2:
              if ((_step2 = _iterator2.n()).done) {
                _context2.next = 6;
                break;
              }
              item = _step2.value;
              _context2.next = 3;
              return this.manager.getParserOf(item, true);
            case 3:
              parser = _context2.sent;
              if (!parser) {
                _context2.next = 4;
                break;
              }
              parsed.push(parser.parse());
              _context2.next = 5;
              break;
            case 4:
              throw new Error('An error occurred when trying to parse the input');
            case 5:
              _context2.next = 2;
              break;
            case 6:
              _context2.next = 8;
              break;
            case 7:
              _context2.prev = 7;
              _t2 = _context2["catch"](1);
              _iterator2.e(_t2);
            case 8:
              _context2.prev = 8;
              _iterator2.f();
              return _context2.finish(8);
            case 9:
              return _context2.abrupt("return", Promise.all(parsed).then(function (result) {
                return _this.resolve(result.flat());
              }));
            case 10:
            case "end":
              return _context2.stop();
          }
        }, _callee2, this, [[1, 7, 8, 9]]);
      }));
      function apply() {
        return _apply.apply(this, arguments);
      }
      return apply;
    }()
    /**
     * Resolve containers to fulfill their purpose.
     *
     * @param {*} containers
     * @return {*} result
     */
    )
  }, {
    key: "resolve",
    value: function resolve(containers) {
      var _this2 = this;
      if (Object.values(containers).some(function (element) {
        return 'section' === element.model.get('elType');
      })) {
        this.target = elementor.getPreviewContainer();
      }

      // eslint-disable-next-line array-callback-return
      return containers.map(function (element) {
        switch (element.type) {
          case 'container':
          case 'section':
          case 'column':
          case 'e-div-block':
          case 'widget':
            return _this2.target.view.createElementFromModel(element.model, Object.assign(_this2.options.target, {
              event: _this2.options.event,
              scrollIntoView: 0 === containers.indexOf(element)
            }));
        }
      });
    }
  }]);
}();

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/commands/close.js":
/*!**********************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/commands/close.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Close = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Close = exports.Close = /*#__PURE__*/function (_$e$modules$CommandBa) {
  function Close() {
    (0, _classCallCheck2.default)(this, Close);
    return _callSuper(this, Close, arguments);
  }
  (0, _inherits2.default)(Close, _$e$modules$CommandBa);
  return (0, _createClass2.default)(Close, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireArgument('id', args);
    }
  }, {
    key: "apply",
    value: function () {
      var _apply = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(args) {
        var id, mode, onClose, document, deferred, _t;
        return _regenerator.default.wrap(function (_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              id = args.id, mode = args.mode, onClose = args.onClose, document = elementor.documents.get(id); // Already closed.
              if (!('closed' === document.editor.status)) {
                _context.next = 1;
                break;
              }
              return _context.abrupt("return", jQuery.Deferred().resolve());
            case 1:
              if (!(!mode && (document.editor.isChanged || document.isDraft()))) {
                _context.next = 2;
                break;
              }
              deferred = jQuery.Deferred();
              this.getConfirmDialog(deferred).show();
              return _context.abrupt("return", deferred.promise());
            case 2:
              _t = mode;
              _context.next = _t === 'autosave' ? 3 : _t === 'save' ? 5 : _t === 'discard' ? 7 : 9;
              break;
            case 3:
              _context.next = 4;
              return $e.run('document/save/auto');
            case 4:
              return _context.abrupt("continue", 9);
            case 5:
              _context.next = 6;
              return $e.run('document/save/update');
            case 6:
              return _context.abrupt("continue", 9);
            case 7:
              _context.next = 8;
              return $e.run('document/save/discard', {
                document: document
              });
            case 8:
              return _context.abrupt("continue", 9);
            case 9:
              $e.run('document/elements/deselect-all');
              _context.next = 10;
              return $e.internal('editor/documents/unload', {
                document: document
              });
            case 10:
              if (!onClose) {
                _context.next = 11;
                break;
              }
              _context.next = 11;
              return onClose(document);
            case 11:
              return _context.abrupt("return", jQuery.Deferred().resolve());
            case 12:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function apply(_x) {
        return _apply.apply(this, arguments);
      }
      return apply;
    }()
  }, {
    key: "getConfirmDialog",
    value: function getConfirmDialog(deferred) {
      var _this = this;
      if (this.confirmDialog) {
        return this.confirmDialog;
      }
      this.confirmDialog = elementorCommon.dialogsManager.createWidget('confirm', {
        id: 'elementor-document-save-on-close',
        headerMessage: __('You are leaving to a separate site part.', 'elementor'),
        message: __('Save your changes before moving on because the current document and the one you’re moving to are separate site parts.', 'elementor'),
        position: {
          my: 'center center',
          at: 'center center'
        },
        strings: {
          confirm: __('Save & leave', 'elementor'),
          cancel: __('Don\'t leave', 'elementor')
        },
        onHide: function onHide() {
          // If still not action chosen. use `defer` because onHide is called before onConfirm/onCancel.
          _.defer(function () {
            if (!_this.args.mode) {
              deferred.reject('Close document has been canceled.');
            }
          });
        },
        onCancel: function onCancel() {
          window.top.$e.internal('panel/state-ready');
          deferred.reject('Close document has been canceled.');
        },
        onConfirm: function onConfirm() {
          _this.args.mode = 'save';

          // Re-run with same args.
          $e.run('editor/documents/close', _this.args).then(function () {
            deferred.resolve();
          });
        }
      });
      return this.confirmDialog;
    }
  }]);
}($e.modules.CommandBase);
var _default = exports["default"] = Close;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/commands/index.js":
/*!**********************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/commands/index.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Close", ({
  enumerable: true,
  get: function get() {
    return _close.Close;
  }
}));
Object.defineProperty(exports, "Open", ({
  enumerable: true,
  get: function get() {
    return _open.Open;
  }
}));
Object.defineProperty(exports, "Preview", ({
  enumerable: true,
  get: function get() {
    return _preview.Preview;
  }
}));
Object.defineProperty(exports, "Switch", ({
  enumerable: true,
  get: function get() {
    return _switch.Switch;
  }
}));
Object.defineProperty(exports, "View", ({
  enumerable: true,
  get: function get() {
    return _view.View;
  }
}));
var _close = __webpack_require__(/*! ./close */ "../assets/dev/js/editor/components/documents/commands/close.js");
var _open = __webpack_require__(/*! ./open */ "../assets/dev/js/editor/components/documents/commands/open.js");
var _preview = __webpack_require__(/*! ./preview */ "../assets/dev/js/editor/components/documents/commands/preview.js");
var _view = __webpack_require__(/*! ./view */ "../assets/dev/js/editor/components/documents/commands/view.js");
var _switch = __webpack_require__(/*! ./switch */ "../assets/dev/js/editor/components/documents/commands/switch.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/commands/internal/attach-preview.js":
/*!****************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/commands/internal/attach-preview.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.AttachPreview = void 0;
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _excluded = ["shouldNavigateToDefaultRoute"];
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var AttachPreview = exports.AttachPreview = /*#__PURE__*/function (_$e$modules$CommandIn) {
  function AttachPreview() {
    (0, _classCallCheck2.default)(this, AttachPreview);
    return _callSuper(this, AttachPreview, arguments);
  }
  (0, _inherits2.default)(AttachPreview, _$e$modules$CommandIn);
  return (0, _createClass2.default)(AttachPreview, [{
    key: "validateArgs",
    value: function validateArgs() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      if (args.selector) {
        this.requireArgumentType('selector', 'string');
        if (0 === elementor.$previewContents.find(args.selector).length) {
          throw new Error('Invalid argument. The `selector` argument must be existed selector.');
        }
      }
    }
  }, {
    key: "apply",
    value: function apply() {
      var _this = this;
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var _ref$shouldNavigateTo = _ref.shouldNavigateToDefaultRoute,
        shouldNavigateToDefaultRoute = _ref$shouldNavigateTo === void 0 ? true : _ref$shouldNavigateTo,
        args = (0, _objectWithoutProperties2.default)(_ref, _excluded);
      var document = elementor.documents.getCurrent();
      return $e.data.get('globals/index').then(function () {
        elementor.trigger('globals:loaded');
        return _this.attachDocumentToPreview(document, args);
      }).then(function () {
        elementor.toggleDocumentCssFiles(document, false);
        elementor.onEditModeSwitched();
        elementor.checkPageStatus();
        elementor.trigger('document:loaded', document);
        if (shouldNavigateToDefaultRoute) {
          return $e.internal('panel/open-default', {
            refresh: true
          });
        }
      });
    }
  }, {
    key: "attachDocumentToPreview",
    value: function attachDocumentToPreview(document, args) {
      var _args$selector = args.selector,
        selector = _args$selector === void 0 ? '.elementor-' + document.id : _args$selector,
        _args$shouldScroll = args.shouldScroll,
        shouldScroll = _args$shouldScroll === void 0 ? true : _args$shouldScroll;
      return new Promise(function (resolve, reject) {
        // Not yet loaded.
        if (!document) {
          return reject("Can't attach preview, there is no open document.");
        }
        if (!document.config.elements) {
          return resolve();
        }
        document.$element = elementor.$previewContents.find(selector);
        var isInitialDocument = document.id === elementor.config.initial_document.id;
        if (!document.$element.length) {
          if (isInitialDocument) {
            elementor.onPreviewElNotFound();
          }
          return reject("Can't attach preview to document '".concat(document.id, "', element '").concat(selector, "' was not found."));
        }
        document.$element.addClass('elementor-edit-area elementor-edit-mode');
        if (!isInitialDocument) {
          elementor.documents.getCurrent().$element.addClass('elementor-embedded-editor');
        }
        elementor.initElements();
        elementor.initPreviewView(document);
        document.container.view = elementor.getPreviewView();
        document.container.model.attributes.elements = elementor.elements;
        if (shouldScroll) {
          elementor.helpers.scrollToView(document.$element);
        }
        document.$element.addClass('elementor-edit-area-active').removeClass('elementor-editor-preview');
        resolve();
      });
    }
  }]);
}($e.modules.CommandInternalBase);
var _default = exports["default"] = AttachPreview;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/commands/internal/index.js":
/*!*******************************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/commands/internal/index.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "AttachPreview", ({
  enumerable: true,
  get: function get() {
    return _attachPreview.AttachPreview;
  }
}));
Object.defineProperty(exports, "Load", ({
  enumerable: true,
  get: function get() {
    return _load.Load;
  }
}));
Object.defineProperty(exports, "Unload", ({
  enumerable: true,
  get: function get() {
    return _unload.Unload;
  }
}));
var _attachPreview = __webpack_require__(/*! ./attach-preview */ "../assets/dev/js/editor/components/documents/commands/internal/attach-preview.js");
var _load = __webpack_require__(/*! ./load */ "../assets/dev/js/editor/components/documents/commands/internal/load.js");
var _unload = __webpack_require__(/*! ./unload */ "../assets/dev/js/editor/components/documents/commands/internal/unload.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/commands/internal/load.js":
/*!******************************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/commands/internal/load.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Load = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _document = _interopRequireDefault(__webpack_require__(/*! ../../document */ "../assets/dev/js/editor/components/documents/document.js"));
var _heartbeat = _interopRequireDefault(__webpack_require__(/*! elementor-editor-utils/heartbeat */ "../assets/dev/js/editor/utils/heartbeat.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Load = exports.Load = /*#__PURE__*/function (_$e$modules$CommandIn) {
  function Load() {
    (0, _classCallCheck2.default)(this, Load);
    return _callSuper(this, Load, arguments);
  }
  (0, _inherits2.default)(Load, _$e$modules$CommandIn);
  return (0, _createClass2.default)(Load, [{
    key: "validateArgs",
    value: function validateArgs() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      this.requireArgument('config', args);
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var config = args.config,
        _args$setAsInitial = args.setAsInitial,
        setAsInitial = _args$setAsInitial === void 0 ? false : _args$setAsInitial,
        _args$shouldScroll = args.shouldScroll,
        shouldScroll = _args$shouldScroll === void 0 ? true : _args$shouldScroll,
        _args$shouldNavigateT = args.shouldNavigateToDefaultRoute,
        shouldNavigateToDefaultRoute = _args$shouldNavigateT === void 0 ? true : _args$shouldNavigateT;
      if (elementorCommon.config.experimentalFeatures.additional_custom_breakpoints) {
        // When the Responsive Optimization experiment is active, the responsive controls are generated on the
        // JS side instead of the PHP.
        config.settings.controls = elementor.generateResponsiveControls(config.settings.controls);
      }
      elementor.config.document = config;
      elementor.setAjax();
      elementor.addWidgetsCache(config.widgets);
      elementor.templates.init();
      var document = new _document.default(config);
      elementor.documents.add(document);

      // Must set current before create a container.
      elementor.documents.setCurrent(document);
      if (setAsInitial) {
        elementor.documents.setInitialById(document.id);
      }
      elementor.settings.page = new elementor.settings.modules.page(config.settings);
      document.container = elementor.settings.page.getEditedView().getContainer();

      // Reference container back to document.
      document.container.document = document;
      elementor.heartbeat = new _heartbeat.default(document);
      var isOldPageVersion = elementor.config.document.version && elementor.helpers.compareVersions(elementor.config.document.version, '2.5.0', '<');
      if (!elementor.config.user.introduction.flexbox && isOldPageVersion) {
        elementor.showFlexBoxAttentionDialog();
      }
      if (elementor.loaded) {
        // TODO: Find better solution - Fix issue when globals does not render after saving from kit.
        // The issue is that the css-parser is depends upon cache and cache is not available during this time.
        return $e.data.get('globals/index').then(function () {
          if (setAsInitial) {
            // There is no need to attach preview when the iframe is reloaded. It will be triggered
            // automatically after the iframe finishes loading (see `EditorBase.onPreviewLoaded()`).
            elementor.reloadPreview();
            return Promise.resolve();
          }
          return $e.internal('editor/documents/attach-preview', {
            shouldScroll: shouldScroll,
            shouldNavigateToDefaultRoute: shouldNavigateToDefaultRoute,
            selector: args.selector
          });
        });
      }
      return Promise.resolve(document);
    }
  }]);
}($e.modules.CommandInternalBase);
var _default = exports["default"] = Load;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/commands/internal/unload.js":
/*!********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/commands/internal/unload.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Unload = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _document = _interopRequireDefault(__webpack_require__(/*! ../../document */ "../assets/dev/js/editor/components/documents/document.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Unload = exports.Unload = /*#__PURE__*/function (_$e$modules$CommandIn) {
  function Unload() {
    (0, _classCallCheck2.default)(this, Unload);
    return _callSuper(this, Unload, arguments);
  }
  (0, _inherits2.default)(Unload, _$e$modules$CommandIn);
  return (0, _createClass2.default)(Unload, [{
    key: "validateArgs",
    value: function validateArgs() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      this.requireArgumentConstructor('document', _document.default, args);
    }
  }, {
    key: "apply",
    value: function apply(args) {
      return new Promise(function (resolve, reject) {
        var document = args.document;
        if (document.id !== elementor.config.document.id) {
          reject();
        }
        elementor.elements = [];
        elementor.saver.stopAutoSave(document);
        elementor.channels.dataEditMode.trigger('switch', 'preview');
        if (document.$element) {
          document.$element.removeClass('elementor-edit-area-active elementor-edit-mode').addClass('elementor-editor-preview');
        }
        elementorCommon.elements.$body.removeClass("elementor-editor-".concat(document.config.type));
        elementor.settings.page.destroy();
        elementor.heartbeat.destroy();
        document.editor.status = 'closed';
        elementor.config.document = {};
        elementor.documents.unsetCurrent();
        elementor.trigger('document:unloaded', document);
        resolve();
      });
    }
  }]);
}($e.modules.CommandInternalBase);
var _default = exports["default"] = Unload;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/commands/open.js":
/*!*********************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/commands/open.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Open = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Open = exports.Open = /*#__PURE__*/function (_$e$modules$CommandBa) {
  function Open() {
    (0, _classCallCheck2.default)(this, Open);
    return _callSuper(this, Open, arguments);
  }
  (0, _inherits2.default)(Open, _$e$modules$CommandBa);
  return (0, _createClass2.default)(Open, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireArgument('id', args);
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var id = args.id,
        selector = args.selector,
        _args$shouldScroll = args.shouldScroll,
        shouldScroll = _args$shouldScroll === void 0 ? true : _args$shouldScroll,
        _args$shouldNavigateT = args.shouldNavigateToDefaultRoute,
        shouldNavigateToDefaultRoute = _args$shouldNavigateT === void 0 ? true : _args$shouldNavigateT,
        _args$setAsInitial = args.setAsInitial,
        setAsInitial = _args$setAsInitial === void 0 ? false : _args$setAsInitial,
        currentDocument = elementor.documents.getCurrent();

      // Already opened.
      if (currentDocument && id === currentDocument.id) {
        return jQuery.Deferred().resolve();
      }

      // TODO: move to $e.hooks.ui.
      if (elementor.loaded) {
        elementor.$previewContents.find(".elementor-".concat(id)).addClass('loading');
      }
      if (setAsInitial) {
        // Set the new initial document id to be sent with all requests.
        // The next request needs to have the new initial document id in order to have the correct preview URL.
        elementorCommon.ajax.addRequestConstant('initial_document_id', id);

        // Because the initial document has changed, we need to clear cached values (e.g. header wp_preview URL),
        elementor.documents.invalidateCache();
      }
      return elementor.documents.request(id).then(function (config) {
        elementorCommon.elements.$body.addClass("elementor-editor-".concat(config.type));

        // Tell the editor to load the document.
        return $e.internal('editor/documents/load', {
          config: config,
          selector: selector,
          setAsInitial: setAsInitial,
          shouldScroll: shouldScroll,
          shouldNavigateToDefaultRoute: shouldNavigateToDefaultRoute
        });
      }).always(function () {
        // TODO: move to $e.hooks.ui.
        if (elementor.loaded) {
          elementor.$previewContents.find(".elementor-".concat(id)).removeClass('loading');
        }
      });
    }
  }]);
}($e.modules.CommandBase);
var _default = exports["default"] = Open;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/commands/preview.js":
/*!************************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/commands/preview.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Preview = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Preview = exports.Preview = /*#__PURE__*/function (_$e$modules$CommandBa) {
  function Preview() {
    (0, _classCallCheck2.default)(this, Preview);
    return _callSuper(this, Preview, arguments);
  }
  (0, _inherits2.default)(Preview, _$e$modules$CommandBa);
  return (0, _createClass2.default)(Preview, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireArgument('id', args);
    }

    // TODO: Check if blocking is required.
  }, {
    key: "apply",
    value: function () {
      var _apply = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(args) {
        var id, _$e$components$get, footerSaver, document;
        return _regenerator.default.wrap(function (_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              id = args.id, _$e$components$get = $e.components.get('document/save'), footerSaver = _$e$components$get.footerSaver, document = elementor.documents.get(id);
              if (!document.editor.isChanged) {
                _context.next = 1;
                break;
              }
              _context.next = 1;
              return $e.run('document/save/auto', {
                force: true
              });
            case 1:
              // Open immediately in order to avoid popup blockers.
              footerSaver.previewWindow = open(document.config.urls.wp_preview, "wp-preview-".concat(document.id));
            case 2:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      function apply(_x) {
        return _apply.apply(this, arguments);
      }
      return apply;
    }()
  }]);
}($e.modules.CommandBase);
var _default = exports["default"] = Preview;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/commands/switch.js":
/*!***********************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/commands/switch.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Switch = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Switch = exports.Switch = /*#__PURE__*/function (_$e$modules$CommandBa) {
  function Switch() {
    (0, _classCallCheck2.default)(this, Switch);
    return _callSuper(this, Switch, arguments);
  }
  (0, _inherits2.default)(Switch, _$e$modules$CommandBa);
  return (0, _createClass2.default)(Switch, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireArgument('id', args);
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var id = args.id,
        mode = args.mode,
        onClose = args.onClose,
        _args$shouldScroll = args.shouldScroll,
        shouldScroll = _args$shouldScroll === void 0 ? true : _args$shouldScroll,
        _args$shouldNavigateT = args.shouldNavigateToDefaultRoute,
        shouldNavigateToDefaultRoute = _args$shouldNavigateT === void 0 ? true : _args$shouldNavigateT,
        _args$setAsInitial = args.setAsInitial,
        setAsInitial = _args$setAsInitial === void 0 ? false : _args$setAsInitial;
      if (setAsInitial) {
        // Will be removed by the attach-preview after the iframe has loaded.
        jQuery('#elementor-preview-loading').show();
      }
      return $e.run('editor/documents/close', {
        id: elementor.documents.getCurrentId(),
        mode: mode,
        onClose: onClose,
        selector: args.selector
      }).then(function () {
        return $e.run('editor/documents/open', {
          id: id,
          shouldScroll: shouldScroll,
          shouldNavigateToDefaultRoute: shouldNavigateToDefaultRoute,
          selector: args.selector,
          setAsInitial: setAsInitial
        });
      }).then(function () {
        elementor.getPanelView().getPages('menu').view.addExitItem();
      });
    }
  }]);
}($e.modules.CommandBase);
var _default = exports["default"] = Switch;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/commands/view.js":
/*!*********************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/commands/view.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.View = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var View = exports.View = /*#__PURE__*/function (_$e$modules$CommandBa) {
  function View() {
    (0, _classCallCheck2.default)(this, View);
    return _callSuper(this, View, arguments);
  }
  (0, _inherits2.default)(View, _$e$modules$CommandBa);
  return (0, _createClass2.default)(View, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireArgument('id', args);
    }
  }, {
    key: "apply",
    value: function () {
      var _apply = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(args) {
        var id, document;
        return _regenerator.default.wrap(function (_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              id = args.id, document = elementor.documents.get(id); // Open immediately in order to avoid popup blockers.
              open(document.config.urls.permalink, "wp-view-".concat(document.id));
            case 1:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      function apply(_x) {
        return _apply.apply(this, arguments);
      }
      return apply;
    }()
  }]);
}($e.modules.CommandBase);
var _default = exports["default"] = View;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/component.js":
/*!*****************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/component.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _componentBase = _interopRequireDefault(__webpack_require__(/*! elementor-api/modules/component-base */ "../modules/web-cli/assets/js/modules/component-base.js"));
var _document = _interopRequireDefault(__webpack_require__(/*! ./document */ "../assets/dev/js/editor/components/documents/document.js"));
var commands = _interopRequireWildcard(__webpack_require__(/*! ./commands/ */ "../assets/dev/js/editor/components/documents/commands/index.js"));
var internalCommands = _interopRequireWildcard(__webpack_require__(/*! ./commands/internal/ */ "../assets/dev/js/editor/components/documents/commands/internal/index.js"));
var hooks = _interopRequireWildcard(__webpack_require__(/*! ./hooks */ "../assets/dev/js/editor/components/documents/hooks/index.js"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, o, e, r) { var p = (0, _get2.default)((0, _getPrototypeOf2.default)(1 & r ? t.prototype : t), o, e); return 2 & r && "function" == typeof p ? function (t) { return p.apply(e, t); } : p; }
var Component = exports["default"] = /*#__PURE__*/function (_ComponentBase) {
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _callSuper(this, Component, arguments);
  }
  (0, _inherits2.default)(Component, _ComponentBase);
  return (0, _createClass2.default)(Component, [{
    key: "__construct",
    value: function __construct() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      _superPropGet(Component, "__construct", this, 3)([args]);

      /**
       * All the documents.
       *
       * @type {Object.<Document>}
       */
      this.documents = {};

      /**
       * Current document.
       *
       * @type {Document}
       */
      this.currentDocument = null;
      this.saveInitialDocumentToCache();
    }
  }, {
    key: "getNamespace",
    value: function getNamespace() {
      return 'editor/documents';
    }
  }, {
    key: "defaultCommands",
    value: function defaultCommands() {
      return this.importCommands(commands);
    }
  }, {
    key: "defaultHooks",
    value: function defaultHooks() {
      return this.importHooks(hooks);
    }
  }, {
    key: "defaultCommandsInternal",
    value: function defaultCommandsInternal() {
      return this.importCommands(internalCommands);
    }

    /**
     * Function add().
     *
     * Add's document to the manager.
     *
     * @param {Document} document
     *
     * @return {Document} document
     */
  }, {
    key: "add",
    value: function add(document) {
      var id = document.id;

      // Save the document.
      this.documents[id] = document;
      return document;
    }

    /**
     * Function addDocumentByConfig().
     *
     * Add document to manager by config.
     *
     * @param {{}} config
     *
     * @return {Document} document
     */
  }, {
    key: "addDocumentByConfig",
    value: function addDocumentByConfig(config) {
      return this.add(new _document.default(config));
    }

    /**
     * Function get().
     *
     * Get document by id.
     *
     * @param {number} id
     *
     * @return {Document|boolean} document, or false if doesn't exist
     */
  }, {
    key: "get",
    value: function get(id) {
      if (undefined !== this.documents[id]) {
        return this.documents[id];
      }
      return false;
    }

    /**
     * Function getCurrent().
     *
     * Return's current document.
     *
     * @return {Document} document
     */
  }, {
    key: "getCurrent",
    value: function getCurrent() {
      return this.currentDocument;
    }

    /**
     * Function getCurrentId().
     *
     * Return's current document id.
     *
     * @return {number} document id
     */
  }, {
    key: "getCurrentId",
    value: function getCurrentId() {
      return this.currentDocument.id;
    }
  }, {
    key: "getInitialId",
    value: function getInitialId() {
      return elementor.config.initial_document.id;
    }
  }, {
    key: "setInitialById",
    value: function setInitialById(id) {
      var document = this.get(id);
      if (!document) {
        return;
      }
      elementor.config.initial_document = document.config;
      elementorCommon.ajax.addRequestConstant('initial_document_id', document.id);
    }

    /**
     * Function setCurrent().
     *
     * set current document by document instance.
     *
     * @param {Document} document
     */
  }, {
    key: "setCurrent",
    value: function setCurrent(document) {
      if (undefined === this.documents[document.id]) {
        throw Error("The document with id: '".concat(document.id, "' does not exist/loaded"));
      }
      if (this.currentDocument) {
        this.currentDocument.editor.status = 'closed';
      }
      this.currentDocument = this.documents[document.id];
      this.currentDocument.editor.status = 'open';
      elementorCommon.ajax.addRequestConstant('editor_post_id', document.id);
    }
  }, {
    key: "isCurrent",
    value: function isCurrent(id) {
      return parseInt(id) === this.currentDocument.id;
    }
  }, {
    key: "unsetCurrent",
    value: function unsetCurrent() {
      this.currentDocument = null;
      elementorCommon.ajax.addRequestConstant('editor_post_id', null);
    }
  }, {
    key: "request",
    value: function request(id) {
      return elementorCommon.ajax.load(this.getRequestArgs(id), true);
    }
  }, {
    key: "invalidateCache",
    value: function invalidateCache() {
      var _this = this;
      var id = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      if (id) {
        elementorCommon.ajax.invalidateCache(this.getRequestArgs(id));
        return;
      }
      Object.keys(this.documents).forEach(function (docId) {
        elementorCommon.ajax.invalidateCache(_this.getRequestArgs(docId));
      });
    }
  }, {
    key: "getRequestArgs",
    value: function getRequestArgs(id) {
      id = parseInt(id);
      return {
        action: 'get_document_config',
        unique_id: "document-".concat(id),
        data: {
          id: id
        },
        success: function success(config) {
          return config;
        },
        error: function error(data) {
          var message;
          if (_.isString(data)) {
            message = data;
          } else if (data.statusText) {
            message = elementor.createAjaxErrorMessage(data);
            if (0 === data.readyState) {
              message += ' ' + __('Cannot load editor', 'elementor');
            }
          } else if (data[0] && data[0].code) {
            message = __('Server Error', 'elementor') + ' ' + data[0].code;
          }

          // eslint-disable-next-line no-alert
          alert(message);
        }
      };
    }

    /**
     * Temp: Don't request initial document via ajax.
     * Keep the event `elementor:init` before `preview:loaded`.
     */
  }, {
    key: "saveInitialDocumentToCache",
    value: function saveInitialDocumentToCache() {
      var document = elementor.config.initial_document;
      elementorCommon.ajax.addRequestCache(this.getRequestArgs(document.id), document);
    }
  }]);
}(_componentBase.default);

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/document.js":
/*!****************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/document.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _manager = _interopRequireDefault(__webpack_require__(/*! elementor/modules/history/assets/js/history/manager */ "../modules/history/assets/js/history/manager.js"));
var _manager2 = _interopRequireDefault(__webpack_require__(/*! elementor/modules/history/assets/js/revisions/manager */ "../modules/history/assets/js/revisions/manager.js"));
var _editor = _interopRequireDefault(__webpack_require__(/*! ./models/editor */ "../assets/dev/js/editor/components/documents/models/editor.js"));
/**
 * @typedef {import('../../container/container')} Container
 */
var Document = exports["default"] = /*#__PURE__*/function () {
  /**
   * Function constructor().
   *
   * Create document.
   *
   * @param {{}} config
   */
  function Document(config) {
    (0, _classCallCheck2.default)(this, Document);
    /**
     * Document id.
     *
     * @type {number|null}
     */
    (0, _defineProperty2.default)(this, "id", null);
    /**
     * History of the document.
     *
     * @type {HistoryManager}
     */
    (0, _defineProperty2.default)(this, "history", null);
    /**
     * Revisions of the document.
     *
     * @type {RevisionsManager}
     */
    (0, _defineProperty2.default)(this, "revisions", null);
    /**
     * Current container.
     *
     * @type {Container}
     */
    (0, _defineProperty2.default)(this, "container", null);
    /**
     * Editor Settings.
     *
     * @type {Editor}
     */
    (0, _defineProperty2.default)(this, "editor", new _editor.default());
    this.config = config;
    this.id = config.id;
    this.history = new _manager.default(this);
    this.revisions = new _manager2.default(this);
  }
  return (0, _createClass2.default)(Document, [{
    key: "isDraft",
    value: function isDraft() {
      return this.config.revisions.current_id !== this.config.id;
    }
  }]);
}();

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/hooks/index.js":
/*!*******************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/hooks/index.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "RemoveActiveDocumentQueryParam", ({
  enumerable: true,
  get: function get() {
    return _removeActiveDocumentQueryParam.RemoveActiveDocumentQueryParam;
  }
}));
Object.defineProperty(exports, "RemoveActiveTabQueryParam", ({
  enumerable: true,
  get: function get() {
    return _removeActiveTabQueryParam.RemoveActiveTabQueryParam;
  }
}));
Object.defineProperty(exports, "RemoveActiveTabQueryParamBack", ({
  enumerable: true,
  get: function get() {
    return _removeActiveTabQueryParamBack.RemoveActiveTabQueryParamBack;
  }
}));
Object.defineProperty(exports, "SetActiveDocumentQueryParam", ({
  enumerable: true,
  get: function get() {
    return _setActiveDocumentQueryParam.SetActiveDocumentQueryParam;
  }
}));
Object.defineProperty(exports, "SwitchToActiveDocument", ({
  enumerable: true,
  get: function get() {
    return _switchToActiveDocument.SwitchToActiveDocument;
  }
}));
Object.defineProperty(exports, "SwitchToActiveTab", ({
  enumerable: true,
  get: function get() {
    return _switchToActiveTab.SwitchToActiveTab;
  }
}));
var _removeActiveDocumentQueryParam = __webpack_require__(/*! ./ui/close/remove-active-document-query-param */ "../assets/dev/js/editor/components/documents/hooks/ui/close/remove-active-document-query-param.js");
var _setActiveDocumentQueryParam = __webpack_require__(/*! ./ui/open/set-active-document-query-param */ "../assets/dev/js/editor/components/documents/hooks/ui/open/set-active-document-query-param.js");
var _switchToActiveDocument = __webpack_require__(/*! ./ui/attach-preview/switch-to-active-document */ "../assets/dev/js/editor/components/documents/hooks/ui/attach-preview/switch-to-active-document.js");
var _switchToActiveTab = __webpack_require__(/*! ./ui/switch/switch-to-active-tab */ "../assets/dev/js/editor/components/documents/hooks/ui/switch/switch-to-active-tab.js");
var _removeActiveTabQueryParam = __webpack_require__(/*! ./ui/close/remove-active-tab-query-param */ "../assets/dev/js/editor/components/documents/hooks/ui/close/remove-active-tab-query-param.js");
var _removeActiveTabQueryParamBack = __webpack_require__(/*! ./ui/close/remove-active-tab-query-param-back */ "../assets/dev/js/editor/components/documents/hooks/ui/close/remove-active-tab-query-param-back.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/hooks/ui/attach-preview/switch-to-active-document.js":
/*!*********************************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/hooks/ui/attach-preview/switch-to-active-document.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.SwitchToActiveDocument = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _queryParams = __webpack_require__(/*! elementor-editor-utils/query-params */ "../assets/dev/js/editor/utils/query-params.js");
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/**
 * Switch to the document in the `active-document` query param on initial Editor load.
 * This hook runs only once, when the initial document has been attached.
 */
var SwitchToActiveDocument = exports.SwitchToActiveDocument = /*#__PURE__*/function (_$e$modules$hookUI$Af) {
  function SwitchToActiveDocument() {
    (0, _classCallCheck2.default)(this, SwitchToActiveDocument);
    return _callSuper(this, SwitchToActiveDocument, arguments);
  }
  (0, _inherits2.default)(SwitchToActiveDocument, _$e$modules$hookUI$Af);
  return (0, _createClass2.default)(SwitchToActiveDocument, [{
    key: "getCommand",
    value: function getCommand() {
      return 'editor/documents/attach-preview';
    }
  }, {
    key: "getId",
    value: function getId() {
      return 'switch-to-active-document';
    }
  }, {
    key: "getConditions",
    value: function getConditions() {
      if (this.constructor.calledOnce) {
        return false;
      }
      return elementor.documents.getCurrentId() === elementor.config.initial_document.id;
    }
  }, {
    key: "apply",
    value: function () {
      var _apply = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
        var activeDocumentId, isLoadedAlready, _t;
        return _regenerator.default.wrap(function (_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              this.constructor.calledOnce = true;
              activeDocumentId = parseInt((0, _queryParams.getQueryParam)('active-document')), isLoadedAlready = activeDocumentId === elementor.documents.getCurrentId();
              if (!(isNaN(activeDocumentId) || isLoadedAlready)) {
                _context.next = 1;
                break;
              }
              return _context.abrupt("return");
            case 1:
              _context.prev = 1;
              _context.next = 2;
              return $e.run('editor/documents/switch', {
                id: activeDocumentId,
                mode: 'autosave'
              });
            case 2:
              _context.next = 4;
              break;
            case 3:
              _context.prev = 3;
              _t = _context["catch"](1);
              $e.run('editor/documents/switch', {
                id: elementor.config.initial_document.id,
                mode: 'autosave'
              });
              (0, _queryParams.removeQueryParam)('active-document');
            case 4:
            case "end":
              return _context.stop();
          }
        }, _callee, this, [[1, 3]]);
      }));
      function apply() {
        return _apply.apply(this, arguments);
      }
      return apply;
    }()
  }]);
}($e.modules.hookUI.After);
(0, _defineProperty2.default)(SwitchToActiveDocument, "calledOnce", false);
var _default = exports["default"] = SwitchToActiveDocument;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/hooks/ui/close/remove-active-document-query-param.js":
/*!*********************************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/hooks/ui/close/remove-active-document-query-param.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.RemoveActiveDocumentQueryParam = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _queryParams = __webpack_require__(/*! elementor-editor-utils/query-params */ "../assets/dev/js/editor/utils/query-params.js");
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var RemoveActiveDocumentQueryParam = exports.RemoveActiveDocumentQueryParam = /*#__PURE__*/function (_$e$modules$hookUI$Af) {
  function RemoveActiveDocumentQueryParam() {
    (0, _classCallCheck2.default)(this, RemoveActiveDocumentQueryParam);
    return _callSuper(this, RemoveActiveDocumentQueryParam, arguments);
  }
  (0, _inherits2.default)(RemoveActiveDocumentQueryParam, _$e$modules$hookUI$Af);
  return (0, _createClass2.default)(RemoveActiveDocumentQueryParam, [{
    key: "getCommand",
    value: function getCommand() {
      return 'editor/documents/close';
    }
  }, {
    key: "getId",
    value: function getId() {
      return 'remove-active-document-query-param';
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var activeDocumentId = parseInt((0, _queryParams.getQueryParam)('active-document')),
        closedDocumentId = parseInt(args.id);
      if (activeDocumentId === closedDocumentId) {
        (0, _queryParams.removeQueryParam)('active-document');
      }
      args.previous_active_document_id = activeDocumentId;
    }
  }]);
}($e.modules.hookUI.After);
var _default = exports["default"] = RemoveActiveDocumentQueryParam;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/hooks/ui/close/remove-active-tab-query-param-back.js":
/*!*********************************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/hooks/ui/close/remove-active-tab-query-param-back.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.RemoveActiveTabQueryParamBack = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _queryParams = __webpack_require__(/*! elementor-editor-utils/query-params */ "../assets/dev/js/editor/utils/query-params.js");
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var RemoveActiveTabQueryParamBack = exports.RemoveActiveTabQueryParamBack = /*#__PURE__*/function (_$e$modules$hookUI$Af) {
  function RemoveActiveTabQueryParamBack() {
    (0, _classCallCheck2.default)(this, RemoveActiveTabQueryParamBack);
    return _callSuper(this, RemoveActiveTabQueryParamBack, arguments);
  }
  (0, _inherits2.default)(RemoveActiveTabQueryParamBack, _$e$modules$hookUI$Af);
  return (0, _createClass2.default)(RemoveActiveTabQueryParamBack, [{
    key: "getCommand",
    value: function getCommand() {
      return 'panel/global/back';
    }
  }, {
    key: "getId",
    value: function getId() {
      return 'remove-active-tab-query-param-back';
    }
  }, {
    key: "apply",
    value: function apply() {
      var activeTab = (0, _queryParams.getQueryParam)('active-tab');
      if (activeTab) {
        (0, _queryParams.removeQueryParam)('active-tab');
      }
    }
  }]);
}($e.modules.hookUI.After);
var _default = exports["default"] = RemoveActiveTabQueryParamBack;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/hooks/ui/close/remove-active-tab-query-param.js":
/*!****************************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/hooks/ui/close/remove-active-tab-query-param.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.RemoveActiveTabQueryParam = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _queryParams = __webpack_require__(/*! elementor-editor-utils/query-params */ "../assets/dev/js/editor/utils/query-params.js");
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var RemoveActiveTabQueryParam = exports.RemoveActiveTabQueryParam = /*#__PURE__*/function (_$e$modules$hookUI$Af) {
  function RemoveActiveTabQueryParam() {
    (0, _classCallCheck2.default)(this, RemoveActiveTabQueryParam);
    return _callSuper(this, RemoveActiveTabQueryParam, arguments);
  }
  (0, _inherits2.default)(RemoveActiveTabQueryParam, _$e$modules$hookUI$Af);
  return (0, _createClass2.default)(RemoveActiveTabQueryParam, [{
    key: "getCommand",
    value: function getCommand() {
      return 'editor/documents/close';
    }
  }, {
    key: "getId",
    value: function getId() {
      return 'remove-active-tab-query-param';
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var activeTab = (0, _queryParams.getQueryParam)('active-tab'),
        activeDocumentId = parseInt(args.previous_active_document_id),
        closedDocumentId = parseInt(args.id);
      if (activeDocumentId === closedDocumentId && activeTab) {
        (0, _queryParams.removeQueryParam)('active-tab');
      }
    }
  }]);
}($e.modules.hookUI.After);
var _default = exports["default"] = RemoveActiveTabQueryParam;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/hooks/ui/open/set-active-document-query-param.js":
/*!*****************************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/hooks/ui/open/set-active-document-query-param.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.SetActiveDocumentQueryParam = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _queryParams = __webpack_require__(/*! elementor-editor-utils/query-params */ "../assets/dev/js/editor/utils/query-params.js");
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var SetActiveDocumentQueryParam = exports.SetActiveDocumentQueryParam = /*#__PURE__*/function (_$e$modules$hookUI$Af) {
  function SetActiveDocumentQueryParam() {
    (0, _classCallCheck2.default)(this, SetActiveDocumentQueryParam);
    return _callSuper(this, SetActiveDocumentQueryParam, arguments);
  }
  (0, _inherits2.default)(SetActiveDocumentQueryParam, _$e$modules$hookUI$Af);
  return (0, _createClass2.default)(SetActiveDocumentQueryParam, [{
    key: "getCommand",
    value: function getCommand() {
      return 'editor/documents/open';
    }
  }, {
    key: "getId",
    value: function getId() {
      return 'set-active-document-query-param';
    }
  }, {
    key: "getConditions",
    value: function getConditions(args) {
      // Don't run for the initial/default document because it's redundant.
      return parseInt(args.id) !== parseInt(elementor.config.initial_document.id);
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var id = parseInt(args.id);
      if (!isNaN(id)) {
        (0, _queryParams.setQueryParam)('active-document', args.id);
      }
    }
  }]);
}($e.modules.hookUI.After);
var _default = exports["default"] = SetActiveDocumentQueryParam;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/hooks/ui/switch/switch-to-active-tab.js":
/*!********************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/hooks/ui/switch/switch-to-active-tab.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.SwitchToActiveTab = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _queryParams = __webpack_require__(/*! elementor-editor-utils/query-params */ "../assets/dev/js/editor/utils/query-params.js");
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var SwitchToActiveTab = exports.SwitchToActiveTab = /*#__PURE__*/function (_$e$modules$hookUI$Af) {
  function SwitchToActiveTab() {
    (0, _classCallCheck2.default)(this, SwitchToActiveTab);
    return _callSuper(this, SwitchToActiveTab, arguments);
  }
  (0, _inherits2.default)(SwitchToActiveTab, _$e$modules$hookUI$Af);
  return (0, _createClass2.default)(SwitchToActiveTab, [{
    key: "getCommand",
    value: function getCommand() {
      return 'editor/documents/switch';
    }
  }, {
    key: "getId",
    value: function getId() {
      return 'switch-to-active-tab';
    }
  }, {
    key: "getConditions",
    value: function getConditions() {
      if (this.constructor.calledOnce) {
        return false;
      }
      return true;
    }
  }, {
    key: "apply",
    value: function apply() {
      this.constructor.calledOnce = true;
      try {
        var activeTab = (0, _queryParams.getQueryParam)('active-tab');
        if (activeTab) {
          $e.route('panel/global/' + activeTab);
        }
      } catch (e) {
        (0, _queryParams.removeQueryParam)('active-tab');
      }
    }
  }]);
}($e.modules.hookUI.After);
(0, _defineProperty2.default)(SwitchToActiveTab, "calledOnce", false);
var _default = exports["default"] = SwitchToActiveTab;

/***/ }),

/***/ "../assets/dev/js/editor/components/documents/models/editor.js":
/*!*********************************************************************!*\
  !*** ../assets/dev/js/editor/components/documents/models/editor.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var Editor = exports["default"] = /*#__PURE__*/(0, _createClass2.default)(function Editor() {
  (0, _classCallCheck2.default)(this, Editor);
  /**
   * Editor status.
   *
   * @type {'open'|'closed'}
   */
  (0, _defineProperty2.default)(this, "status", 'closed');
  /**
   * Is document still saving?.
   *
   * @type {boolean}
   */
  (0, _defineProperty2.default)(this, "isSaving", false);
  /**
   * Is document changed?.
   *
   * @type {boolean}
   */
  (0, _defineProperty2.default)(this, "isChanged", false);
  /**
   * Is document changed during save?.
   *
   * @type {boolean}
   */
  (0, _defineProperty2.default)(this, "isChangedDuringSave", false);
  /**
   * Is document saved?
   *
   * @type {boolean}
   */
  (0, _defineProperty2.default)(this, "isSaved", true);
  /**
   * Last save history id.
   *
   * @type {number}
   */
  (0, _defineProperty2.default)(this, "lastSaveHistoryId", 0);
});

/***/ }),

/***/ "../assets/dev/js/editor/components/dynamic-tags/control-behavior.js":
/*!***************************************************************************!*\
  !*** ../assets/dev/js/editor/components/dynamic-tags/control-behavior.js ***!
  \***************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var TagPanelView = __webpack_require__(/*! elementor-dynamic-tags/tag-panel-view */ "../assets/dev/js/editor/components/dynamic-tags/tag-panel-view.js");
module.exports = Marionette.Behavior.extend({
  tagView: null,
  listenerAttached: false,
  initialize: function initialize() {
    if (!this.listenerAttached) {
      this.listenTo(this.view.options.container.settings, 'change:external:__dynamic__', this.onAfterExternalChange);
      this.listenerAttached = true;
    }
  },
  shouldRenderTools: function shouldRenderTools() {
    var hasDefault = this.getOption('dynamicSettings').default;
    if (hasDefault) {
      return false;
    }
    var isFeatureAvailableToUser = elementor.helpers.hasPro() && !elementor.helpers.hasProAndNotConnected(),
      hasTags = this.getOption('tags').length > 0;
    return !isFeatureAvailableToUser || hasTags;
  },
  renderTools: function renderTools() {
    var _this = this;
    if (!this.shouldRenderTools()) {
      return;
    }
    var $dynamicSwitcher = jQuery(Marionette.Renderer.render('#tmpl-elementor-control-dynamic-switcher'));
    $dynamicSwitcher.on('click', function (event) {
      return _this.onDynamicSwitcherClick(event);
    });
    this.$el.find('.elementor-control-dynamic-switcher-wrapper').append($dynamicSwitcher);
    this.ui.dynamicSwitcher = $dynamicSwitcher;
    if ('color' === this.view.model.get('type')) {
      if (this.view.colorPicker) {
        this.moveDynamicSwitcherToColorPicker();
      } else {
        setTimeout(function () {
          return _this.moveDynamicSwitcherToColorPicker();
        });
      }
    }

    // Add a Tipsy Tooltip to the Dynamic Switcher
    this.ui.dynamicSwitcher.tipsy({
      title: function title() {
        return this.getAttribute('data-tooltip');
      },
      gravity: 's'
    });
  },
  moveDynamicSwitcherToColorPicker: function moveDynamicSwitcherToColorPicker() {
    var $colorPickerToolsContainer = this.view.colorPicker.$pickerToolsContainer;
    this.ui.dynamicSwitcher.removeClass('elementor-control-unit-1').addClass('e-control-tool');
    var $eyedropper = $colorPickerToolsContainer.find('.elementor-control-element-color-picker');
    if ($eyedropper.length) {
      this.ui.dynamicSwitcher.insertBefore($eyedropper);
    } else {
      $colorPickerToolsContainer.append(this.ui.dynamicSwitcher);
    }
  },
  toggleDynamicClass: function toggleDynamicClass() {
    this.$el.toggleClass('elementor-control-dynamic-value', this.isDynamicMode());
  },
  isDynamicMode: function isDynamicMode() {
    var dynamicSettings = this.view.container.settings.get('__dynamic__');
    return !!(dynamicSettings && dynamicSettings[this.view.model.get('name')]);
  },
  createTagsList: function createTagsList() {
    var tags = _.groupBy(this.getOption('tags'), 'group'),
      groups = elementor.dynamicTags.getConfig('groups'),
      $tagsList = this.ui.tagsList = jQuery('<div>', {
        class: 'elementor-tags-list'
      }),
      $tagsListInner = jQuery('<div>', {
        class: 'elementor-tags-list__inner'
      });
    $tagsList.append($tagsListInner);
    jQuery.each(groups, function (groupName) {
      var groupTags = tags[groupName];
      if (!groupTags) {
        return;
      }
      var group = this,
        $groupTitle = jQuery('<div>', {
          class: 'elementor-tags-list__group-title'
        }).text(group.title);
      $tagsListInner.append($groupTitle);
      groupTags.forEach(function (tag) {
        var $tag = jQuery('<div>', {
          class: 'elementor-tags-list__item'
        });
        $tag.text(tag.title).attr('data-tag-name', tag.name);
        $tagsListInner.append($tag);
      });
    });

    // Create and inject pro dynamic teaser template if Pro is not installed
    if (!elementor.helpers.hasPro() && Object.keys(tags).length) {
      var proTeaser = Marionette.Renderer.render('#tmpl-elementor-dynamic-tags-promo', {
        promotionUrl: elementor.config.dynamicPromotionURL.replace('%s', this.view.model.get('name'))
      });
      $tagsListInner.append(proTeaser);
    }
    $tagsListInner.on('click', '.elementor-tags-list__item', this.onTagsListItemClick.bind(this));
    elementorCommon.elements.$body.append($tagsList);
  },
  getTagsList: function getTagsList() {
    if (!this.ui.tagsList) {
      this.createTagsList();
    }
    return this.ui.tagsList;
  },
  toggleTagsList: function toggleTagsList() {
    var $tagsList = this.getTagsList();
    if ($tagsList.is(':visible')) {
      $tagsList.hide();
      return;
    }
    var direction = elementorCommon.config.isRTL ? 'left' : 'right';
    $tagsList.show().position({
      my: "".concat(direction, " top"),
      at: "".concat(direction, " bottom+5"),
      of: this.ui.dynamicSwitcher
    });
  },
  setTagView: function setTagView(id, name, settings) {
    if (this.tagView) {
      this.tagView.destroy();
    }
    var tagView = this.tagView = new TagPanelView({
        id: id,
        name: name,
        settings: settings,
        controlName: this.view.model.get('name'),
        dynamicSettings: this.getOption('dynamicSettings')
      }),
      elementContainer = this.view.options.container,
      tagViewLabel = elementContainer.controls[tagView.options.controlName].label;
    tagView.options.container = new elementorModules.editor.Container({
      type: 'dynamic',
      id: id,
      model: tagView.model,
      settings: tagView.model,
      view: tagView,
      parent: elementContainer,
      label: elementContainer.label + ' ' + tagViewLabel,
      controls: tagView.model.options.controls,
      renderer: elementContainer
    });
    tagView.render();
    this.$el.find('.elementor-control-tag-area').after(tagView.el);
    this.listenTo(tagView, 'remove', this.onTagViewRemove.bind(this));
  },
  setDefaultTagView: function setDefaultTagView() {
    var tagData = elementor.dynamicTags.tagTextToTagData(this.getDynamicValue());
    this.setTagView(tagData.id, tagData.name, tagData.settings);
  },
  tagViewToTagText: function tagViewToTagText() {
    var tagView = this.tagView;
    return elementor.dynamicTags.tagDataToTagText(tagView.getOption('id'), tagView.getOption('name'), tagView.model);
  },
  getDynamicValue: function getDynamicValue() {
    return this.view.container.dynamic.get(this.view.model.get('name'));
  },
  destroyTagView: function destroyTagView() {
    if (this.tagView) {
      this.tagView.destroy();
      this.tagView = null;
    }
  },
  showPromotion: function showPromotion() {
    var hasProAndNotConnected = elementor.helpers.hasProAndNotConnected(),
      dialogOptions = {
        title: __('Dynamic Content', 'elementor'),
        content: __('Create more personalized and dynamic sites by populating data from various sources with dozens of dynamic tags to choose from.', 'elementor'),
        targetElement: this.ui.dynamicSwitcher,
        position: {
          blockStart: '-10'
        },
        actionButton: {
          url: hasProAndNotConnected ? elementorProEditorConfig.urls.connect : elementor.config.dynamicPromotionURL.replace('%s', this.view.model.get('name')),
          text: hasProAndNotConnected ? __('Connect & Activate', 'elementor') : __('Upgrade', 'elementor')
        }
      };
    elementor.promotion.showDialog(dialogOptions);
  },
  onRender: function onRender() {
    this.$el.addClass('elementor-control-dynamic');
    this.renderTools();
    this.toggleDynamicClass();
    if (this.isDynamicMode()) {
      this.setDefaultTagView();
    }
  },
  onDynamicSwitcherClick: function onDynamicSwitcherClick(event) {
    event.stopPropagation();
    if (this.getOption('tags').length) {
      this.toggleTagsList();
    } else {
      this.showPromotion();
    }
  },
  onTagsListItemClick: function onTagsListItemClick(event) {
    var $tag = jQuery(event.currentTarget);
    this.setTagView(elementorCommon.helpers.getUniqueId(), $tag.data('tagName'), {});

    // If an element has an active global value, disable it before applying the dynamic value.
    if (this.view.getGlobalKey()) {
      this.view.triggerMethod('unset:global:value');
    }
    if (this.isDynamicMode()) {
      $e.run('document/dynamic/settings', {
        container: this.view.options.container,
        settings: (0, _defineProperty2.default)({}, this.view.model.get('name'), this.tagViewToTagText())
      });
    } else {
      $e.run('document/dynamic/enable', {
        container: this.view.options.container,
        settings: (0, _defineProperty2.default)({}, this.view.model.get('name'), this.tagViewToTagText())
      });
    }
    this.toggleDynamicClass();
    this.toggleTagsList();
    if (this.tagView.getTagConfig().settings_required) {
      this.tagView.showSettingsPopup();
    }
  },
  onTagViewRemove: function onTagViewRemove() {
    $e.run('document/dynamic/disable', {
      container: this.view.options.container,
      settings: (0, _defineProperty2.default)({}, this.view.model.get('name'), this.tagViewToTagText())
    });
    this.toggleDynamicClass();
  },
  onAfterExternalChange: function onAfterExternalChange() {
    this.destroyTagView();
    if (this.isDynamicMode()) {
      this.setDefaultTagView();
    }
    this.toggleDynamicClass();
  },
  onDestroy: function onDestroy() {
    this.destroyTagView();
    if (this.ui.tagsList) {
      this.ui.tagsList.remove();
    }
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/dynamic-tags/manager.js":
/*!******************************************************************!*\
  !*** ../assets/dev/js/editor/components/dynamic-tags/manager.js ***!
  \******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
module.exports = elementorModules.Module.extend({
  CACHE_KEY_NOT_FOUND_ERROR: 'Cache key not found',
  tags: {
    Base: __webpack_require__(/*! elementor-dynamic-tags/tag */ "../assets/dev/js/editor/components/dynamic-tags/tag.js")
  },
  cache: {},
  cacheRequests: {},
  cacheCallbacks: [],
  addCacheRequest: function addCacheRequest(tag) {
    this.cacheRequests[this.createCacheKey(tag)] = true;
  },
  createCacheKey: function createCacheKey(tag) {
    return btoa(tag.getOption('name')) + '-' + btoa(encodeURIComponent(JSON.stringify(tag.model)));
  },
  loadTagDataFromCache: function loadTagDataFromCache(tag) {
    var cacheKey = this.createCacheKey(tag);
    if (undefined !== this.cache[cacheKey]) {
      return this.cache[cacheKey];
    }
    if (!this.cacheRequests[cacheKey]) {
      this.addCacheRequest(tag);
    }
  },
  loadCacheRequests: function loadCacheRequests() {
    var _this = this;
    var cacheRequests = this.cacheRequests,
      cacheCallbacks = this.cacheCallbacks;
    this.cacheRequests = {};
    this.cacheCallbacks = [];
    elementorCommon.ajax.addRequest('render_tags', {
      data: {
        post_id: elementor.config.document.id,
        tags: Object.keys(cacheRequests)
      },
      success: function success(data) {
        _this.cache = _objectSpread(_objectSpread({}, _this.cache), data);
        cacheCallbacks.forEach(function (callback) {
          callback();
        });
      }
    });
  },
  refreshCacheFromServer: function refreshCacheFromServer(callback) {
    this.cacheCallbacks.push(callback);
    this.loadCacheRequests();
  },
  getConfig: function getConfig(key) {
    return this.getItems(elementor.config.dynamicTags, key);
  },
  parseTagsText: function parseTagsText(text, settings, parseCallback) {
    var self = this;
    if ('object' === settings.returnType) {
      return self.parseTagText(text, settings, parseCallback);
    }
    return text.replace(/\[elementor-tag[^\]]+]/g, function (tagText) {
      return self.parseTagText(tagText, settings, parseCallback);
    });
  },
  parseTagText: function parseTagText(tagText, settings, parseCallback) {
    var tagData = this.tagTextToTagData(tagText);
    if (!tagData) {
      if ('object' === settings.returnType) {
        return {};
      }
      return '';
    }
    return parseCallback(tagData.id, tagData.name, tagData.settings);
  },
  tagTextToTagData: function tagTextToTagData(tagText) {
    var tagIDMatch = tagText.match(/id="(.*?(?="))"/),
      tagNameMatch = tagText.match(/name="(.*?(?="))"/),
      tagSettingsMatch = tagText.match(/settings="(.*?(?="]))/);
    if (!tagIDMatch || !tagNameMatch || !tagSettingsMatch) {
      return false;
    }
    return {
      id: tagIDMatch[1],
      name: tagNameMatch[1],
      settings: JSON.parse(decodeURIComponent(tagSettingsMatch[1]))
    };
  },
  createTag: function createTag(tagID, tagName, tagSettings) {
    var tagConfig = this.getConfig('tags.' + tagName);
    if (!tagConfig) {
      return;
    }
    var TagClass = this.tags[tagName] || this.tags.Base,
      model = new elementorModules.editor.elements.models.BaseSettings(tagSettings, {
        controls: tagConfig.controls
      });
    return new TagClass({
      id: tagID,
      name: tagName,
      model: model
    });
  },
  getTagDataContent: function getTagDataContent(tagID, tagName, tagSettings) {
    var tag = this.createTag(tagID, tagName, tagSettings);
    if (!tag) {
      return;
    }
    return tag.getContent();
  },
  tagDataToTagText: function tagDataToTagText(tagID, tagName, tagSettings) {
    tagSettings = encodeURIComponent(JSON.stringify(tagSettings && tagSettings.toJSON({
      remove: ['default']
    }) || {}));
    return '[elementor-tag id="' + tagID + '" name="' + tagName + '" settings="' + tagSettings + '"]';
  },
  tagContainerToTagText: function tagContainerToTagText(/** Container*/container) {
    return elementor.dynamicTags.tagDataToTagText(container.view.getOption('id'), container.view.getOption('name'), container.view.model);
  },
  cleanCache: function cleanCache() {
    this.cache = {};
  },
  onInit: function onInit() {
    this.loadCacheRequests = _.debounce(this.loadCacheRequests, 300);
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/dynamic-tags/tag-controls-stack-empty.js":
/*!***********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/dynamic-tags/tag-controls-stack-empty.js ***!
  \***********************************************************************************/
/***/ ((module) => {

"use strict";


module.exports = Marionette.ItemView.extend({
  className: 'elementor-tag-controls-stack-empty',
  template: '#tmpl-elementor-tag-controls-stack-empty'
});

/***/ }),

/***/ "../assets/dev/js/editor/components/dynamic-tags/tag-controls-stack.js":
/*!*****************************************************************************!*\
  !*** ../assets/dev/js/editor/components/dynamic-tags/tag-controls-stack.js ***!
  \*****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var EmptyView = __webpack_require__(/*! elementor-dynamic-tags/tag-controls-stack-empty */ "../assets/dev/js/editor/components/dynamic-tags/tag-controls-stack-empty.js");
module.exports = elementorModules.editor.views.ControlsStack.extend({
  activeTab: 'content',
  template: _.noop,
  emptyView: EmptyView,
  isEmpty: function isEmpty() {
    // Ignore the section control
    return this.collection.length < 2;
  },
  childViewOptions: function childViewOptions() {
    return {
      container: this.options.container
    };
  },
  getNamespaceArray: function getNamespaceArray() {
    var currentPageView = elementor.getPanelView().getCurrentPageView(),
      eventNamespace = currentPageView.getNamespaceArray();
    eventNamespace.push(currentPageView.activeSection);
    eventNamespace.push(this.getOption('controlName'));
    eventNamespace.push(this.getOption('name'));
    return eventNamespace;
  },
  onRenderTemplate: function onRenderTemplate() {
    this.activateFirstSection();
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/dynamic-tags/tag-panel-view.js":
/*!*************************************************************************!*\
  !*** ../assets/dev/js/editor/components/dynamic-tags/tag-panel-view.js ***!
  \*************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var TagControlsStack = __webpack_require__(/*! elementor-dynamic-tags/tag-controls-stack */ "../assets/dev/js/editor/components/dynamic-tags/tag-controls-stack.js");
module.exports = Marionette.ItemView.extend({
  className: 'elementor-dynamic-cover e-input-style',
  tagControlsStack: null,
  templateHelpers: function templateHelpers() {
    var helpers = {};
    if (this.model) {
      helpers.controls = this.model.options.controls;
    }
    return helpers;
  },
  ui: {
    remove: '.elementor-dynamic-cover__remove'
  },
  events: function events() {
    var events = {
      'click @ui.remove': 'onRemoveClick'
    };
    if (this.hasSettings()) {
      events.click = 'onClick';
    }
    return events;
  },
  getTemplate: function getTemplate() {
    var config = this.getTagConfig(),
      templateFunction = Marionette.TemplateCache.get('#tmpl-elementor-control-dynamic-cover'),
      renderedTemplate = Marionette.Renderer.render(templateFunction, {
        hasSettings: this.hasSettings(),
        isRemovable: !this.getOption('dynamicSettings').default,
        title: config.title,
        content: config.panel_template
      });
    return Marionette.TemplateCache.prototype.compileTemplate(renderedTemplate.trim());
  },
  getTagConfig: function getTagConfig() {
    return elementor.dynamicTags.getConfig('tags.' + this.getOption('name'));
  },
  initSettingsPopup: function initSettingsPopup() {
    var settingsPopupOptions = {
      className: 'elementor-tag-settings-popup',
      position: {
        my: 'left top+5',
        at: 'left bottom',
        of: this.$el,
        autoRefresh: true
      },
      hide: {
        ignore: '.select2-container'
      }
    };
    var settingsPopup = elementorCommon.dialogsManager.createWidget('buttons', settingsPopupOptions);
    this.getSettingsPopup = function () {
      return settingsPopup;
    };
  },
  hasSettings: function hasSettings() {
    return !!Object.values(this.getTagConfig().controls).length;
  },
  showSettingsPopup: function showSettingsPopup() {
    if (!this.tagControlsStack) {
      this.initTagControlsStack();
    }
    var settingsPopup = this.getSettingsPopup();
    if (settingsPopup.isVisible()) {
      return;
    }
    settingsPopup.show();
  },
  initTagControlsStack: function initTagControlsStack() {
    this.tagControlsStack = new TagControlsStack({
      model: this.model,
      controls: this.model.controls,
      name: this.options.name,
      controlName: this.options.controlName,
      container: this.options.container,
      el: this.getSettingsPopup().getElements('message')[0]
    });
    this.tagControlsStack.render();
  },
  initModel: function initModel() {
    this.model = new elementorModules.editor.elements.models.BaseSettings(this.getOption('settings'), {
      controls: this.getTagConfig().controls
    });
  },
  initialize: function initialize() {
    // The `model` should always be available.
    this.initModel();
    if (!this.hasSettings()) {
      return;
    }
    this.initSettingsPopup();
    this.listenTo(this.model, 'change', this.render);
  },
  onClick: function onClick() {
    this.showSettingsPopup();
  },
  onRemoveClick: function onRemoveClick(event) {
    event.stopPropagation();
    this.destroy();
    this.trigger('remove');
  },
  onDestroy: function onDestroy() {
    if (this.hasSettings()) {
      this.getSettingsPopup().destroy();
    }
    if (this.tagControlsStack) {
      this.tagControlsStack.destroy();
    }
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/dynamic-tags/tag.js":
/*!**************************************************************!*\
  !*** ../assets/dev/js/editor/components/dynamic-tags/tag.js ***!
  \**************************************************************/
/***/ ((module) => {

"use strict";


module.exports = Marionette.ItemView.extend({
  hasTemplate: true,
  tagName: 'span',
  className: function className() {
    return 'elementor-tag';
  },
  getTemplate: function getTemplate() {
    if (!this.hasTemplate) {
      return false;
    }
    return Marionette.TemplateCache.get('#tmpl-elementor-tag-' + this.getOption('name') + '-content');
  },
  initialize: function initialize() {
    try {
      this.getTemplate();
    } catch (e) {
      this.hasTemplate = false;
    }
  },
  getConfig: function getConfig(key) {
    var config = elementor.dynamicTags.getConfig('tags.' + this.getOption('name'));
    if (key) {
      return config[key];
    }
    return config;
  },
  getContent: function getContent() {
    var contentType = this.getConfig('content_type'),
      data;
    if (!this.hasTemplate) {
      data = elementor.dynamicTags.loadTagDataFromCache(this);
      if (undefined === data) {
        throw new Error(elementor.dynamicTags.CACHE_KEY_NOT_FOUND_ERROR);
      }
    }
    if ('ui' === contentType) {
      this.render();
      if (this.hasTemplate) {
        return this.el.outerHTML;
      }
      if (this.getConfig('wrapped_tag')) {
        data = jQuery(data).html();
      }
      this.$el.html(data);
    }
    return data;
  },
  onRender: function onRender() {
    this.el.id = 'elementor-tag-' + this.getOption('id');
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/hotkeys/component.js":
/*!***************************************************************!*\
  !*** ../assets/dev/js/editor/components/hotkeys/component.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _componentModalBase = _interopRequireDefault(__webpack_require__(/*! elementor-api/modules/component-modal-base */ "../modules/web-cli/assets/js/modules/component-modal-base.js"));
var _modalLayout = _interopRequireDefault(__webpack_require__(/*! ./modal-layout */ "../assets/dev/js/editor/components/hotkeys/modal-layout.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Component = exports["default"] = /*#__PURE__*/function (_ComponentModalBase) {
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _callSuper(this, Component, arguments);
  }
  (0, _inherits2.default)(Component, _ComponentModalBase);
  return (0, _createClass2.default)(Component, [{
    key: "getNamespace",
    value: function getNamespace() {
      return 'shortcuts';
    }
  }, {
    key: "defaultShortcuts",
    value: function defaultShortcuts() {
      return {
        '': {
          keys: 'ctrl+?, shift+?',
          exclude: ['input']
        }
      };
    }
  }, {
    key: "getModalLayout",
    value: function getModalLayout() {
      return _modalLayout.default;
    }
  }]);
}(_componentModalBase.default);

/***/ }),

/***/ "../assets/dev/js/editor/components/hotkeys/hotkeys.js":
/*!*************************************************************!*\
  !*** ../assets/dev/js/editor/components/hotkeys/hotkeys.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _component = _interopRequireDefault(__webpack_require__(/*! ./component */ "../assets/dev/js/editor/components/hotkeys/component.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var _default = exports["default"] = /*#__PURE__*/function (_elementorModules$Mod) {
  function _default() {
    (0, _classCallCheck2.default)(this, _default);
    return _callSuper(this, _default, arguments);
  }
  (0, _inherits2.default)(_default, _elementorModules$Mod);
  return (0, _createClass2.default)(_default, [{
    key: "onInit",
    value: function onInit() {
      $e.components.register(new _component.default({
        manager: this
      }));
    }
  }]);
}(elementorModules.Module);

/***/ }),

/***/ "../assets/dev/js/editor/components/hotkeys/modal-content.js":
/*!*******************************************************************!*\
  !*** ../assets/dev/js/editor/components/hotkeys/modal-content.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _environment = _interopRequireDefault(__webpack_require__(/*! elementor-common/utils/environment */ "../core/common/assets/js/utils/environment.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var _default = exports["default"] = /*#__PURE__*/function (_Marionette$LayoutVie) {
  function _default() {
    (0, _classCallCheck2.default)(this, _default);
    return _callSuper(this, _default, arguments);
  }
  (0, _inherits2.default)(_default, _Marionette$LayoutVie);
  return (0, _createClass2.default)(_default, [{
    key: "id",
    value: function id() {
      return 'elementor-hotkeys';
    }
  }, {
    key: "templateHelpers",
    value: function templateHelpers() {
      return {
        environment: _environment.default
      };
    }
  }, {
    key: "getTemplate",
    value: function getTemplate() {
      return '#tmpl-elementor-hotkeys';
    }
  }]);
}(Marionette.LayoutView);

/***/ }),

/***/ "../assets/dev/js/editor/components/hotkeys/modal-layout.js":
/*!******************************************************************!*\
  !*** ../assets/dev/js/editor/components/hotkeys/modal-layout.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _modalContent = _interopRequireDefault(__webpack_require__(/*! ./modal-content */ "../assets/dev/js/editor/components/hotkeys/modal-content.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, o, e, r) { var p = (0, _get2.default)((0, _getPrototypeOf2.default)(1 & r ? t.prototype : t), o, e); return 2 & r && "function" == typeof p ? function (t) { return p.apply(e, t); } : p; }
var _default = exports["default"] = /*#__PURE__*/function (_elementorModules$com) {
  function _default() {
    (0, _classCallCheck2.default)(this, _default);
    return _callSuper(this, _default, arguments);
  }
  (0, _inherits2.default)(_default, _elementorModules$com);
  return (0, _createClass2.default)(_default, [{
    key: "getModalOptions",
    value: function getModalOptions() {
      return {
        id: 'elementor-hotkeys__modal'
      };
    }
  }, {
    key: "getLogoOptions",
    value: function getLogoOptions() {
      return {
        title: __('Keyboard Shortcuts', 'elementor')
      };
    }
  }, {
    key: "initialize",
    value: function initialize() {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      _superPropGet(_default, "initialize", this, 3)(args);
      this.showLogo();
      this.showContentView();
    }
  }, {
    key: "showContentView",
    value: function showContentView() {
      this.modalContent.show(new _modalContent.default());
    }
  }]);
}(elementorModules.common.views.modal.Layout);

/***/ }),

/***/ "../assets/dev/js/editor/components/icons-manager/classes/icon-library.js":
/*!********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/icons-manager/classes/icon-library.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _typeof2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _default = exports["default"] = /*#__PURE__*/function () {
  function _default() {
    var _this = this;
    (0, _classCallCheck2.default)(this, _default);
    (0, _defineProperty2.default)(this, "loaded", {});
    (0, _defineProperty2.default)(this, "notifyCallback", null);
    (0, _defineProperty2.default)(this, "fetchIcons", function (library) {
      fetch(library.fetchJson, {
        mode: 'cors'
      }).then(function (res) {
        return res.json();
      }).then(function (json) {
        library.icons = json.icons;
        return _this.normalizeIconList(library);
      });
    });
    (0, _defineProperty2.default)(this, "runCallback", function (library) {
      if ('function' !== typeof _this.notifyCallback) {
        return library;
      }
      return _this.notifyCallback(library);
    });
    (0, _defineProperty2.default)(this, "initIconType", function (libraryConfig, callback) {
      _this.notifyCallback = callback;
      var store = elementor.iconManager.store;
      if (_this.loaded[libraryConfig.name]) {
        libraryConfig.icons = store.getIcons(libraryConfig);
        return _this.runCallback(libraryConfig);
      }

      // Enqueue CSS
      if (libraryConfig.enqueue) {
        libraryConfig.enqueue.forEach(function (assetURL) {
          var versionAddedURL = "".concat(assetURL).concat(libraryConfig !== null && libraryConfig !== void 0 && libraryConfig.ver ? '?ver=' + libraryConfig.ver : '');
          elementor.helpers.enqueueEditorStylesheet(versionAddedURL);
        });
      }
      if (libraryConfig.url) {
        var versionAddedURL = "".concat(libraryConfig.url).concat(libraryConfig !== null && libraryConfig !== void 0 && libraryConfig.ver ? '?ver=' + libraryConfig.ver : '');
        elementor.helpers.enqueueEditorStylesheet(versionAddedURL);
      }

      // Already saved an stored
      if (store.isValid(libraryConfig)) {
        var data = store.get(store.getKey(libraryConfig));
        return _this.normalizeIconList(data);
      }

      // Comes with icons
      if (libraryConfig.icons && libraryConfig.icons.length) {
        return _this.normalizeIconList(libraryConfig);
      }

      // Get icons from via ajax
      if (libraryConfig.fetchJson) {
        return _this.fetchIcons(libraryConfig);
      }
      // @todo: error handling
    });
  }
  return (0, _createClass2.default)(_default, [{
    key: "normalizeIconList",
    value: function normalizeIconList(library) {
      var icons = {};
      var name;
      jQuery.each(library.icons, function (index, icon) {
        name = icon;
        if ('object' === (0, _typeof2.default)(name)) {
          name = Object.entries(name)[0][0];
        }
        if (!name) {
          return;
        }
        icons[name] = {
          prefix: library.prefix,
          selector: library.prefix + name.trim(':'),
          name: elementorCommon.helpers.upperCaseWords(name).trim(':').split('-').join(' '),
          filter: name.trim(':'),
          displayPrefix: library.displayPrefix || library.prefix.replace('-', '')
        };
      });
      if (Object.keys(icons).length) {
        library.icons = icons;
        this.loaded[library.name] = true;
        elementor.iconManager.store.save(library);
        this.runCallback(library);
      }
    }
  }]);
}();

/***/ }),

/***/ "../assets/dev/js/editor/components/icons-manager/classes/store.js":
/*!*************************************************************************!*\
  !*** ../assets/dev/js/editor/components/icons-manager/classes/store.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _Store = /*#__PURE__*/function () {
  function Store() {
    (0, _classCallCheck2.default)(this, Store);
  }
  return (0, _createClass2.default)(Store, [{
    key: "save",
    value: function save(library) {
      elementorCommon.storage.set(_Store.getKey(library), library);
    }
  }, {
    key: "getIcons",
    value: function getIcons(library) {
      var data = this.get(_Store.getKey(library));
      if (data && data.icons) {
        return data.icons;
      }
      return false;
    }
  }, {
    key: "get",
    value: function get(key) {
      return elementorCommon.storage.get(key);
    }
  }, {
    key: "isValid",
    value: function isValid(library) {
      var saved = this.get(_Store.getKey(library));
      if (!saved) {
        return false;
      }
      if (saved.ver !== library.ver) {
        // @todo: delete from localStorage if version is invalid
        return false;
      }
      return saved.icons && saved.icons.length;
    }
  }], [{
    key: "getKey",
    value: function getKey(library) {
      var name = library.name ? library.name : library;
      return "elementor_".concat(name, "_icons");
    }
  }]);
}();
var _default = exports["default"] = _Store;

/***/ }),

/***/ "../assets/dev/js/editor/components/icons-manager/components/icon-list.js":
/*!********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/icons-manager/components/icon-list.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var LazyIconList = /*#__PURE__*/function (_Component) {
  function LazyIconList() {
    var _this;
    (0, _classCallCheck2.default)(this, LazyIconList);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, LazyIconList, [].concat(args));
    (0, _defineProperty2.default)(_this, "state", {
      itemSize: {
        width: 0,
        height: 0
      },
      wrapperSize: {
        width: 0,
        height: 0
      },
      firstRowInView: 0
    });
    (0, _defineProperty2.default)(_this, "selectors", {
      item: '.elementor-icons-manager__tab__item',
      wrapper: 'elementor-icons-manager__tab__wrapper'
    });
    (0, _defineProperty2.default)(_this, "attachScrollListener", function () {
      var element = document.getElementById(_this.selectors.wrapper);
      if (element) {
        element.addEventListener('scroll', _this.handleScroll);
      }
    });
    (0, _defineProperty2.default)(_this, "maybeMeasureItem", function () {
      if (_this.state.itemSize.width) {
        return;
      }
      // CSS Item Padding
      var itemPadding = 20,
        testElement = document.querySelector(_this.selectors.item);
      if (!testElement) {
        return;
      }
      var wrapper = document.getElementById(_this.selectors.wrapper);
      var newState = {
        itemSize: {
          width: testElement.offsetWidth + itemPadding,
          height: testElement.offsetHeight + itemPadding
        },
        wrapperSize: {
          width: wrapper.offsetWidth,
          height: wrapper.clientHeight
        }
      };
      return _this.setState(newState, function () {
        _this.maybeScrollToSelected();
      });
    });
    (0, _defineProperty2.default)(_this, "maybeScrollToSelected", function () {
      if (!_this.hasSelected()) {
        return;
      }
      var selectedIndex = _this.props.selectedIndex,
        _this$state = _this.state,
        wrapperSize = _this$state.wrapperSize,
        itemSize = _this$state.itemSize,
        itemsInRow = Math.floor(wrapperSize.width / itemSize.width),
        selectedItemRow = Math.ceil(selectedIndex / itemsInRow) - 1,
        scrollTop = selectedItemRow * itemSize.height;
      setTimeout(function () {
        _this.props.parentRef.current.scrollTo({
          top: scrollTop,
          left: 0,
          behavior: 'auto'
        });
      }, 0);
    });
    (0, _defineProperty2.default)(_this, "handleScroll", function () {
      _this.clearDebounceScrollCallback();
      _this._debounce = setTimeout(function () {
        var element = document.getElementById(_this.selectors.wrapper);
        var itemSize = _this.state.itemSize;
        _this.setState({
          firstRowInView: Math.floor(element.scrollTop / itemSize.height)
        });
      }, 10);
    });
    (0, _defineProperty2.default)(_this, "render", function () {
      var _this$state2 = _this.state,
        itemSize = _this$state2.itemSize,
        wrapperSize = _this$state2.wrapperSize;
      var firstRowInView = _this.state.firstRowInView;
      if (!itemSize.width) {
        return _this.renderFirstElementForMeasurement();
      }
      var items = _this.props.items,
        itemsInRow = Math.floor(wrapperSize.width / itemSize.width),
        totalRows = Math.ceil(items.length / itemsInRow),
        spareRows = 4;
      var rowsInView = Math.ceil(wrapperSize.height / itemSize.height) + spareRows;
      if (rowsInView > totalRows) {
        rowsInView = totalRows;
      }

      // Prevent scroll overflow
      if (firstRowInView > totalRows - rowsInView) {
        firstRowInView = totalRows - rowsInView;
      }
      var tailRows = totalRows - firstRowInView - rowsInView,
        firstItemIndexInWindow = firstRowInView * itemsInRow,
        lastItemIndexInWindow = (firstRowInView + rowsInView) * itemsInRow - 1,
        itemsInView = items.slice(firstItemIndexInWindow, lastItemIndexInWindow + 1),
        offsetStyle = {
          height: "".concat(firstRowInView * itemSize.height, "px")
        },
        tailStyle = {
          height: "".concat(tailRows * itemSize.height, "px")
        };
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
        className: 'elementor-icons-manager__tab__content__offset',
        style: offsetStyle
      }), /*#__PURE__*/_react.default.createElement("div", {
        id: 'elementor-icons-manager__tab__content'
      }, itemsInView), /*#__PURE__*/_react.default.createElement("div", {
        className: 'elementor-icons-manager__tab__content__tail',
        style: tailStyle
      }));
    });
    return _this;
  }
  (0, _inherits2.default)(LazyIconList, _Component);
  return (0, _createClass2.default)(LazyIconList, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.attachScrollListener();
      this.maybeMeasureItem();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.clearDebounceScrollCallback();
      var element = document.getElementById(this.selectors.wrapper);
      if (element) {
        element.removeEventListener('scroll', this.handleScroll);
      }
    }
  }, {
    key: "clearDebounceScrollCallback",
    value: function clearDebounceScrollCallback() {
      clearTimeout(this._debounce);
    }
  }, {
    key: "renderFirstElementForMeasurement",
    value: function renderFirstElementForMeasurement() {
      return /*#__PURE__*/_react.default.createElement("div", {
        id: 'elementor-icons-manager__tab__content'
      }, this.props.items[0]);
    }
  }, {
    key: "hasSelected",
    value: function hasSelected() {
      return -1 !== this.props.selectedIndex;
    }
  }]);
}(_react.Component);
var _default = exports["default"] = LazyIconList;
LazyIconList.propTypes = {
  items: _propTypes.default.array,
  selectedIndex: _propTypes.default.number,
  parentRef: _propTypes.default.any
};

/***/ }),

/***/ "../assets/dev/js/editor/components/icons-manager/components/icon-manager.js":
/*!***********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/icons-manager/components/icon-manager.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.renderIconManager = exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _react2 = _interopRequireDefault(__webpack_require__(/*! elementor-utils/react */ "../assets/dev/js/utils/react.js"));
var _tab = _interopRequireDefault(__webpack_require__(/*! ./tab */ "../assets/dev/js/editor/components/icons-manager/components/tab.js"));
var _iconsGoPro = _interopRequireDefault(__webpack_require__(/*! ./icons-go-pro */ "../assets/dev/js/editor/components/icons-manager/components/icons-go-pro.js"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var IconsManager = /*#__PURE__*/function (_Component) {
  function IconsManager() {
    var _this;
    (0, _classCallCheck2.default)(this, IconsManager);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, IconsManager, [].concat(args));
    (0, _defineProperty2.default)(_this, "scrollViewRef", (0, _react.createRef)());
    (0, _defineProperty2.default)(_this, "state", {
      activeTab: _this.props.activeTab,
      selected: {
        library: '',
        value: ''
      },
      iconTabs: elementor.config.icons.libraries,
      loaded: _this.props.loaded,
      filter: ''
    });
    (0, _defineProperty2.default)(_this, "cache", {});
    (0, _defineProperty2.default)(_this, "loadAllTabs", function () {
      var loaded = _this.state.loaded;
      var icons = _this.props.icons;
      icons.forEach(function (tabSettings) {
        if (loaded[tabSettings.name]) {
          return;
        }
        if (-1 < ['all', 'recommended'].indexOf(tabSettings.name)) {
          return;
        }
        elementor.iconManager.library.initIconType(_objectSpread({}, tabSettings), function (library) {
          _this.cache[library.name] = library;
          loaded[tabSettings.name] = true;
        });
      });
      loaded.all = true;
      loaded.recommended = true;
      _this.setState({
        loaded: loaded
      });
    });
    (0, _defineProperty2.default)(_this, "getActiveTab", function () {
      var activeTab = _this.state.activeTab;
      var loaded = _this.state.loaded,
        icons = _this.props.icons;
      if (!activeTab) {
        if (_this.props.activeTab) {
          activeTab = _this.props.activeTab;
        }
      }
      if ('GoPro' === activeTab) {
        return activeTab;
      }
      if (!loaded[activeTab]) {
        return false;
      }
      var tabSettings = _objectSpread({}, icons.filter(function (tab) {
        return tab.name === activeTab;
      })[0]);
      if (loaded[activeTab]) {
        return _objectSpread({}, tabSettings);
      }
      if ('all' === tabSettings.name && !loaded.all) {
        return _this.loadAllTabs();
      }
      elementor.iconManager.library.initIconType(_objectSpread({}, tabSettings), function (library) {
        _this.cache[library.name] = library;
        _this.updateLoaded(library.name);
      });
      return false;
    });
    (0, _defineProperty2.default)(_this, "getIconTabsLinks", function () {
      var native = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
      return _this.props.icons.map(function (tab) {
        if (native ^ _this.isNativeTab(tab)) {
          return '';
        }
        var isCurrentTab = tab.name === _this.state.activeTab;
        var className = 'elementor-icons-manager__tab-link';
        if (isCurrentTab) {
          className += ' elementor-active';
        }
        return (
          /*#__PURE__*/
          // eslint-disable-next-line jsx-a11y/click-events-have-key-events, jsx-a11y/no-static-element-interactions
          _react.default.createElement("div", {
            className: className,
            key: tab.name,
            onClick: function onClick() {
              if (isCurrentTab) {
                return;
              }
              _this.setState({
                activeTab: tab.name
              });
            }
          }, /*#__PURE__*/_react.default.createElement("i", {
            className: tab.labelIcon
          }), tab.label)
        );
      });
    });
    (0, _defineProperty2.default)(_this, "getActiveTabIcons", function (activeTab) {
      if (activeTab.name) {
        return _this.getActiveTabIcons(activeTab.name);
      }
      if (_this.cache[activeTab]) {
        return _this.cache[activeTab].icons;
      }
      if ('recommended' === activeTab) {
        return _this.state.iconTabs[0].icons;
      }
      if ('all' === activeTab) {
        return _this.getAllIcons();
      }
      if (!_this.state.loaded[activeTab]) {
        var librarySettings = _this.props.icons.filter(function (library) {
          return activeTab === library.name;
        });
        return elementor.iconManager.library.initIconType(_objectSpread({}, librarySettings[0]), function (library) {
          _this.cache[library.name] = library;
          _this.updateLoaded(library.name);
        });
      }
      return elementor.iconManager.store.getIcons(activeTab);
    });
    (0, _defineProperty2.default)(_this, "getAllIcons", function () {
      if (_this.cache.all) {
        return _this.cache.all.icons;
      }
      var icons = {};
      _this.props.icons.forEach(function (tabSettings) {
        if ('all' === tabSettings.name || 'recommended' === tabSettings.name) {
          return;
        }
        icons[tabSettings.name] = _this.getActiveTabIcons(tabSettings.name);
      });
      _this.cache.all = {
        icons: icons
      };
      return icons;
    });
    (0, _defineProperty2.default)(_this, "handleSearch", function (event) {
      var filter = event.target.value;
      if (filter && '' !== filter) {
        filter = filter.toLocaleLowerCase();
        if (_this.state.filter === filter) {
          return;
        }
      } else {
        filter = '';
      }
      _this.setState({
        filter: filter
      });
    });
    (0, _defineProperty2.default)(_this, "setSelected", function (selected) {
      elementor.iconManager.setSettings('selectedIcon', selected);
      _this.setState({
        selected: selected
      });
    });
    (0, _defineProperty2.default)(_this, "getSelected", function () {
      var selected = _this.state.selected;
      if ('' === selected.value && _this.props.selected && _this.props.selected.value) {
        selected = {
          value: _this.props.selected.value,
          library: _this.props.selected.library
        };
      }
      return selected;
    });
    (0, _defineProperty2.default)(_this, "render", function () {
      var activeTab = _this.getActiveTab(),
        activeTabName = activeTab.name ? activeTab.name : activeTab,
        _this$props$showSearc = _this.props.showSearch,
        showSearch = _this$props$showSearc === void 0 ? true : _this$props$showSearc,
        filter = _this.state.filter;
      if ('GoPro' !== activeTab) {
        if (!activeTabName || !_this.state.loaded[activeTabName]) {
          return 'Loading';
        }
        if (activeTab) {
          activeTab.icons = _this.getActiveTabIcons(activeTab);
        }
      }
      var selected = _this.getSelected();
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
        id: "elementor-icons-manager__sidebar",
        className: 'elementor-templates-modal__sidebar'
      }, /*#__PURE__*/_react.default.createElement("div", {
        id: "elementor-icons-manager__tab-links"
      }, _this.getIconTabsLinks(), _this.getUploadCustomButton(), _this.getIconTabsLinks(false))), /*#__PURE__*/_react.default.createElement("div", {
        id: "elementor-icons-manager__main",
        className: 'elementor-templates-modal__content'
      }, 'GoPro' === activeTabName ? /*#__PURE__*/_react.default.createElement(_iconsGoPro.default, null) : /*#__PURE__*/_react.default.createElement(_react.Fragment, null, showSearch ? _this.getSearchHTML() : '', /*#__PURE__*/_react.default.createElement("div", {
        id: "elementor-icons-manager__tab__wrapper",
        ref: _this.scrollViewRef
      }, /*#__PURE__*/_react.default.createElement("div", {
        id: "elementor-icons-manager__tab__title"
      }, activeTab.label), /*#__PURE__*/_react.default.createElement("div", {
        id: "elementor-icons-manager__tab__content_wrapper"
      }, /*#__PURE__*/_react.default.createElement("input", {
        type: "hidden",
        name: "icon_value",
        id: "icon_value",
        value: selected.value
      }), /*#__PURE__*/_react.default.createElement("input", {
        type: "hidden",
        name: "icon_type",
        id: "icon_type",
        value: selected.library
      }), _this.state.loaded[activeTab.name] ? /*#__PURE__*/_react.default.createElement(_tab.default, (0, _extends2.default)({
        setSelected: _this.setSelected,
        selected: selected,
        filter: filter,
        key: activeTab.name,
        parentRef: _this.scrollViewRef
      }, activeTab)) : 'Loading')))));
    });
    return _this;
  }
  (0, _inherits2.default)(IconsManager, _Component);
  return (0, _createClass2.default)(IconsManager, [{
    key: "updateLoaded",
    value: function updateLoaded(libraryName) {
      var loaded = this.state.loaded;
      loaded[libraryName] = true;
      this.setState({
        loaded: loaded
      });
    }
  }, {
    key: "isNativeTab",
    value: function isNativeTab(tab) {
      return ('all' === tab.name || 'recommended' === tab.name || 'fa-' === tab.name.substr(0, 3)) && tab.native;
    }
  }, {
    key: "getUploadCustomButton",
    value: function getUploadCustomButton() {
      var _this2 = this;
      var onClick = function onClick() {
        if ('GoPro' === _this2.state.activeTab) {
          return;
        }
        _this2.setState({
          activeTab: 'GoPro'
        });
      };
      if (this.props.customIconsURL) {
        onClick = function onClick() {
          window.open(_this2.props.customIconsURL, '_blank');
        };
      }
      return /*#__PURE__*/_react.default.createElement("div", {
        id: "elementor-icons-manager__upload"
      }, /*#__PURE__*/_react.default.createElement("div", {
        id: "elementor-icons-manager__upload__title"
      }, __('My Libraries', 'elementor')), /*#__PURE__*/_react.default.createElement("button", {
        id: "elementor-icons-manager__upload__button",
        className: "elementor-button",
        onClick: onClick
      }, __('Upload', 'elementor')));
    }
  }, {
    key: "getSearchHTML",
    value: function getSearchHTML() {
      return /*#__PURE__*/_react.default.createElement("div", {
        id: "elementor-icons-manager__search"
      }, /*#__PURE__*/_react.default.createElement("input", {
        placeholder: 'Filter by name...',
        onInput: this.handleSearch
      }), /*#__PURE__*/_react.default.createElement("i", {
        className: 'eicon-search'
      }));
    }
  }]);
}(_react.Component);
var _default = exports["default"] = IconsManager;
var renderIconManager = exports.renderIconManager = function renderIconManager(props) {
  var containerElement = document.querySelector('#elementor-icons-manager-modal .dialog-content');
  return _react2.default.render(/*#__PURE__*/_react.default.createElement(IconsManager, (0, _extends2.default)({}, props, {
    containerElement: containerElement
  })), containerElement);
};
IconsManager.propTypes = {
  activeTab: _propTypes.default.any,
  customIconsURL: _propTypes.default.string,
  icons: _propTypes.default.any,
  loaded: _propTypes.default.any,
  modalView: _propTypes.default.any,
  recommended: _propTypes.default.oneOfType([_propTypes.default.bool, _propTypes.default.object]),
  selected: _propTypes.default.any,
  showSearch: _propTypes.default.bool
};

/***/ }),

/***/ "../assets/dev/js/editor/components/icons-manager/components/icon.js":
/*!***************************************************************************!*\
  !*** ../assets/dev/js/editor/components/icons-manager/components/icon.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Icon = exports["default"] = /*#__PURE__*/function (_Component) {
  function Icon() {
    var _this;
    (0, _classCallCheck2.default)(this, Icon);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, Icon, [].concat(args));
    (0, _defineProperty2.default)(_this, "setSelected", function () {
      _this.props.setSelectedHandler({
        value: _this.props.data.displayPrefix + ' ' + _this.props.data.selector,
        library: _this.props.library
      });
    });
    (0, _defineProperty2.default)(_this, "render", function () {
      return (
        /*#__PURE__*/
        // eslint-disable-next-line jsx-a11y/click-events-have-key-events, jsx-a11y/no-static-element-interactions
        _react.default.createElement("div", {
          className: _this.props.containerClass,
          key: _this.props.keyID,
          onClick: _this.setSelected,
          filter: _this.props.data.filter
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "elementor-icons-manager__tab__item__content"
        }, /*#__PURE__*/_react.default.createElement("i", {
          className: 'elementor-icons-manager__tab__item__icon ' + _this.props.className
        }), /*#__PURE__*/_react.default.createElement("div", {
          className: 'elementor-icons-manager__tab__item__name',
          title: _this.props.data.name
        }, _this.props.data.name)))
      );
    });
    return _this;
  }
  (0, _inherits2.default)(Icon, _Component);
  return (0, _createClass2.default)(Icon);
}(_react.Component);
Icon.propTypes = {
  className: _propTypes.default.string,
  containerClass: _propTypes.default.string,
  data: _propTypes.default.object,
  keyID: _propTypes.default.string,
  library: _propTypes.default.string,
  selector: _propTypes.default.string,
  setSelectedHandler: _propTypes.default.func
};

/***/ }),

/***/ "../assets/dev/js/editor/components/icons-manager/components/icons-go-pro.js":
/*!***********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/icons-manager/components/icons-go-pro.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var IconsGoPro = /*#__PURE__*/function (_Component) {
  function IconsGoPro() {
    var _this;
    (0, _classCallCheck2.default)(this, IconsGoPro);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, IconsGoPro, [].concat(args));
    (0, _defineProperty2.default)(_this, "render", function () {
      return /*#__PURE__*/_react.default.createElement("div", {
        id: "elementor-icons-manager__promotion"
      }, /*#__PURE__*/_react.default.createElement("i", {
        id: "elementor-icons-manager__promotion__icon",
        className: "eicon-nerd"
      }), /*#__PURE__*/_react.default.createElement("div", {
        id: "elementor-icons-manager__promotion__text"
      }, __('Become a Pro user to upload unlimited font icon folders to your website.', 'elementor')), /*#__PURE__*/_react.default.createElement("a", {
        href: elementor.config.icons.goProURL,
        id: "elementor-icons-manager__promotion__link",
        className: "elementor-button go-pro",
        target: "_blank",
        rel: "noopener noreferrer"
      }, __('Upgrade Now', 'elementor')));
    });
    return _this;
  }
  (0, _inherits2.default)(IconsGoPro, _Component);
  return (0, _createClass2.default)(IconsGoPro);
}(_react.Component);
var _default = exports["default"] = IconsGoPro;

/***/ }),

/***/ "../assets/dev/js/editor/components/icons-manager/components/tab.js":
/*!**************************************************************************!*\
  !*** ../assets/dev/js/editor/components/icons-manager/components/tab.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _toConsumableArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "../node_modules/@babel/runtime/helpers/toConsumableArray.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _iconList = _interopRequireDefault(__webpack_require__(/*! ./icon-list */ "../assets/dev/js/editor/components/icons-manager/components/icon-list.js"));
var _icon = _interopRequireDefault(__webpack_require__(/*! ./icon */ "../assets/dev/js/editor/components/icons-manager/components/icon.js"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Tab = /*#__PURE__*/function (_Component) {
  function Tab() {
    var _this;
    (0, _classCallCheck2.default)(this, Tab);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, Tab, [].concat(args));
    (0, _defineProperty2.default)(_this, "componentDidMount", function () {
      if (_this.props.selected && _this.props.selected.value) {
        setTimeout(function () {
          var element = document.querySelector('.elementor-selected');
          if (element) {
            element.scrollIntoView(false);
          }
        }, 0);
      }
    });
    (0, _defineProperty2.default)(_this, "handleFullIconList", function () {
      var fullIconList = [];
      Object.entries(_this.props.icons).forEach(function (library) {
        if ('recommended' !== library[0]) {
          fullIconList = [].concat((0, _toConsumableArray2.default)(fullIconList), (0, _toConsumableArray2.default)(_this.getIconsOfType(library[0], library[1])));
        }
      });
      return fullIconList.sort(function (a, b) {
        return a.filter === b.filter ? 0 : +(a.filter > b.filter) || -1;
      });
    });
    (0, _defineProperty2.default)(_this, "getLibrary", function (libraryName) {
      var icons = elementor.config.icons.libraries.filter(function (library) {
        return libraryName === library.name;
      });
      return icons;
    });
    (0, _defineProperty2.default)(_this, "handleRecommendedList", function () {
      var recommendedIconList = [];
      Object.entries(_this.props.icons).forEach(function (library) {
        var iconLibrary = _this.getLibrary(library[0]),
          iconsOfType = iconLibrary[0].icons,
          recommendedIconsOfType = {};
        library[1].forEach(function (iconName) {
          if (iconsOfType[iconName]) {
            recommendedIconsOfType[iconName] = iconsOfType[iconName];
          }
        });
        recommendedIconList = [].concat((0, _toConsumableArray2.default)(recommendedIconList), (0, _toConsumableArray2.default)(_this.getIconsOfType(library[0], recommendedIconsOfType)));
      });
      return recommendedIconList;
    });
    (0, _defineProperty2.default)(_this, "getIconsComponentList", function () {
      var iconsToShow = [];
      var _this$props = _this.props,
        name = _this$props.name,
        icons = _this$props.icons,
        filter = _this$props.filter;
      switch (name) {
        case 'all':
          iconsToShow = _this.handleFullIconList();
          break;
        case 'recommended':
          iconsToShow = _this.handleRecommendedList();
          break;
        default:
          iconsToShow = _this.getIconsOfType(name, icons);
          break;
      }
      if (filter) {
        iconsToShow = Object.values(iconsToShow).filter(function (icon) {
          return icon.props.data.name.toLowerCase().indexOf(filter) > -1;
        });
      }
      return iconsToShow;
    });
    (0, _defineProperty2.default)(_this, "render", function () {
      var icons = _this.getIconsComponentList();
      var selectedIndex = -1;
      var _iterator = _createForOfIteratorHelper(icons.entries()),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var _step$value = (0, _slicedToArray2.default)(_step.value, 2),
            index = _step$value[0],
            icon = _step$value[1];
          if (icon.props.containerClass.includes('elementor-selected')) {
            selectedIndex = index;
            break;
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      return /*#__PURE__*/_react.default.createElement(_iconList.default, {
        selectedIndex: selectedIndex,
        items: icons,
        parentRef: _this.props.parentRef
      });
    });
    return _this;
  }
  (0, _inherits2.default)(Tab, _Component);
  return (0, _createClass2.default)(Tab, [{
    key: "getIconsOfType",
    value: function getIconsOfType(type, icons) {
      var _this2 = this;
      var _this$props2 = this.props,
        selected = _this$props2.selected,
        filter = _this$props2.filter;
      return Object.entries(icons).map(function (icon) {
        var iconData = icon[1],
          iconName = icon[0],
          className = iconData.displayPrefix + ' ' + iconData.selector;
        var containerClass = 'elementor-icons-manager__tab__item';
        if (selected.value === className) {
          containerClass += ' elementor-selected';
        }
        var key = containerClass + type + '-' + iconName + filter;
        return /*#__PURE__*/_react.default.createElement(_icon.default, {
          key: key,
          library: type,
          keyID: iconName,
          containerClass: containerClass,
          className: className,
          setSelectedHandler: _this2.props.setSelected,
          data: iconData
        });
      });
    }
  }]);
}(_react.Component);
Tab.propTypes = {
  data: _propTypes.default.any,
  filter: _propTypes.default.any,
  icons: _propTypes.default.object,
  name: _propTypes.default.string,
  selected: _propTypes.default.object,
  setSelected: _propTypes.default.func,
  parentRef: _propTypes.default.any
};
var _default = exports["default"] = Tab;

/***/ }),

/***/ "../assets/dev/js/editor/components/icons-manager/icons-manager.js":
/*!*************************************************************************!*\
  !*** ../assets/dev/js/editor/components/icons-manager/icons-manager.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _modalLayout = _interopRequireDefault(__webpack_require__(/*! ./modal-layout */ "../assets/dev/js/editor/components/icons-manager/modal-layout.js"));
var _iconManager = __webpack_require__(/*! ./components/icon-manager */ "../assets/dev/js/editor/components/icons-manager/components/icon-manager.js");
var _iconLibrary = _interopRequireDefault(__webpack_require__(/*! ./classes/icon-library */ "../assets/dev/js/editor/components/icons-manager/classes/icon-library.js"));
var _store = _interopRequireDefault(__webpack_require__(/*! ./classes/store */ "../assets/dev/js/editor/components/icons-manager/classes/store.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var _default = exports["default"] = /*#__PURE__*/function (_elementorModules$Mod) {
  function _default() {
    (0, _classCallCheck2.default)(this, _default);
    return _callSuper(this, _default, arguments);
  }
  (0, _inherits2.default)(_default, _elementorModules$Mod);
  return (0, _createClass2.default)(_default, [{
    key: "onInit",
    value: function onInit() {
      // Init icon library helper
      this.library = new _iconLibrary.default();
      // Init Icon library Storage helper
      this.store = new _store.default();
      // Fetch fa4 to fa5 migration data
      elementor.helpers.fetchFa4ToFa5Mapping();
      this.cache = {};
    }
  }, {
    key: "getLayout",
    value: function getLayout() {
      var _this = this;
      if (!this.layout) {
        this.layout = new _modalLayout.default();
        var layoutModal = this.layout.getModal();
        layoutModal.addButton({
          name: 'insert_icon',
          text: __('Insert', 'elementor'),
          classes: 'elementor-button e-primary',
          callback: function callback() {
            _this.updateControlValue();
            _this.unMountIconManager();
          }
        });
        layoutModal.on('show', this.onPickerShow.bind(this)).on('hide', this.unMountIconManager.bind(this));
      }
      return this.layout;
    }
  }, {
    key: "getDefaultSettings",
    value: function getDefaultSettings() {
      return {
        selectedIcon: {}
      };
    }
  }, {
    key: "unMountIconManager",
    value: function unMountIconManager() {
      this.unmount();
    }
  }, {
    key: "loadIconLibraries",
    value: function loadIconLibraries() {
      if (!this.cache.loaded) {
        elementor.config.icons.libraries.forEach(function (library) {
          if ('all' === library.name) {
            return;
          }
          elementor.iconManager.library.initIconType(library);
        });
        this.cache.loaded = true;
      }
    }
  }, {
    key: "onPickerShow",
    value: function onPickerShow() {
      var controlView = this.getSettings('controlView'),
        loaded = {
          GoPro: true
        },
        iconManagerConfig = {
          recommended: controlView.model.get('recommended') || false
        };
      var selected = controlView.getControlValue(),
        icons = elementor.config.icons.libraries;
      if (!selected.library || !selected.value) {
        selected = {
          value: '',
          library: ''
        };
      }
      iconManagerConfig.selected = selected;
      this.setSettings('selectedIcon', selected);
      if (iconManagerConfig.recommended) {
        var hasRecommended = false;
        icons.forEach(function (library, index) {
          if ('recommended' === library.name) {
            hasRecommended = true;
            icons[index].icons = iconManagerConfig.recommended;
          }
        });
        if (!hasRecommended) {
          icons.unshift({
            name: 'recommended',
            label: 'Recommended',
            icons: iconManagerConfig.recommended,
            labelIcon: 'eicon-star-o',
            native: true
          });
        }
      } else {
        icons = icons.filter(function (library) {
          return 'recommended' !== library.name;
        });
      }
      icons.forEach(function (tab, index) {
        if (-1 === ['all', 'recommended'].indexOf(tab.name)) {
          elementor.iconManager.library.initIconType(tab, function (lib) {
            icons[index] = lib;
          });
        }
        loaded[tab.name] = true;
      });
      iconManagerConfig.loaded = loaded;
      iconManagerConfig.icons = icons;

      // Set active tab
      var activeTab = selected.library || icons[0].name;
      if ('svg' === selected.library) {
        activeTab = icons[0].name;
      }

      // Selected Library exists
      if (!Object.keys(icons).some(function (library) {
        return library === activeTab;
      })) {
        activeTab = icons[0].name;
      }

      // Show recommended tab if selected from it
      if (iconManagerConfig.recommended && '' !== selected.library && '' !== selected.value && Object.prototype.hasOwnProperty.call(iconManagerConfig.recommended, selected.library)) {
        var iconLibrary = icons.filter(function (library) {
          return selected.library === library.name;
        });
        var selectedIconName = selected.value.replace(iconLibrary[0].displayPrefix + ' ' + iconLibrary[0].prefix, '');
        if (iconManagerConfig.recommended[selected.library].some(function (icon) {
          return -1 < icon.indexOf(selectedIconName);
        })) {
          activeTab = icons[0].name;
        }
      }
      iconManagerConfig.customIconsURL = elementor.config.customIconsURL;
      iconManagerConfig.activeTab = activeTab;
      var _renderIconManager = (0, _iconManager.renderIconManager)(iconManagerConfig),
        unmount = _renderIconManager.unmount;
      this.unmount = unmount;
    }
  }, {
    key: "updateControlValue",
    value: function updateControlValue() {
      var settings = this.getSettings();
      settings.controlView.setValue(settings.selectedIcon);
      settings.controlView.applySavedValue();
    }
  }, {
    key: "show",
    value: function show(options) {
      this.setSettings('controlView', options.view);
      this.getLayout().showModal(options);
    }
  }]);
}(elementorModules.Module);

/***/ }),

/***/ "../assets/dev/js/editor/components/icons-manager/modal-layout.js":
/*!************************************************************************!*\
  !*** ../assets/dev/js/editor/components/icons-manager/modal-layout.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _layout = _interopRequireDefault(__webpack_require__(/*! elementor-common/views/modal/layout */ "../core/common/assets/js/views/modal/layout.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, o, e, r) { var p = (0, _get2.default)((0, _getPrototypeOf2.default)(1 & r ? t.prototype : t), o, e); return 2 & r && "function" == typeof p ? function (t) { return p.apply(e, t); } : p; }
var _default = exports["default"] = /*#__PURE__*/function (_BaseModalLayout) {
  function _default() {
    (0, _classCallCheck2.default)(this, _default);
    return _callSuper(this, _default, arguments);
  }
  (0, _inherits2.default)(_default, _BaseModalLayout);
  return (0, _createClass2.default)(_default, [{
    key: "getModalOptions",
    value: function getModalOptions() {
      return {
        id: 'elementor-icons-manager-modal'
      };
    }
  }, {
    key: "getLogoOptions",
    value: function getLogoOptions() {
      return {
        title: __('Icon Library', 'elementor')
      };
    }
  }, {
    key: "initialize",
    value: function initialize() {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      _superPropGet(_default, "initialize", this, 3)(args);
      this.showLogo();
    }
  }]);
}(_layout.default);

/***/ }),

/***/ "../assets/dev/js/editor/components/preview/commands/drop.js":
/*!*******************************************************************!*\
  !*** ../assets/dev/js/editor/components/preview/commands/drop.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Drop = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Drop = exports.Drop = /*#__PURE__*/function (_$e$modules$editor$Co) {
  function Drop() {
    (0, _classCallCheck2.default)(this, Drop);
    return _callSuper(this, Drop, arguments);
  }
  (0, _inherits2.default)(Drop, _$e$modules$editor$Co);
  return (0, _createClass2.default)(Drop, [{
    key: "validateArgs",
    value: function validateArgs() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      this.requireContainer(args);
      this.requireArgumentType('model', 'object', args);
    }
  }, {
    key: "apply",
    value: function apply() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers,
        _args$options = args.options,
        options = _args$options === void 0 ? {} : _args$options,
        result = [];
      containers.forEach(function (container) {
        result.push(container.view.createElementFromModel(args.model, options));
      });
      if (1 === containers.length) {
        return result[0];
      }
      return result;
    }
  }]);
}($e.modules.editor.CommandContainerBase);

/***/ }),

/***/ "../assets/dev/js/editor/components/preview/commands/index.js":
/*!********************************************************************!*\
  !*** ../assets/dev/js/editor/components/preview/commands/index.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Drop", ({
  enumerable: true,
  get: function get() {
    return _drop.Drop;
  }
}));
Object.defineProperty(exports, "Reload", ({
  enumerable: true,
  get: function get() {
    return _reload.Reload;
  }
}));
var _drop = __webpack_require__(/*! ./drop */ "../assets/dev/js/editor/components/preview/commands/drop.js");
var _reload = __webpack_require__(/*! ./reload */ "../assets/dev/js/editor/components/preview/commands/reload.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/preview/commands/reload.js":
/*!*********************************************************************!*\
  !*** ../assets/dev/js/editor/components/preview/commands/reload.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Reload = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Reload = exports.Reload = /*#__PURE__*/function (_$e$modules$CommandBa) {
  function Reload() {
    (0, _classCallCheck2.default)(this, Reload);
    return _callSuper(this, Reload, arguments);
  }
  (0, _inherits2.default)(Reload, _$e$modules$CommandBa);
  return (0, _createClass2.default)(Reload, [{
    key: "apply",
    value: function apply() {
      elementor.reloadPreview();
    }
  }]);
}($e.modules.CommandBase);

/***/ }),

/***/ "../assets/dev/js/editor/components/preview/component.js":
/*!***************************************************************!*\
  !*** ../assets/dev/js/editor/components/preview/component.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var commands = _interopRequireWildcard(__webpack_require__(/*! ./commands/ */ "../assets/dev/js/editor/components/preview/commands/index.js"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Component = exports["default"] = /*#__PURE__*/function (_$e$modules$Component) {
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _callSuper(this, Component, arguments);
  }
  (0, _inherits2.default)(Component, _$e$modules$Component);
  return (0, _createClass2.default)(Component, [{
    key: "getNamespace",
    value: function getNamespace() {
      return 'preview';
    }
  }, {
    key: "defaultCommands",
    value: function defaultCommands() {
      return this.importCommands(commands);
    }
  }]);
}($e.modules.ComponentBase);

/***/ }),

/***/ "../assets/dev/js/editor/components/selection/manager.js":
/*!***************************************************************!*\
  !*** ../assets/dev/js/editor/components/selection/manager.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/**
 * @typedef {import('../../container/container')} Container
 */
var Manager = exports["default"] = /*#__PURE__*/function (_elementorModules$edi) {
  /**
   * Manager constructor.
   *
   * @return {Manager} manager
   */
  function Manager() {
    var _this;
    (0, _classCallCheck2.default)(this, Manager);
    _this = _callSuper(this, Manager);

    // Using a Proxy in order to use update methods only once on external invocations, but internally the `add` or
    // `remove` methods may be executed many times, when update methods will be used only once.
    /**
     * Selected elements.
     *
     * The list of the selected elements.
     *
     * @type {{}}
     */
    (0, _defineProperty2.default)(_this, "elements", {});
    /**
     * Selected elements type.
     *
     * Represents the common type of multiple selected elements, or false when the selected elements are of different
     * types.
     *
     * @type {string|boolean}
     */
    (0, _defineProperty2.default)(_this, "type", false);
    return (0, _possibleConstructorReturn2.default)(_this, new Proxy(_this, {
      get: function get(target, prop) {
        if (['add', 'remove'].includes(prop)) {
          return function () {
            if (!target.isAllowed()) {
              return;
            }
            var result = target[prop].apply(target, arguments);
            target.updateType();
            target.updateSortable();
            target.updatePanelPage();
            target.updateNavigator();
            return result;
          };
        }
        return Reflect.get.apply(Reflect, arguments);
      }
    }));
  }

  /**
   * Get selection elements.
   *
   * Get the list of selected elements as an array of containers. If a fallback element container specified, it will
   * be returned when there are no selected elements.
   *
   * @param {Container[]|Container} fallback
   * @return {Container[]} selection elements
   */
  (0, _inherits2.default)(Manager, _elementorModules$edi);
  return (0, _createClass2.default)(Manager, [{
    key: "getElements",
    value: function getElements() {
      var fallback = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      var result = Object.values(this.elements);
      if (!result.length && fallback) {
        result = Array.isArray(fallback) ? fallback : [fallback];
      }
      return result;
    }

    /**
     * Add elements to selection.
     *
     * Add new elements to selection by their container, and clear the currently selected elements unless appending is
     * active, in which case the new elements are just added to the current selection.
     *
     * @param {Container[]|Container} containers
     * @param {boolean}               append
     */
  }, {
    key: "add",
    value: function add(containers) {
      var append = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      if (!this.isAllowed()) {
        return;
      }
      containers = Array.isArray(containers) ? containers : [containers];

      // If command/ctrl+click not clicked, clear selected elements.
      if (!append) {
        this.remove([], true);
      }
      var _iterator = _createForOfIteratorHelper(containers),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var container = _step.value;
          this.elements[container.id] = container;
          container.view.select();
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }

    /**
     * Remove elements from selection.
     *
     * Remove elements from selection by their container, unless the parameter for clearing all selected elements is
     * active, in which case the the whole selection is cleared.
     *
     * @param {Container[]|Container} containers
     * @param {boolean}               all
     */
  }, {
    key: "remove",
    value: function remove(containers) {
      var all = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      if (!this.isAllowed()) {
        return;
      }
      containers = Array.isArray(containers) ? containers : [containers];
      if (all) {
        containers = this.getElements();
      }
      var _iterator2 = _createForOfIteratorHelper(containers),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var container = _step2.value;
          delete this.elements[container.id];
          container.view.deselect();
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }

    /**
     * Does element selected.
     *
     * Check whether an element container exists in the selected elements.
     *
     * @param {Container} container
     * @return {boolean} true if the container exists in the selected elements
     */
  }, {
    key: "has",
    value: function has(container) {
      return this.getElements().includes(container);
    }

    /**
     * Update selected elements type.
     *
     * Resolve the common type of all selected elements and assign it as class property. When the selected objects are
     * of different types, `false` is assigned.
     */
  }, {
    key: "updateType",
    value: function updateType() {
      var elements = this.getElements();
      this.type = Boolean(elements.length) && elements.reduce(function (previous, current) {
        if (previous === current.type) {
          return current.type;
        }
        return false;
      }, elements[0].type);
    }

    /**
     * Update sortable state.
     *
     * In case more than one element is selected, currently sorting supposed to be disabled, and vice-versa.
     */
  }, {
    key: "updateSortable",
    value: function updateSortable() {
      elementor.toggleSortableState(!this.isMultiple());
    }

    /**
     * Update the panel page.
     *
     * Selected elements affect the panel panel in a way that when element is selected - its settings page is displayed,
     * and when the element is blurred (unfocused) - the the default page opened. When more than one element selected,
     * the default page should appear.
     */
  }, {
    key: "updatePanelPage",
    value: function updatePanelPage() {
      var elements = this.getElements();
      if (1 === elements.length) {
        $e.run('panel/editor/open', {
          model: elements[0].model,
          view: elements[0].view
        });
      } else {
        $e.internal('panel/open-default', {
          autoFocusSearch: false
        });
      }
    }

    /**
     * Update navigator selections.
     *
     * Any change in the document selected elements should be reflected in the navigator, this method is responsible for
     * updating the navigator.
     */
  }, {
    key: "updateNavigator",
    value: function updateNavigator() {
      if (!$e.components.get('document/elements').utils.showNavigator()) {
        return;
      }
      elementor.navigator.getLayout().elements.currentView.recursiveChildInvoke('updateSelection');
    }

    /**
     * Is multiple selection.
     *
     * Check whether multiple elements were selected.
     *
     * @return {boolean} true if multiple elements were selected
     */
  }, {
    key: "isMultiple",
    value: function isMultiple() {
      return this.getElements().length > 1;
    }

    /**
     * Is selection of same type.
     *
     * Check whether the selected elements are of same type.
     *
     * @return {boolean} true if the selected elements are of same type
     */
  }, {
    key: "isSameType",
    value: function isSameType() {
      return !this.getElements().length || Boolean(this.type);
    }
  }, {
    key: "isAllowed",
    value: function isAllowed() {
      return 'edit' === elementor.channels.dataEditMode.request('activeMode');
    }
  }]);
}(elementorModules.editor.utils.Module);

/***/ }),

/***/ "../assets/dev/js/editor/components/settings/base/manager.js":
/*!*******************************************************************!*\
  !*** ../assets/dev/js/editor/components/settings/base/manager.js ***!
  \*******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var ControlsCSSParser = __webpack_require__(/*! elementor-editor-utils/controls-css-parser */ "../assets/dev/js/editor/utils/controls-css-parser.js");
module.exports = elementorModules.ViewModule.extend({
  model: null,
  hasChange: false,
  changeCallbacks: {},
  addChangeCallback: function addChangeCallback(attribute, callback) {
    this.changeCallbacks[attribute] = callback;
  },
  bindEvents: function bindEvents() {
    elementor.on('document:loaded', this.onElementorDocumentLoaded);
    this.model.on('change', this.onModelChange);
  },
  unbindEvents: function unbindEvents() {
    elementor.off('document:loaded', this.onElementorDocumentLoaded);
  },
  addPanelPage: function addPanelPage() {
    var name = this.getSettings('name');
    elementor.getPanelView().addPage(name + '_settings', {
      view: elementor.settings.panelPages[name] || elementor.settings.panelPages.base,
      title: this.getSettings('panelPage.title'),
      options: {
        editedView: this.getEditedView(),
        model: this.model,
        controls: this.model.controls,
        name: name
      }
    });
  },
  getContainerType: function getContainerType() {
    return this.getSettings('name') + '_settings';
  },
  /**
   * @deprecated since 3.7.0, use `getContainerType()` instead.
   */
  getContainerId: function getContainerId() {
    elementorDevTools.deprecation.deprecated('getContainerId()', '3.7.0', 'getContainerType()');
    return this.getContainerType();
  },
  // Emulate an element view/model structure with the parts needed for a container.
  getEditedView: function getEditedView() {
    var documentElementType = elementor.elementsManager.getElementTypeClass('document'),
      ModelClass = documentElementType.getModel(),
      type = this.getContainerType(),
      editModel = new ModelClass({
        id: type,
        elType: type,
        settings: this.model
      });
    var container = new elementorModules.editor.Container({
      type: type,
      id: type,
      model: editModel,
      settings: editModel.get('settings'),
      view: false,
      parent: false,
      label: this.getSettings('panelPage').title,
      controls: this.model.controls,
      document: this.getDocument(),
      renderer: false
    });
    return {
      getContainer: function getContainer() {
        return container;
      },
      getEditModel: function getEditModel() {
        return editModel;
      },
      model: editModel,
      container: container
    };
  },
  getDocument: function getDocument() {
    return false;
  },
  updateStylesheet: function updateStylesheet(keepOldEntries) {
    var controlsCSS = this.getControlsCSS();
    if (!keepOldEntries) {
      controlsCSS.stylesheet.empty();
    }
    this.model.handleRepeaterData(this.model.attributes);
    controlsCSS.addStyleRules(this.model.getStyleControls(), this.model.attributes, this.model.controls, [/{{WRAPPER}}/g], [this.getSettings('cssWrapperSelector')]);
    controlsCSS.addStyleToDocument({
      // Ensures we don't override default global style
      at: 'before',
      of: '#elementor-style-e-global-style'
    });
  },
  initModel: function initModel() {
    this.model = new elementorModules.editor.elements.models.BaseSettings(this.getSettings('settings'), {
      controls: this.getSettings('controls')
    });
  },
  getStyleId: function getStyleId() {
    return this.getSettings('name');
  },
  initControlsCSSParser: function initControlsCSSParser() {
    var controlsCSS;
    this.destroyControlsCSS = function () {
      controlsCSS.removeStyleFromDocument();
    };
    this.getControlsCSS = function () {
      if (!controlsCSS) {
        controlsCSS = new ControlsCSSParser({
          id: this.getStyleId(),
          settingsModel: this.model,
          context: this.getEditedView()
        });
      }
      return controlsCSS;
    };
  },
  getDataToSave: function getDataToSave(data) {
    return data;
  },
  save: function save(callback) {
    var _this = this;
    return (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
      var self, settings, data;
      return _regenerator.default.wrap(function (_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            self = _this;
            if (self.hasChange) {
              _context.next = 1;
              break;
            }
            return _context.abrupt("return");
          case 1:
            settings = _this.model.toJSON({
              remove: ['default']
            }), data = _this.getDataToSave({
              data: settings
            });
            NProgress.start();
            return _context.abrupt("return", elementorCommon.ajax.addRequest('save_' + _this.getSettings('name') + '_settings', {
              data: data,
              success: function success() {
                NProgress.done();
                self.setSettings('settings', settings);
                self.hasChange = false;
                if (callback) {
                  callback.apply(self, arguments);
                }
              },
              error: function error() {
                // eslint-disable-next-line no-alert
                alert('An error occurred.');
              }
            }));
          case 2:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }))();
  },
  onInit: function onInit() {
    this.initModel();
    this.initControlsCSSParser();
    this.addPanelMenuItem();
    this.debounceSave = _.debounce(this.save, 3000);
    elementorModules.ViewModule.prototype.onInit.apply(this, arguments);
  },
  /**
   * BC for custom settings without a JS component.
   */
  addPanelMenuItem: function addPanelMenuItem() {
    var menuSettings = this.getSettings('panelPage.menu');
    if (!menuSettings) {
      return;
    }
    var namespace = 'panel/' + this.getSettings('name') + '-settings',
      menuItemOptions = {
        icon: menuSettings.icon,
        title: this.getSettings('panelPage.title'),
        type: 'page',
        pageName: this.getSettings('name') + '_settings',
        callback: function callback() {
          return $e.route("".concat(namespace, "/settings"));
        }
      };
    $e.bc.ensureTab(namespace, 'settings', menuItemOptions.pageName);
    elementor.modules.layouts.panel.pages.menu.Menu.addItem(menuItemOptions, 'settings', menuSettings.beforeItem);
  },
  onModelChange: function onModelChange(model) {
    var self = this;
    self.hasChange = true;
    this.getControlsCSS().stylesheet.empty();
    _.each(model.changed, function (value, key) {
      if (self.changeCallbacks[key]) {
        self.changeCallbacks[key].call(self, value);
      }
    });
    self.updateStylesheet(true);
    self.debounceSave();
  },
  onElementorDocumentLoaded: function onElementorDocumentLoaded() {
    this.updateStylesheet();
    this.addPanelPage();
  },
  destroy: function destroy() {
    this.unbindEvents();
    this.model.destroy();
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/settings/base/panel.js":
/*!*****************************************************************!*\
  !*** ../assets/dev/js/editor/components/settings/base/panel.js ***!
  \*****************************************************************/
/***/ ((module) => {

"use strict";


module.exports = elementorModules.editor.views.ControlsStack.extend({
  id: function id() {
    return 'elementor-panel-' + this.getOption('name') + '-settings';
  },
  getTemplate: function getTemplate() {
    return '#tmpl-elementor-panel-' + this.getOption('name') + '-settings';
  },
  childViewContainer: function childViewContainer() {
    return '#elementor-panel-' + this.getOption('name') + '-settings-controls';
  },
  childViewOptions: function childViewOptions() {
    return {
      container: this.getOption('editedView').getContainer()
    };
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/settings/editor-preferences/manager.js":
/*!*********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/settings/editor-preferences/manager.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _manager = _interopRequireDefault(__webpack_require__(/*! ../base/manager */ "../assets/dev/js/editor/components/settings/base/manager.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var _default = exports["default"] = /*#__PURE__*/function (_BaseManager) {
  function _default() {
    var _this;
    (0, _classCallCheck2.default)(this, _default);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, _default, [].concat(args));
    _this.changeCallbacks = {
      ui_theme: _this.onUIThemeChanged,
      panel_width: _this.onPanelWidthChanged,
      edit_buttons: _this.onEditButtonsChanged,
      show_hidden_elements: _this.onShowHiddenElementsChange,
      show_launchpad_checklist: _this.toggleChecklistIconVisibility
    };
    return _this;
  }
  (0, _inherits2.default)(_default, _BaseManager);
  return (0, _createClass2.default)(_default, [{
    key: "getDefaultSettings",
    value: function getDefaultSettings() {
      return {
        darkModeLinkID: 'elementor-editor-dark-mode-css'
      };
    }
  }, {
    key: "toggleChecklistIconVisibility",
    value: function toggleChecklistIconVisibility(switcherValue) {
      var shouldShow = 'yes' === switcherValue;
      this.addMixpanelTrackingChecklist(shouldShow);
      $e.run('checklist/toggle-icon', shouldShow);
    }
  }, {
    key: "onUIThemeChanged",
    value: function onUIThemeChanged(newValue) {
      var $lightUi = jQuery('#e-theme-ui-light-css');
      var $darkUi = jQuery('#e-theme-ui-dark-css');
      if ('auto' === newValue) {
        $lightUi.attr('media', '(prefers-color-scheme: light)');
        $darkUi.attr('media', '(prefers-color-scheme: dark)');
        return;
      }
      if ('light' === newValue) {
        $lightUi.attr('media', 'all');
        $darkUi.attr('media', 'none');
      } else {
        $lightUi.attr('media', 'none');
        $darkUi.attr('media', 'all');
      }
    }
  }, {
    key: "onPanelWidthChanged",
    value: function onPanelWidthChanged(newValue) {
      elementor.panel.saveSize({
        width: newValue.size + newValue.unit
      });
      elementor.panel.setSize();
    }
  }, {
    key: "onEditButtonsChanged",
    value: function onEditButtonsChanged() {
      // Let the button change before the high-performance action of rendering the entire page
      setTimeout(function () {
        return elementor.getPreviewView()._renderChildren();
      }, 300);
    }
  }, {
    key: "onShowHiddenElementsChange",
    value: function onShowHiddenElementsChange() {
      elementorFrontend.elements.$body.toggleClass('e-preview--show-hidden-elements');
    }
  }, {
    key: "addMixpanelTrackingChecklist",
    value: function addMixpanelTrackingChecklist(shouldShow) {
      var name = shouldShow ? 'checklistShow' : 'checklistHide';
      var postId = elementor.getPreviewContainer().document.config.id;
      var postTitle = elementor.getPreviewContainer().model.attributes.settings.attributes.post_title;
      var postTypeTitle = elementor.getPreviewContainer().document.config.post_type_title;
      var documentType = elementor.getPreviewContainer().document.config.type;
      return elementor.editorEvents.dispatchEvent(elementor.editorEvents.config.names.elementorEditor.userPreferences[name], {
        location: elementor.editorEvents.config.locations.elementorEditor,
        secondaryLocation: elementor.editorEvents.config.secondaryLocations.userPreferences,
        trigger: elementor.editorEvents.config.triggers.toggleClick,
        element: elementor.editorEvents.config.elements.toggle,
        postId: postId,
        postTitle: postTitle,
        postTypeTitle: postTypeTitle,
        documentType: documentType
      });
    }
  }]);
}(_manager.default);

/***/ }),

/***/ "../assets/dev/js/editor/components/settings/page/component.js":
/*!*********************************************************************!*\
  !*** ../assets/dev/js/editor/components/settings/page/component.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _componentBase = _interopRequireDefault(__webpack_require__(/*! elementor-editor/component-base */ "../assets/dev/js/editor/component-base.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Component = exports["default"] = /*#__PURE__*/function (_ComponentBase) {
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _callSuper(this, Component, arguments);
  }
  (0, _inherits2.default)(Component, _ComponentBase);
  return (0, _createClass2.default)(Component, [{
    key: "getNamespace",
    value: function getNamespace() {
      return 'panel/page-settings';
    }
  }, {
    key: "defaultTabs",
    value: function defaultTabs() {
      return {
        settings: {
          title: __('Settings', 'elementor')
        },
        style: {
          title: __('Style', 'elementor')
        },
        advanced: {
          title: __('Advanced', 'elementor')
        }
      };
    }
  }, {
    key: "renderTab",
    value: function renderTab(tab, args) {
      var activeControl = args.activeControl,
        _args$refresh = args.refresh,
        refresh = _args$refresh === void 0 ? false : _args$refresh;
      if (this.shouldRenderPage(tab) || refresh) {
        elementor.getPanelView().setPage('page_settings').activateTab(tab);
      }
      this.activateControl(activeControl);
    }
  }, {
    key: "shouldRenderPage",
    value: function shouldRenderPage(tab) {
      var _currentPanelView$get;
      var currentPanelView = elementor.getPanelView();
      var isSamePage = 'page_settings' === currentPanelView.getCurrentPageName();
      var isSameTab = tab === ((_currentPanelView$get = currentPanelView.getCurrentPageView()) === null || _currentPanelView$get === void 0 ? void 0 : _currentPanelView$get.activeTab);
      return !isSamePage || !isSameTab;
    }
  }, {
    key: "getTabsWrapperSelector",
    value: function getTabsWrapperSelector() {
      return '.elementor-panel-navigation';
    }
  }]);
}(_componentBase.default);

/***/ }),

/***/ "../assets/dev/js/editor/components/settings/page/manager.js":
/*!*******************************************************************!*\
  !*** ../assets/dev/js/editor/components/settings/page/manager.js ***!
  \*******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _construct2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/construct */ "../node_modules/@babel/runtime/helpers/construct.js"));
var _toConsumableArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "../node_modules/@babel/runtime/helpers/toConsumableArray.js"));
var _component = _interopRequireDefault(__webpack_require__(/*! ./component */ "../assets/dev/js/editor/components/settings/page/component.js"));
var _childrenArray = _interopRequireDefault(__webpack_require__(/*! elementor-editor/container/model/children-array */ "../assets/dev/js/editor/container/model/children-array.js"));
var BaseSettings = __webpack_require__(/*! elementor-editor/components/settings/base/manager */ "../assets/dev/js/editor/components/settings/base/manager.js");
module.exports = BaseSettings.extend({
  getStyleId: function getStyleId() {
    return this.getSettings('name') + '-' + elementor.documents.getCurrent().id;
  },
  onInit: function onInit() {
    BaseSettings.prototype.onInit.apply(this);
    $e.components.register(new _component.default({
      manager: this
    }));
  },
  save: function save() {},
  getDataToSave: function getDataToSave(data) {
    data.id = elementor.config.document.id;
    return data;
  },
  // Emulate an element view/model structure with the parts needed for a container.
  getEditedView: function getEditedView() {
    var _this = this;
    if (this.editedView) {
      return this.editedView;
    }
    var documentElementType = elementor.elementsManager.getElementTypeClass('document'),
      ModelClass = documentElementType.getModel(),
      type = this.getContainerType(),
      editModel = new ModelClass({
        id: type,
        elType: type,
        settings: this.model,
        elements: elementor.elements
      }),
      container = new elementorModules.editor.Container({
        type: type,
        id: editModel.id,
        model: editModel,
        settings: editModel.get('settings'),
        label: elementor.config.document.panel.title,
        controls: this.model.controls,
        children: (0, _construct2.default)(_childrenArray.default, (0, _toConsumableArray2.default)(elementor.elements || [])),
        parent: false,
        // Emulate a view that can render the style.
        renderer: {
          view: {
            lookup: function lookup() {
              return container;
            },
            renderOnChange: function renderOnChange() {
              return _this.updateStylesheet();
            },
            renderUI: function renderUI() {
              return _this.updateStylesheet();
            }
          }
        }
      });
    this.editedView = {
      getContainer: function getContainer() {
        return container;
      },
      getEditModel: function getEditModel() {
        return editModel;
      },
      model: editModel,
      container: container
    };
    return this.editedView;
  },
  getContainerType: function getContainerType() {
    return 'document';
  },
  /**
   * @deprecated since 3.7.0, use `getContainerType()` instead.
   */
  getContainerId: function getContainerId() {
    elementorDevTools.deprecation.deprecated('getContainerId()', '3.7.0', 'getContainerType()');
    return this.getContainerType();
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/settings/settings.js":
/*!***************************************************************!*\
  !*** ../assets/dev/js/editor/components/settings/settings.js ***!
  \***************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _manager = _interopRequireDefault(__webpack_require__(/*! ./editor-preferences/manager */ "../assets/dev/js/editor/components/settings/editor-preferences/manager.js"));
module.exports = elementorModules.Module.extend({
  modules: {
    base: __webpack_require__(/*! elementor-editor/components/settings/base/manager */ "../assets/dev/js/editor/components/settings/base/manager.js"),
    page: __webpack_require__(/*! elementor-editor/components/settings/page/manager */ "../assets/dev/js/editor/components/settings/page/manager.js"),
    editorPreferences: _manager.default
  },
  panelPages: {
    base: __webpack_require__(/*! elementor-editor/components/settings/base/panel */ "../assets/dev/js/editor/components/settings/base/panel.js")
  },
  onInit: function onInit() {
    this.initSettings();
  },
  initSettings: function initSettings() {
    var self = this;
    _.each(elementor.config.settings, function (config, name) {
      var Manager = self.modules[name] || self.modules.base;
      self[name] = new Manager(config);
    });
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/behaviors/insert-template.js":
/*!****************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/behaviors/insert-template.js ***!
  \****************************************************************************************/
/***/ ((module) => {

"use strict";


var InsertTemplateHandler;
InsertTemplateHandler = Marionette.Behavior.extend({
  ui: {
    insertButton: '.elementor-template-library-template-insert'
  },
  events: {
    'click @ui.insertButton': 'onInsertButtonClick'
  },
  onRender: function onRender() {
    this.ui.insertButton.toggleClass('disabled', this.view.model.isLocked());
  },
  onInsertButtonClick: function onInsertButtonClick(e) {
    if ('locked' === this.view.model.get('status')) {
      e.preventDefault();
      e.stopPropagation();
      return;
    }
    var args = {
      model: this.view.model
    };
    this.ui.insertButton.addClass('elementor-disabled');
    var activeSource = args.model.get('source');

    /**
     * Filter template source.
     *
     * @param bool   isRemote     - If `true` the source is a remote source.
     * @param string activeSource - The current template source.
     */
    var isRemote = elementor.hooks.applyFilters('templates/source/is-remote', 'remote' === activeSource, activeSource);
    if (isRemote && !elementor.config.library_connect.is_connected) {
      $e.route('library/connect', args);
      return;
    }
    $e.run('library/insert-template', args);
  }
});
module.exports = InsertTemplateHandler;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/collections/templates.js":
/*!************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/collections/templates.js ***!
  \************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var TemplateLibraryTemplateModel = __webpack_require__(/*! elementor-templates/models/template */ "../assets/dev/js/editor/components/template-library/models/template.js"),
  TemplateLibraryCollection;
TemplateLibraryCollection = Backbone.Collection.extend({
  model: TemplateLibraryTemplateModel
});
module.exports = TemplateLibraryCollection;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/commands-data/index.js":
/*!**********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/commands-data/index.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Templates", ({
  enumerable: true,
  get: function get() {
    return _templates.Templates;
  }
}));
var _templates = __webpack_require__(/*! ./templates */ "../assets/dev/js/editor/components/template-library/commands-data/templates.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/commands-data/templates.js":
/*!**************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/commands-data/templates.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Templates = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Templates = exports.Templates = /*#__PURE__*/function (_$e$modules$CommandDa) {
  function Templates() {
    (0, _classCallCheck2.default)(this, Templates);
    return _callSuper(this, Templates, arguments);
  }
  (0, _inherits2.default)(Templates, _$e$modules$CommandDa);
  return (0, _createClass2.default)(Templates, null, [{
    key: "getEndpointFormat",
    value: function getEndpointFormat() {
      return 'template-library/templates';
    }
  }]);
}($e.modules.CommandData);
var _default = exports["default"] = Templates;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/commands/index.js":
/*!*****************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/commands/index.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "InsertTemplate", ({
  enumerable: true,
  get: function get() {
    return _insertTemplate.InsertTemplate;
  }
}));
Object.defineProperty(exports, "Open", ({
  enumerable: true,
  get: function get() {
    return _open.Open;
  }
}));
var _insertTemplate = __webpack_require__(/*! ./insert-template */ "../assets/dev/js/editor/components/template-library/commands/insert-template.js");
var _open = __webpack_require__(/*! ./open */ "../assets/dev/js/editor/components/template-library/commands/open.js");

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/commands/insert-template.js":
/*!***************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/commands/insert-template.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.InsertTemplate = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var InsertTemplate = exports.InsertTemplate = /*#__PURE__*/function (_$e$modules$CommandBa) {
  function InsertTemplate() {
    (0, _classCallCheck2.default)(this, InsertTemplate);
    return _callSuper(this, InsertTemplate, arguments);
  }
  (0, _inherits2.default)(InsertTemplate, _$e$modules$CommandBa);
  return (0, _createClass2.default)(InsertTemplate, [{
    key: "apply",
    value: function apply(args) {
      return this.component.insertTemplate(args);
    }
  }]);
}($e.modules.CommandBase);
var _default = exports["default"] = InsertTemplate;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/commands/open.js":
/*!****************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/commands/open.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Open = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Open = exports.Open = /*#__PURE__*/function (_$e$modules$CommandBa) {
  function Open() {
    (0, _classCallCheck2.default)(this, Open);
    return _callSuper(this, Open, arguments);
  }
  (0, _inherits2.default)(Open, _$e$modules$CommandBa);
  return (0, _createClass2.default)(Open, [{
    key: "apply",
    value: function apply(args) {
      return this.component.show(args);
    }
  }]);
}($e.modules.CommandBase);
var _default = exports["default"] = Open;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/component.js":
/*!************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/component.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _readOnlyError2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/readOnlyError */ "../node_modules/@babel/runtime/helpers/readOnlyError.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _componentModalBase = _interopRequireDefault(__webpack_require__(/*! elementor-api/modules/component-modal-base */ "../modules/web-cli/assets/js/modules/component-modal-base.js"));
var commands = _interopRequireWildcard(__webpack_require__(/*! ./commands/ */ "../assets/dev/js/editor/components/template-library/commands/index.js"));
var commandsData = _interopRequireWildcard(__webpack_require__(/*! ./commands-data/ */ "../assets/dev/js/editor/components/template-library/commands-data/index.js"));
var _constants = __webpack_require__(/*! ./constants */ "../assets/dev/js/editor/components/template-library/constants.js");
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, o, e, r) { var p = (0, _get2.default)((0, _getPrototypeOf2.default)(1 & r ? t.prototype : t), o, e); return 2 & r && "function" == typeof p ? function (t) { return p.apply(e, t); } : p; }
var TemplateLibraryLayoutView = __webpack_require__(/*! elementor-templates/views/library-layout */ "../assets/dev/js/editor/components/template-library/views/library-layout.js");
var Component = exports["default"] = /*#__PURE__*/function (_ComponentModalBase) {
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _callSuper(this, Component, arguments);
  }
  (0, _inherits2.default)(Component, _ComponentModalBase);
  return (0, _createClass2.default)(Component, [{
    key: "__construct",
    value: function __construct(args) {
      var _elementorCommon$conf;
      _superPropGet(Component, "__construct", this, 3)([args]);

      // When switching documents update defaultTabs.
      elementor.on('document:loaded', this.onDocumentLoaded.bind(this));

      // Remove whole component cache data.
      $e.data.deleteCache(this, 'library');
      if ((_elementorCommon$conf = elementorCommon.config.experimentalFeatures) !== null && _elementorCommon$conf !== void 0 && _elementorCommon$conf['cloud-library']) {
        elementor.channels.templates.on('quota:update', function () {
          var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
            force = _ref.force;
          $e.components.get('cloud-library').utils.setQuotaConfig(force);
        });
      }
    }
  }, {
    key: "getNamespace",
    value: function getNamespace() {
      return 'library';
    }
  }, {
    key: "defaultTabs",
    value: function defaultTabs() {
      return {
        'templates/blocks': {
          title: __('Blocks', 'elementor'),
          getFilter: function getFilter() {
            return {
              source: 'remote',
              type: 'block',
              subtype: elementor.config.document.remoteLibrary.category
            };
          }
        },
        'templates/pages': {
          title: __('Pages', 'elementor'),
          filter: {
            source: 'remote',
            type: 'page'
          }
        },
        'templates/my-templates': {
          title: __('Templates', 'elementor'),
          getFilter: function getFilter() {
            var _elementor$templates$, _elementor$templates$2;
            return {
              source: (_elementor$templates$ = elementor.templates.getSourceSelection()) !== null && _elementor$templates$ !== void 0 ? _elementor$templates$ : 'local',
              view: (_elementor$templates$2 = elementor.templates.getViewSelection()) !== null && _elementor$templates$2 !== void 0 ? _elementor$templates$2 : 'list'
            };
          }
        }
      };
    }
  }, {
    key: "defaultRoutes",
    value: function defaultRoutes() {
      var _this = this,
        _elementorCommon$conf2;
      var defaultRoutes = {
        import: function _import() {
          _this.manager.layout.showImportView();
        },
        'save-template': function saveTemplate(args) {
          var _args$context;
          _this.manager.layout.showSaveTemplateView(args.model, (_args$context = args.context) !== null && _args$context !== void 0 ? _args$context : _constants.SAVE_CONTEXTS.SAVE);
        },
        preview: function preview(args) {
          _this.manager.layout.showPreviewView(args.model);
        },
        connect: function connect(args) {
          args.texts = {
            title: __('Connect to Template Library', 'elementor'),
            message: __('Access this template and our entire library by creating a free personal account', 'elementor'),
            button: __('Get Started', 'elementor')
          };
          _this.manager.layout.showConnectView(args);
        }
      };
      if ((_elementorCommon$conf2 = elementorCommon.config.experimentalFeatures) !== null && _elementorCommon$conf2 !== void 0 && _elementorCommon$conf2['cloud-library']) {
        defaultRoutes['view-folder'] = function (args) {
          _this.manager.layout.showFolderView(args);
        };
      }
      return defaultRoutes;
    }
  }, {
    key: "defaultCommands",
    value: function defaultCommands() {
      var modalCommands = _superPropGet(Component, "defaultCommands", this, 3)([]);
      return _objectSpread(_objectSpread({}, modalCommands), this.importCommands(commands));
    }
  }, {
    key: "defaultData",
    value: function defaultData() {
      return this.importCommands(commandsData);
    }
  }, {
    key: "defaultShortcuts",
    value: function defaultShortcuts() {
      return {
        open: {
          keys: 'ctrl+shift+l'
        }
      };
    }
  }, {
    key: "onDocumentLoaded",
    value: function onDocumentLoaded(document) {
      this.setDefaultRoute(document.config.remoteLibrary.default_route);
      this.maybeOpenLibrary();
    }
  }, {
    key: "renderTab",
    value: function renderTab(tab) {
      var currentTab = this.tabs[tab];
      var filter = currentTab.getFilter ? currentTab.getFilter() : currentTab.filter;
      this.currentTab = tab;
      this.manager.setScreen(filter);
    }
  }, {
    key: "activateTab",
    value: function activateTab(tab) {
      $e.routes.saveState('library');
      _superPropGet(Component, "activateTab", this, 3)([tab]);
    }
  }, {
    key: "open",
    value: function open() {
      _superPropGet(Component, "open", this, 3)([]);
      if (!this.manager.layout) {
        this.manager.layout = this.layout;
      }
      this.manager.layout.setHeaderDefaultParts();
      return true;
    }
  }, {
    key: "close",
    value: function close() {
      if (!_superPropGet(Component, "close", this, 3)([])) {
        return false;
      }
      this.manager.modalConfig = {};
      return true;
    }
  }, {
    key: "show",
    value: function show(args) {
      this.manager.modalConfig = args;
      if (args.toDefault || !$e.routes.restoreState('library')) {
        $e.route(this.getDefaultRoute());
      }
    }

    // TODO: Move function to 'insert-template' command.
  }, {
    key: "insertTemplate",
    value: function insertTemplate(args) {
      var _this2 = this;
      this.downloadTemplate(args, function (data, callbackParams) {
        $e.run('document/elements/import', {
          model: callbackParams.model,
          data: data,
          options: callbackParams.importOptions,
          onAfter: function onAfter() {
            var _callbackParams$model;
            _this2.manager.eventManager.sendTemplateInsertedEvent({
              library_type: (_callbackParams$model = callbackParams.model.get('source')) !== null && _callbackParams$model !== void 0 ? _callbackParams$model : 'local'
            });
          }
        });
      });
    }
  }, {
    key: "downloadTemplate",
    value: function downloadTemplate(args, callback) {
      var _this3 = this;
      var autoImportSettings = elementor.config.document.remoteLibrary.autoImportSettings,
        model = args.model;
      var _args$withPageSetting = args.withPageSettings,
        withPageSettings = _args$withPageSetting === void 0 ? null : _args$withPageSetting;
      if (autoImportSettings) {
        withPageSettings = true;
      }
      if (null === withPageSettings && model.get('hasPageSettings')) {
        var insertTemplateHandler = this.getImportSettingsDialog();
        insertTemplateHandler.showImportDialog(model);
        return;
      }
      this.manager.layout.showLoadingView();
      this.manager.requestTemplateContent(model.get('source'), model.get('template_id'), {
        data: {
          with_page_settings: withPageSettings
        },
        success: function success(data) {
          // Clone the `modalConfig.importOptions` because it deleted during the closing.
          var importOptions = jQuery.extend({}, _this3.manager.modalConfig.importOptions);
          importOptions.withPageSettings = withPageSettings;

          // Hide for next open.
          _this3.manager.layout.hideLoadingView();
          _this3.manager.layout.hideModal();
          callback(data, {
            model: model,
            importOptions: importOptions
          });
        },
        error: function error(data) {
          _this3.manager.showErrorDialog(data);
        },
        complete: function complete() {
          _this3.manager.layout.hideLoadingView();
        }
      });
    }
  }, {
    key: "getImportSettingsDialog",
    value: function getImportSettingsDialog() {
      // Moved from ./behaviors/insert-template.js
      var InsertTemplateHandler = {
        dialog: null,
        showImportDialog: function showImportDialog(model) {
          var dialog = InsertTemplateHandler.getDialog(model);
          dialog.onConfirm = function () {
            $e.run('library/insert-template', {
              model: model,
              withPageSettings: true,
              onAfter: function onAfter() {
                elementor.templates.eventManager.sendInsertApplySettingsEvent({
                  apply_modal_result: 'apply',
                  library_type: model.get('source')
                });
              }
            });
          };
          dialog.onCancel = function () {
            $e.run('library/insert-template', {
              model: model,
              withPageSettings: false,
              onAfter: function onAfter() {
                elementor.templates.eventManager.sendInsertApplySettingsEvent({
                  apply_modal_result: "don't apply",
                  library_type: model.get('source')
                });
              }
            });
          };
          dialog.show();
        },
        initDialog: function initDialog(model) {
          InsertTemplateHandler.dialog = elementorCommon.dialogsManager.createWidget('confirm', {
            id: 'elementor-insert-template-settings-dialog',
            /* Translators: %s is the type content */
            headerMessage: __('Apply the settings of this %s too?', 'elementor').replace('%s', elementor.translate(model.attributes.type)),
            /* Translators: %s is the type content */
            message: __('This will override the design, layout, and other settings of the %s you’re working on.', 'elementor').replace('%s', elementor.documents.getCurrent().container.label),
            strings: {
              confirm: __('Apply', 'elementor'),
              cancel: __('Don’t apply', 'elementor')
            }
          });
        },
        getDialog: function getDialog(model) {
          if (!InsertTemplateHandler.dialog) {
            InsertTemplateHandler.initDialog(model);
          }
          return InsertTemplateHandler.dialog;
        }
      };
      return InsertTemplateHandler;
    }
  }, {
    key: "getTabsWrapperSelector",
    value: function getTabsWrapperSelector() {
      return '#elementor-template-library-header-menu';
    }
  }, {
    key: "getModalLayout",
    value: function getModalLayout() {
      return TemplateLibraryLayoutView;
    }
  }, {
    key: "maybeOpenLibrary",
    value: function maybeOpenLibrary() {
      if ('#library' === location.hash) {
        $e.run('library/open');
        location.hash = '';
      }
    }
  }]);
}(_componentModalBase.default);

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/constants.js":
/*!************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/constants.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.SAVE_CONTEXTS = exports.QUOTA_WARNINGS = exports.QUOTA_BAR_STATES = void 0;
var SAVE_CONTEXTS = exports.SAVE_CONTEXTS = Object.freeze({
  SAVE: 'save',
  MOVE: 'move',
  COPY: 'copy',
  BULK_MOVE: 'bulkMove',
  BULK_COPY: 'bulkCopy'
});
var QUOTA_WARNINGS = exports.QUOTA_WARNINGS = Object.freeze({
  /* Translators: 1: Quota usage percentage */
  warning: __('You\'ve saved %1$d%% of the templates in your plan. To get more space ', 'elementor') + '<a href="https://go.elementor.com/go-pro-cloud-templates-usage-bar-80" target="_blank">' + __('Upgrade now', 'elementor') + '</a>',
  /* Translators: 1: Quota usage percentage */
  alert: __('You\'ve saved %1$d%% of the templates in your plan. To get more space ', 'elementor') + '<a href="https://go.elementor.com/go-pro-cloud-templates-usage-bar-100" target="_blank">' + __('Upgrade now', 'elementor') + '</a>'
});
var QUOTA_BAR_STATES = exports.QUOTA_BAR_STATES = Object.freeze({
  NORMAL: 'normal',
  WARNING: 'warning',
  ALERT: 'alert'
});

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/event-manager/index.js":
/*!**********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/event-manager/index.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.EventManager = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var EVENTS_MAP = {
  SAVE_TEMPLATE_CONTEXT_MENU_EXPOSURE: 'save_template_context_menu_exposure',
  NEW_SAVE_TEMPLATE_CLICKED: 'new_save_template_clicked',
  TEMPLATE_SAVED: 'template_saved',
  TEMPLATE_TRANSFER: 'template_transfer',
  ITEM_DELETED: 'item_deleted',
  TEMPLATE_IMPORT: 'template_import',
  TEMPLATE_RENAME: 'template_rename',
  TEMPLATE_INSERTED: 'template_inserted',
  BULK_ACTIONS_SUCCESS: 'bulk_actions',
  BULK_ACTIONS_FAILED: 'bulk_actions',
  FOLDER_CREATE: 'folder_create',
  QUOTA_BAR_CAPACITY: 'quota_bar_capacity',
  INSERT_APPLY_SETTINGS: 'insert_apply_settings',
  UPGRADE_CLICKED: 'upgrade_clicked',
  PAGE_VIEWED: 'page_viewed',
  DELETION_UNDO: 'deletion_undo'
};
var EventManager = exports.EventManager = /*#__PURE__*/function () {
  function EventManager() {
    (0, _classCallCheck2.default)(this, EventManager);
  }
  return (0, _createClass2.default)(EventManager, [{
    key: "sendEvent",
    value: function sendEvent(eventName, data) {
      return elementor.editorEvents.dispatchEvent(eventName, data);
    }
  }, {
    key: "sendContextMenuExposureEvent",
    value: function sendContextMenuExposureEvent() {
      return this.sendEvent(EVENTS_MAP.SAVE_TEMPLATE_CONTEXT_MENU_EXPOSURE, {
        location: elementor.editorEvents.config.locations.elementorEditor,
        secondaryLocation: elementor.editorEvents.config.secondaryLocations.contextMenu,
        trigger: elementor.editorEvents.config.triggers.visible
      });
    }
  }, {
    key: "sendNewSaveTemplateClickedEvent",
    value: function sendNewSaveTemplateClickedEvent() {
      return this.sendEvent(EVENTS_MAP.NEW_SAVE_TEMPLATE_CLICKED, {
        location: elementor.editorEvents.config.locations.templatesLibrary.library,
        secondaryLocation: elementor.editorEvents.config.secondaryLocations.templateLibrary.saveModal,
        trigger: elementor.editorEvents.config.triggers.click
      });
    }
  }, {
    key: "sendTemplateSavedEvent",
    value: function sendTemplateSavedEvent(data) {
      return this.sendEvent(EVENTS_MAP.TEMPLATE_SAVED, _objectSpread({
        location: elementor.editorEvents.config.locations.templatesLibrary.library,
        secondaryLocation: elementor.editorEvents.config.secondaryLocations.templateLibrary.saveModal,
        trigger: elementor.editorEvents.config.triggers.click
      }, data));
    }
  }, {
    key: "sendTemplateTransferEvent",
    value: function sendTemplateTransferEvent(data) {
      return this.sendEvent(EVENTS_MAP.TEMPLATE_TRANSFER, _objectSpread({
        location: elementor.editorEvents.config.locations.templatesLibrary.library,
        secondaryLocation: elementor.editorEvents.config.secondaryLocations.templateLibrary.saveModal
      }, data));
    }
  }, {
    key: "sendItemDeletedEvent",
    value: function sendItemDeletedEvent(data) {
      return this.sendEvent(EVENTS_MAP.ITEM_DELETED, _objectSpread({
        location: elementor.editorEvents.config.locations.templatesLibrary.library,
        secondaryLocation: elementor.editorEvents.config.secondaryLocations.templateLibrary.deleteDialog
      }, data));
    }
  }, {
    key: "sendTemplateImportEvent",
    value: function sendTemplateImportEvent(data) {
      return this.sendEvent(EVENTS_MAP.TEMPLATE_IMPORT, _objectSpread({
        location: elementor.editorEvents.config.locations.templatesLibrary.library,
        secondaryLocation: elementor.editorEvents.config.secondaryLocations.templateLibrary.saveModal
      }, data));
    }
  }, {
    key: "sendTemplateRenameEvent",
    value: function sendTemplateRenameEvent(data) {
      return this.sendEvent(EVENTS_MAP.TEMPLATE_RENAME, _objectSpread({
        location: elementor.editorEvents.config.locations.templatesLibrary.library,
        secondaryLocation: elementor.editorEvents.config.secondaryLocations.templateLibrary.renameDialog
      }, data));
    }
  }, {
    key: "sendTemplateInsertedEvent",
    value: function sendTemplateInsertedEvent(data) {
      return this.sendEvent(EVENTS_MAP.TEMPLATE_INSERTED, _objectSpread({
        location: elementor.editorEvents.config.locations.templatesLibrary.library
      }, data));
    }
  }, {
    key: "sendBulkActionsSuccessEvent",
    value: function sendBulkActionsSuccessEvent(data) {
      return this.sendEvent(EVENTS_MAP.BULK_ACTIONS_SUCCESS, _objectSpread({
        bulk_status: 'success',
        location: elementor.editorEvents.config.locations.templatesLibrary.library,
        secondaryLocation: elementor.editorEvents.config.secondaryLocations.templateLibrary.saveModal
      }, data));
    }
  }, {
    key: "sendBulkActionsFailedEvent",
    value: function sendBulkActionsFailedEvent(data) {
      return this.sendEvent(EVENTS_MAP.BULK_ACTIONS_FAILED, _objectSpread({
        bulk_status: 'fail',
        location: elementor.editorEvents.config.locations.templatesLibrary.library,
        secondaryLocation: elementor.editorEvents.config.secondaryLocations.templateLibrary.saveModal
      }, data));
    }
  }, {
    key: "sendFolderCreateEvent",
    value: function sendFolderCreateEvent() {
      return this.sendEvent(EVENTS_MAP.FOLDER_CREATE, {
        location: elementor.editorEvents.config.locations.templatesLibrary.library,
        secondaryLocation: elementor.editorEvents.config.secondaryLocations.templateLibrary.createFolderDialog
      });
    }
  }, {
    key: "sendQuotaBarCapacityEvent",
    value: function sendQuotaBarCapacityEvent(data) {
      return this.sendEvent(EVENTS_MAP.QUOTA_BAR_CAPACITY, _objectSpread({
        location: elementor.editorEvents.config.locations.templatesLibrary.library
      }, data));
    }
  }, {
    key: "sendInsertApplySettingsEvent",
    value: function sendInsertApplySettingsEvent(data) {
      return this.sendEvent(EVENTS_MAP.INSERT_APPLY_SETTINGS, _objectSpread({
        location: elementor.editorEvents.config.locations.templatesLibrary.library,
        secondaryLocation: elementor.editorEvents.config.secondaryLocations.templateLibrary.applySettingsDialog
      }, data));
    }
  }, {
    key: "sendUpgradeClickedEvent",
    value: function sendUpgradeClickedEvent(data) {
      var _elementor;
      return this.sendEvent(EVENTS_MAP.UPGRADE_CLICKED, _objectSpread({
        location: elementor.editorEvents.config.locations.templatesLibrary.library,
        current_sub: (_elementor = elementor) === null || _elementor === void 0 || (_elementor = _elementor.config) === null || _elementor === void 0 || (_elementor = _elementor.library_connect) === null || _elementor === void 0 ? void 0 : _elementor.current_access_tier
      }, data));
    }
  }, {
    key: "sendPageViewEvent",
    value: function sendPageViewEvent(data) {
      return this.sendEvent(EVENTS_MAP.PAGE_VIEWED, _objectSpread({
        page_loaded: data.location
      }, data));
    }
  }, {
    key: "sendDeletionUndoEvent",
    value: function sendDeletionUndoEvent(data) {
      return this.sendEvent(EVENTS_MAP.DELETION_UNDO, _objectSpread({}, data));
    }
  }]);
}();

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/manager.js":
/*!**********************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/manager.js ***!
  \**********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];
/* provided dependency */ var sprintf = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["sprintf"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _typeof2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _component = _interopRequireDefault(__webpack_require__(/*! ./component */ "../assets/dev/js/editor/components/template-library/component.js"));
var _localStorage = _interopRequireDefault(__webpack_require__(/*! elementor-api/core/data/storages/local-storage */ "../modules/web-cli/assets/js/core/data/storages/local-storage.js"));
var _eventManager = __webpack_require__(/*! ./event-manager */ "../assets/dev/js/editor/components/template-library/event-manager/index.js");
var _constants = __webpack_require__(/*! ./constants */ "../assets/dev/js/editor/components/template-library/constants.js");
var TemplateLibraryCollection = __webpack_require__(/*! elementor-templates/collections/templates */ "../assets/dev/js/editor/components/template-library/collections/templates.js");
var TemplateLibraryManager = function TemplateLibraryManager() {
  var _this3 = this;
  this.modalConfig = {};
  this.eventManager = new _eventManager.EventManager();
  var self = this,
    templateTypes = {},
    storage = new _localStorage.default(),
    storageKeyPrefix = 'my_templates_',
    sourceKey = 'source',
    viewKey = 'view',
    bulkSelectedItems = new Set(),
    lastDeletedItems = new Set();
  var deleteDialog,
    errorDialog,
    templatesCollection,
    config = {},
    filterTerms = {},
    isLoading = false,
    total = 0,
    toastConfig = {
      show: false,
      options: {}
    };
  var registerDefaultTemplateTypes = function registerDefaultTemplateTypes() {
    var data = self.getDefaultTemplateTypeData();
    var translationMap = (0, _defineProperty2.default)({
      page: __('Page', 'elementor'),
      section: __('Section', 'elementor'),
      container: __('Container', 'elementor'),
      'e-div-block': __('Div Block', 'elementor'),
      'e-flexbox': __('Flexbox', 'elementor')
    }, elementor.config.document.type, elementor.config.document.panel.title);
    jQuery.each(translationMap, function (type, title) {
      var safeData = jQuery.extend(true, {}, data, self.getDefaultTemplateTypeSafeData(title));
      self.registerTemplateType(type, safeData);
    });
  };
  var registerDefaultFilterTerms = function registerDefaultFilterTerms() {
    filterTerms = {
      text: {
        callback: function callback(value) {
          value = value.toLowerCase();
          if (this.get('title').toLowerCase().indexOf(value) >= 0) {
            return true;
          }
          return _.any(this.get('tags'), function (tag) {
            return tag.toLowerCase().indexOf(value) >= 0;
          });
        }
      },
      type: {},
      subtype: {},
      favorite: {}
    };
  };
  this.isLoading = function () {
    return isLoading;
  };
  this.canLoadMore = function () {
    if (!templatesCollection) {
      return false;
    }
    return templatesCollection.length < total;
  };
  this.init = function () {
    var _this = this;
    registerDefaultTemplateTypes();
    registerDefaultFilterTerms();
    this.component = $e.components.register(new _component.default({
      manager: this
    }));
    elementor.addBackgroundClickListener('libraryToggleMore', {
      element: '.elementor-template-library-template-more'
    });
    window.addEventListener('message', function (message) {
      var data = message.data;
      if (!data.name || data.name !== 'library/capture-screenshot-done') {
        return;
      }
      var template = templatesCollection.models.find(function (templateModel) {
        return templateModel.get('template_id') === parseInt(data.id);
      });
      if (!template) {
        return null;
      }
      template.set('preview_url', data.imageUrl);
    });
    this.handleKeydown = function (event) {
      if (_this.isSelectAllShortcut(event) && _this.isCloudGridView() && _this.isClickedInLibrary(event)) {
        event.preventDefault();
        _this.selectAllTemplates();
      }
      if (_this.isUndoShortCut(event) && lastDeletedItems.size) {
        _this.restoreRemovedItems();
      }
    };
    document.addEventListener('keydown', this.handleKeydown);
  };
  this.getDefaultTemplateTypeData = function () {
    var _elementorCommon$conf, _elementorCommon$conf2, _elementorCommon$conf3, _elementorCommon$conf4, _elementorCommon$conf5;
    return {
      saveDialog: {
        icon: '<i class="eicon-library-upload" aria-hidden="true"></i>',
        canSaveToCloud: (_elementorCommon$conf = elementorCommon.config.experimentalFeatures) === null || _elementorCommon$conf === void 0 ? void 0 : _elementorCommon$conf['cloud-library'],
        saveBtnText: __('Save', 'elementor')
      },
      moveDialog: {
        description: __('Alternatively, you can copy the template.', 'elementor'),
        icon: '<i class="eicon-library-move" aria-hidden="true"></i>',
        canSaveToCloud: (_elementorCommon$conf2 = elementorCommon.config.experimentalFeatures) === null || _elementorCommon$conf2 === void 0 ? void 0 : _elementorCommon$conf2['cloud-library'],
        saveBtnText: __('Move', 'elementor')
      },
      copyDialog: {
        description: __('Alternatively, you can move the template.', 'elementor'),
        icon: '<i class="eicon-library-copy" aria-hidden="true"></i>',
        canSaveToCloud: (_elementorCommon$conf3 = elementorCommon.config.experimentalFeatures) === null || _elementorCommon$conf3 === void 0 ? void 0 : _elementorCommon$conf3['cloud-library'],
        saveBtnText: __('Copy', 'elementor')
      },
      bulkMoveDialog: {
        description: __('Alternatively, you can copy the templates.', 'elementor'),
        title: __('Move templates to a different location', 'elementor'),
        icon: '<i class="eicon-library-move" aria-hidden="true"></i>',
        canSaveToCloud: (_elementorCommon$conf4 = elementorCommon.config.experimentalFeatures) === null || _elementorCommon$conf4 === void 0 ? void 0 : _elementorCommon$conf4['cloud-library'],
        saveBtnText: __('Move', 'elementor')
      },
      bulkCopyDialog: {
        description: __('Alternatively, you can move the templates.', 'elementor'),
        title: __('Copy templates to a different location', 'elementor'),
        icon: '<i class="eicon-library-copy" aria-hidden="true"></i>',
        canSaveToCloud: (_elementorCommon$conf5 = elementorCommon.config.experimentalFeatures) === null || _elementorCommon$conf5 === void 0 ? void 0 : _elementorCommon$conf5['cloud-library'],
        saveBtnText: __('Copy', 'elementor')
      }
    };
  };
  this.getDefaultTemplateTypeSafeData = function (title) {
    var _elementorCommon$conf6;
    return {
      saveDialog: {
        description: (_elementorCommon$conf6 = elementorCommon.config.experimentalFeatures) !== null && _elementorCommon$conf6 !== void 0 && _elementorCommon$conf6['cloud-library'] ? sprintf(/* Translators: 1: Opening bold tag, 2: Closing bold tag.  2: Line break tag. 4: Opening bold tag, 5: Closing bold tag. */
        __('You can save it to %1$sCloud Templates%2$s to reuse across any of your Elementor sites at any time%3$sor to %4$sSite Templates%5$s so it’s always ready when editing this website.', 'elementor'), '<b>', '</b>', '<br>', '<b>', '</b>') : __('Your designs will be available for export and reuse on any page or website', 'elementor'),
        /* Translators: %s: Template type. */
        title: sprintf(__('Save this %s to your library', 'elementor'), title)
      },
      moveDialog: {
        /* Translators: %s: Template type. */
        title: sprintf(__('Move your %s to a different location', 'elementor'), title)
      },
      copyDialog: {
        /* Translators: %s: Template type. */
        title: sprintf(__('Copy your %s to a different location', 'elementor'), title)
      }
    };
  };
  this.isSelectAllShortcut = function (event) {
    return (event.metaKey || event.ctrlKey) && 'a' === event.key;
  };
  this.isUndoShortCut = function (event) {
    return (event.metaKey || event.ctrlKey) && 'z' === event.key;
  };
  this.isCloudGridView = function () {
    return 'cloud' === this.getFilter('source') && 'grid' === this.getViewSelection();
  };
  this.isClickedInLibrary = function (event) {
    if (event.target === document.body) {
      return true; // When the rename dialog is closed it sets the target to the body.
    }
    var libraryElement = document.getElementById('elementor-template-library-modal');
    return libraryElement && event.target === libraryElement;
  };
  this.clearLastRemovedItems = function () {
    lastDeletedItems.clear();
  };
  this.addLastRemovedItems = function (ids) {
    if (!Array.isArray(ids) && !ids.length) {
      return;
    }
    ids.forEach(function (id) {
      return lastDeletedItems.add(id);
    });
  };
  this.selectAllTemplates = function () {
    var _this2 = this;
    document.querySelectorAll('.elementor-template-library-template[data-template_id]').forEach(function (element) {
      var templateId = element.getAttribute('data-template_id');
      element.classList.add('bulk-selected-item');
      _this2.addBulkSelectionItem(templateId);
    });
    this.layout.handleBulkActionBar();
  };
  this.restoreRemovedItems = function () {
    this.onUndoDelete();
  };
  this.getSourceSelection = function () {
    return storage.getItem(storageKeyPrefix + sourceKey);
  };
  this.setSourceSelection = function (value) {
    return storage.setItem(storageKeyPrefix + sourceKey, value);
  };
  this.getViewSelection = function () {
    return storage.getItem(storageKeyPrefix + viewKey);
  };
  this.setViewSelection = function (value) {
    return storage.setItem(storageKeyPrefix + viewKey, value);
  };
  this.getTemplateTypes = function (type) {
    if (type) {
      return templateTypes[type];
    }
    return templateTypes;
  };
  this.registerTemplateType = function (type, data) {
    if (templateTypes.hasOwnProperty(type)) {
      return;
    }
    templateTypes[type] = data;
  };
  this.deleteTemplate = function (templateModel, options) {
    this.clearLastRemovedItems();
    var dialog = self.getDeleteDialog(templateModel);
    dialog.onConfirm = function () {
      if (options.onConfirm) {
        options.onConfirm();
      }
      var templateId = templateModel.get('template_id');
      var source = templateModel.get('source');
      var itemType = templateModel.get('subType');
      elementorCommon.ajax.addRequest('delete_template', {
        data: {
          source: source,
          template_id: templateId
        },
        success: function success(response) {
          templatesCollection.remove(templateModel);
          if ('cloud' === source) {
            self.addLastRemovedItems([templateId]);
          }
          if (options.onSuccess) {
            options.onSuccess(response);
          }
          self.layout.updateViewCollection(self.filterTemplates());
          self.triggerQuotaUpdate();
          self.resetBulkActionBar();
          self.eventManager.sendItemDeletedEvent({
            library_type: source,
            item_type: itemType
          });
        }
      });
    };
    dialog.show();
  };
  this.renameTemplate = function (templateModel, options) {
    var originalTitle = templateModel.get('title');
    _this3.clearLastRemovedItems();
    var dialog = _this3.getRenameDialog(templateModel);
    return new Promise(function (resolve) {
      dialog.onConfirm = function () {
        if (options.onConfirm) {
          options.onConfirm();
        }
        var source = templateModel.get('source');
        elementorCommon.ajax.addRequest('rename_template', {
          data: {
            source: source,
            id: templateModel.get('template_id'),
            title: templateModel.get('title')
          },
          success: function success(response) {
            templateModel.trigger('change:title');
            _this3.eventManager.sendTemplateRenameEvent({
              source: source
            });
            resolve(response);
          },
          error: function error(_error) {
            _this3.showErrorDialog(_error);
            templateModel.set('title', originalTitle);
            resolve();
          }
        });
      };
      dialog.show();
    });
  };
  this.getRenameDialog = function (templateModel) {
    var headerMessage = sprintf(
    // Translators: %1$s: Folder name, %2$s: Number of templates.
    __('Rename "%1$s"', 'elementor'), templateModel.get('title'));
    var originalTitle = templateModel.get('title');
    var $inputArea = jQuery('<input>', {
      id: 'elementor-rename-template-dialog__input',
      type: 'text',
      value: templateModel.get('title')
    }).attr('autocomplete', 'off');
    var dialog = elementorCommon.dialogsManager.createWidget('confirm', {
      id: 'elementor-template-library-rename-dialog',
      headerMessage: headerMessage,
      message: $inputArea,
      strings: {
        confirm: __('Rename', 'elementor')
      },
      hide: {
        ignore: '#elementor-template-library-modal'
      },
      onCancel: function onCancel() {
        templateModel.set('title', originalTitle);
      },
      onShow: function onShow() {
        elementor.templates.eventManager.sendPageViewEvent({
          location: elementor.editorEvents.config.secondaryLocations.templateLibrary.renameDialog
        });
        $inputArea.trigger('focus');
      }
    });
    $inputArea.on('input', function (event) {
      event.preventDefault();
      var title = event.target.value.trim();
      templateModel.set('title', title, {
        silent: true
      });
      dialog.getElements('ok').prop('disabled', !self.isTemplateTitleValid(title));
    });
    return dialog;
  };
  this.isTemplateTitleValid = function (title) {
    return title.trim().length > 0 && title.trim().length <= 75;
  };
  this.getFolderTemplates = function (parentElement) {
    _this3.clearLastRemovedItems();
    var parentId = parentElement.model.get('template_id');
    var parentTitle = parentElement.model.get('title');
    return new Promise(function (resolve) {
      isLoading = true;
      var ajaxOptions = {
        data: {
          source: 'cloud',
          template_id: parentId
        },
        success: function success(data) {
          _this3.setFilter('orderby', '', true);
          _this3.setFilter('order', '', true);
          _this3.setFilter('parent', {
            id: parentId,
            title: parentTitle
          });
          templatesCollection = new TemplateLibraryCollection(data.templates);
          elementor.templates.layout.hideLoadingView();
          self.layout.updateViewCollection(templatesCollection.models);
          self.layout.modalContent.currentView.ui.addNewFolder.remove();
          self.layout.modalContent.currentView.ui.addNewFolderDivider.remove();
          self.layout.resetSortingUI();
          isLoading = false;
          resolve();
        },
        error: function error(_error2) {
          isLoading = false;
          _this3.showErrorDialog(_error2);
        }
      };
      elementorCommon.ajax.addRequest('get_item_children', ajaxOptions);
    });
  };
  this.createFolder = function (folderData, options) {
    var _this4 = this;
    this.clearLastRemovedItems();
    if (null !== this.getFilter('parent')) {
      this.showErrorDialog(__('You can not create a folder inside another folder.', 'elementor'));
      return;
    }
    var dialog = this.getCreateFolderDialog(folderData);
    return new Promise(function (resolve) {
      dialog.onConfirm = /*#__PURE__*/(0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
        return _regenerator.default.wrap(function (_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 1;
              return elementorCommon.ajax.addRequest('create_folder', {
                data: {
                  source: folderData.source,
                  title: folderData.title
                },
                success: function success(response) {
                  resolve(response);
                  options === null || options === void 0 || options.onSuccess();
                  _this4.eventManager.sendFolderCreateEvent();
                },
                error: function error(_error3) {
                  _this4.showErrorDialog(_error3);
                  resolve();
                }
              });
            case 1:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      dialog.show();
    });
  };
  this.getCreateFolderDialog = function (folderData) {
    var paragraph = document.createElement('p');
    paragraph.className = 'elementor-create-folder-template-dialog__p';
    paragraph.textContent = __('Save assets to reuse on any site in your account.', 'elementor');
    var inputArea = document.createElement('input');
    inputArea.className = 'elementor-create-folder-template-dialog__input';
    inputArea.type = 'text';
    inputArea.value = '';
    inputArea.placeholder = __('Folder name', 'elementor');
    inputArea.autocomplete = 'off';
    var fragment = document.createDocumentFragment();
    fragment.appendChild(paragraph);
    fragment.appendChild(inputArea);
    var dialog = elementorCommon.dialogsManager.createWidget('confirm', {
      id: 'elementor-template-library-create-new-folder-dialog',
      headerMessage: __('Create a new folder', 'elementor'),
      message: fragment,
      strings: {
        confirm: __('Create', 'elementor')
      },
      hide: {
        ignore: '#elementor-template-library-modal'
      },
      onShow: function onShow() {
        inputArea.focus();
        elementor.templates.eventManager.sendPageViewEvent({
          location: elementor.editorEvents.config.secondaryLocations.templateLibrary.newFolderModal
        });
      }
    });
    dialog.getElements('ok').prop('disabled', true);
    inputArea.addEventListener('input', function (event) {
      event.preventDefault();
      var title = event.target.value.trim();
      folderData.title = title;
      var isTitleValid = self.isTemplateTitleValid(title);
      dialog.getElements('ok').prop('disabled', !isTitleValid);
    });
    return dialog;
  };
  this.deleteFolder = function (templateModel, options) {
    var _this5 = this;
    this.clearLastRemovedItems();
    var ajaxOptions = {
      data: {
        source: 'cloud',
        template_id: templateModel.get('template_id')
      },
      success: function success(data) {
        return _this5.handleGetFolderDataSuccess(templateModel, options, data);
      }
    };
    elementorCommon.ajax.addRequest('get_item_children', ajaxOptions);
  };
  this.handleGetFolderDataSuccess = function (templateModel, options, data) {
    var _this6 = this;
    var dialog = this.getDeleteFolderDialog(templateModel, data);
    dialog.onConfirm = function () {
      var _options$onConfirm;
      (_options$onConfirm = options.onConfirm) === null || _options$onConfirm === void 0 || _options$onConfirm.call(options);
      _this6.sendDeleteRequest(templateModel, options);
    };
    dialog.show();
  };
  this.getDeleteFolderDialog = function (templateModel, data) {
    var deleteFolderDialog = elementorCommon.dialogsManager.createWidget('confirm', {
      id: 'elementor-template-library-delete-dialog',
      headerMessage: __('Delete this folder?', 'elementor'),
      message: sprintf(
      // Translators: %1$s: Folder name, %2$s: Number of templates.
      __('This will permanently delete "%1$s" that contains %2$d templates.', 'elementor'), templateModel.get('title'), data.total),
      strings: {
        confirm: __('Delete', 'elementor')
      },
      onShow: function onShow() {
        elementor.templates.eventManager.sendPageViewEvent({
          location: elementor.editorEvents.config.secondaryLocations.templateLibrary.deleteFolderDialog
        });
      }
    });
    deleteFolderDialog.getElements('ok').addClass('e-danger color-white');
    return deleteFolderDialog;
  };
  this.getBulkDeleteDialog = function () {
    var bulkDeleteDialog = elementorCommon.dialogsManager.createWidget('confirm', {
      id: 'elementor-template-library-bulk-delete-dialog',
      headerMessage: __('Delete items?', 'elementor'),
      message: sprintf(
      // Translators: %1$s: Number of selected items.
      __('This will permanently remove %1$s selected items.', 'elementor'), bulkSelectedItems.size),
      strings: {
        confirm: __('Delete', 'elementor')
      }
    });
    bulkDeleteDialog.getElements('ok').addClass('e-danger color-white');
    return bulkDeleteDialog;
  };
  this.sendDeleteRequest = function (templateModel, options) {
    var _this7 = this;
    var templateId = templateModel.get('template_id');
    var source = templateModel.get('source');
    elementorCommon.ajax.addRequest('delete_template', {
      data: {
        source: source,
        template_id: templateId
      },
      success: function success(response) {
        var _options$onSuccess;
        self.addLastRemovedItems([templateId]);
        templatesCollection.remove(templateModel, {
          silent: true
        });
        (_options$onSuccess = options.onSuccess) === null || _options$onSuccess === void 0 || _options$onSuccess.call(options, response);
        elementor.templates.eventManager.sendPageViewEvent({
          location: elementor.editorEvents.config.secondaryLocations.templateLibrary.deleteFolderDialog
        });
        elementor.templates.eventManager.sendItemDeletedEvent({
          library_type: source,
          item_type: 'folder'
        });
        _this7.triggerQuotaUpdate();
      }
    });
  };

  /**
   * @param {*}      model - Template model.
   * @param {Object} args  - Template arguments.
   * @deprecated since 2.8.0, use `$e.run( 'library/insert-template' )` instead.
   */
  this.importTemplate = function (model) {
    var args = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    this.clearLastRemovedItems();
    elementorDevTools.deprecation.deprecated('importTemplate', '2.8.0', "$e.run( 'library/insert-template' )");
    args.model = model;
    $e.run('library/insert-template', args);
  };
  this.saveTemplate = function (type, data) {
    var _data$source;
    this.clearLastRemovedItems();
    var templateType = templateTypes[type];
    _.extend(data, {
      source: (_data$source = data.source) !== null && _data$source !== void 0 ? _data$source : 'local',
      type: type
    });
    if (templateType.prepareSavedData) {
      data = templateType.prepareSavedData(data);
    }
    data.content = JSON.stringify(data.content);
    var defaultAjaxParams = {
      data: data,
      success: function success(successData) {
        $e.route('library/templates/my-templates', {
          onBefore: function onBefore() {
            self.triggerQuotaUpdate();
            if (templatesCollection) {
              var itemExist = templatesCollection.findWhere({
                template_id: successData.template_id
              });
              if (!itemExist) {
                templatesCollection.add(successData);
              }
            }
            self.sendOnSavedTemplateSuccessEvent(data);
          }
        });
      },
      error: function error(errorData) {
        self.showErrorDialog(errorData);
        self.clearToastConfig();
        self.sendOnSavedTemplateFailedEvent(data);
      }
    };
    var ajaxParams = _.extend(defaultAjaxParams, templateType.ajaxParams);
    elementorCommon.ajax.addRequest(this.getSaveAjaxAction(data.save_context), ajaxParams);
  };
  this.sendOnSavedTemplateSuccessEvent = function (formData) {
    if (_constants.SAVE_CONTEXTS.SAVE === formData.save_context) {
      self.eventManager.sendTemplateSavedEvent({
        library_type: formData.source,
        template_type: formData.type
      });
    } else if ([_constants.SAVE_CONTEXTS.COPY, _constants.SAVE_CONTEXTS.MOVE].includes(formData.save_context)) {
      self.eventManager.sendTemplateTransferEvent({
        transfer_method: formData.save_context,
        template_type: formData.type,
        template_origin: formData.from_source,
        template_destination: formData.source
      });
    } else if ([_constants.SAVE_CONTEXTS.BULK_MOVE, _constants.SAVE_CONTEXTS.BULK_COPY].includes(formData.save_context)) {
      self.eventManager.sendBulkActionsSuccessEvent({
        bulk_action: _constants.SAVE_CONTEXTS.BULK_MOVE === formData.save_context ? 'move' : 'copy',
        library_type: formData.source,
        bulk_count: formData.from_template_id.length,
        template_origin: formData.from_source,
        template_destination: formData.source
      });
    }
  };
  this.sendOnSavedTemplateFailedEvent = function (formData) {
    if ([_constants.SAVE_CONTEXTS.BULK_MOVE, _constants.SAVE_CONTEXTS.BULK_COPY].includes(formData.save_context)) {
      self.eventManager.sendBulkActionsFailedEvent({
        bulk_action: _constants.SAVE_CONTEXTS.BULK_MOVE === formData.save_context ? 'move' : 'copy',
        library_type: formData.source,
        bulk_count: formData.from_template_id.length,
        template_origin: formData.from_source,
        template_destination: formData.source
      });
    }
  };
  this.getSaveAjaxAction = function (saveContext) {
    var _saveActions$saveCont;
    this.clearLastRemovedItems();
    var saveActions = (0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)({}, _constants.SAVE_CONTEXTS.SAVE, 'save_template'), _constants.SAVE_CONTEXTS.MOVE, 'move_template'), _constants.SAVE_CONTEXTS.COPY, 'copy_template'), _constants.SAVE_CONTEXTS.BULK_MOVE, 'bulk_move_templates'), _constants.SAVE_CONTEXTS.BULK_COPY, 'bulk_copy_templates');
    return (_saveActions$saveCont = saveActions[saveContext]) !== null && _saveActions$saveCont !== void 0 ? _saveActions$saveCont : 'save_template';
  };
  this.requestTemplateContent = function (source, id, ajaxOptions) {
    this.clearLastRemovedItems();
    var options = {
      unique_id: id,
      data: {
        source: source,
        edit_mode: true,
        display: true,
        template_id: id
      }
    };
    if (ajaxOptions) {
      jQuery.extend(true, options, ajaxOptions);
    }
    return elementorCommon.ajax.addRequest('get_template_data', options);
  };
  this.markAsFavorite = function (templateModel, favorite) {
    this.clearLastRemovedItems();
    var options = {
      data: {
        source: templateModel.get('source'),
        template_id: templateModel.get('template_id'),
        favorite: favorite
      }
    };
    return elementorCommon.ajax.addRequest('mark_template_as_favorite', options);
  };
  this.getDeleteDialog = function (templateModel) {
    if (!deleteDialog) {
      deleteDialog = elementorCommon.dialogsManager.createWidget('confirm', {
        id: 'elementor-template-library-delete-dialog',
        headerMessage: __('Delete this template?', 'elementor'),
        message: sprintf(
        // Translators: %1$s: Template name.
        __('This will permanently remove "%1$s".', 'elementor'), templateModel.get('title')),
        strings: {
          confirm: __('Delete', 'elementor')
        },
        onShow: function onShow() {
          elementor.templates.eventManager.sendPageViewEvent({
            location: elementor.editorEvents.config.secondaryLocations.templateLibrary.deleteDialog
          });
        }
      });
      deleteDialog.getElements('ok').addClass('e-danger color-white');
    }
    return deleteDialog;
  };
  this.getErrorDialog = function () {
    if (!errorDialog) {
      errorDialog = elementorCommon.dialogsManager.createWidget('alert', {
        id: 'elementor-template-library-error-dialog',
        headerMessage: __('An error occurred.', 'elementor')
      });
    }
    return errorDialog;
  };
  this.getTemplatesCollection = function () {
    return templatesCollection;
  };
  this.getConfig = function (item) {
    if (item) {
      return config[item] ? config[item] : {};
    }
    return config;
  };
  this.requestLibraryData = function (options) {
    if (templatesCollection && !options.forceUpdate) {
      if (options.onUpdate) {
        options.onUpdate();
      }
      return;
    }
    if (options.onBeforeUpdate) {
      options.onBeforeUpdate();
    }
    var ajaxOptions = {
      data: {},
      success: function success(data) {
        templatesCollection = new TemplateLibraryCollection(data.templates);
        if (data.config) {
          config = data.config;
        }
        if (options.onUpdate) {
          options.onUpdate();
        }
      }
    };
    if (options.forceSync) {
      ajaxOptions.data.sync = true;
    }
    elementorCommon.ajax.addRequest('get_library_data', ajaxOptions);
  };
  this.getFilter = function (name) {
    return elementor.channels.templates.request('filter:' + name);
  };
  this.setFilter = function (name, value, silent) {
    this.clearLastRemovedItems();
    elementor.channels.templates.reply('filter:' + name, value);
    if (!silent) {
      elementor.channels.templates.trigger('filter:change');
    }
  };
  this.getFilterTerms = function (termName) {
    if (termName) {
      return filterTerms[termName];
    }
    return filterTerms;
  };
  this.setScreen = function (args) {
    this.clearLastRemovedItems();
    elementor.channels.templates.stopReplying();
    self.setFilter('source', args.source, true);
    self.setFilter('type', args.type, true);
    self.setFilter('subtype', args.subtype, true);
    self.showTemplates();
  };
  this.loadTemplates = function (onUpdate) {
    this.clearLastRemovedItems();
    isLoading = true;
    total = 0;
    self.layout.showLoadingView();
    var query = {
        source: this.getFilter('source')
      },
      options = {};

    // TODO: Remove - it when all the data commands is ready, manage the cache!.
    if ('local' === query.source || 'cloud' === query.source) {
      options.refresh = true;
    }
    this.setFilter('parent', null, query);
    var loadTemplatesData = function loadTemplatesData() {
      return $e.data.get('library/templates', query, options).then(function (result) {
        var _result$data;
        var templates = 'cloud' === query.source ? result.data.templates.templates : result.data.templates;
        templatesCollection = new TemplateLibraryCollection(templates);
        if ((_result$data = result.data) !== null && _result$data !== void 0 && (_result$data = _result$data.templates) !== null && _result$data !== void 0 && _result$data.total) {
          var _result$data2;
          total = (_result$data2 = result.data) === null || _result$data2 === void 0 || (_result$data2 = _result$data2.templates) === null || _result$data2 === void 0 ? void 0 : _result$data2.total;
        }
        if (result.data.config) {
          config = result.data.config;
        }
        self.layout.hideLoadingView();
        if (onUpdate) {
          onUpdate();
        }
      }).finally(function () {
        isLoading = false;
      });
    };
    var handleCloudSource = function handleCloudSource() {
      var _elementorAppConfig$c;
      if ('undefined' === typeof ((_elementorAppConfig$c = elementorAppConfig['cloud-library']) === null || _elementorAppConfig$c === void 0 ? void 0 : _elementorAppConfig$c.quota)) {
        return $e.components.get('cloud-library').utils.getQuotaConfig(true).then(function () {
          if (self.shouldShowCloudStateView()) {
            self.layout.showCloudStateView();
            return;
          }
          return loadTemplatesData();
        }).catch(function () {
          self.layout.showCloudStateView();
          isLoading = false;
        });
      }
      if (self.shouldShowCloudStateView()) {
        self.layout.showCloudStateView();
        return;
      }
      return loadTemplatesData();
    };
    if ('cloud' === query.source) {
      handleCloudSource();
    } else {
      loadTemplatesData();
    }
  };
  this.searchTemplates = function (data) {
    _this3.clearLastRemovedItems();
    return new Promise(function (resolve) {
      _this3.setFilter('parent', null);
      isLoading = true;
      var ajaxOptions = {
        data: data,
        success: function success(result) {
          isLoading = false;
          templatesCollection = new TemplateLibraryCollection(result.templates);
          total = result.total;
          self.layout.updateViewCollection(templatesCollection.models);
          _this3.setFilter('text', data.search);
          resolve(result);
        },
        error: function error(_error4) {
          isLoading = false;
          _this3.showErrorDialog(_error4);
          resolve();
        }
      };
      elementorCommon.ajax.addRequest('search_templates', ajaxOptions);
    });
  };
  this.loadMore = function () {
    var _this3$getFilter;
    var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      onUpdate = _ref2.onUpdate,
      _ref2$search = _ref2.search,
      search = _ref2$search === void 0 ? '' : _ref2$search,
      _ref2$refresh = _ref2.refresh,
      refresh = _ref2$refresh === void 0 ? false : _ref2$refresh;
    isLoading = true;
    _this3.clearLastRemovedItems();
    var source = _this3.getFilter('source');
    var parentId = (_this3$getFilter = _this3.getFilter('parent')) === null || _this3$getFilter === void 0 ? void 0 : _this3$getFilter.id;
    var ajaxOptions = {
      data: {
        source: source,
        offset: refresh ? 0 : templatesCollection.length,
        search: search,
        parentId: parentId,
        orderby: elementor.templates.getFilter('orderby') || null,
        order: elementor.templates.getFilter('order') || null
      },
      success: function success(result) {
        var collection = new TemplateLibraryCollection(result.templates);
        if (refresh) {
          templatesCollection.reset(collection.models);
          self.layout.updateViewCollection(templatesCollection.models);
        } else {
          templatesCollection.add(collection.models, {
            merge: true
          });
          self.layout.addTemplates(collection.models);
        }
        if (onUpdate) {
          onUpdate();
        }
        isLoading = false;
      },
      error: function error() {
        isLoading = false;
      }
    };
    elementorCommon.ajax.addRequest('load_more_templates', ajaxOptions);
  };
  this.showTemplates = function () {
    // The tabs should exist in DOM on loading.
    self.layout.setHeaderDefaultParts();
    self.loadTemplates(function () {
      var templatesToShow = self.filterTemplates();
      self.layout.showTemplatesView(new TemplateLibraryCollection(templatesToShow));
      self.handleToast();
    });
  };
  this.handleToast = function () {
    var _toastConfig, _toastConfig2;
    if (!((_toastConfig = toastConfig) !== null && _toastConfig !== void 0 && _toastConfig.show)) {
      return;
    }
    elementor.notifications.showToast((_toastConfig2 = toastConfig) === null || _toastConfig2 === void 0 ? void 0 : _toastConfig2.options);
    this.clearToastConfig();
  };
  this.setToastConfig = function (newConfig) {
    toastConfig = newConfig;
  };
  this.clearToastConfig = function () {
    this.setToastConfig({
      show: false,
      options: {}
    });
  };
  this.filterTemplates = function () {
    var activeSource = self.getFilter('source');
    return templatesCollection.filter(function (model) {
      if (activeSource !== model.get('source')) {
        return false;
      }
      var typeInfo = templateTypes[model.get('type')];
      return !typeInfo || false !== typeInfo.showInLibrary;
    });
  };
  this.showErrorDialog = function (errorMessage) {
    if ('object' === (0, _typeof2.default)(errorMessage)) {
      var message = '';
      _.each(errorMessage, function (error) {
        if (!(error !== null && error !== void 0 && error.message)) {
          return;
        }
        message += '<div>' + error.message + '.</div>';
      });
      errorMessage = message;
    } else if (errorMessage) {
      errorMessage += '.';
    }
    if (errorMessage) {
      errorMessage = __('The following error(s) occurred while processing the request:', 'elementor') + '<div id="elementor-template-library-error-info">' + errorMessage + '</div>';
    } else {
      errorMessage = __('Please try again.', 'elementor');
    }
    self.getErrorDialog().setMessage(errorMessage).show();
  };
  this.onSelectSourceFilterChange = function (event) {
    var _event$currentTarget$, _event$currentTarget;
    var templatesSource = (_event$currentTarget$ = event === null || event === void 0 || (_event$currentTarget = event.currentTarget) === null || _event$currentTarget === void 0 || (_event$currentTarget = _event$currentTarget.dataset) === null || _event$currentTarget === void 0 ? void 0 : _event$currentTarget.source) !== null && _event$currentTarget$ !== void 0 ? _event$currentTarget$ : 'local',
      alreadyActive = templatesSource === self.getFilter('source');
    if (alreadyActive) {
      return;
    }
    self.setSourceSelection(templatesSource);
    self.setFilter('source', templatesSource, true);
    self.clearBulkSelectionItems();
    self.loadTemplates(function () {
      var templatesToShow = self.filterTemplates();
      self.layout.showTemplatesView(new TemplateLibraryCollection(templatesToShow));
    });
  };
  this.onSelectViewChange = function (selectedView) {
    self.setViewSelection(selectedView);
    self.setFilter(viewKey, selectedView, true);
    self.layout.updateViewCollection(self.filterTemplates());
    self.resetBulkActionBar();
  };
  this.resetBulkActionBar = function () {
    _this3.clearBulkSelectionItems();
    _this3.layout.handleBulkActionBarUi();
  };
  this.shouldShowCloudStateView = function () {
    if (!elementor.config.library_connect.is_connected) {
      return true;
    }
    return !this.hasCloudLibraryQuota() || this.cloudLibraryIsDeactivated();
  };
  this.cloudLibraryIsDeactivated = function () {
    var _elementorAppConfig$c2;
    var quota = (_elementorAppConfig$c2 = elementorAppConfig['cloud-library']) === null || _elementorAppConfig$c2 === void 0 ? void 0 : _elementorAppConfig$c2.quota;
    if (!quota) {
      return false;
    }
    var _quota$currentUsage = quota.currentUsage,
      currentUsage = _quota$currentUsage === void 0 ? 0 : _quota$currentUsage,
      _quota$threshold = quota.threshold,
      threshold = _quota$threshold === void 0 ? 0 : _quota$threshold,
      _quota$subscriptionId = quota.subscriptionId,
      subscriptionId = _quota$subscriptionId === void 0 ? '' : _quota$subscriptionId;
    var isOverThreshold = currentUsage > threshold;
    var hasSubscription = '' !== subscriptionId;
    return isOverThreshold && !hasSubscription;
  };
  this.hasCloudLibraryQuota = function () {
    var _elementorAppConfig$c3, _elementorAppConfig$c4;
    return 'undefined' !== typeof ((_elementorAppConfig$c3 = elementorAppConfig['cloud-library']) === null || _elementorAppConfig$c3 === void 0 ? void 0 : _elementorAppConfig$c3.quota) && 0 < ((_elementorAppConfig$c4 = elementorAppConfig['cloud-library'].quota) === null || _elementorAppConfig$c4 === void 0 ? void 0 : _elementorAppConfig$c4.threshold);
  };
  this.addBulkSelectionItem = function (templateId) {
    bulkSelectedItems.add(parseInt(templateId));
  };
  this.removeBulkSelectionItem = function (templateId) {
    bulkSelectedItems.delete(parseInt(templateId));
  };
  this.clearBulkSelectionItems = function () {
    bulkSelectedItems.clear();
  };
  this.getBulkSelectionItems = function () {
    return bulkSelectedItems;
  };
  this.onBulkDeleteClick = function () {
    var _this8 = this;
    this.clearLastRemovedItems();
    return new Promise(function (resolve) {
      var selectedItems = _this8.getBulkSelectionItems();
      if (!selectedItems.size) {
        return;
      }
      var dialog = _this8.getBulkDeleteDialog();
      var source = _this8.getFilter('source');
      var templateIds = Array.from(selectedItems);
      dialog.onConfirm = function () {
        isLoading = true;
        var ajaxOptions = {
          data: {
            source: source,
            template_ids: templateIds
          },
          success: function success() {
            isLoading = false;
            var modelsToRemove = templatesCollection.models.filter(function (templateModel) {
              return selectedItems.has(templateModel.get('template_id'));
            });
            if ('cloud' === source) {
              self.addLastRemovedItems(templateIds);
            }
            templatesCollection.remove(modelsToRemove);
            self.layout.updateViewCollection(self.filterTemplates());
            self.clearBulkSelectionItems();
            self.eventManager.sendBulkActionsSuccessEvent({
              library_type: source,
              bulk_action: 'delete',
              bulk_count: templateIds.length
            });
            var buttons = 'cloud' === source ? [{
              name: 'undo_bulk_delete',
              text: __('Undo', 'elementor'),
              callback: function callback() {
                _this8.onUndoDelete(isBulk);
              }
            }] : null;
            elementor.notifications.showToast({
              message: "".concat(templateIds.length, " items deleted successfully"),
              buttons: buttons
            });
            _this8.triggerQuotaUpdate();
            resolve();
          },
          error: function error(_error5) {
            isLoading = false;
            _this8.showErrorDialog(_error5);
            self.eventManager.sendBulkActionsFailedEvent({
              library_type: source,
              bulk_action: 'delete',
              bulk_count: templateIds.length
            });
            resolve();
          }
        };
        elementorCommon.ajax.addRequest('bulk_delete_templates', ajaxOptions);
      };
      dialog.onCancel = function () {
        resolve();
      };
      dialog.show();
    });
  };
  this.onUndoDelete = function (isBulk) {
    var _this9 = this;
    return new Promise(function (resolve) {
      isLoading = true;
      if (!lastDeletedItems.size) {
        return resolve();
      }
      var source = _this9.getFilter('source');
      var templateIds = Array.from(lastDeletedItems);
      var ajaxOptions = {
        data: {
          source: source,
          template_ids: templateIds
        },
        success: function success() {
          isLoading = false;
          $e.routes.refreshContainer('library');
          _this9.clearLastRemovedItems();
          _this9.triggerQuotaUpdate();
          resolve();
        },
        error: function error(_error6) {
          isLoading = false;
          _this9.clearLastRemovedItems();
          _this9.showErrorDialog(_error6);
          resolve();
        }
      };
      elementorCommon.ajax.addRequest('bulk_undo_delete_items', ajaxOptions);
      self.eventManager.sendDeletionUndoEvent({
        is_bulk: isBulk
      });
    });
  };
  this.triggerQuotaUpdate = function () {
    var force = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
    elementor.channels.templates.trigger('quota:update', {
      force: force
    });
  };
};
module.exports = new TemplateLibraryManager();

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/models/template.js":
/*!******************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/models/template.js ***!
  \******************************************************************************/
/***/ ((module) => {

"use strict";


module.exports = Backbone.Model.extend({
  defaults: {
    template_id: 0,
    title: '',
    source: '',
    type: '',
    subtype: '',
    author: '',
    thumbnail: '',
    url: '',
    export_link: '',
    status: null,
    preview_url: null,
    generate_preview_url: null,
    tags: []
  },
  isLocked: function isLocked() {
    return 'locked' === this.get('status');
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/library-layout.js":
/*!***********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/library-layout.js ***!
  \***********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _constants = __webpack_require__(/*! ./../constants */ "../assets/dev/js/editor/components/template-library/constants.js");
var TemplateLibraryHeaderActionsView = __webpack_require__(/*! elementor-templates/views/parts/header-parts/actions */ "../assets/dev/js/editor/components/template-library/views/parts/header-parts/actions.js"),
  TemplateLibraryHeaderMenuView = __webpack_require__(/*! elementor-templates/views/parts/header-parts/menu */ "../assets/dev/js/editor/components/template-library/views/parts/header-parts/menu.js"),
  TemplateLibraryHeaderPreviewView = __webpack_require__(/*! elementor-templates/views/parts/header-parts/preview */ "../assets/dev/js/editor/components/template-library/views/parts/header-parts/preview.js"),
  TemplateLibraryHeaderBackView = __webpack_require__(/*! elementor-templates/views/parts/header-parts/back */ "../assets/dev/js/editor/components/template-library/views/parts/header-parts/back.js"),
  TemplateLibraryCollectionView = __webpack_require__(/*! elementor-templates/views/parts/templates */ "../assets/dev/js/editor/components/template-library/views/parts/templates.js"),
  TemplateLibrarySaveTemplateView = __webpack_require__(/*! elementor-templates/views/parts/save-template */ "../assets/dev/js/editor/components/template-library/views/parts/save-template.js"),
  TemplateLibraryImportView = __webpack_require__(/*! elementor-templates/views/parts/import */ "../assets/dev/js/editor/components/template-library/views/parts/import.js"),
  TemplateLibraryConnectView = __webpack_require__(/*! elementor-templates/views/parts/connect */ "../assets/dev/js/editor/components/template-library/views/parts/connect.js"),
  TemplateLibraryCloudStateView = __webpack_require__(/*! elementor-templates/views/parts/cloud-states */ "../assets/dev/js/editor/components/template-library/views/parts/cloud-states.js"),
  TemplateLibraryPreviewView = __webpack_require__(/*! elementor-templates/views/parts/preview */ "../assets/dev/js/editor/components/template-library/views/parts/preview.js"),
  TemplateLibraryNavigationContainerView = __webpack_require__(/*! elementor-templates/views/parts/navigation-container */ "../assets/dev/js/editor/components/template-library/views/parts/navigation-container.js");
module.exports = elementorModules.common.views.modal.Layout.extend({
  getModalOptions: function getModalOptions() {
    var _window$elementor$con, _window;
    var allowClosingModal = (_window$elementor$con = (_window = window) === null || _window === void 0 || (_window = _window.elementor) === null || _window === void 0 || (_window = _window.config) === null || _window === void 0 || (_window = _window.document) === null || _window === void 0 || (_window = _window.panel) === null || _window === void 0 ? void 0 : _window.allow_closing_remote_library) !== null && _window$elementor$con !== void 0 ? _window$elementor$con : true;
    return {
      id: 'elementor-template-library-modal',
      hide: {
        onOutsideClick: allowClosingModal,
        onBackgroundClick: allowClosingModal,
        onEscKeyPress: allowClosingModal,
        ignore: '.dialog-widget-content, .dialog-buttons-undo_bulk_delete, .dialog-buttons-template_after_save, #elementor-library--infotip__dialog, #elementor-template-library-rename-dialog, #elementor-template-library-delete-dialog'
      }
    };
  },
  getLogoOptions: function getLogoOptions() {
    return {
      title: __('Library', 'elementor'),
      click: function click() {
        $e.run('library/open', {
          toDefault: true
        });
      }
    };
  },
  getTemplateActionButton: function getTemplateActionButton(templateData) {
    var subscriptionPlans = elementor.config.library_connect.subscription_plans,
      baseAccessTier = elementor.config.library_connect.base_access_tier,
      templateAccessTier = templateData.accessTier,
      shouldUpgrade = baseAccessTier !== templateAccessTier;
    var viewId = '#tmpl-elementor-template-library-' + (shouldUpgrade ? 'upgrade-plan-button' : 'insert-button');
    viewId = elementor.hooks.applyFilters('elementor/editor/template-library/template/action-button', viewId, templateData);
    var template = Marionette.TemplateCache.get(viewId);
    var subscriptionPlan = subscriptionPlans[templateAccessTier];
    var promotionText = elementorAppConfig.hasPro ? 'Upgrade' : "Go ".concat(subscriptionPlan.label);
    try {
      var promotionUrlPieces = new URL(subscriptionPlan.promotion_url);
      var queryString = promotionUrlPieces.searchParams.toString();
      var promotionLinkQueryString = elementor.hooks.applyFilters('elementor/editor/template-library/template/promotion-link-search-params', queryString, templateData);
      return Marionette.Renderer.render(template, {
        promotionText: promotionText,
        promotionLink: "".concat(promotionUrlPieces.origin).concat(promotionUrlPieces.pathname, "?").concat(promotionLinkQueryString)
      });
    } catch (e) {
      return Marionette.Renderer.render(template, {
        promotionText: promotionText,
        promotionLink: subscriptionPlan.promotion_url
      });
    }
  },
  setHeaderDefaultParts: function setHeaderDefaultParts() {
    var headerView = this.getHeaderView();
    headerView.tools.show(new TemplateLibraryHeaderActionsView());
    headerView.menuArea.show(new TemplateLibraryHeaderMenuView());
    this.showLogo();
  },
  showTemplatesView: function showTemplatesView(templatesCollection) {
    this.modalContent.show(new TemplateLibraryCollectionView({
      collection: templatesCollection
    }));
  },
  updateViewCollection: function updateViewCollection(models) {
    var _TemplateLibraryNavig;
    this.modalContent.currentView.collection.reset(models);
    this.modalContent.currentView.ui.navigationContainer.html((_TemplateLibraryNavig = new TemplateLibraryNavigationContainerView().render()) === null || _TemplateLibraryNavig === void 0 ? void 0 : _TemplateLibraryNavig.el);
  },
  addTemplates: function addTemplates(models) {
    this.modalContent.currentView.collection.add(models, {
      merge: true
    });
  },
  showImportView: function showImportView() {
    var headerView = this.getHeaderView();
    headerView.menuArea.reset();
    this.modalContent.show(new TemplateLibraryImportView());
    headerView.logoArea.show(new TemplateLibraryHeaderBackView());
  },
  showConnectView: function showConnectView(args) {
    this.getHeaderView().menuArea.reset();
    this.modalContent.show(new TemplateLibraryConnectView(args));
  },
  showCloudStateView: function showCloudStateView() {
    elementor.templates.layout.hideLoadingView();
    this.modalContent.show(new TemplateLibraryCloudStateView());
  },
  showSaveTemplateView: function showSaveTemplateView(elementModel) {
    var context = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _constants.SAVE_CONTEXTS.SAVE;
    var headerView = this.getHeaderView();
    headerView.menuArea.reset();
    if (_constants.SAVE_CONTEXTS.SAVE !== context) {
      headerView.logoArea.show(new TemplateLibraryHeaderBackView());
    }
    this.modalContent.show(new TemplateLibrarySaveTemplateView({
      model: elementModel,
      context: context
    }));
  },
  showPreviewView: function showPreviewView(templateModel) {
    this.modalContent.show(new TemplateLibraryPreviewView({
      url: templateModel.get('url')
    }));
    var headerView = this.getHeaderView();
    headerView.menuArea.reset();
    headerView.tools.show(new TemplateLibraryHeaderPreviewView({
      model: templateModel
    }));
    headerView.logoArea.show(new TemplateLibraryHeaderBackView());
  },
  showFolderView: function showFolderView(elementModel) {
    return (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
      return _regenerator.default.wrap(function (_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            _context.prev = 0;
            elementor.templates.layout.showLoadingView();
            _context.next = 1;
            return elementor.templates.getFolderTemplates(elementModel);
          case 1:
            _context.prev = 1;
            elementor.templates.layout.hideLoadingView();
            return _context.finish(1);
          case 2:
          case "end":
            return _context.stop();
        }
      }, _callee, null, [[0,, 1, 2]]);
    }))();
  },
  createScreenshotIframe: function createScreenshotIframe(previewUrl) {
    var iframe = document.createElement('iframe');
    iframe.src = previewUrl;
    iframe.width = '1200';
    iframe.height = '500';
    iframe.style = 'visibility: hidden;';
    document.body.appendChild(iframe);
    return iframe;
  },
  handleBulkActionBarUi: function handleBulkActionBarUi() {
    if (0 === this.modalContent.currentView.$('.bulk-selection-item-checkbox:checked').length) {
      this.modalContent.currentView.$el.addClass('no-bulk-selections');
      this.modalContent.currentView.$el.removeClass('has-bulk-selections');
    } else {
      this.modalContent.currentView.$el.addClass('has-bulk-selections');
      this.modalContent.currentView.$el.removeClass('no-bulk-selections');
    }
    this.handleBulkActionBar();
  },
  handleBulkActionBar: function handleBulkActionBar() {
    var _elementor$templates$;
    var selectedCount = (_elementor$templates$ = elementor.templates.getBulkSelectionItems().size) !== null && _elementor$templates$ !== void 0 ? _elementor$templates$ : 0;
    var display = 0 === selectedCount ? 'none' : 'flex';
    this.modalContent.currentView.ui.bulkSelectedCount.html("".concat(selectedCount, " Selected"));
    this.modalContent.currentView.ui.bulkSelectionActionBar.css('display', display);

    // TODO: Temporary fix until the bulk action bar will be as separate view.
    var displayNavigationContainer = 0 === selectedCount ? 'flex' : 'none';
    this.modalContent.currentView.ui.navigationContainer.css('display', displayNavigationContainer);
  },
  selectAllCheckboxMinus: function selectAllCheckboxMinus() {
    if (this.isListView()) {
      this.modalContent.currentView.ui.bulkSelectAllCheckbox.addClass('checkbox-minus');
    }
  },
  selectAllCheckboxNormal: function selectAllCheckboxNormal() {
    if (this.isListView()) {
      this.modalContent.currentView.ui.bulkSelectAllCheckbox.removeClass('checkbox-minus');
    }
  },
  isListView: function isListView() {
    return 'list' === elementor.templates.getViewSelection();
  },
  resetSortingUI: function resetSortingUI() {
    var _this$modalContent$cu;
    Array.from(((_this$modalContent$cu = this.modalContent.currentView.ui) === null || _this$modalContent$cu === void 0 ? void 0 : _this$modalContent$cu.orderInputs) || []).forEach(function (input) {
      input.checked = false;
    });
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/parts/cloud-states.js":
/*!***************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/parts/cloud-states.js ***!
  \***************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


module.exports = Marionette.ItemView.extend({
  template: '#tmpl-elementor-template-library-connect-states',
  id: 'elementor-template-library-connect-states',
  ui: {
    connect: '#elementor-template-library-connect__button',
    selectSourceFilter: '.elementor-template-library-filter-select-source .source-option',
    title: '.elementor-template-library-blank-title',
    message: '.elementor-template-library-blank-message',
    icon: '.elementor-template-library-blank-icon',
    button: '.elementor-template-library-cloud-empty__button'
  },
  events: {
    'click @ui.selectSourceFilter': 'onSelectSourceFilterChange',
    'click @ui.button': 'onButtonClick'
  },
  modesStrings: function modesStrings() {
    var _elementorAppConfig$c, _elementorAppConfig, _elementorAppConfig$c2, _elementorAppConfig2, _elementorAppConfig3, _elementorAppConfig$c3, _elementorAppConfig4;
    var defaultIcon = this.getDefaultIcon();
    return {
      notConnected: {
        title: (_elementorAppConfig$c = (_elementorAppConfig = elementorAppConfig) === null || _elementorAppConfig === void 0 || (_elementorAppConfig = _elementorAppConfig['cloud-library']) === null || _elementorAppConfig === void 0 ? void 0 : _elementorAppConfig.library_connect_title_copy) !== null && _elementorAppConfig$c !== void 0 ? _elementorAppConfig$c : __('Connect to your Elementor account', 'elementor'),
        message: (_elementorAppConfig$c2 = (_elementorAppConfig2 = elementorAppConfig) === null || _elementorAppConfig2 === void 0 || (_elementorAppConfig2 = _elementorAppConfig2['cloud-library']) === null || _elementorAppConfig2 === void 0 ? void 0 : _elementorAppConfig2.library_connect_sub_title_copy) !== null && _elementorAppConfig$c2 !== void 0 ? _elementorAppConfig$c2 : __('Then you can find all your templates in one convenient library.', 'elementor'),
        icon: defaultIcon,
        button: "<a class=\"elementor-button e-primary\" href=\"".concat((_elementorAppConfig3 = elementorAppConfig) === null || _elementorAppConfig3 === void 0 || (_elementorAppConfig3 = _elementorAppConfig3['cloud-library']) === null || _elementorAppConfig3 === void 0 ? void 0 : _elementorAppConfig3.library_connect_url, "\" target=\"_blank\">").concat((_elementorAppConfig$c3 = (_elementorAppConfig4 = elementorAppConfig) === null || _elementorAppConfig4 === void 0 || (_elementorAppConfig4 = _elementorAppConfig4['cloud-library']) === null || _elementorAppConfig4 === void 0 ? void 0 : _elementorAppConfig4.library_connect_button_copy) !== null && _elementorAppConfig$c3 !== void 0 ? _elementorAppConfig$c3 : __('Connect', 'elementor'), "</a>")
      },
      connectedNoQuota: {
        title: __('It’s time to level up', 'elementor'),
        message: __('Elementor Pro plans come with Cloud Templates.', 'elementor') + '<br>' + __('Upgrade now to re-use your templates on all the websites you’re working on.', 'elementor'),
        icon: "<i class=\"eicon-library-subscription-upgrade\" aria-hidden=\"true\" title=\"".concat(__('Upgrade now', 'elememntor'), "\"></i>"),
        button: "<a class=\"elementor-button e-accent\" href=\"https://go.elementor.com/go-pro-cloud-templates-cloud-tab\" target=\"_blank\">".concat(__('Upgrade now', 'elementor'), "</a>")
      },
      deactivated: {
        title: __('Your library has been deactivated', 'elementor'),
        message: __('This is because you don’t have an active subscription.', 'elementor') + '<br>' + __('Your templates are saved for 90 days from the day your subscription expires,', 'elementor') + '<br>' + __('then they’ll be gone forever.', 'elementor'),
        icon: "<i class=\"eicon-library-subscription-upgrade\" aria-hidden=\"true\" title=\"".concat(__('Renew my subscription', 'elememntor'), "\"></i>"),
        button: "<a class=\"elementor-button e-accent\" href=\"https://go.elementor.com/renew-license-cloud-templates-cloud-tab\" target=\"_blank\">".concat(__('Renew my subscription', 'elementor'), "</a>")
      }
    };
  },
  getDefaultIcon: function getDefaultIcon() {
    return "<i class=\"eicon-library-cloud-connect\" aria-hidden=\"true\" title=\"".concat(__('Empty folder', 'elememntor'), "\"></i>");
  },
  getCurrentMode: function getCurrentMode() {
    if (!elementor.config.library_connect.is_connected) {
      return 'notConnected';
    }
    if (elementor.templates.cloudLibraryIsDeactivated()) {
      return 'deactivated';
    }
    return 'connectedNoQuota';
  },
  onRender: function onRender() {
    var _elementor$templates$;
    this.updateTemplateMarkup();
    this.handleElementorConnect();
    (_elementor$templates$ = elementor.templates.layout.getHeaderView()) === null || _elementor$templates$ === void 0 || (_elementor$templates$ = _elementor$templates$.tools) === null || _elementor$templates$ === void 0 || (_elementor$templates$ = _elementor$templates$.$el[0]) === null || _elementor$templates$ === void 0 || (_elementor$templates$ = _elementor$templates$.classList) === null || _elementor$templates$ === void 0 || _elementor$templates$.add('e-hidden-disabled');
    elementor.templates.eventManager.sendPageViewEvent({
      location: elementor.editorEvents.config.secondaryLocations.templateLibrary.cloudTabUpgrade
    });
  },
  updateTemplateMarkup: function updateTemplateMarkup() {
    var modeStrings = this.modesStrings()[this.getCurrentMode()];
    this.ui.title.html(modeStrings.title);
    this.ui.message.html(modeStrings.message);
    this.ui.button.html(modeStrings.button);
    this.ui.icon.html(modeStrings.icon);
  },
  handleElementorConnect: function handleElementorConnect() {
    this.ui.connect.elementorConnect({
      success: function success() {
        elementor.config.library_connect.is_connected = true;
        $e.run('library/close');
        elementor.notifications.showToast({
          message: __('Connected successfully.', 'elementor')
        });
      },
      error: function error() {
        elementor.config.library_connect.is_connected = false;
      }
    });
  },
  onSelectSourceFilterChange: function onSelectSourceFilterChange(event) {
    elementor.templates.onSelectSourceFilterChange(event);
  },
  onButtonClick: function onButtonClick() {
    elementor.templates.eventManager.sendUpgradeClickedEvent({
      secondaryLocation: elementor.editorEvents.config.secondaryLocations.templateLibrary.cloudTab,
      upgradePosition: elementor.editorEvents.config.secondaryLocations.templateLibrary.cloudTab
    });
  },
  onDestroy: function onDestroy() {
    var _elementor$templates$2;
    (_elementor$templates$2 = elementor.templates.layout.getHeaderView()) === null || _elementor$templates$2 === void 0 || (_elementor$templates$2 = _elementor$templates$2.tools) === null || _elementor$templates$2 === void 0 || (_elementor$templates$2 = _elementor$templates$2.$el[0]) === null || _elementor$templates$2 === void 0 || (_elementor$templates$2 = _elementor$templates$2.classList) === null || _elementor$templates$2 === void 0 || _elementor$templates$2.remove('e-hidden-disabled');
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/parts/connect.js":
/*!**********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/parts/connect.js ***!
  \**********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


module.exports = Marionette.ItemView.extend({
  template: '#tmpl-elementor-template-library-connect',
  id: 'elementor-template-library-connect',
  ui: {
    connect: '#elementor-template-library-connect__button',
    thumbnails: '#elementor-template-library-connect-thumbnails'
  },
  templateHelpers: function templateHelpers() {
    return this.getOption('texts');
  },
  onRender: function onRender() {
    var _this = this;
    elementor.templates.eventManager.sendPageViewEvent({
      location: elementor.editorEvents.config.secondaryLocations.templateLibrary.cloudTabConnect
    });
    this.ui.connect.elementorConnect({
      parseUrl: function parseUrl(url) {
        return url.replace('%%template_type%%', _this.model.get('type'));
      },
      success: function success() {
        elementor.config.library_connect.is_connected = true;

        // If is connecting during insert template.
        if (_this.getOption('model')) {
          $e.run('library/insert-template', {
            model: _this.getOption('model')
          });
        } else {
          $e.run('library/close');
          elementor.notifications.showToast({
            message: __('Connected successfully.', 'elementor')
          });
        }
      },
      error: function error() {
        elementor.config.library_connect.is_connected = false;
      }
    });
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/parts/folders/folder-empty.js":
/*!***********************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/parts/folders/folder-empty.js ***!
  \***********************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var sprintf = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["sprintf"];
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


module.exports = Marionette.ItemView.extend({
  tagName: 'li',
  className: 'no-results',
  template: _.template(sprintf(/* Translators: 1: Empty message, 2: CTA. */
  '<i class="eicon-folder-plus" aria-hidden="true"></i><br><p>%1$s<br>%2$s</p>', __('Folders you create will appear here.', 'elementor'), __('To create a new one, go to Cloud Templates.', 'elementor')))
});

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/parts/folders/folder-item.js":
/*!**********************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/parts/folders/folder-item.js ***!
  \**********************************************************************************************/
/***/ ((module) => {

"use strict";


module.exports = Marionette.ItemView.extend({
  tagName: 'li',
  template: _.template('<i class="eicon-folder-o" aria-hidden="true"></i><%= title %>'),
  className: 'folder-item',
  attributes: function attributes() {
    var data = this.model.toJSON();
    return {
      'data-id': data.template_id,
      'data-value': data.title
    };
  },
  render: function render() {
    this.$el.html(this.template(this.model.toJSON()));
    return this;
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/parts/folders/folders-list.js":
/*!***********************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/parts/folders/folders-list.js ***!
  \***********************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var EmptyView = __webpack_require__(/*! ./folder-empty */ "../assets/dev/js/editor/components/template-library/views/parts/folders/folder-empty.js");
var FolderItemView = __webpack_require__(/*! ./folder-item */ "../assets/dev/js/editor/components/template-library/views/parts/folders/folder-item.js");
module.exports = Marionette.CollectionView.extend({
  tagName: 'ul',
  className: 'folder-list',
  childView: FolderItemView,
  emptyView: EmptyView
});

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/parts/header-parts/actions.js":
/*!***********************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/parts/header-parts/actions.js ***!
  \***********************************************************************************************/
/***/ ((module) => {

"use strict";


module.exports = Marionette.ItemView.extend({
  template: '#tmpl-elementor-template-library-header-actions',
  id: 'elementor-template-library-header-actions',
  ui: {
    import: '#elementor-template-library-header-import i',
    sync: '#elementor-template-library-header-sync i',
    save: '#elementor-template-library-header-save i'
  },
  events: {
    'click @ui.import': 'onImportClick',
    'click @ui.sync': 'onSyncClick',
    'click @ui.save': 'onSaveClick'
  },
  onImportClick: function onImportClick() {
    $e.route('library/import');
  },
  onRender: function onRender() {
    var _$e$components$get$cu;
    var currentTab = (_$e$components$get$cu = $e.components.get('library').currentTab) !== null && _$e$components$get$cu !== void 0 ? _$e$components$get$cu : '';
    this.ui.import.toggleClass('elementor-hidden', 'templates/my-templates' !== currentTab);
  },
  onSyncClick: function onSyncClick() {
    var self = this;
    self.ui.sync.addClass('eicon-animation-spin');
    elementor.templates.requestLibraryData({
      onUpdate: function onUpdate() {
        self.ui.sync.removeClass('eicon-animation-spin');
        $e.routes.refreshContainer('library');
      },
      forceUpdate: true,
      forceSync: true
    });
  },
  onSaveClick: function onSaveClick() {
    $e.route('library/save-template');
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/parts/header-parts/back.js":
/*!********************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/parts/header-parts/back.js ***!
  \********************************************************************************************/
/***/ ((module) => {

"use strict";


module.exports = Marionette.ItemView.extend({
  template: '#tmpl-elementor-template-library-header-back',
  id: 'elementor-template-library-header-preview-back',
  events: {
    click: 'onClick'
  },
  onClick: function onClick() {
    $e.routes.restoreState('library');
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/parts/header-parts/menu.js":
/*!********************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/parts/header-parts/menu.js ***!
  \********************************************************************************************/
/***/ ((module) => {

"use strict";


module.exports = Marionette.ItemView.extend({
  template: '#tmpl-elementor-template-library-header-menu',
  id: 'elementor-template-library-header-menu',
  templateHelpers: function templateHelpers() {
    return {
      tabs: $e.components.get('library').getTabs()
    };
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/parts/header-parts/preview.js":
/*!***********************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/parts/header-parts/preview.js ***!
  \***********************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var TemplateLibraryInsertTemplateBehavior = __webpack_require__(/*! elementor-templates/behaviors/insert-template */ "../assets/dev/js/editor/components/template-library/behaviors/insert-template.js");
module.exports = Marionette.ItemView.extend({
  template: '#tmpl-elementor-template-library-header-preview',
  id: 'elementor-template-library-header-preview',
  behaviors: {
    insertTemplate: {
      behaviorClass: TemplateLibraryInsertTemplateBehavior
    }
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/parts/import.js":
/*!*********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/parts/import.js ***!
  \*********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var sprintf = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["sprintf"];
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _filesUploadHandler = _interopRequireDefault(__webpack_require__(/*! ../../../../utils/files-upload-handler */ "../assets/dev/js/editor/utils/files-upload-handler.js"));
var _jsonUploadWarningMessage = __webpack_require__(/*! elementor-utils/json-upload-warning-message */ "../assets/dev/js/utils/json-upload-warning-message.js");
var TemplateLibraryImportView;
TemplateLibraryImportView = Marionette.ItemView.extend({
  template: '#tmpl-elementor-template-library-import',
  id: 'elementor-template-library-import',
  ui: {
    uploadForm: '#elementor-template-library-import-form',
    fileInput: '#elementor-template-library-import-form-input',
    icon: '.elementor-template-library-blank-icon i'
  },
  events: {
    'change @ui.fileInput': 'onFileInputChange'
  },
  droppedFiles: null,
  submitForm: function submitForm() {
    var _this = this;
    var file;
    if (this.droppedFiles) {
      file = this.droppedFiles[0];
      this.droppedFiles = null;
    } else {
      file = this.ui.fileInput[0].files[0];
      this.ui.uploadForm[0].reset();
    }
    var fileReader = new FileReader();
    fileReader.onload = function (event) {
      return _this.importTemplate(file.name, event.target.result.replace(/^[^,]+,/, ''));
    };
    fileReader.readAsDataURL(file);
  },
  importTemplate: function importTemplate(fileName, fileData) {
    var _this2 = this;
    return (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
      var layout, activeSource, enableUnfilteredFilesModal;
      return _regenerator.default.wrap(function (_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            layout = elementor.templates.layout;
            activeSource = elementor.templates.getFilter('source');
            _this2.options = {
              data: {
                fileName: fileName,
                fileData: fileData,
                source: activeSource
              },
              success: function success(successData) {
                elementor.templates.clearLastRemovedItems();
                elementor.templates.getTemplatesCollection().add(successData);
                elementor.templates.setToastConfig({
                  show: true,
                  options: {
                    /* Translators: 1: Number of templates */
                    message: sprintf(__('You successfully imported %1$d template(s).', 'elementor'), successData.length),
                    position: {
                      my: 'right bottom',
                      at: 'right-10 bottom-10',
                      of: '#elementor-template-library-modal .dialog-lightbox-widget-content'
                    }
                  }
                });
                $e.route('library/templates/my-templates');
                elementor.templates.triggerQuotaUpdate();
                elementor.templates.eventManager.sendTemplateImportEvent({
                  library_type: activeSource,
                  file_type: fileName.split('.').pop(),
                  template_count: successData.length
                });
              },
              error: function error(errorData) {
                elementor.templates.showErrorDialog(errorData);
                layout.showImportView();
              },
              complete: function complete() {
                layout.hideLoadingView();
              }
            };
            _context.next = 1;
            return (0, _jsonUploadWarningMessage.showJsonUploadWarningMessageIfNeeded)({
              introductionMap: window.elementor.config.user.introduction,
              IntroductionClass: window.elementorModules.editor.utils.Introduction
            });
          case 1:
            if (!elementorCommon.config.filesUpload.unfilteredFiles) {
              enableUnfilteredFilesModal = _filesUploadHandler.default.getUnfilteredFilesNotEnabledImportTemplateDialog(function () {
                return _this2.sendImportRequest();
              });
              enableUnfilteredFilesModal.show();
            } else {
              _this2.sendImportRequest();
            }
          case 2:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }))();
  },
  sendImportRequest: function sendImportRequest() {
    elementorCommon.ajax.addRequest('import_template', this.options);
    elementor.templates.layout.showLoadingView();
  },
  onRender: function onRender() {
    this.ui.uploadForm.on({
      'drag dragstart dragend dragover dragenter dragleave drop': this.onFormActions.bind(this),
      dragenter: this.onFormDragEnter.bind(this),
      'dragleave drop': this.onFormDragLeave.bind(this),
      drop: this.onFormDrop.bind(this)
    });
    this.resolveIcon();
    elementor.templates.eventManager.sendPageViewEvent({
      location: elementor.editorEvents.config.secondaryLocations.templateLibrary.importModal
    });
  },
  resolveIcon: function resolveIcon() {
    var activeSource = elementor.templates.getFilter('source') || 'local';
    var className = 'local' === activeSource ? 'eicon-library-upload' : 'eicon-library-import';
    this.ui.icon.removeClass().addClass(className);
  },
  onFormActions: function onFormActions(event) {
    event.preventDefault();
    event.stopPropagation();
  },
  onFormDragEnter: function onFormDragEnter() {
    this.ui.uploadForm.addClass('elementor-drag-over');
  },
  onFormDragLeave: function onFormDragLeave(event) {
    if (jQuery(event.relatedTarget).closest(this.ui.uploadForm).length) {
      return;
    }
    this.ui.uploadForm.removeClass('elementor-drag-over');
  },
  onFormDrop: function onFormDrop(event) {
    this.droppedFiles = event.originalEvent.dataTransfer.files;
    this.submitForm();
  },
  onFileInputChange: function onFileInputChange() {
    this.submitForm();
  }
});
module.exports = TemplateLibraryImportView;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/parts/navigation-container.js":
/*!***********************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/parts/navigation-container.js ***!
  \***********************************************************************************************/
/***/ ((module) => {

"use strict";


module.exports = Marionette.ItemView.extend({
  template: '#tmpl-elementor-template-library-navigation-container',
  className: 'elementor-template-library-navigation-container',
  ui: {
    title: '.elementor-template-library-current-folder-title',
    backButton: '.elementor-template-library-navigation-back-button'
  },
  events: {
    'click @ui.backButton': 'onBackButtonClick'
  },
  render: function render() {
    if (null === elementor.templates.getFilter('parent')) {
      return this;
    }
    return Marionette.ItemView.prototype.render.call(this);
  },
  onRender: function onRender() {
    var _elementor$templates$;
    this.ui.title.text((_elementor$templates$ = elementor.templates.getFilter('parent')) === null || _elementor$templates$ === void 0 ? void 0 : _elementor$templates$.title);
  },
  onBackButtonClick: function onBackButtonClick() {
    elementor.templates.setFilter('parent', null);
    $e.route('library/templates/my-templates');
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/parts/preview.js":
/*!**********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/parts/preview.js ***!
  \**********************************************************************************/
/***/ ((module) => {

"use strict";


var TemplateLibraryPreviewView;
TemplateLibraryPreviewView = Marionette.ItemView.extend({
  template: '#tmpl-elementor-template-library-preview',
  id: 'elementor-template-library-preview',
  ui: {
    iframe: '> iframe'
  },
  onRender: function onRender() {
    this.ui.iframe.attr('src', this.getOption('url'));
  }
});
module.exports = TemplateLibraryPreviewView;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/parts/save-template.js":
/*!****************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/parts/save-template.js ***!
  \****************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];
/* provided dependency */ var sprintf = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["sprintf"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _constants = __webpack_require__(/*! ./../../constants */ "../assets/dev/js/editor/components/template-library/constants.js");
var TemplateLibraryTemplateModel = __webpack_require__(/*! elementor-templates/models/template */ "../assets/dev/js/editor/components/template-library/models/template.js");
var TemplateLibraryCollection = __webpack_require__(/*! elementor-templates/collections/templates */ "../assets/dev/js/editor/components/template-library/collections/templates.js");
var FolderCollectionView = __webpack_require__(/*! ./folders/folders-list */ "../assets/dev/js/editor/components/template-library/views/parts/folders/folders-list.js");
var LOAD_MORE_ID = 0;
var TemplateLibrarySaveTemplateView = Marionette.ItemView.extend({
  id: 'elementor-template-library-save-template',
  template: '#tmpl-elementor-template-library-save-template',
  ui: {
    form: '#elementor-template-library-save-template-form',
    submitButton: '#elementor-template-library-save-template-submit',
    ellipsisIcon: '.cloud-library-form-inputs .ellipsis-container',
    foldersList: '.cloud-folder-selection-dropdown ul',
    foldersDropdown: '.cloud-folder-selection-dropdown',
    foldersListContainer: '.cloud-folder-selection-dropdown-list',
    removeFolderSelection: '.source-selections .selected-folder i',
    selectedFolder: '.selected-folder',
    selectedFolderText: '.selected-folder-text',
    hiddenInputSelectedFolder: '#parentId',
    templateNameInput: '#elementor-template-library-save-template-name',
    localInput: '.source-selections-input.local',
    cloudInput: '.source-selections-input.cloud',
    sourceSelectionCheckboxes: '.source-selections-input input[type="checkbox"]',
    infoIcon: '.source-selections-input.cloud .eicon-info',
    connect: '#elementor-template-library-connect__badge',
    connectBadge: '.source-selections-input.cloud .connect-badge',
    cloudFormInputs: '.cloud-library-form-inputs',
    upgradeBadge: '.source-selections-input.cloud upgrade-badge'
  },
  events: {
    'submit @ui.form': 'onFormSubmit',
    'click @ui.ellipsisIcon': 'onEllipsisIconClick',
    'click @ui.foldersList': 'onFoldersListClick',
    'click @ui.removeFolderSelection': 'onRemoveFolderSelectionClick',
    'click @ui.selectedFolderText': 'onSelectedFolderTextClick',
    'click @ui.upgradeBadge': 'onUpgradeBadgeClicked',
    'change @ui.sourceSelectionCheckboxes': 'handleSourceSelectionChange',
    'mouseenter @ui.infoIcon': 'showInfoTip',
    'mouseenter @ui.connect': 'showConnectInfoTip',
    'input @ui.templateNameInput': 'onTemplateNameInputChange'
  },
  onRender: function onRender() {
    var _elementorAppConfig$c,
      _this$templateHelpers,
      _this = this;
    if ('undefined' === typeof ((_elementorAppConfig$c = elementorAppConfig['cloud-library']) === null || _elementorAppConfig$c === void 0 ? void 0 : _elementorAppConfig$c.quota) && (_this$templateHelpers = this.templateHelpers()) !== null && _this$templateHelpers !== void 0 && _this$templateHelpers.canSaveToCloud) {
      elementor.templates.layout.showLoadingView();
      $e.components.get('cloud-library').utils.setQuotaConfig().then(function (data) {
        elementorAppConfig['cloud-library'].quota = data;
      }).catch(function () {
        delete elementorAppConfig['cloud-library'].quota;
      }).finally(function () {
        _this.handleOnRender();
        elementor.templates.layout.hideLoadingView();
      });
    } else {
      this.handleOnRender();
    }
  },
  handleOnRender: function handleOnRender() {
    var _this2 = this;
    setTimeout(function () {
      return _this2.ui.templateNameInput.trigger('focus');
    });
    elementor.templates.eventManager.sendPageViewEvent({
      location: elementor.editorEvents.config.secondaryLocations.templateLibrary["".concat(context, "Modal")]
    });
    var context = this.getOption('context');
    if (_constants.SAVE_CONTEXTS.SAVE === context) {
      this.handleSaveAction();
    }
    if (_constants.SAVE_CONTEXTS.MOVE === context || _constants.SAVE_CONTEXTS.COPY === context) {
      this.handleSingleActionContextUiState();
    }
    if (_constants.SAVE_CONTEXTS.BULK_MOVE === context || _constants.SAVE_CONTEXTS.BULK_COPY === context) {
      this.handleBulkActionContextUiState();
    }
    if (!elementor.templates.hasCloudLibraryQuota()) {
      this.handleCloudLibraryPromo();
    }
    if (this.cloudMaxCapacityReached()) {
      this.handleCloudLibraryPromo('max-capacity');
    }
    if (!elementor.config.library_connect.is_connected) {
      this.handleElementorConnect();
    }
  },
  cloudMaxCapacityReached: function cloudMaxCapacityReached() {
    var _elementorAppConfig$c2, _elementorAppConfig$c3, _elementorAppConfig$c4, _elementorAppConfig$c5;
    return 'undefined' !== typeof ((_elementorAppConfig$c2 = elementorAppConfig['cloud-library']) === null || _elementorAppConfig$c2 === void 0 ? void 0 : _elementorAppConfig$c2.quota) && 0 < ((_elementorAppConfig$c3 = elementorAppConfig['cloud-library'].quota) === null || _elementorAppConfig$c3 === void 0 ? void 0 : _elementorAppConfig$c3.threshold) && ((_elementorAppConfig$c4 = elementorAppConfig['cloud-library'].quota) === null || _elementorAppConfig$c4 === void 0 ? void 0 : _elementorAppConfig$c4.currentUsage) >= ((_elementorAppConfig$c5 = elementorAppConfig['cloud-library'].quota) === null || _elementorAppConfig$c5 === void 0 ? void 0 : _elementorAppConfig$c5.threshold);
  },
  handleSaveAction: function handleSaveAction() {
    this.maybeEnableSaveButton();
  },
  handleSingleActionContextUiState: function handleSingleActionContextUiState() {
    var title = this.model.get('title');
    this.ui.templateNameInput.val(title);
    this.handleContextUiStateChecboxes();
    this.maybeEnableSaveButton();
  },
  maybeEnableSaveButton: function maybeEnableSaveButton() {
    var _this$templateHelpers2;
    if (!((_this$templateHelpers2 = this.templateHelpers()) !== null && _this$templateHelpers2 !== void 0 && _this$templateHelpers2.canSaveToCloud)) {
      return;
    }
    var isAnyChecked = this.ui.sourceSelectionCheckboxes.is(':checked');
    var title = this.ui.templateNameInput.val().trim();
    var isTitleFilled = this.ui.templateNameInput.is(':visible') ? elementor.templates.isTemplateTitleValid(title) : true;
    this.updateSubmitButtonState(!isAnyChecked || !isTitleFilled);
  },
  handleBulkActionContextUiState: function handleBulkActionContextUiState() {
    this.ui.templateNameInput.remove();
    this.handleContextUiStateChecboxes();
    this.maybeEnableSaveButton();
  },
  handleContextUiStateChecboxes: function handleContextUiStateChecboxes() {
    var fromSource = elementor.templates.getFilter('source');
    if ('local' === fromSource) {
      this.$('.source-selections-input #cloud').prop('checked', true);
      this.ui.localInput.addClass('disabled');
    }
  },
  handleCloudLibraryPromo: function handleCloudLibraryPromo() {
    var stateClass = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'promotion';
    if (_constants.SAVE_CONTEXTS.SAVE === this.getOption('context')) {
      this.$('.source-selections-input #local').prop('checked', true);
    } else {
      this.$('.source-selections-input #local, .source-selections-input.local label').css('pointer-events', 'none');
    }
    this.$('.source-selections-input #cloud').prop('checked', false);
    this.$('.source-selections-input #cloud').prop('disabled', true);
    this.ui.cloudFormInputs.addClass(stateClass);
    elementor.templates.eventManager.sendPageViewEvent({
      location: elementor.editorEvents.config.secondaryLocations.templateLibrary.saveModalSelectUpgrade
    });
  },
  getSaveType: function getSaveType() {
    var type;
    if (_constants.SAVE_CONTEXTS.MOVE === this.getOption('context') || _constants.SAVE_CONTEXTS.COPY === this.getOption('context')) {
      type = this.model.get('type');
    } else if (this.model) {
      type = this.model.get('elType');
    } else if (elementor.config.document.library && elementor.config.document.library.save_as_same_type) {
      type = elementor.config.document.type;
    } else {
      type = 'page';
    }
    return type;
  },
  templateHelpers: function templateHelpers() {
    var saveType = this.getSaveType(),
      templateType = elementor.templates.getTemplateTypes(saveType),
      saveContext = this.getOption('context');
    return templateType["".concat(saveContext, "Dialog")];
  },
  onFormSubmit: function onFormSubmit(event) {
    var _this$templateHelpers3;
    event.preventDefault();
    elementor.templates.eventManager.sendNewSaveTemplateClickedEvent();
    var formData = this.ui.form.elementorSerializeObject(),
      JSONParams = {
        remove: ['default']
      };
    formData.parentTitle = formData.parentId ? this.ui.selectedFolderText.html() : '';
    formData.content = this.model ? [this.model.toJSON(JSONParams)] : elementor.elements.toJSON(JSONParams);
    this.updateSourceSelections(formData);
    if (!(formData !== null && formData !== void 0 && formData.source) && (_this$templateHelpers3 = this.templateHelpers()) !== null && _this$templateHelpers3 !== void 0 && _this$templateHelpers3.canSaveToCloud) {
      this.showEmptySourceErrorDialog();
      return;
    }
    this.ui.submitButton.addClass('elementor-button-state');
    this.updateSaveContext(formData);
    this.updateToastConfig(formData);
    this.updateSourceState(formData);
    elementor.templates.saveTemplate(this.getSaveType(), formData);
  },
  updateSourceSelections: function updateSourceSelections(formData) {
    var selectedSources = ['cloud', 'local'].filter(function (type) {
      return formData[type];
    });
    if (!selectedSources.length) {
      return;
    }
    formData.source = selectedSources;
    ['cloud', 'local'].forEach(function (type) {
      return delete formData[type];
    });
  },
  showEmptySourceErrorDialog: function showEmptySourceErrorDialog() {
    elementorCommon.dialogsManager.createWidget('alert', {
      id: 'elementor-template-library-error-dialog',
      headerMessage: __('An error occured.', 'elementor'),
      message: __('Please select at least one location.', 'elementor')
    }).show();
  },
  updateSaveContext: function updateSaveContext(formData) {
    var _this$getOption;
    var saveContext = (_this$getOption = this.getOption('context')) !== null && _this$getOption !== void 0 ? _this$getOption : _constants.SAVE_CONTEXTS.SAVE;
    formData.save_context = saveContext;
    if ([_constants.SAVE_CONTEXTS.MOVE, _constants.SAVE_CONTEXTS.BULK_MOVE, _constants.SAVE_CONTEXTS.COPY, _constants.SAVE_CONTEXTS.BULK_COPY].includes(saveContext)) {
      formData.from_source = elementor.templates.getFilter('source');
      formData.from_template_id = [_constants.SAVE_CONTEXTS.MOVE, _constants.SAVE_CONTEXTS.COPY].includes(saveContext) ? this.model.get('template_id') : Array.from(elementor.templates.getBulkSelectionItems());
    }
  },
  updateToastConfig: function updateToastConfig(formData) {
    var _formData$source, _this$getOption2, _formData$source2, _formData$parentId, _formData$parentTitle;
    if (!((_formData$source = formData.source) !== null && _formData$source !== void 0 && _formData$source.length)) {
      return;
    }
    var lastSource = formData.source.at(-1),
      saveContext = (_this$getOption2 = this.getOption('context')) !== null && _this$getOption2 !== void 0 ? _this$getOption2 : _constants.SAVE_CONTEXTS.SAVE,
      toastMessage = this.getToastMessage(lastSource, saveContext, formData);
    if (!toastMessage) {
      return;
    }
    var toastButtons = ((_formData$source2 = formData.source) === null || _formData$source2 === void 0 ? void 0 : _formData$source2.length) > 1 ? null : this.getToastButtons(lastSource, formData === null || formData === void 0 || (_formData$parentId = formData.parentId) === null || _formData$parentId === void 0 ? void 0 : _formData$parentId.trim(), formData === null || formData === void 0 || (_formData$parentTitle = formData.parentTitle) === null || _formData$parentTitle === void 0 ? void 0 : _formData$parentTitle.trim());
    elementor.templates.setToastConfig({
      show: true,
      options: {
        message: toastMessage,
        buttons: toastButtons,
        position: {
          my: 'right bottom',
          at: 'right-10 bottom-10',
          of: '#elementor-template-library-modal .dialog-lightbox-widget-content'
        }
      }
    });
  },
  updateSourceState: function updateSourceState(formData) {
    var _formData$source3, _this$getOption3;
    if (!((_formData$source3 = formData.source) !== null && _formData$source3 !== void 0 && _formData$source3.length)) {
      return;
    }
    var saveContext = (_this$getOption3 = this.getOption('context')) !== null && _this$getOption3 !== void 0 ? _this$getOption3 : _constants.SAVE_CONTEXTS.SAVE;
    if (_constants.SAVE_CONTEXTS.SAVE !== saveContext) {
      return;
    }
    var lastSource = formData.source.at(-1);
    elementor.templates.setSourceSelection(lastSource);
    elementor.templates.setFilter('source', lastSource, true);
  },
  getToastMessage: function getToastMessage(lastSource, saveContext, formData) {
    var _formData$source4, _formData$from_templa, _formData$from_templa2, _formData$from_templa3, _formData$from_templa4, _actions$key;
    var key = "".concat(lastSource, "_").concat(saveContext);
    if (((_formData$source4 = formData.source) === null || _formData$source4 === void 0 ? void 0 : _formData$source4.length) > 1) {
      return __('Template saved to your Site and Cloud Templates.', 'elementor');
    }
    var actions = (0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)({}, "local_".concat(_constants.SAVE_CONTEXTS.MOVE), this.getFormattedToastMessage('moved to your Site Templates', formData.title)), "cloud_".concat(_constants.SAVE_CONTEXTS.MOVE), this.getFormattedToastMessage('moved to your Cloud Templates', formData.title)), "local_".concat(_constants.SAVE_CONTEXTS.COPY), this.getFormattedToastMessage('copied to your Site Templates', formData.title)), "cloud_".concat(_constants.SAVE_CONTEXTS.COPY), this.getFormattedToastMessage('copied to your Cloud Templates', formData.title)), "local_".concat(_constants.SAVE_CONTEXTS.BULK_MOVE), this.getFormattedToastMessage('moved to your Site Templates', null, (_formData$from_templa = formData.from_template_id) === null || _formData$from_templa === void 0 ? void 0 : _formData$from_templa.length)), "cloud_".concat(_constants.SAVE_CONTEXTS.BULK_MOVE), this.getFormattedToastMessage('moved to your Cloud Templates', null, (_formData$from_templa2 = formData.from_template_id) === null || _formData$from_templa2 === void 0 ? void 0 : _formData$from_templa2.length)), "local_".concat(_constants.SAVE_CONTEXTS.BULK_COPY), this.getFormattedToastMessage('copied to your Site Templates', null, (_formData$from_templa3 = formData.from_template_id) === null || _formData$from_templa3 === void 0 ? void 0 : _formData$from_templa3.length)), "cloud_".concat(_constants.SAVE_CONTEXTS.BULK_COPY), this.getFormattedToastMessage('copied to your Cloud Templates', null, (_formData$from_templa4 = formData.from_template_id) === null || _formData$from_templa4 === void 0 ? void 0 : _formData$from_templa4.length));
    return (_actions$key = actions[key]) !== null && _actions$key !== void 0 ? _actions$key : false;
  },
  getFormattedToastMessage: function getFormattedToastMessage(action, title, count) {
    if (count !== undefined) {
      /* Translators: 1: Number of templates, 2: Action performed (e.g., "moved", "copied"). */
      return sprintf(__('%1$d Template(s) %2$s.', 'elementor'), count, action);
    }

    /* Translators: 1: Template title or "Template" fallback, 2: Action performed. */
    return sprintf(__('%1$s %2$s.', 'elementor'), title ? "\"".concat(title, "\"") : __('Template', 'elementor'), action);
  },
  getToastButtons: function getToastButtons(lastSource, parentId, parentTitle) {
    var _this3 = this;
    var parsedParentId = parseInt(parentId, 10) || null;
    return [{
      name: 'template_after_save',
      text: __('View', 'elementor'),
      callback: function callback() {
        return _this3.navigateToSavedSource(lastSource, parsedParentId, parentTitle);
      }
    }];
  },
  navigateToSavedSource: function navigateToSavedSource(lastSource, parentId, parentTitle) {
    elementor.templates.setSourceSelection(lastSource);
    elementor.templates.setFilter('source', lastSource, true);
    if (parentId) {
      var model = new TemplateLibraryTemplateModel({
        template_id: parentId,
        title: parentTitle
      });
      $e.route('library/view-folder', {
        model: model
      });
      elementor.templates.layout.showTemplatesView(new TemplateLibraryCollection(elementor.templates.filterTemplates()));
      return;
    }
    $e.routes.refreshContainer('library');
  },
  onSelectedFolderTextClick: function onSelectedFolderTextClick() {
    if (!this.folderCollectionView) {
      this.onEllipsisIconClick();
      return;
    }
    if (!this.ui.foldersDropdown.is(':visible')) {
      this.ui.foldersDropdown.show();
    }
  },
  onEllipsisIconClick: function onEllipsisIconClick() {
    var _this4 = this;
    return (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
      return _regenerator.default.wrap(function (_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            if (!_this4.ui.foldersDropdown.is(':visible')) {
              _context.next = 1;
              break;
            }
            _this4.ui.foldersDropdown.hide();
            return _context.abrupt("return");
          case 1:
            _this4.ui.foldersDropdown.show();
            if (_this4.folderCollectionView) {
              _context.next = 4;
              break;
            }
            _this4.folderCollectionView = new FolderCollectionView({
              collection: new TemplateLibraryCollection()
            });
            _this4.addSpinner();
            _this4.renderFolderDropdown();
            _context.prev = 2;
            _context.next = 3;
            return _this4.fetchFolders();
          case 3:
            _context.prev = 3;
            _this4.removeSpinner();
            _this4.disableSelectedFolder();
            return _context.finish(3);
          case 4:
            elementor.templates.eventManager.sendPageViewEvent({
              location: elementor.editorEvents.config.secondaryLocations.templateLibrary.saveModalSelectFolder
            });
          case 5:
          case "end":
            return _context.stop();
        }
      }, _callee, null, [[2,, 3, 4]]);
    }))();
  },
  renderFolderDropdown: function renderFolderDropdown() {
    var _this$folderCollectio;
    this.ui.foldersListContainer.html((_this$folderCollectio = this.folderCollectionView.render()) === null || _this$folderCollectio === void 0 ? void 0 : _this$folderCollectio.el);
  },
  addSpinner: function addSpinner() {
    var spinner = new TemplateLibraryTemplateModel({
      template_id: LOAD_MORE_ID,
      title: '<i class="eicon-loading eicon-animation-spin" aria-hidden="true"></i>'
    });
    this.folderCollectionView.collection.add(spinner);
  },
  removeSpinner: function removeSpinner() {
    var spinner = this.folderCollectionView.collection.findWhere({
      template_id: LOAD_MORE_ID
    });
    if (spinner) {
      this.folderCollectionView.collection.remove(spinner);
    }
  },
  fetchFolders: function fetchFolders() {
    var _this5 = this;
    return new Promise(function (resolve) {
      var offset = _this5.folderCollectionView.collection.length - 1;
      var ajaxOptions = {
        data: {
          source: 'cloud',
          offset: offset
        },
        success: function success(response) {
          _this5.folderCollectionView.collection.add(response === null || response === void 0 ? void 0 : response.templates);
          if (_this5.shouldAddLoadMoreItem(response)) {
            _this5.addLoadMoreItem();
          }
          resolve(response);
        },
        error: function error(_error) {
          elementor.templates.showErrorDialog(_error);
          resolve();
        }
      };
      elementorCommon.ajax.addRequest('get_folders', ajaxOptions);
    });
  },
  disableSelectedFolder: function disableSelectedFolder() {
    if (!_constants.SAVE_CONTEXTS.MOVE === this.getOption('context')) {
      return;
    }
    if (!this.model || !Number.isInteger(this.model.get('parentId'))) {
      return;
    }
    this.$(".folder-list li[data-id=\"".concat(this.model.get('parentId'), "\"]")).addClass('disabled');
  },
  onFoldersListClick: function onFoldersListClick(event) {
    var _event$target$dataset = event.target.dataset,
      id = _event$target$dataset.id,
      value = _event$target$dataset.value;
    if (!id || !value) {
      return;
    }
    if (this.clickedOnLoadMore(id)) {
      this.loadMoreFolders();
      return;
    }
    this.handleFolderSelected(id, value);
  },
  clickedOnLoadMore: function clickedOnLoadMore(templateId) {
    return LOAD_MORE_ID === +templateId;
  },
  handleFolderSelected: function handleFolderSelected(id, value) {
    this.highlightSelectedFolder(id);
    this.ui.foldersDropdown.hide();
    this.ui.ellipsisIcon.hide();
    this.ui.selectedFolderText.html(value);
    this.ui.selectedFolder.show();
    this.ui.hiddenInputSelectedFolder.val(id);
    this.$('.source-selections-input #cloud').prop('checked', true);
    this.maybeEnableSaveButton();
  },
  highlightSelectedFolder: function highlightSelectedFolder(id) {
    this.clearSelectedFolder();
    this.$(".folder-list li[data-id=\"".concat(id, "\"]")).addClass('selected');
  },
  clearSelectedFolder: function clearSelectedFolder() {
    this.$('.folder-list li.selected').removeClass('selected');
  },
  onRemoveFolderSelectionClick: function onRemoveFolderSelectionClick() {
    this.clearSelectedFolder();
    this.ui.selectedFolderText.html('');
    this.ui.selectedFolder.hide();
    this.ui.ellipsisIcon.show();
    this.ui.hiddenInputSelectedFolder.val('');
    this.ui.foldersDropdown.hide();
  },
  loadMoreFolders: function loadMoreFolders() {
    var _this6 = this;
    return (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee2() {
      return _regenerator.default.wrap(function (_context2) {
        while (1) switch (_context2.prev = _context2.next) {
          case 0:
            _this6.removeLoadMoreItem();
            _this6.addSpinner();
            _context2.prev = 1;
            _context2.next = 2;
            return _this6.fetchFolders();
          case 2:
            _context2.prev = 2;
            _this6.removeSpinner();
            _this6.disableSelectedFolder();
            return _context2.finish(2);
          case 3:
          case "end":
            return _context2.stop();
        }
      }, _callee2, null, [[1,, 2, 3]]);
    }))();
  },
  shouldAddLoadMoreItem: function shouldAddLoadMoreItem(response) {
    return this.folderCollectionView.collection.length < (response === null || response === void 0 ? void 0 : response.total);
  },
  addLoadMoreItem: function addLoadMoreItem() {
    this.folderCollectionView.collection.add({
      template_id: LOAD_MORE_ID,
      title: __('Load More', 'elementor')
    });
  },
  removeLoadMoreItem: function removeLoadMoreItem() {
    var loadMore = this.folderCollectionView.collection.findWhere({
      template_id: LOAD_MORE_ID
    });
    if (loadMore) {
      this.folderCollectionView.collection.remove(loadMore);
    }
  },
  handleSourceSelectionChange: function handleSourceSelectionChange(event) {
    this.maybeAllowOnlyOneCheckboxToBeChecked(event);
    this.maybeEnableSaveButton();
  },
  maybeAllowOnlyOneCheckboxToBeChecked: function maybeAllowOnlyOneCheckboxToBeChecked(event) {
    var _this7 = this;
    if (this.moreThanOneCheckboxCanBeChecked()) {
      return;
    }
    var selectedCheckbox = event.currentTarget;
    this.ui.sourceSelectionCheckboxes.each(function (_, checkbox) {
      var wrapper = _this7.$(checkbox).closest('.source-selections-input');
      if (checkbox !== selectedCheckbox) {
        if (selectedCheckbox.checked) {
          wrapper.addClass('disabled');
          checkbox.checked = false;
        } else {
          wrapper.removeClass('disabled');
        }
      }
    });
  },
  moreThanOneCheckboxCanBeChecked: function moreThanOneCheckboxCanBeChecked() {
    return _constants.SAVE_CONTEXTS.SAVE === this.getOption('context') || 'cloud' !== elementor.templates.getFilter('source');
  },
  showInfoTip: function showInfoTip() {
    var _this8 = this;
    if (this.infoTipDialog) {
      this.infoTipDialog.hide();
    }
    var message = elementor.templates.hasCloudLibraryQuota() ? __('Upgrade your subscription to get more space and reuse saved assets across all your sites.', 'elementor') : __('Upgrade your subscription to access Cloud Templates and reuse saved assets across all your sites.', 'elementor');
    var goLink = elementor.templates.hasCloudLibraryQuota() ? 'https://go.elementor.com/go-pro-cloud-templates-save-to-100-usage-notice' : 'https://go.elementor.com/go-pro-cloud-templates-save-to-free-tooltip/';
    this.infoTipDialog = elementor.dialogsManager.createWidget('buttons', {
      id: 'elementor-library--infotip__dialog',
      effects: {
        show: 'show',
        hide: 'hide'
      },
      position: {
        of: this.ui.infoIcon,
        at: 'top-75'
      }
    }).setMessage(message).addButton({
      name: 'learn_more',
      text: __('Upgrade Now', 'elementor'),
      classes: '',
      callback: function callback() {
        open(goLink, '_blank');
        _this8.onUpgradeBadgeClicked();
      }
    });
    this.infoTipDialog.getElements('header').remove();
    this.infoTipDialog.show();
  },
  showConnectInfoTip: function showConnectInfoTip() {
    if (this.connectInfoTipDialog) {
      this.connectInfoTipDialog.hide();
    }
    this.connectInfoTipDialog = elementor.dialogsManager.createWidget('buttons', {
      id: 'elementor-library--connect_infotip__dialog',
      effects: {
        show: 'show',
        hide: 'hide'
      },
      position: {
        of: this.ui.connectBadge,
        at: 'top+80'
      }
    }).setMessage(__('To access the Cloud Templates Library you must have an active Elementor Pro subscription', 'elementor') + ' <i>' + __('and', 'elementor') + '</i> ' + __('connect your site.', 'elementor'));
    this.connectInfoTipDialog.getElements('header').remove();
    this.connectInfoTipDialog.getElements('buttonsWrapper').remove();
    this.connectInfoTipDialog.show();
  },
  handleElementorConnect: function handleElementorConnect() {
    elementor.templates.eventManager.sendPageViewEvent({
      location: elementor.editorEvents.config.secondaryLocations.templateLibrary.saveModalSelectConnect
    });
    this.ui.connect.elementorConnect({
      success: function success() {
        elementor.config.library_connect.is_connected = true;
        $e.run('library/close');
        elementor.notifications.showToast({
          message: __('Connected successfully.', 'elementor')
        });
      },
      error: function error() {
        elementor.config.library_connect.is_connected = false;
      }
    });
  },
  onTemplateNameInputChange: function onTemplateNameInputChange() {
    this.maybeEnableSaveButton();
  },
  updateSubmitButtonState: function updateSubmitButtonState(shouldDisableSubmitButton) {
    this.ui.submitButton.toggleClass('e-primary', !shouldDisableSubmitButton);
    this.ui.submitButton.prop('disabled', shouldDisableSubmitButton);
  },
  onUpgradeBadgeClicked: function onUpgradeBadgeClicked() {
    var upgradePosition = elementor.templates.hasCloudLibraryQuota() ? 'save to-max' : 'save to-free';
    elementor.templates.eventManager.sendUpgradeClickedEvent({
      secondaryLocation: elementor.editorEvents.config.secondaryLocations.templateLibrary.saveModal,
      upgrade_position: upgradePosition
    });
  }
});
module.exports = TemplateLibrarySaveTemplateView;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/parts/templates-empty.js":
/*!******************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/parts/templates-empty.js ***!
  \******************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var TemplateLibraryTemplatesEmptyView = Marionette.ItemView.extend({
  id: 'elementor-template-library-templates-empty',
  template: '#tmpl-elementor-template-library-templates-empty',
  ui: {
    title: '.elementor-template-library-blank-title',
    message: '.elementor-template-library-blank-message',
    icon: '.elementor-template-library-blank-icon',
    button: '.elementor-template-library-cloud-empty__button',
    backToEditor: '.e-back-to-editor'
  },
  events: {
    'click @ui.backToEditor': 'closeLibrary'
  },
  closeLibrary: function closeLibrary(event) {
    event.preventDefault();
    $e.run('library/close');
  },
  modesStrings: function modesStrings() {
    var defaultIcon = this.getDefaultIcon();
    return {
      empty: {
        title: __('Haven’t Saved Templates Yet?', 'elementor'),
        message: __('This is where your templates should be. Design it. Save it. Reuse it.', 'elementor'),
        icon: defaultIcon,
        button: ''
      },
      noResults: {
        title: __('No Results Found', 'elementor'),
        message: __('Please make sure your search is spelled correctly or try a different words.', 'elementor'),
        icon: defaultIcon,
        button: ''
      },
      noFavorites: {
        title: __('No Favorite Templates', 'elementor'),
        message: __('You can mark any pre-designed template as a favorite.', 'elementor'),
        icon: defaultIcon,
        button: ''
      },
      cloudEmpty: {
        title: __('No templates saved just yet', 'elementor'),
        message: __('Once you save a template, it’ll show up here, ready for reuse across all of your Elementor sites—no extra work needed.', 'elementor'),
        icon: this.getCloudIcon(),
        button: "<a class=\"e-back-to-editor\">".concat(__('Back to editor', 'elementor'), "</a>")
      },
      cloudFolderEmpty: {
        title: __('No templates to show here, yet', 'elementor'),
        message: __('Once you save some templates to this folder, you can use them on any website you’re working on.', 'elementor'),
        icon: this.getEmptyFolderIcon(),
        button: "<a class=\"e-back-to-editor\">".concat(__('Back to editor', 'elementor'), "</a>")
      }
    };
  },
  getDefaultIcon: function getDefaultIcon() {
    return "<img src=\"".concat(elementorCommon.config.urls.assets, "images/no-search-results.svg\" class=\"elementor-template-library-no-results\" loading=\"lazy\" />");
  },
  getCloudIcon: function getCloudIcon() {
    return "<i class=\"eicon-library-cloud-empty\" aria-hidden=\"true\" title=\"Empty Cloud Library\"></i>";
  },
  getEmptyFolderIcon: function getEmptyFolderIcon() {
    return "<i class=\"eicon-library-folder-empty\" aria-hidden=\"true\" title=\"Empty folder\"></i>";
  },
  getCurrentMode: function getCurrentMode() {
    if (elementor.templates.getFilter('text')) {
      return 'noResults';
    }
    if (elementor.templates.getFilter('favorite')) {
      return 'noFavorites';
    }
    if ('cloud' === elementor.templates.getFilter('source')) {
      return null !== elementor.templates.getFilter('parent') ? 'cloudFolderEmpty' : 'cloudEmpty';
    }
    return 'empty';
  },
  onRender: function onRender() {
    var modeStrings = this.modesStrings()[this.getCurrentMode()];
    this.ui.title.html(modeStrings.title);
    this.ui.message.html(modeStrings.message);
    this.ui.button.html(modeStrings.button);
    this.ui.icon.html(modeStrings.icon);
  }
});
module.exports = TemplateLibraryTemplatesEmptyView;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/parts/templates.js":
/*!************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/parts/templates.js ***!
  \************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var sprintf = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["sprintf"];
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _select = _interopRequireDefault(__webpack_require__(/*! elementor-editor-utils/select2.js */ "../assets/dev/js/editor/utils/select2.js"));
var _constants = __webpack_require__(/*! ./../../constants */ "../assets/dev/js/editor/components/template-library/constants.js");
var TemplateLibraryTemplateLocalView = __webpack_require__(/*! elementor-templates/views/template/local */ "../assets/dev/js/editor/components/template-library/views/template/local.js");
var TemplateLibraryTemplateRemoteView = __webpack_require__(/*! elementor-templates/views/template/remote */ "../assets/dev/js/editor/components/template-library/views/template/remote.js");
var TemplateLibraryTemplateCloudView = __webpack_require__(/*! elementor-templates/views/template/cloud */ "../assets/dev/js/editor/components/template-library/views/template/cloud.js");
var TemplateLibraryCollectionView = Marionette.CompositeView.extend({
  template: '#tmpl-elementor-template-library-templates',
  id: 'elementor-template-library-templates',
  childViewContainer: '#elementor-template-library-templates-container',
  reorderOnSort: true,
  emptyView: function emptyView() {
    var EmptyView = __webpack_require__(/*! elementor-templates/views/parts/templates-empty */ "../assets/dev/js/editor/components/template-library/views/parts/templates-empty.js");
    return new EmptyView();
  },
  ui: {
    textFilter: '#elementor-template-library-filter-text',
    selectFilter: '.elementor-template-library-filter-select',
    myFavoritesFilter: '#elementor-template-library-filter-my-favorites',
    orderInputs: '.elementor-template-library-order-input',
    orderLabels: 'label.elementor-template-library-order-label',
    searchInputIcon: '#elementor-template-library-filter-text-wrapper i',
    loadMoreAnchor: '#elementor-template-library-load-more-anchor',
    selectSourceFilter: '.elementor-template-library-filter-select-source .source-option',
    addNewFolder: '#elementor-template-library-add-new-folder',
    addNewFolderDivider: '.elementor-template-library-filter-toolbar-side-actions .divider',
    selectGridView: '#elementor-template-library-view-grid',
    selectListView: '#elementor-template-library-view-list',
    bulkSelectionActionBar: '.bulk-selection-action-bar',
    bulkActionBarDelete: '.bulk-selection-action-bar .bulk-delete i',
    bulkSelectedCount: '.bulk-selection-action-bar .selected-count',
    bulkSelectAllCheckbox: '#bulk-select-all',
    clearBulkSelections: '.bulk-selection-action-bar .clear-bulk-selections',
    bulkMove: '.bulk-selection-action-bar .bulk-move',
    bulkCopy: '.bulk-selection-action-bar .bulk-copy',
    quota: '.quota-progress-container .quota-progress-bar',
    quotaFill: '.quota-progress-container  .quota-progress-bar .quota-progress-bar-fill',
    quotaValue: '.quota-progress-container .quota-progress-bar-value',
    quotaWarning: '.quota-progress-container .progress-bar-container .quota-warning',
    quotaUpgrade: '.quota-progress-container .progress-bar-container .quota-warning a',
    navigationContainer: '#elementor-template-library-navigation-container'
  },
  events: {
    'input @ui.textFilter': 'onTextFilterInput',
    'change @ui.selectFilter': 'onSelectFilterChange',
    'change @ui.myFavoritesFilter': 'onMyFavoritesFilterChange',
    'mousedown @ui.orderLabels': 'onOrderLabelsClick',
    'click @ui.selectSourceFilter': 'onSelectSourceFilterChange',
    'click @ui.addNewFolder': 'onCreateNewFolderClick',
    'click @ui.selectGridView': 'onSelectGridViewClick',
    'click @ui.selectListView': 'onSelectListViewClick',
    'change @ui.bulkSelectAllCheckbox': 'onBulkSelectAllCheckbox',
    'click @ui.clearBulkSelections': 'onClearBulkSelections',
    'mouseenter @ui.bulkMove': 'onHoverBulkAction',
    'mouseenter @ui.bulkCopy': 'onHoverBulkAction',
    'click @ui.bulkMove': 'onClickBulkMove',
    'click @ui.bulkActionBarDelete': 'onBulkDeleteClick',
    'click @ui.bulkCopy': 'onClickBulkCopy',
    'click @ui.quotaUpgrade': 'onQuotaUpgradeClicked'
  },
  className: 'no-bulk-selections',
  resetQuotaBarStyles: function resetQuotaBarStyles() {
    this.ui.quota.removeClass(['quota-progress-bar-normal', 'quota-progress-bar-warning', 'quota-progress-bar-alert']);
    this.ui.quotaFill.removeClass(['quota-progress-bar-fill-normal', 'quota-progress-bar-fill-warning', 'quota-progress-bar-fill-alert']);
  },
  setQuotaBarStyles: function setQuotaBarStyles(variant) {
    this.ui.quota.addClass("quota-progress-bar-".concat(variant));
    this.ui.quotaFill.addClass("quota-progress-bar-fill-".concat(variant));
  },
  handleQuotaWarning: function handleQuotaWarning(variant, quotaUsage) {
    var message = _constants.QUOTA_WARNINGS[variant];
    if (!message) {
      return;
    }
    this.ui.quotaWarning.html(sprintf(message, quotaUsage));
    this.ui.quotaWarning.show();
  },
  handleQuotaBar: function handleQuotaBar() {
    var _elementorAppConfig, _quota$currentUsage, _quota$threshold;
    var quota = (_elementorAppConfig = elementorAppConfig) === null || _elementorAppConfig === void 0 || (_elementorAppConfig = _elementorAppConfig['cloud-library']) === null || _elementorAppConfig === void 0 ? void 0 : _elementorAppConfig.quota;
    var value = quota ? Math.round(quota.currentUsage / quota.threshold * 100) : 0;
    this.ui.quotaFill.css('width', "".concat(value, "%"));
    this.ui.quotaValue.text("".concat(quota === null || quota === void 0 || (_quota$currentUsage = quota.currentUsage) === null || _quota$currentUsage === void 0 ? void 0 : _quota$currentUsage.toLocaleString(), "/").concat(quota === null || quota === void 0 || (_quota$threshold = quota.threshold) === null || _quota$threshold === void 0 ? void 0 : _quota$threshold.toLocaleString()));
    this.ui.quotaWarning.hide();
    this.resetQuotaBarStyles();
    var quotaState = this.resolveQuotaState(value);
    this.handleQuotaWarning(quotaState, value);
    this.setQuotaBarStyles(quotaState);
  },
  resolveQuotaState: function resolveQuotaState(value) {
    if (value < 80) {
      return _constants.QUOTA_BAR_STATES.NORMAL;
    } else if (value < 100) {
      return _constants.QUOTA_BAR_STATES.WARNING;
    }
    return _constants.QUOTA_BAR_STATES.ALERT;
  },
  onClearBulkSelections: function onClearBulkSelections() {
    elementor.templates.clearBulkSelectionItems();
    elementor.templates.layout.handleBulkActionBar();
    elementor.templates.layout.selectAllCheckboxNormal();
    this.deselectAllBulkItems();
  },
  deselectAllBulkItems: function deselectAllBulkItems() {
    if ('list' === elementor.templates.getViewSelection() || 'local' === elementor.templates.getFilter('source')) {
      this.ui.bulkSelectAllCheckbox.prop('checked', false).trigger('change');
    } else {
      document.querySelectorAll('.bulk-selected-item').forEach(function (item) {
        item.classList.remove('bulk-selected-item');
      });
    }
  },
  onBulkSelectAllCheckbox: function onBulkSelectAllCheckbox() {
    var isChecked = this.$('#bulk-select-all:checked').length > 0;
    if (isChecked) {
      elementor.templates.layout.selectAllCheckboxNormal();
    }
    this.updateBulkSelectedItems(isChecked);
    elementor.templates.layout.handleBulkActionBarUi();
  },
  updateBulkSelectedItems: function updateBulkSelectedItems(isChecked) {
    document.querySelectorAll('.bulk-selection-item-checkbox').forEach(function (checkbox) {
      checkbox.checked = isChecked;
      var templateId = checkbox.dataset.template_id;
      var parentDiv = checkbox.closest('.elementor-template-library-template');
      if (isChecked) {
        elementor.templates.addBulkSelectionItem(templateId);
        parentDiv === null || parentDiv === void 0 || parentDiv.classList.add('bulk-selected-item');
      } else {
        elementor.templates.removeBulkSelectionItem(templateId);
        parentDiv === null || parentDiv === void 0 || parentDiv.classList.remove('bulk-selected-item');
      }
    });
  },
  onBulkDeleteClick: function onBulkDeleteClick() {
    var _this = this;
    this.ui.bulkActionBarDelete.toggleClass('disabled');
    elementor.templates.onBulkDeleteClick().finally(function () {
      _this.ui.bulkActionBarDelete.toggleClass('disabled');
      elementor.templates.layout.handleBulkActionBar();
    });
  },
  comparators: {
    title: function title(model) {
      return model.get('title').toLowerCase();
    },
    popularityIndex: function popularityIndex(model) {
      var popularityIndex = model.get('popularityIndex');
      if (!popularityIndex) {
        popularityIndex = model.get('date');
      }
      return -popularityIndex;
    },
    trendIndex: function trendIndex(model) {
      var trendIndex = model.get('trendIndex');
      if (!trendIndex) {
        trendIndex = model.get('date');
      }
      return -trendIndex;
    }
  },
  getChildView: function getChildView(childModel) {
    var sourceMappings = {
      local: TemplateLibraryTemplateLocalView,
      remote: TemplateLibraryTemplateRemoteView,
      cloud: TemplateLibraryTemplateCloudView
    };
    var activeSource = childModel.get('source') ? childModel.get('source') : 'local';

    /**
     * Filter template source.
     *
     * @param bool   isRemote     - If `true` the source is a remote source.
     * @param string activeSource - The current template source.
     */
    var isRemote = elementor.hooks.applyFilters('templates/source/is-remote', 'remote' === activeSource, activeSource);
    return isRemote ? TemplateLibraryTemplateRemoteView : sourceMappings[activeSource] || TemplateLibraryTemplateLocalView;
  },
  initialize: function initialize() {
    this.handleQuotaBar = this.handleQuotaBar.bind(this);
    this.handleQuotaUpdate = this.handleQuotaUpdate.bind(this);
    this.listenTo(elementor.channels.templates, 'filter:change', this._renderChildren);
    this.listenTo(elementor.channels.templates, 'quota:updated', this.handleQuotaUpdate);
    this.debouncedSearchTemplates = _.debounce(this.searchTemplates, 300);
  },
  handleQuotaUpdate: function handleQuotaUpdate() {
    var _elementor$templates$,
      _this2 = this;
    var activeSource = (_elementor$templates$ = elementor.templates.getFilter('source')) !== null && _elementor$templates$ !== void 0 ? _elementor$templates$ : 'local';
    if ('cloud' === activeSource) {
      $e.components.get('cloud-library').utils.getQuotaConfig().then(function () {
        _this2.handleQuotaBar();
      });
    }
  },
  filter: function filter(childModel) {
    var activeSource = elementor.templates.getFilter('source');
    if ('cloud' === activeSource) {
      return true; // Filtering happens on the backend.
    }
    var filterTerms = elementor.templates.getFilterTerms(),
      passingFilter = true;
    jQuery.each(filterTerms, function (filterTermName) {
      var filterValue = elementor.templates.getFilter(filterTermName);
      if (!filterValue) {
        return;
      }
      if (this.callback) {
        var callbackResult = this.callback.call(childModel, filterValue);
        if (!callbackResult) {
          passingFilter = false;
        }
        return callbackResult;
      }
      var filterResult = filterValue === childModel.get(filterTermName);
      if (!filterResult) {
        passingFilter = false;
      }
      return filterResult;
    });
    return passingFilter;
  },
  order: function order(by, reverseOrder) {
    var comparator = this.comparators[by] || by;
    if ('cloud' === elementor.templates.getFilter('source')) {
      this.handleCloudOrder(by, reverseOrder);
      return;
    }
    if (reverseOrder) {
      comparator = this.reverseOrder(comparator);
    }
    this.collection.comparator = comparator;
    this.collection.sort();
  },
  handleCloudOrder: function handleCloudOrder(by, reverseOrder) {
    elementor.templates.setFilter('orderby', by);
    elementor.templates.setFilter('order', reverseOrder ? 'desc' : 'asc');
    this.onClearBulkSelections();
    this.collection.reset();
    elementor.templates.layout.showLoadingView();
    elementor.templates.loadMore({
      onUpdate: function onUpdate() {
        elementor.templates.layout.hideLoadingView();
      },
      search: this.ui.textFilter.val(),
      refresh: true
    });
  },
  reverseOrder: function reverseOrder(comparator) {
    if ('function' !== typeof comparator) {
      var comparatorValue = comparator;
      comparator = function comparator(model) {
        return model.get(comparatorValue);
      };
    }
    return function (left, right) {
      var l = comparator(left);
      if (undefined === l) {
        return -1;
      }
      var r = comparator(right);
      if (undefined === r) {
        return 1;
      }
      if (l < r) {
        return 1;
      }
      if (l > r) {
        return -1;
      }
      return 0;
    };
  },
  addSourceData: function addSourceData() {
    var isEmpty = this.children.isEmpty();
    this.$el.attr('data-template-source', isEmpty ? 'empty' : elementor.templates.getFilter('source'));
  },
  addViewData: function addViewData() {
    var view = elementor.templates.getViewSelection();
    this.$el.attr('data-template-view', view);
  },
  setFiltersUI: function setFiltersUI() {
    if (!this.select2Instance && this.$(this.ui.selectFilter).length) {
      var $filters = this.$(this.ui.selectFilter),
        select2Options = {
          placeholder: __('Category', 'elementor'),
          allowClear: true,
          width: 150,
          dropdownParent: this.$el
        };
      this.select2Instance = new _select.default({
        $element: $filters,
        options: select2Options
      });
    }
  },
  setMasonrySkin: function setMasonrySkin() {
    var masonry = new elementorModules.utils.Masonry({
      container: this.$childViewContainer,
      items: this.$childViewContainer.children()
    });
    this.$childViewContainer.imagesLoaded(masonry.run.bind(masonry));
  },
  toggleFilterClass: function toggleFilterClass() {
    this.$el.toggleClass('elementor-templates-filter-active', !!(elementor.templates.getFilter('text') || elementor.templates.getFilter('favorite')));
  },
  isPageOrLandingPageTemplates: function isPageOrLandingPageTemplates() {
    var templatesType = elementor.templates.getFilter('type');
    return 'page' === templatesType || 'lp' === templatesType;
  },
  onDestroy: function onDestroy() {
    if (this.removeScrollListener) {
      this.removeScrollListener();
    }
  },
  onRender: function onRender() {
    elementor.templates.clearBulkSelectionItems();
    var activeSource = elementor.templates.getFilter('source');
    var templateType = elementor.templates.getFilter('type');
    if ('remote' === activeSource && 'page' !== templateType && 'lb' !== templateType) {
      this.setFiltersUI();
    }
    if ('cloud' === activeSource) {
      var isFolderView = elementor.templates.getFilter('parentId');
      var location = isFolderView ? elementor.editorEvents.config.secondaryLocations.templateLibrary.cloudTabFolder : elementor.editorEvents.config.secondaryLocations.templateLibrary.cloudTab;
      elementor.templates.eventManager.sendPageViewEvent({
        location: location
      });
      this.handleQuotaBar();
    }
    if ('local' === activeSource) {
      elementor.templates.eventManager.sendPageViewEvent({
        location: elementor.editorEvents.config.secondaryLocations.templateLibrary.siteTab
      });
    }
  },
  onRenderCollection: function onRenderCollection() {
    this.addSourceData();
    this.toggleFilterClass();
    var activeSource = elementor.templates.getFilter('source');
    if ('remote' === activeSource && !this.isPageOrLandingPageTemplates()) {
      this.setMasonrySkin();
    }
    if ('cloud' === activeSource) {
      this.handleLoadMore();
      this.addViewData();
      this.handleQuotaUpdate();
    }
  },
  onBeforeRenderEmpty: function onBeforeRenderEmpty() {
    this.addSourceData();
  },
  onTextFilterInput: function onTextFilterInput() {
    var activeSource = elementor.templates.getFilter('source');
    if (['cloud', 'local'].includes(activeSource)) {
      elementor.templates.clearBulkSelectionItems();
      elementor.templates.layout.handleBulkActionBar();
    }
    if ('cloud' === activeSource) {
      this.debouncedSearchTemplates(activeSource);
      return;
    }
    elementor.templates.setFilter('text', this.ui.textFilter.val());
  },
  searchTemplates: function searchTemplates(source) {
    var _this3 = this;
    return (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
      return _regenerator.default.wrap(function (_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            _this3.showLoadingSpinner();
            _context.prev = 1;
            _context.next = 2;
            return elementor.templates.searchTemplates({
              source: source,
              search: _this3.ui.textFilter.val()
            });
          case 2:
            _context.prev = 2;
            _this3.showSearchIcon();
            return _context.finish(2);
          case 3:
          case "end":
            return _context.stop();
        }
      }, _callee, null, [[1,, 2, 3]]);
    }))();
  },
  showLoadingSpinner: function showLoadingSpinner() {
    this.ui.searchInputIcon.removeClass('eicon-search').addClass('eicon-loading eicon-animation-spin');
  },
  showSearchIcon: function showSearchIcon() {
    this.ui.searchInputIcon.removeClass('eicon-loading eicon-animation-spin').addClass('eicon-search');
  },
  onSelectFilterChange: function onSelectFilterChange(event) {
    var $select = jQuery(event.currentTarget),
      filterName = $select.data('elementor-filter');
    elementor.templates.setFilter(filterName, $select.val());
  },
  onSelectSourceFilterChange: function onSelectSourceFilterChange(event) {
    elementor.templates.onSelectSourceFilterChange(event);
  },
  onSelectGridViewClick: function onSelectGridViewClick() {
    elementor.templates.onSelectViewChange('grid');
  },
  onSelectListViewClick: function onSelectListViewClick() {
    elementor.templates.onSelectViewChange('list');
  },
  onMyFavoritesFilterChange: function onMyFavoritesFilterChange() {
    elementor.templates.setFilter('favorite', this.ui.myFavoritesFilter[0].checked);
  },
  onOrderLabelsClick: function onOrderLabelsClick(event) {
    var $clickedInput = jQuery(event.currentTarget.control);
    var toggle;
    if (!$clickedInput[0].checked) {
      toggle = 'asc' !== $clickedInput.data('default-ordering-direction');
    } else {
      toggle = !$clickedInput.hasClass('elementor-template-library-order-reverse');
    }
    $clickedInput.prop('checked', true);
    $clickedInput.toggleClass('elementor-template-library-order-reverse', toggle);
    this.order($clickedInput.val(), toggle);
  },
  handleLoadMore: function handleLoadMore() {
    var _elementor,
      _this4 = this;
    if (this.removeScrollListener) {
      this.removeScrollListener();
    }
    var scrollableContainer = (_elementor = elementor) === null || _elementor === void 0 || (_elementor = _elementor.templates) === null || _elementor === void 0 || (_elementor = _elementor.layout) === null || _elementor === void 0 ? void 0 : _elementor.modal.getElements('message');
    var listener = function listener() {
      var scrollTop = scrollableContainer.scrollTop();
      var scrollHeight = scrollableContainer[0].scrollHeight;
      var clientHeight = scrollableContainer.outerHeight();
      var scrollPercentage = scrollTop / (scrollHeight - clientHeight) * 100;
      var canLoadMore = elementor.templates.canLoadMore() && !elementor.templates.isLoading();
      if (scrollPercentage < 90 || !canLoadMore) {
        return;
      }
      _this4.ui.loadMoreAnchor.toggleClass('elementor-visibility-hidden');
      elementor.templates.layout.selectAllCheckboxMinus();
      elementor.templates.loadMore({
        onUpdate: function onUpdate() {
          _this4.ui.loadMoreAnchor.toggleClass('elementor-visibility-hidden');
        },
        search: _this4.ui.textFilter.val()
      });
    };
    scrollableContainer.on('scroll', listener);
    this.removeScrollListener = function () {
      return scrollableContainer.off('scroll', listener);
    };
  },
  onCreateNewFolderClick: function onCreateNewFolderClick() {
    var activeSource = elementor.templates.getFilter('source');
    if ('cloud' !== activeSource) {
      return;
    }
    elementor.templates.createFolder({
      source: activeSource
    }, {
      onSuccess: function onSuccess() {
        $e.routes.refreshContainer('library');
      }
    });
  },
  onHoverBulkAction: function onHoverBulkAction() {
    if (this.hasFolderInBulkSelection() || this.hasLockedTemplatesInBulkSelection()) {
      this.ui.bulkMove.find('i').css('cursor', 'not-allowed');
      this.ui.bulkCopy.find('i').css('cursor', 'not-allowed');
    } else {
      this.ui.bulkMove.find('i').css('cursor', 'pointer');
      this.ui.bulkCopy.find('i').css('cursor', 'pointer');
    }
  },
  onClickBulkMove: function onClickBulkMove() {
    if (this.hasFolderInBulkSelection() || this.hasLockedTemplatesInBulkSelection()) {
      return;
    }
    $e.route('library/save-template', {
      model: this.model,
      context: _constants.SAVE_CONTEXTS.BULK_MOVE
    });
  },
  hasFolderInBulkSelection: function hasFolderInBulkSelection() {
    var bulkSelectedItems = elementor.templates.getBulkSelectionItems();
    return this.collection.some(function (model) {
      var templateId = model.get('template_id');
      var type = model.get('type');
      return bulkSelectedItems.has(templateId) && 'folder' === type;
    });
  },
  hasLockedTemplatesInBulkSelection: function hasLockedTemplatesInBulkSelection() {
    var bulkSelectedItems = elementor.templates.getBulkSelectionItems();
    return this.collection.some(function (model) {
      var templateId = model.get('template_id');
      return bulkSelectedItems.has(templateId) && model.isLocked();
    });
  },
  onClickBulkCopy: function onClickBulkCopy() {
    if (this.hasFolderInBulkSelection() || this.hasLockedTemplatesInBulkSelection()) {
      return;
    }
    $e.route('library/save-template', {
      model: this.model,
      context: _constants.SAVE_CONTEXTS.BULK_COPY
    });
  },
  onQuotaUpgradeClicked: function onQuotaUpgradeClicked() {
    var _elementorAppConfig2;
    var quota = (_elementorAppConfig2 = elementorAppConfig) === null || _elementorAppConfig2 === void 0 || (_elementorAppConfig2 = _elementorAppConfig2['cloud-library']) === null || _elementorAppConfig2 === void 0 ? void 0 : _elementorAppConfig2.quota;
    var value = quota ? Math.round(quota.currentUsage / quota.threshold * 100) : 0;
    elementor.templates.eventManager.sendUpgradeClickedEvent({
      secondaryLocation: elementor.editorEvents.config.secondaryLocations.templateLibrary.quotaBar,
      upgrade_position: "quota bar ".concat(value ? value + '%' : '')
    });
  }
});
module.exports = TemplateLibraryCollectionView;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/template/base.js":
/*!**********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/template/base.js ***!
  \**********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var TemplateLibraryInsertTemplateBehavior = __webpack_require__(/*! elementor-templates/behaviors/insert-template */ "../assets/dev/js/editor/components/template-library/behaviors/insert-template.js");
var _require = __webpack_require__(/*! elementor-utils/tiers */ "../assets/dev/js/utils/tiers.js"),
  isTierAtLeast = _require.isTierAtLeast,
  TIERS = _require.TIERS;
var TemplateLibraryTemplateView = Marionette.ItemView.extend({
  className: function className() {
    var classes = 'elementor-template-library-template';
    var source = this.model.get('source');
    classes += ' elementor-template-library-template-' + source;
    if ('remote' === source) {
      classes += ' elementor-template-library-template-' + this.model.get('type');
    }
    if (elementor.config.library_connect.base_access_tier !== this.model.get('accessTier')) {
      classes += ' elementor-template-library-pro-template';
    }
    return elementor.hooks.applyFilters('elementor/editor/template-library/template/classes', classes, this);
  },
  attributes: function attributes() {
    var userAccessTier = elementor.config.library_connect.current_access_tier;
    var templateAccessTier = this.model.get('accessTier');
    var canDownloadTemplate = isTierAtLeast(userAccessTier, templateAccessTier);

    // User with access to the template shouldn't see the badge.
    if (canDownloadTemplate) {
      return {};
    }
    var subscriptionPlans = elementor.config.library_connect.subscription_plans;
    var subscriptionPlan = subscriptionPlans[templateAccessTier];

    // Free user should see a generic "Pro" badge.
    if (userAccessTier === TIERS.free) {
      subscriptionPlan = subscriptionPlans.essential;
    }
    if (!subscriptionPlan) {
      return {};
    }
    return {
      style: "--elementor-template-library-subscription-plan-label: \"".concat(subscriptionPlan.label, "\";--elementor-template-library-subscription-plan-color: ").concat(subscriptionPlan.color, ";")
    };
  },
  ui: function ui() {
    return {
      previewButton: '.elementor-template-library-template-preview'
    };
  },
  events: function events() {
    return {
      'click @ui.previewButton': 'onPreviewButtonClick'
    };
  },
  behaviors: function behaviors() {
    var behaviors = {
      insertTemplate: {
        behaviorClass: TemplateLibraryInsertTemplateBehavior
      }
    };
    return elementor.hooks.applyFilters('elementor/editor/template-library/template/behaviors', behaviors, this);
  }
});
module.exports = TemplateLibraryTemplateView;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/template/cloud.js":
/*!***********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/template/cloud.js ***!
  \***********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var TemplateLibraryTemplateLocalView = __webpack_require__(/*! elementor-templates/views/template/local */ "../assets/dev/js/editor/components/template-library/views/template/local.js"),
  TemplateLibraryTemplateCloudView;
TemplateLibraryTemplateCloudView = TemplateLibraryTemplateLocalView.extend({
  className: function className() {
    var view = elementor.templates.getViewSelection(),
      subType = 'FOLDER' === this.model.get('subType') ? 'folder' : 'template';
    var classes = TemplateLibraryTemplateLocalView.prototype.className.apply(this, arguments);
    classes += ' elementor-template-library-template-view-' + view;
    classes += ' elementor-template-library-template-type-' + subType;
    return classes;
  },
  attributes: function attributes() {
    if ('grid' === elementor.templates.getViewSelection()) {
      var data = this.model.toJSON();
      return {
        'data-template_id': data.template_id,
        'data-type': data.type,
        'data-status': data.status
      };
    }
  },
  ui: function ui() {
    return _.extend(TemplateLibraryTemplateLocalView.prototype.ui.apply(this, arguments), {
      previewImg: '.elementor-template-library-template-thumbnail img'
    });
  },
  modelEvents: _.extend({}, TemplateLibraryTemplateLocalView.prototype.modelEvents, {
    'change:preview_url': 'onPreviewUrlChange'
  }),
  onRender: function onRender() {
    var previewUrl = this.model.get('preview_url');
    if (this.shouldGeneratePreview()) {
      this.iframe = elementor.templates.layout.createScreenshotIframe(this.model.get('generate_preview_url'));
      this.isGeneratingPreview = true;
    }
    if (previewUrl) {
      this.updatePreviewImgStyle();
    }
  },
  onPreviewUrlChange: function onPreviewUrlChange() {
    var previewUrl = this.model.get('preview_url');
    this.isGeneratingPreview = false;
    if (previewUrl) {
      this.ui.previewImg.attr('src', previewUrl);
      this.updatePreviewImgStyle();
      this.model.set('generate_preview_url', null);
      this.iframe.remove();
    }
  },
  updatePreviewImgStyle: function updatePreviewImgStyle() {
    this.ui.previewImg.css('object-fit', 'contain');
  },
  shouldGeneratePreview: function shouldGeneratePreview() {
    var view = elementor.templates.getViewSelection();
    return 'FOLDER' !== this.model.get('subType') && this.model.get('generate_preview_url') && !this.model.get('preview_url') && 'grid' === view && !this.isGeneratingPreview;
  },
  onPreviewButtonClick: function onPreviewButtonClick(event) {
    event.stopPropagation();
    if ('FOLDER' === this.model.get('subType')) {
      $e.route('library/view-folder', {
        model: this.model,
        onAfter: function onAfter() {
          elementor.templates.resetBulkActionBar();
        }
      });
    }
    if ('TEMPLATE' === this.model.get('subType')) {
      this.handleGridViewItemSingleClick();
    }
  },
  onDeleteButtonClick: function onDeleteButtonClick(event) {
    event.stopPropagation();
    if ('FOLDER' === this.model.get('subType')) {
      this.handleDeleteFolderClick();
      return;
    }
    TemplateLibraryTemplateLocalView.prototype.onDeleteButtonClick.apply(this, arguments);
  },
  handleDeleteFolderClick: function handleDeleteFolderClick() {
    var toggleMoreIcon = this.ui.toggleMoreIcon;
    elementor.templates.deleteFolder(this.model, {
      onConfirm: function onConfirm() {
        toggleMoreIcon.removeClass('eicon-ellipsis-h').addClass('eicon-loading eicon-animation-spin');
      },
      onSuccess: function onSuccess() {
        $e.routes.refreshContainer('library');
      }
    });
  },
  handleItemSingleClick: function handleItemSingleClick() {
    if ('grid' === elementor.templates.getViewSelection()) {
      this.handleGridViewItemSingleClick();
    } else {
      this.handleListViewItemSingleClick();
    }
  },
  handleItemDoubleClick: function handleItemDoubleClick() {
    if ('FOLDER' === this.model.get('subType')) {
      $e.route('library/view-folder', {
        model: this.model,
        onAfter: function onAfter() {
          elementor.templates.resetBulkActionBar();
        }
      });
    }
  },
  handleGridViewItemSingleClick: function handleGridViewItemSingleClick() {
    var itemIsSelected = this.$el.hasClass('bulk-selected-item');
    if (itemIsSelected) {
      elementor.templates.removeBulkSelectionItem(this.model.get('template_id'));
    } else {
      elementor.templates.addBulkSelectionItem(this.model.get('template_id'));
    }
    this.$el.toggleClass('bulk-selected-item');
    elementor.templates.layout.handleBulkActionBar();
  }
});
module.exports = TemplateLibraryTemplateCloudView;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/template/local.js":
/*!***********************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/template/local.js ***!
  \***********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _constants = __webpack_require__(/*! ./../../constants */ "../assets/dev/js/editor/components/template-library/constants.js");
var TemplateLibraryTemplateView = __webpack_require__(/*! elementor-templates/views/template/base */ "../assets/dev/js/editor/components/template-library/views/template/base.js");
var TemplateLibraryTemplateLocalView = TemplateLibraryTemplateView.extend({
  template: '#tmpl-elementor-template-library-template-local',
  ui: function ui() {
    return _.extend(TemplateLibraryTemplateView.prototype.ui.apply(this, arguments), {
      bulkSelectionItemCheckbox: '.bulk-selection-item-checkbox',
      deleteButton: '.elementor-template-library-template-delete',
      renameButton: '.elementor-template-library-template-rename',
      moveButton: '.elementor-template-library-template-move',
      copyButton: '.elementor-template-library-template-copy',
      exportButton: '.elementor-template-library-template-export',
      morePopup: '.elementor-template-library-template-more',
      toggleMore: '.elementor-template-library-template-more-toggle',
      toggleMoreIcon: '.elementor-template-library-template-more-toggle i',
      titleCell: '.elementor-template-library-template-name span',
      resourceIcon: '.elementor-template-library-template-name i'
    });
  },
  events: function events() {
    return _.extend(TemplateLibraryTemplateView.prototype.events.apply(this, arguments), {
      click: 'handleItemClicked',
      'change @ui.bulkSelectionItemCheckbox': 'onSelectBulkSelectionItemCheckbox',
      'click @ui.deleteButton': 'onDeleteButtonClick',
      'click @ui.toggleMore': 'onToggleMoreClick',
      'click @ui.renameButton': 'onRenameClick',
      'click @ui.moveButton': 'onMoveClick',
      'click @ui.copyButton': 'onCopyClick',
      'click @ui.exportButton': 'onExportClick'
    });
  },
  modelEvents: {
    'change:title': 'onTitleChange'
  },
  handleLockedTemplate: function handleLockedTemplate() {
    var isLocked = this.model.isLocked();
    this.ui.renameButton.toggleClass('disabled', isLocked);
    this.ui.moveButton.toggleClass('disabled', isLocked);
    this.ui.copyButton.toggleClass('disabled', isLocked);
    this.ui.exportButton.toggleClass('disabled', isLocked);
  },
  onTitleChange: function onTitleChange() {
    var title = _.escape(this.model.get('title'));
    this.ui.titleCell.text(title);
  },
  handleItemClicked: function handleItemClicked(event) {
    var _this = this;
    if (event.target.closest('.bulk-selection-item-checkbox')) {
      return; // Ignore clicks from checkbox
    }
    if (!this._clickState) {
      this._clickState = {
        timeoutId: null,
        delay: 250
      };
    }
    var state = this._clickState;
    if (state.timeoutId) {
      clearTimeout(state.timeoutId);
      state.timeoutId = null;
      this.handleItemDoubleClick();
    } else {
      state.timeoutId = setTimeout(function () {
        state.timeoutId = null;
        _this.handleItemSingleClick();
      }, state.delay);
    }
  },
  handleItemSingleClick: function handleItemSingleClick() {
    this.handleListViewItemSingleClick();
  },
  handleItemDoubleClick: function handleItemDoubleClick() {},
  handleListViewItemSingleClick: function handleListViewItemSingleClick() {
    var checkbox = this.ui.bulkSelectionItemCheckbox;
    var isChecked = checkbox.prop('checked');
    checkbox.prop('checked', !isChecked).trigger('change');
  },
  onDeleteButtonClick: function onDeleteButtonClick(event) {
    event.stopPropagation();
    var toggleMoreIcon = this.ui.toggleMoreIcon;
    elementor.templates.deleteTemplate(this.model, {
      onConfirm: function onConfirm() {
        toggleMoreIcon.removeClass('eicon-ellipsis-h').addClass('eicon-loading eicon-animation-spin');
      }
    });
  },
  onToggleMoreClick: function onToggleMoreClick(event) {
    event.stopPropagation();
    this.handleLockedTemplate();
    this.ui.morePopup.show();
    elementor.templates.eventManager.sendPageViewEvent({
      location: elementor.editorEvents.config.secondaryLocations.templateLibrary.morePopup
    });
  },
  onPreviewButtonClick: function onPreviewButtonClick(event) {
    event.stopPropagation();
    open(this.model.get('url'), '_blank');
  },
  onRenameClick: function onRenameClick(event) {
    var _this2 = this;
    return (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
      return _regenerator.default.wrap(function (_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            event.stopPropagation();
            if (!_this2.model.isLocked()) {
              _context.next = 1;
              break;
            }
            return _context.abrupt("return");
          case 1:
            _context.prev = 1;
            _context.next = 2;
            return elementor.templates.renameTemplate(_this2.model, {
              onConfirm: function onConfirm() {
                return _this2.showToggleMoreLoader();
              }
            });
          case 2:
            _context.prev = 2;
            _this2.hideToggleMoreLoader();
            return _context.finish(2);
          case 3:
          case "end":
            return _context.stop();
        }
      }, _callee, null, [[1,, 2, 3]]);
    }))();
  },
  onMoveClick: function onMoveClick() {
    if (this.model.isLocked()) {
      return;
    }
    $e.route('library/save-template', {
      model: this.model,
      context: _constants.SAVE_CONTEXTS.MOVE
    });
  },
  onCopyClick: function onCopyClick() {
    if (this.model.isLocked()) {
      return;
    }
    $e.route('library/save-template', {
      model: this.model,
      context: _constants.SAVE_CONTEXTS.COPY
    });
  },
  onExportClick: function onExportClick(e) {
    e.stopPropagation();
    if (this.model.isLocked()) {
      e.preventDefault();
    }
  },
  showToggleMoreLoader: function showToggleMoreLoader() {
    this.ui.toggleMoreIcon.removeClass('eicon-ellipsis-h').addClass('eicon-loading eicon-animation-spin');
  },
  hideToggleMoreLoader: function hideToggleMoreLoader() {
    this.ui.toggleMoreIcon.addClass('eicon-ellipsis-h').removeClass('eicon-loading eicon-animation-spin');
  },
  onSelectBulkSelectionItemCheckbox: function onSelectBulkSelectionItemCheckbox(event) {
    var _event$target;
    event.stopPropagation();
    if (event !== null && event !== void 0 && (_event$target = event.target) !== null && _event$target !== void 0 && _event$target.checked) {
      elementor.templates.addBulkSelectionItem(event.target.dataset.template_id);
      this.$el.addClass('bulk-selected-item');
    } else {
      elementor.templates.removeBulkSelectionItem(event.target.dataset.template_id);
      this.$el.removeClass('bulk-selected-item');
    }
    elementor.templates.layout.handleBulkActionBarUi();
  }
});
module.exports = TemplateLibraryTemplateLocalView;

/***/ }),

/***/ "../assets/dev/js/editor/components/template-library/views/template/remote.js":
/*!************************************************************************************!*\
  !*** ../assets/dev/js/editor/components/template-library/views/template/remote.js ***!
  \************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var TemplateLibraryTemplateView = __webpack_require__(/*! elementor-templates/views/template/base */ "../assets/dev/js/editor/components/template-library/views/template/base.js"),
  TemplateLibraryTemplateRemoteView;
TemplateLibraryTemplateRemoteView = TemplateLibraryTemplateView.extend({
  template: '#tmpl-elementor-template-library-template-remote',
  ui: function ui() {
    return jQuery.extend(TemplateLibraryTemplateView.prototype.ui.apply(this, arguments), {
      favoriteCheckbox: '.elementor-template-library-template-favorite-input'
    });
  },
  events: function events() {
    return jQuery.extend(TemplateLibraryTemplateView.prototype.events.apply(this, arguments), {
      'change @ui.favoriteCheckbox': 'onFavoriteCheckboxChange'
    });
  },
  onPreviewButtonClick: function onPreviewButtonClick(event) {
    event.stopPropagation();
    $e.route('library/preview', {
      model: this.model
    });
  },
  onFavoriteCheckboxChange: function onFavoriteCheckboxChange() {
    var isFavorite = this.ui.favoriteCheckbox[0].checked;
    this.model.set('favorite', isFavorite);
    elementor.templates.markAsFavorite(this.model, isFavorite);
    if (!isFavorite && elementor.templates.getFilter('favorite')) {
      elementor.channels.templates.trigger('filter:change');
    }
  }
});
module.exports = TemplateLibraryTemplateRemoteView;

/***/ }),

/***/ "../assets/dev/js/editor/components/validator/base.js":
/*!************************************************************!*\
  !*** ../assets/dev/js/editor/components/validator/base.js ***!
  \************************************************************/
/***/ ((module) => {

"use strict";


module.exports = elementorModules.Module.extend({
  errors: [],
  __construct: function __construct(settings) {
    var customValidationMethod = settings.customValidationMethod;
    if (customValidationMethod) {
      this.validationMethod = customValidationMethod;
    }
  },
  getDefaultSettings: function getDefaultSettings() {
    return {
      validationTerms: {}
    };
  },
  isValid: function isValid() {
    var validationErrors = this.validationMethod.apply(this, arguments);
    if (validationErrors.length) {
      this.errors = validationErrors;
      return false;
    }
    return true;
  },
  validationMethod: function validationMethod(newValue) {
    var validationTerms = this.getSettings('validationTerms'),
      errors = [];
    if (validationTerms.required) {
      if (!('' + newValue).length) {
        errors.push('Required value is empty');
      }
    }
    return errors;
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/components/validator/breakpoint.js":
/*!******************************************************************!*\
  !*** ../assets/dev/js/editor/components/validator/breakpoint.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var NumberValidator = __webpack_require__(/*! elementor-validator/number */ "../assets/dev/js/editor/components/validator/number.js");
var BreakpointValidator = exports["default"] = /*#__PURE__*/function (_NumberValidator) {
  function BreakpointValidator() {
    (0, _classCallCheck2.default)(this, BreakpointValidator);
    return _callSuper(this, BreakpointValidator, arguments);
  }
  (0, _inherits2.default)(BreakpointValidator, _NumberValidator);
  return (0, _createClass2.default)(BreakpointValidator, [{
    key: "getDefaultSettings",
    value: function getDefaultSettings() {
      return {
        validationTerms: {
          // Max width we allow in general
          max: 5120
        }
      };
    }

    /**
     * Get Panel Active Breakpoints
     *
     * Since the active kit used in the Site Settings panel could be a draft, we need to use the panel's active
     * breakpoints settings and not the elementorFrontend.config values (which come from the DB).
     *
     * @return {*} Object
     */
  }, {
    key: "getPanelActiveBreakpoints",
    value: function getPanelActiveBreakpoints() {
      var panelBreakpoints = elementor.documents.currentDocument.config.settings.settings.active_breakpoints.map(function (breakpointName) {
          return breakpointName.replace('viewport_', '');
        }),
        panelActiveBreakpoints = {};
      panelBreakpoints.forEach(function (breakpointName) {
        panelActiveBreakpoints[breakpointName] = elementorFrontend.config.responsive.breakpoints[breakpointName];
      });
      return panelActiveBreakpoints;
    }
  }, {
    key: "initBreakpointProperties",
    value: function initBreakpointProperties() {
      var _activeBreakpoints$br, _activeBreakpoints$br2;
      var validationTerms = this.getSettings('validationTerms'),
        activeBreakpoints = this.getPanelActiveBreakpoints(),
        breakpointKeys = Object.keys(activeBreakpoints);
      this.breakpointIndex = breakpointKeys.indexOf(validationTerms.breakpointName);
      this.topBreakpoint = (_activeBreakpoints$br = activeBreakpoints[breakpointKeys[this.breakpointIndex + 1]]) === null || _activeBreakpoints$br === void 0 ? void 0 : _activeBreakpoints$br.value;
      this.bottomBreakpoint = (_activeBreakpoints$br2 = activeBreakpoints[breakpointKeys[this.breakpointIndex - 1]]) === null || _activeBreakpoints$br2 === void 0 ? void 0 : _activeBreakpoints$br2.value;
    }
  }, {
    key: "validationMethod",
    value: function validationMethod(newValue) {
      var validationTerms = this.getSettings('validationTerms'),
        errors = NumberValidator.prototype.validationMethod.call(this, newValue);

      // Validate both numeric and empty values, since breakpoints utilize default values when empty.
      if (_.isFinite(newValue) || '' === newValue) {
        if (!this.validateMinMaxForBreakpoint(newValue, validationTerms)) {
          errors.push('Value is not between the breakpoints above or under the edited breakpoint');
        }
      }
      return errors;
    }
  }, {
    key: "validateMinMaxForBreakpoint",
    value: function validateMinMaxForBreakpoint(newValue, validationTerms) {
      var breakpointDefaultValue = elementorFrontend.config.responsive.breakpoints[validationTerms.breakpointName].default_value;
      var isValid = true;
      this.initBreakpointProperties();

      // Since the following comparison is <=, allow usage of the 320px value for the mobile breakpoint.
      if ('mobile' === validationTerms.breakpointName && 320 === this.bottomBreakpoint) {
        this.bottomBreakpoint -= 1;
      }

      // If there is a breakpoint below the currently edited breakpoint
      if (this.bottomBreakpoint) {
        // Check that the new value is not under the bottom breakpoint's value.
        if ('' !== newValue && newValue <= this.bottomBreakpoint) {
          isValid = false;
        }

        // If the new value is empty, check that the default breakpoint value is not below the bottom breakpoint.
        if ('' === newValue && breakpointDefaultValue <= this.bottomBreakpoint) {
          isValid = false;
        }
      }

      // If there is a breakpoint above the currently edited breakpoint.
      if (this.topBreakpoint) {
        // Check that the value is not above the top breakpoint's value.
        if ('' !== newValue && newValue >= this.topBreakpoint) {
          isValid = false;
        }

        // If the new value is empty, check that the default breakpoint value is not above the top breakpoint.
        if ('' === newValue && breakpointDefaultValue >= this.topBreakpoint) {
          isValid = false;
        }
      }
      return isValid;
    }
  }]);
}(NumberValidator);

/***/ }),

/***/ "../assets/dev/js/editor/components/validator/number.js":
/*!**************************************************************!*\
  !*** ../assets/dev/js/editor/components/validator/number.js ***!
  \**************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var Validator = __webpack_require__(/*! elementor-validator/base */ "../assets/dev/js/editor/components/validator/base.js");
module.exports = Validator.extend({
  validationMethod: function validationMethod(newValue) {
    var validationTerms = this.getSettings('validationTerms'),
      errors = [];
    if (_.isFinite(newValue)) {
      if (undefined !== validationTerms.min && newValue < validationTerms.min) {
        errors.push('Value is less than minimum');
      }
      if (undefined !== validationTerms.max && newValue > validationTerms.max) {
        errors.push('Value is greater than maximum');
      }
    }
    return errors;
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/container/model/children-array.js":
/*!*****************************************************************!*\
  !*** ../assets/dev/js/editor/container/model/children-array.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _wrapNativeSuper2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/wrapNativeSuper */ "../node_modules/@babel/runtime/helpers/wrapNativeSuper.js"));
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/**
 * @typedef {import('../container')} Container
 */
var ChildrenArray = exports["default"] = /*#__PURE__*/function (_Array) {
  function ChildrenArray() {
    (0, _classCallCheck2.default)(this, ChildrenArray);
    return _callSuper(this, ChildrenArray, arguments);
  }
  (0, _inherits2.default)(ChildrenArray, _Array);
  return (0, _createClass2.default)(ChildrenArray, [{
    key: "clear",
    value: function clear() {
      this.length = 0;
    }

    /**
     * Function findRecursive().
     *
     * Will run over children recursively and pass the children to the callback till the callback returns positive value.
     *
     * @param {function(Container) : *} callback
     *
     * @return {Container|false} child
     */
  }, {
    key: "findRecursive",
    value: function findRecursive(callback) {
      var _iterator = _createForOfIteratorHelper(this),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var container = _step.value;
          if (callback(container)) {
            return container;
          }
          if (container.children.length) {
            var foundChildren = container.children.findRecursive(callback);
            if (foundChildren) {
              return foundChildren;
            }
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      return false;
    }

    /**
     * Function forEachRecursive().
     *
     * Will run over children recursively.
     *
     * @param {function(Container) : *} callback
     *
     * @return {void}
     */
  }, {
    key: "forEachRecursive",
    value: function forEachRecursive(callback) {
      var _iterator2 = _createForOfIteratorHelper(this),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var container = _step2.value;
          callback(container);
          if (container.children.length) {
            container.children.forEachRecursive(callback);
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }

    /**
     * Function someRecursive().
     *
     * Will run over children recursively, breaks if the callback return true.
     *
     * @param {function(Container) : *} callback
     */
  }, {
    key: "someRecursive",
    value: function someRecursive(callback) {
      var _iterator3 = _createForOfIteratorHelper(this),
        _step3;
      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var _container$children;
          var container = _step3.value;
          if (callback(container)) {
            return true;
          }
          if ((_container$children = container.children) !== null && _container$children !== void 0 && _container$children.length) {
            if (container.children.someRecursive(callback)) {
              return true;
            }
          }
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }
      return false;
    }
  }]);
}(/*#__PURE__*/(0, _wrapNativeSuper2.default)(Array));

/***/ }),

/***/ "../assets/dev/js/editor/controls/base-data.js":
/*!*****************************************************!*\
  !*** ../assets/dev/js/editor/controls/base-data.js ***!
  \*****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _breakpoint = _interopRequireDefault(__webpack_require__(/*! elementor-validator/breakpoint */ "../assets/dev/js/editor/components/validator/breakpoint.js"));
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
var ControlBaseView = __webpack_require__(/*! elementor-controls/base */ "../assets/dev/js/editor/controls/base.js"),
  TagsBehavior = __webpack_require__(/*! elementor-dynamic-tags/control-behavior */ "../assets/dev/js/editor/components/dynamic-tags/control-behavior.js"),
  Validator = __webpack_require__(/*! elementor-validator/base */ "../assets/dev/js/editor/components/validator/base.js"),
  NumberValidator = __webpack_require__(/*! elementor-validator/number */ "../assets/dev/js/editor/components/validator/number.js"),
  ControlBaseDataView;
ControlBaseDataView = ControlBaseView.extend({
  validatorTypes: {
    Base: Validator,
    Number: NumberValidator,
    Breakpoint: _breakpoint.default
  },
  ui: function ui() {
    var ui = ControlBaseView.prototype.ui.apply(this, arguments);
    _.extend(ui, {
      input: 'input[data-setting][type!="checkbox"][type!="radio"]',
      checkbox: 'input[data-setting][type="checkbox"]',
      radio: 'input[data-setting][type="radio"]',
      select: 'select[data-setting]',
      textarea: 'textarea[data-setting]',
      responsiveSwitchersSibling: "".concat(ui.controlTitle, "[data-e-responsive-switcher-sibling!=\"false\"]"),
      responsiveSwitchers: '.elementor-responsive-switcher',
      contentEditable: '[contenteditable="true"]'
    });
    return ui;
  },
  templateHelpers: function templateHelpers() {
    var controlData = ControlBaseView.prototype.templateHelpers.apply(this, arguments);
    controlData.data.controlValue = this.getControlValue();
    return controlData;
  },
  events: function events() {
    return {
      'input @ui.input': 'onBaseInputTextChange',
      'change @ui.checkbox': 'onBaseInputChange',
      'change @ui.radio': 'onBaseInputChange',
      'input @ui.textarea': 'onBaseInputTextChange',
      'change @ui.select': 'onBaseInputChange',
      'input @ui.contentEditable': 'onBaseInputTextChange',
      'click @ui.responsiveSwitchers': 'onResponsiveSwitchersClick'
    };
  },
  behaviors: function behaviors() {
    var behaviors = ControlBaseView.prototype.behaviors.apply(this, arguments),
      dynamicSettings = this.options.model.get('dynamic');
    if (dynamicSettings && dynamicSettings.active) {
      var tags = _.filter(elementor.dynamicTags.getConfig('tags'), function (tag) {
        return tag.editable && _.intersection(tag.categories, dynamicSettings.categories).length;
      });
      if (tags.length || elementor.config.user.is_administrator) {
        behaviors.tags = {
          behaviorClass: TagsBehavior,
          tags: tags,
          dynamicSettings: dynamicSettings
        };
      }
    }
    return behaviors;
  },
  initialize: function initialize() {
    ControlBaseView.prototype.initialize.apply(this, arguments);
    this.registerValidators();
    if (this.model.get('responsive')) {
      this.setPlaceholderFromParent();
    }
    if (undefined === this.model.get('inherit_placeholders')) {
      this.model.set('inherit_placeholders', true);
    }

    // TODO: this.elementSettingsModel is deprecated since 2.8.0.
    var settings = this.container ? this.container.settings : this.elementSettingsModel;
    this.listenTo(settings, 'change:external:' + this.model.get('name'), this.onAfterExternalChange);
  },
  getControlValue: function getControlValue() {
    return this.container.settings.get(this.model.get('name'));
  },
  getGlobalKey: function getGlobalKey() {
    return this.container.globals.get(this.model.get('name'));
  },
  getGlobalValue: function getGlobalValue() {
    return this.globalValue;
  },
  getGlobalDefault: function getGlobalDefault() {
    var controlGlobalArgs = this.model.get('global');
    if (controlGlobalArgs !== null && controlGlobalArgs !== void 0 && controlGlobalArgs.default) {
      // If the control is a color/typography control and default colors/typography are disabled, don't return the global value.
      if (!elementor.config.globals.defaults_enabled[this.getGlobalMeta().controlType]) {
        return '';
      }
      var _$e$data$commandExtra = $e.data.commandExtractArgs(controlGlobalArgs.default),
        command = _$e$data$commandExtra.command,
        args = _$e$data$commandExtra.args,
        result = $e.data.getCache($e.components.get('globals'), command, args.query);
      return result === null || result === void 0 ? void 0 : result.value;
    }

    // No global default.
    return '';
  },
  getCurrentValue: function getCurrentValue() {
    if (this.getGlobalKey() && !this.globalValue) {
      return '';
    }
    if (this.globalValue) {
      return this.globalValue;
    }
    var controlValue = this.getControlValue();
    if (controlValue) {
      return controlValue;
    }
    return this.getGlobalDefault();
  },
  isGlobalActive: function isGlobalActive() {
    var _this$options$model$g;
    return (_this$options$model$g = this.options.model.get('global')) === null || _this$options$model$g === void 0 ? void 0 : _this$options$model$g.active;
  },
  setValue: function setValue(value) {
    this.setSettingsModel(value);
  },
  setSettingsModel: function setSettingsModel(value) {
    var key = this.model.get('name');
    $e.run('document/elements/settings', {
      container: this.options.container,
      settings: (0, _defineProperty2.default)({}, key, value)
    });
    this.triggerMethod('settings:change');
  },
  applySavedValue: function applySavedValue() {
    this.setInputValue('[data-setting="' + this.model.get('name') + '"]', this.getControlValue());
  },
  getEditSettings: function getEditSettings(setting) {
    var settings = this.getOption('elementEditSettings').toJSON();
    if (setting) {
      return settings[setting];
    }
    return settings;
  },
  setEditSetting: function setEditSetting(settingKey, settingValue) {
    var settings = this.getOption('elementEditSettings') || this.getOption('container').settings;
    settings.set(settingKey, settingValue);
  },
  /**
   * Get the placeholder for the current control.
   *
   * @return {*} placeholder
   */
  getControlPlaceholder: function getControlPlaceholder() {
    var placeholder = this.model.get('placeholder');
    if (this.model.get('responsive') && this.model.get('inherit_placeholders')) {
      placeholder = placeholder || this.container.placeholders[this.model.get('name')];
    }
    return placeholder;
  },
  /**
   * Get the responsive parent view if exists.
   *
   * @return {ControlBaseDataView|undefined} responsive parent view if exists
   */
  getResponsiveParentView: function getResponsiveParentView() {
    var parent = this.model.get('parent');
    try {
      return parent && this.container.panel.getControlView(parent);
      // eslint-disable-next-line no-empty
    } catch (e) {}
  },
  /**
   * Get the responsive children views if exists.
   *
   * @return {ControlBaseDataView|null} responsive children views if exists
   */
  getResponsiveChildrenViews: function getResponsiveChildrenViews() {
    var children = this.model.get('inheritors'),
      views = [];
    try {
      var _iterator = _createForOfIteratorHelper(children),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var child = _step.value;
          views.push(this.container.panel.getControlView(child));
        }
        // eslint-disable-next-line no-empty
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    } catch (e) {}
    return views;
  },
  /**
   * Get prepared placeholder from the responsive parent, and put it into current
   * control model as placeholder.
   */
  setPlaceholderFromParent: function setPlaceholderFromParent() {
    var parent = this.getResponsiveParentView();
    if (parent) {
      this.container.placeholders[this.model.get('name')] = parent.preparePlaceholderForChildren();
    }
  },
  /**
   * Returns the value of the current control if exists, or the parent value if not,
   * so responsive children can set it as their placeholder. When there are multiple
   * inputs, the inputs which are empty on this control will inherit their values
   * from the responsive parent.
   * For example, if on desktop the padding of all edges is 10, and on tablet only
   * padding right and left is set to 15, the mobile control placeholder will
   * eventually be: { top: 10, right: 15, left: 15, bottom: 10 }, because of the
   * inheritance of multiple values.
   *
   * @return {*} value of the current control if exists, or the parent value if not
   */
  preparePlaceholderForChildren: function preparePlaceholderForChildren() {
    var _this$getResponsivePa;
    var cleanValue = this.getCleanControlValue(),
      parentValue = (_this$getResponsivePa = this.getResponsiveParentView()) === null || _this$getResponsivePa === void 0 ? void 0 : _this$getResponsivePa.preparePlaceholderForChildren();
    if (cleanValue instanceof Object) {
      return Object.assign({}, parentValue, cleanValue);
    }
    return cleanValue || parentValue;
  },
  /**
   * Start the re-rendering recursive chain from the responsive child of this
   * control. It's useful when the current control value is changed and we want
   * to update all responsive children. In this case, the re-rendering is supposed
   * to be applied only from the responsive child of this control and on.
   */
  propagatePlaceholder: function propagatePlaceholder() {
    var children = this.getResponsiveChildrenViews();
    var _iterator2 = _createForOfIteratorHelper(children),
      _step2;
    try {
      for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
        var child = _step2.value;
        child.renderWithChildren();
      }
    } catch (err) {
      _iterator2.e(err);
    } finally {
      _iterator2.f();
    }
  },
  /**
   * Re-render current control and trigger this method on the responsive child.
   * The purpose of those actions is to recursively re-render all responsive
   * children.
   */
  renderWithChildren: function renderWithChildren() {
    this.render();
    this.propagatePlaceholder();
  },
  /**
   * Get control value without empty properties, and without default values.
   *
   * @return {{}} control value without empty properties, and without default values
   */
  getCleanControlValue: function getCleanControlValue() {
    var value = this.getControlValue();
    return value && value !== this.model.get('default') ? value : undefined;
  },
  onAfterChange: function onAfterChange(control) {
    if (Object.keys(control.changed).includes(this.model.get('name'))) {
      this.propagatePlaceholder();
    }
    ControlBaseView.prototype.onAfterChange.apply(this, arguments);
  },
  getInputValue: function getInputValue(input) {
    var $input = this.$(input);
    if ($input.is('[contenteditable="true"]')) {
      return $input.html();
    }
    var inputValue = $input.val(),
      inputType = $input.attr('type');
    if (-1 !== ['radio', 'checkbox'].indexOf(inputType)) {
      return $input.prop('checked') ? inputValue : '';
    }
    if ('number' === inputType && _.isFinite(inputValue)) {
      return +inputValue;
    }

    // Temp fix for jQuery (< 3.0) that return null instead of empty array
    if ('SELECT' === input.tagName && $input.prop('multiple') && null === inputValue) {
      inputValue = [];
    }
    return inputValue;
  },
  setInputValue: function setInputValue(input, value) {
    var $input = this.$(input),
      inputType = $input.attr('type');
    if ('checkbox' === inputType) {
      $input.prop('checked', !!value);
    } else if ('radio' === inputType) {
      $input.filter('[value="' + value + '"]').prop('checked', true);
    } else {
      $input.val(value);
    }
  },
  addValidator: function addValidator(validator) {
    this.validators.push(validator);
  },
  registerValidators: function registerValidators() {
    var _this = this;
    this.validators = [];
    var validationTerms = {};
    if (this.model.get('required')) {
      validationTerms.required = true;
    }
    if (!jQuery.isEmptyObject(validationTerms)) {
      this.addValidator(new this.validatorTypes.Base({
        validationTerms: validationTerms
      }));
    }
    var validators = this.model.get('validators');
    if (validators) {
      Object.entries(validators).forEach(function (_ref) {
        var _ref2 = (0, _slicedToArray2.default)(_ref, 2),
          key = _ref2[0],
          args = _ref2[1];
        _this.addValidator(new _this.validatorTypes[key]({
          validationTerms: args
        }));
      });
    }
  },
  onBeforeRender: function onBeforeRender() {
    this.setPlaceholderFromParent();
  },
  onRender: function onRender() {
    ControlBaseView.prototype.onRender.apply(this, arguments);
    if (this.model.get('responsive')) {
      this.renderResponsiveSwitchers();
    }
    this.applySavedValue();
    this.triggerMethod('ready');
    this.toggleControlVisibility();
    this.addTooltip();
  },
  onBaseInputTextChange: function onBaseInputTextChange(event) {
    this.onBaseInputChange(event);
  },
  onBaseInputChange: function onBaseInputChange(event) {
    clearTimeout(this.correctionTimeout);
    var input = event.currentTarget,
      value = this.getInputValue(input),
      validators = this.validators.slice(0),
      settingsValidators = this.container.settings.validators[this.model.get('name')];
    if (settingsValidators) {
      validators = validators.concat(settingsValidators);
    }
    if (validators) {
      var oldValue = this.getControlValue(input.dataset.setting);
      var isValidValue = validators.every(function (validator) {
        return validator.isValid(value, oldValue);
      });
      if (!isValidValue) {
        this.correctionTimeout = setTimeout(this.setInputValue.bind(this, input, oldValue), 1200);
        return;
      }
    }
    this.updateElementModel(value, input);
    this.triggerMethod('input:change', event);
  },
  onResponsiveSwitchersClick: function onResponsiveSwitchersClick(event) {
    var $switcher = jQuery(event.currentTarget),
      device = $switcher.data('device'),
      $switchersWrapper = this.ui.responsiveSwitchersWrapper,
      selectedOption = $switcher.index();
    $switchersWrapper.toggleClass('elementor-responsive-switchers-open');
    $switchersWrapper[0].style.setProperty('--selected-option', selectedOption);
    this.triggerMethod('responsive:switcher:click', device);
    elementor.changeDeviceMode(device);
  },
  renderResponsiveSwitchers: function renderResponsiveSwitchers() {
    var templateHtml = Marionette.Renderer.render('#tmpl-elementor-control-responsive-switchers', this.model.attributes);
    this.ui.responsiveSwitchersSibling.after(templateHtml);
    this.ui.responsiveSwitchersWrapper = this.$el.find('.elementor-control-responsive-switchers');
  },
  onAfterExternalChange: function onAfterExternalChange() {
    this.hideTooltip();
    this.applySavedValue();
  },
  addTooltip: function addTooltip() {
    this.ui.tooltipTargets = this.$el.find('.tooltip-target');
    if (!this.ui.tooltipTargets.length) {
      return;
    }

    // Create tooltip on controls
    this.ui.tooltipTargets.tipsy({
      gravity: function gravity() {
        // `n` for down, `s` for up
        var gravity = jQuery(this).data('tooltip-pos');
        if (undefined !== gravity) {
          return gravity;
        }
        return 's';
      },
      title: function title() {
        return this.getAttribute('data-tooltip');
      }
    });
  },
  hideTooltip: function hideTooltip() {
    if (this.ui.tooltipTargets.length) {
      this.ui.tooltipTargets.tipsy('hide');
    }
  },
  updateElementModel: function updateElementModel(value) {
    this.setValue(value);
  }
}, {
  // Static methods
  getStyleValue: function getStyleValue(placeholder, controlValue, controlData) {
    if ('DEFAULT' === placeholder) {
      return controlData.default;
    }
    return controlValue;
  },
  onPasteStyle: function onPasteStyle() {
    return true;
  }
});
module.exports = ControlBaseDataView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/base-multiple.js":
/*!*********************************************************!*\
  !*** ../assets/dev/js/editor/controls/base-multiple.js ***!
  \*********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js"),
  ControlBaseMultipleItemView;
ControlBaseMultipleItemView = ControlBaseDataView.extend({
  applySavedValue: function applySavedValue() {
    var values = this.getControlValue(),
      $inputs = this.$('[data-setting]'),
      self = this;
    _.each(values, function (value, key) {
      var $input = $inputs.filter(function () {
        return key === this.dataset.setting;
      });
      self.setInputValue($input, value);
    });
  },
  getControlValue: function getControlValue(key) {
    var values = this.container.settings.get(this.model.get('name'));
    if (!jQuery.isPlainObject(values)) {
      return {};
    }
    if (key) {
      var value = values[key];
      if (undefined === value) {
        value = '';
      }
      return value;
    }
    return elementorCommon.helpers.cloneObject(values);
  },
  /**
   * @inheritDoc
   */
  getCleanControlValue: function getCleanControlValue(key) {
    var _this = this;
    var values = Object.fromEntries(Object.entries(this.getControlValue()).filter(function (_ref) {
      var _ref2 = (0, _slicedToArray2.default)(_ref, 2),
        k = _ref2[0],
        v = _ref2[1];
      return v && _this.model.get('default')[k] !== v;
    }));
    if (key) {
      return values === null || values === void 0 ? void 0 : values[key];
    }
    return Object.keys(values).length ? values : undefined;
  },
  setValue: function setValue(key, value) {
    var values = this.getControlValue();
    if ('object' === (0, _typeof2.default)(key)) {
      _.each(key, function (internalValue, internalKey) {
        values[internalKey] = internalValue;
      });
    } else {
      values[key] = value;
    }
    this.setSettingsModel(values);
  },
  updateElementModel: function updateElementModel(value, input) {
    var key = input.dataset.setting;
    this.setValue(key, value);
  }
}, {
  // Static methods
  getStyleValue: function getStyleValue(placeholder, controlValue) {
    if (!_.isObject(controlValue)) {
      return ''; // Invalid
    }
    return controlValue[placeholder.toLowerCase()];
  }
});
module.exports = ControlBaseMultipleItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/base-units.js":
/*!******************************************************!*\
  !*** ../assets/dev/js/editor/controls/base-units.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
var ControlBaseMultipleItemView = __webpack_require__(/*! elementor-controls/base-multiple */ "../assets/dev/js/editor/controls/base-multiple.js"),
  ControlBaseUnitsItemView;
ControlBaseUnitsItemView = ControlBaseMultipleItemView.extend({
  ui: function ui() {
    return Object.assign(ControlBaseMultipleItemView.prototype.ui.apply(this, arguments), {
      units: '.e-units-choices>input',
      unitSwitcher: '.e-units-switcher',
      unitChoices: '.e-units-choices'
    });
  },
  events: function events() {
    return Object.assign(ControlBaseMultipleItemView.prototype.events.apply(this, arguments), {
      'change @ui.units': 'onUnitChange',
      'click @ui.units': 'onUnitClick',
      'click @ui.unitSwitcher': 'onUnitLabelClick'
    });
  },
  updatePlaceholder: function updatePlaceholder() {
    var _this$getControlPlace;
    var placeholder = (_this$getControlPlace = this.getControlPlaceholder()) === null || _this$getControlPlace === void 0 ? void 0 : _this$getControlPlace.unit;
    this.ui.units.removeClass('e-units-placeholder');
    var currentUnitSelected = this.getControlValue('unit');
    if (placeholder !== currentUnitSelected) {
      this.ui.units.filter("[value=\"".concat(placeholder, "\"]")).addClass('e-units-placeholder');
    }
  },
  recursiveUnitChange: function recursiveUnitChange() {
    var includingSelf = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
    var parent = this.getResponsiveParentView();
    if (parent && includingSelf) {
      var unit = parent.getControlValue('unit'),
        values = Object.keys(this.getCleanControlValue() || {});

      // Remove `unit` from values, so only control values are indicated.
      values.splice(values.indexOf('unit'), 1);

      // Only set the unit when no control values are already specified.
      if (unit && !values.length) {
        this.setValue('unit', unit);
        this.render();
      }
    }
    var _iterator = _createForOfIteratorHelper(this.getResponsiveChildrenViews()),
      _step;
    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var child = _step.value;
        child.recursiveUnitChange();
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
  },
  onRender: function onRender() {
    ControlBaseMultipleItemView.prototype.onRender.apply(this, arguments);
    this.updatePlaceholder();
    this.updateUnitChoices();
  },
  onUnitChange: function onUnitChange() {
    this.toggleUnitChoices(false);
    this.recursiveUnitChange(false);
    this.updatePlaceholder();
    this.updateUnitChoices();
  },
  toggleUnitChoices: function toggleUnitChoices(stateVal) {
    this.ui.unitChoices.toggleClass('e-units-choices-open', stateVal);
  },
  updateUnitChoices: function updateUnitChoices() {
    var unit = this.getControlValue('unit');
    this.ui.unitSwitcher.attr('data-selected', unit).find('span').html(unit);
    this.$el.toggleClass('e-units-custom', this.isCustomUnit());
  },
  onUnitClick: function onUnitClick() {
    this.toggleUnitChoices(false);
  },
  onUnitLabelClick: function onUnitLabelClick(event) {
    event.preventDefault();
    this.toggleUnitChoices();
  },
  getCurrentRange: function getCurrentRange() {
    return this.getUnitRange(this.getControlValue('unit'));
  },
  getUnitRange: function getUnitRange(unit) {
    var ranges = this.model.get('range');
    if (!ranges) {
      return false;
    }
    if (!ranges[unit]) {
      ranges[unit] = Object.values(ranges)[0];
    }
    return ranges[unit];
  },
  isCustomUnit: function isCustomUnit() {
    return 'custom' === this.getControlValue('unit');
  }
}, {
  // Static methods
  getStyleValue: function getStyleValue(placeholder, controlValue) {
    var returnValue = ControlBaseMultipleItemView.getStyleValue(placeholder, controlValue);
    if ('UNIT' === placeholder && 'custom' === returnValue) {
      returnValue = '__EMPTY__';
    }
    return returnValue;
  }
});
module.exports = ControlBaseUnitsItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/base.js":
/*!************************************************!*\
  !*** ../assets/dev/js/editor/controls/base.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var ControlBaseView;
ControlBaseView = Marionette.CompositeView.extend({
  ui: function ui() {
    return {
      controlTitle: '.elementor-control-title'
    };
  },
  behaviors: function behaviors() {
    var behaviors = {};
    return elementor.hooks.applyFilters('controls/base/behaviors', behaviors, this);
  },
  getBehavior: function getBehavior(name) {
    return this._behaviors[Object.keys(this.behaviors()).indexOf(name)];
  },
  className: function className() {
    // TODO: Any better classes for that?
    var classes = 'elementor-control elementor-control-' + this.model.get('name') + ' elementor-control-type-' + this.model.get('type'),
      modelClasses = this.model.get('classes'),
      responsive = this.model.get('responsive');
    if (!_.isEmpty(modelClasses)) {
      classes += ' ' + modelClasses;
    }
    if (!_.isEmpty(responsive)) {
      var responsiveControlName = responsive.max || responsive.min;
      classes += ' elementor-control-responsive-' + responsiveControlName;
    }
    return classes;
  },
  templateHelpers: function templateHelpers() {
    var controlData = {
      _cid: this.model.cid
    };
    return {
      view: this,
      data: _.extend({}, this.model.toJSON(), controlData)
    };
  },
  getTemplate: function getTemplate() {
    return Marionette.TemplateCache.get('#tmpl-elementor-control-' + this.model.get('type') + '-content');
  },
  initialize: function initialize(options) {
    var label = this.model.get('label');

    // TODO: Temp backwards compatibility. since 2.8.0.
    Object.defineProperty(this, 'container', {
      get: function get() {
        if (!options.container) {
          var settingsModel = options.elementSettingsModel,
            view = $e.components.get('document').utils.findViewById(settingsModel.id);

          // Element control.
          if (view && view.getContainer) {
            options.container = view.getContainer();
          } else {
            if (!settingsModel.id) {
              settingsModel.id = 'bc-' + elementorCommon.helpers.getUniqueId();
            }

            // Document/General/Other control.
            options.container = new elementorModules.editor.Container({
              type: 'bc-container',
              id: settingsModel.id,
              model: settingsModel,
              settings: settingsModel,
              label: label,
              view: false,
              parent: false,
              renderer: false,
              controls: settingsModel.options.controls
            });
          }
        }
        return options.container;
      }
    });

    // Use `defineProperty` because `get elementSettingsModel()` fails during the `Marionette.CompositeView.extend`.
    Object.defineProperty(this, 'elementSettingsModel', {
      get: function get() {
        elementorDevTools.deprecation.deprecated('elementSettingsModel', '2.8.0', 'container.settings');
        return options.container ? options.container.settings : options.elementSettingsModel;
      }
    });
    var controlType = this.model.get('type'),
      controlSettings = jQuery.extend(true, {}, elementor.config.controls[controlType], this.model.attributes);
    this.model.set(controlSettings);

    // TODO: this.elementSettingsModel is deprecated since 2.8.0.
    var settings = this.container ? this.container.settings : this.elementSettingsModel;
    this.listenTo(settings, 'change', this.onAfterChange);
    if (this.model.attributes.responsive) {
      this.onDeviceModeChange = this.onDeviceModeChange.bind(this);
      elementor.listenTo(elementor.channels.deviceMode, 'change', this.onDeviceModeChange);
    }
  },
  onDestroy: function onDestroy() {
    elementor.stopListening(elementor.channels.deviceMode, 'change', this.onDeviceModeChange);
  },
  onDeviceModeChange: function onDeviceModeChange() {
    this.toggleControlVisibility();
  },
  onAfterChange: function onAfterChange() {
    this.toggleControlVisibility();
  },
  toggleControlVisibility: function toggleControlVisibility() {
    // TODO: this.elementSettingsModel is deprecated since 2.8.0.
    var settings = this.container ? this.container.settings : this.elementSettingsModel;
    var isVisible = elementor.helpers.isActiveControl(this.model, settings.attributes, settings.controls);
    this.$el.toggleClass('elementor-hidden-control', !isVisible);
    elementor.getPanelView().updateScrollbar();
  },
  onRender: function onRender() {
    var layoutType = this.model.get('label_block') ? 'block' : 'inline',
      showLabel = this.model.get('show_label'),
      elClasses = 'elementor-label-' + layoutType;
    elClasses += ' elementor-control-separator-' + this.model.get('separator');
    if (!showLabel) {
      elClasses += ' elementor-control-hidden-label';
    }
    this.$el.addClass(elClasses);
    this.toggleControlVisibility();
  },
  reRoute: function reRoute(controlActive) {
    $e.route($e.routes.getCurrent('panel'), this.getControlInRouteArgs(controlActive ? this.getControlPath() : ''), {
      history: false
    });
  },
  getControlInRouteArgs: function getControlInRouteArgs(path) {
    return _objectSpread(_objectSpread({}, $e.routes.getCurrentArgs('panel')), {}, {
      activeControl: path
    });
  },
  getControlPath: function getControlPath() {
    var controlPath = this.model.get('name'),
      parent = this._parent;
    while (!parent.$el.hasClass('elementor-controls-stack')) {
      var parentName = parent.model.get('name') || parent.model.get('_id');
      controlPath = parentName + '/' + controlPath;
      parent = parent._parent;
    }
    return controlPath;
  }
});
module.exports = ControlBaseView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/behaviors/scrubbing.js":
/*!***************************************************************!*\
  !*** ../assets/dev/js/editor/controls/behaviors/scrubbing.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _uiStates = __webpack_require__(/*! elementor-document/ui-states */ "../assets/dev/js/editor/document/ui-states/index.js");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var SCRUB_REGULAR = 'UPDATE-VALUE';
var SCRUB_ENHANCED = 'UPDATE-VALUE-ENHANCED';
var SKIP_SCRUB = 'SKIP-UPDATE-VALUE';
var Scrubbing = exports["default"] = /*#__PURE__*/function (_Marionette$Behavior) {
  function Scrubbing() {
    var _this;
    (0, _classCallCheck2.default)(this, Scrubbing);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, Scrubbing, [].concat(args));
    (0, _defineProperty2.default)(_this, "checkIntentTimeout", null);
    (0, _defineProperty2.default)(_this, "skipperCount", 0);
    var userOptions = _this.getOption('scrubSettings') || {};
    _this.scrubSettings = _objectSpread({
      intentTime: 600,
      skipperSteps: 10,
      valueModifier: 1,
      enhancedNumber: 10,
      scrubbingActiveClass: 'e-scrubbing--active',
      scrubbingOverClass: 'e-scrubbing-over'
    }, userOptions);
    return _this;
  }
  (0, _inherits2.default)(Scrubbing, _Marionette$Behavior);
  return (0, _createClass2.default)(Scrubbing, [{
    key: "ui",
    value: function ui() {
      return {
        input: 'input[type=number]',
        label: 'label[for^="elementor-control-"]'
      };
    }
  }, {
    key: "events",
    value: function events() {
      return {
        'mousedown @ui.input': 'onMouseDownInput',
        'mousedown @ui.label': 'onMouseDownLabel',
        'mouseenter @ui.label': 'onMouseEnterLabel',
        'mouseleave @ui.label': 'onMouseLeaveLabel'
      };
    }
  }, {
    key: "scrub",
    value: function scrub(input, movementEvent) {
      var movementType = this.getMovementType(movementEvent);
      if (SKIP_SCRUB === movementType) {
        return;
      }
      switch (movementType) {
        case SCRUB_REGULAR:
          input.value = this.getModifiedValue({
            value: input.value,
            change: movementEvent.movementX,
            modifier: this.scrubSettings.valueModifier
          });
          break;
        case SCRUB_ENHANCED:
          input.value = this.getModifiedValue({
            value: input.value,
            change: movementEvent.movementX,
            modifier: this.scrubSettings.enhancedNumber
          });
          break;
        default:
          break;
      }

      // Fire an input event so other behaviors/validators can handle the new input
      input.dispatchEvent(new Event('input', {
        bubbles: true
      }));
    }
  }, {
    key: "getMovementType",
    value: function getMovementType(movementEvent) {
      if (movementEvent.altKey) {
        this.skipperCount++;

        // When ALT key is pressed, skipping x times before updating input value.
        // 'skipperSteps' defines the exact times to skip, can be changed to any number.
        if (this.skipperCount <= this.scrubSettings.skipperSteps) {
          return SKIP_SCRUB;
        }
        this.skipperCount = 0;
        return SCRUB_REGULAR;
      }
      return movementEvent.ctrlKey || movementEvent.metaKey ? SCRUB_ENHANCED : SCRUB_REGULAR;
    }
  }, {
    key: "getModifiedValue",
    value: function getModifiedValue(_ref) {
      var value = _ref.value,
        change = _ref.change,
        modifier = _ref.modifier;
      if ('function' === typeof modifier) {
        modifier = modifier();
      }
      var newValue = +value + change * modifier;

      // Prevent cases where the value resolves to something like 1.0000000000000001.
      return parseFloat(newValue.toFixed(1));
    }
  }, {
    key: "isInputValidForScrubbing",
    value: function isInputValidForScrubbing(input) {
      return input && !input.disabled && 'number' === input.type;
    }

    /**
     * @param {HTMLElement[]} elements
     */
  }, {
    key: "setActive",
    value: function setActive(elements) {
      var _this2 = this;
      elements.forEach(function (element) {
        element.classList.add(_this2.scrubSettings.scrubbingActiveClass);
      });
    }

    /**
     * @param {HTMLElement[]} elements
     */
  }, {
    key: "setInactive",
    value: function setInactive(elements) {
      var _this3 = this;
      elements.forEach(function (element) {
        element.classList.remove(_this3.scrubSettings.scrubbingActiveClass);
      });
    }
  }, {
    key: "onMouseDownInput",
    value: function onMouseDownInput(e) {
      var _this4 = this;
      var input = e.target;
      if (!this.isInputValidForScrubbing(input)) {
        return;
      }
      var trackMovement = function trackMovement(movementEvent) {
        _this4.scrub(input, movementEvent);
      };

      // For input, scrubbing effect works only after X time the mouse is down.
      var checkIntentTimeout = setTimeout(function () {
        clearTimeout(checkIntentTimeout);
        document.addEventListener('mousemove', trackMovement);
        $e.uiStates.set('document/scrubbing-mode', _uiStates.ScrubbingMode.ON);
        _this4.setActive([input]);
      }, this.scrubSettings.intentTime);
      document.addEventListener('mouseup', function () {
        document.removeEventListener('mousemove', trackMovement);
        clearTimeout(checkIntentTimeout);
        $e.uiStates.remove('document/scrubbing-mode');
        _this4.setInactive([input]);
      }, {
        once: true
      });
    }
  }, {
    key: "onMouseDownLabel",
    value: function onMouseDownLabel(e) {
      var _this5 = this;
      var label = e.target;
      var input = e.target.control;
      if (!this.isInputValidForScrubbing(input)) {
        return;
      }
      $e.uiStates.set('document/scrubbing-mode', _uiStates.ScrubbingMode.ON);
      this.setActive([input, label]);
      var trackMovement = function trackMovement(movementEvent) {
        _this5.scrub(input, movementEvent);
      };
      document.addEventListener('mousemove', trackMovement);
      document.addEventListener('mouseup', function () {
        document.removeEventListener('mousemove', trackMovement);
        $e.uiStates.remove('document/scrubbing-mode');
        _this5.setInactive([input, label]);
      }, {
        once: true
      });
    }
  }, {
    key: "onMouseEnterLabel",
    value: function onMouseEnterLabel(e) {
      var input = e.target.control;
      if (!this.isInputValidForScrubbing(input)) {
        return;
      }
      e.target.classList.add(this.scrubSettings.scrubbingOverClass);
    }
  }, {
    key: "onMouseLeaveLabel",
    value: function onMouseLeaveLabel(e) {
      var input = e.target.control;
      if (!this.isInputValidForScrubbing(input)) {
        return;
      }
      e.target.classList.remove(this.scrubSettings.scrubbingOverClass);
    }
  }]);
}(Marionette.Behavior);

/***/ }),

/***/ "../assets/dev/js/editor/controls/box-shadow.js":
/*!******************************************************!*\
  !*** ../assets/dev/js/editor/controls/box-shadow.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _colorPicker = _interopRequireDefault(__webpack_require__(/*! ../utils/color-picker */ "../assets/dev/js/editor/utils/color-picker.js"));
var ControlMultipleBaseItemView = __webpack_require__(/*! elementor-controls/base-multiple */ "../assets/dev/js/editor/controls/base-multiple.js"),
  ControlBoxShadowItemView;
ControlBoxShadowItemView = ControlMultipleBaseItemView.extend({
  ui: function ui() {
    var ui = ControlMultipleBaseItemView.prototype.ui.apply(this, arguments);
    ui.sliders = '.elementor-slider';
    ui.colorPickerPlaceholder = '.elementor-color-picker-placeholder';
    return ui;
  },
  initSliders: function initSliders() {
    var _this = this;
    var value = this.getControlValue();
    this.ui.sliders.each(function (index, slider) {
      var $input = jQuery(slider).next('.elementor-slider-input').find('input');
      var sliderInstance = noUiSlider.create(slider, {
        start: [value[slider.dataset.input]],
        step: 1,
        range: {
          min: +$input.attr('min'),
          max: +$input.attr('max')
        },
        format: {
          to: function to(sliderValue) {
            return +sliderValue.toFixed(1);
          },
          from: function from(sliderValue) {
            return +sliderValue;
          }
        }
      });
      sliderInstance.on('slide', function (values) {
        var type = sliderInstance.target.dataset.input;
        $input.val(values[0]);
        _this.setValue(type, values[0]);
      });
    });
  },
  initColors: function initColors() {
    var _this2 = this;
    this.colorPicker = new _colorPicker.default({
      picker: {
        el: this.ui.colorPickerPlaceholder[0],
        default: this.getControlValue('color')
      },
      onChange: function onChange() {
        _this2.setValue('color', _this2.colorPicker.getColor());
      },
      onClear: function onClear() {
        _this2.setValue('color', '');
      }
    });
  },
  onInputChange: function onInputChange(event) {
    var type = event.currentTarget.dataset.setting,
      $slider = this.ui.sliders.filter('[data-input="' + type + '"]');
    $slider[0].noUiSlider.set(this.getControlValue(type));
  },
  onReady: function onReady() {
    this.initSliders();
    this.initColors();
  },
  onBeforeDestroy: function onBeforeDestroy() {
    this.colorPicker.destroy();
  }
});
module.exports = ControlBoxShadowItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/button.js":
/*!**************************************************!*\
  !*** ../assets/dev/js/editor/controls/button.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlBaseView = __webpack_require__(/*! elementor-controls/base */ "../assets/dev/js/editor/controls/base.js");
module.exports = ControlBaseView.extend({
  ui: function ui() {
    var ui = ControlBaseView.prototype.ui.apply(this, arguments);
    ui.button = 'button';
    return ui;
  },
  events: {
    'click @ui.button': 'onButtonClick'
  },
  onButtonClick: function onButtonClick() {
    var eventName = this.model.get('event');
    elementor.channels.editor.trigger(eventName, this);
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/controls/choose.js":
/*!**************************************************!*\
  !*** ../assets/dev/js/editor/controls/choose.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js"),
  ControlChooseItemView;
ControlChooseItemView = ControlBaseDataView.extend({
  ui: function ui() {
    var ui = ControlBaseDataView.prototype.ui.apply(this, arguments);
    ui.inputs = '[type="radio"]';
    return ui;
  },
  events: function events() {
    return _.extend(ControlBaseDataView.prototype.events.apply(this, arguments), {
      'mousedown label': 'onMouseDownLabel',
      'click @ui.inputs': 'onClickInput',
      'change @ui.inputs': 'onBaseInputChange'
    });
  },
  updatePlaceholder: function updatePlaceholder() {
    var placeholder = this.getControlPlaceholder();
    if (!this.getControlValue() && placeholder) {
      // Find the input which has value equals to the placeholder (which is the parent's value),
      // and add it a placeholder class, to indicate which value is selected in the parent.
      this.ui.inputs.filter("[value=\"".concat(this.getControlPlaceholder(), "\"]")).addClass('e-choose-placeholder');
    } else {
      this.ui.inputs.removeClass('e-choose-placeholder');
    }
  },
  onReady: function onReady() {
    this.updatePlaceholder();
  },
  applySavedValue: function applySavedValue() {
    var currentValue = this.getControlValue();
    if (currentValue) {
      this.ui.inputs.filter('[value="' + currentValue + '"]').prop('checked', true);
    } else {
      this.ui.inputs.filter(':checked').prop('checked', false);
    }
  },
  onMouseDownLabel: function onMouseDownLabel(event) {
    var $clickedLabel = this.$(event.currentTarget),
      $selectedInput = this.$('#' + $clickedLabel.attr('for'));
    $selectedInput.data('checked', $selectedInput.prop('checked'));
  },
  onClickInput: function onClickInput(event) {
    if (!this.model.get('toggle')) {
      return;
    }
    var $selectedInput = this.$(event.currentTarget);
    if ($selectedInput.data('checked')) {
      $selectedInput.prop('checked', false).trigger('change');
    }
  },
  onBaseInputChange: function onBaseInputChange() {
    ControlBaseDataView.prototype.onBaseInputChange.apply(this, arguments);
    this.updatePlaceholder();
  }
}, {
  onPasteStyle: function onPasteStyle(control, clipboardValue) {
    return '' === clipboardValue || undefined !== control.options[clipboardValue];
  }
});
module.exports = ControlChooseItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/code.js":
/*!************************************************!*\
  !*** ../assets/dev/js/editor/controls/code.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js"),
  ControlCodeEditorItemView;
ControlCodeEditorItemView = ControlBaseDataView.extend({
  ui: function ui() {
    var ui = ControlBaseDataView.prototype.ui.apply(this, arguments);
    ui.editor = '.elementor-code-editor';
    return ui;
  },
  onReady: function onReady() {
    var self = this;
    if ('undefined' === typeof ace) {
      return;
    }
    var langTools = ace.require('ace/ext/language_tools'),
      uiTheme = elementor.settings.editorPreferences.model.get('ui_theme'),
      userPrefersDark = matchMedia('(prefers-color-scheme: dark)').matches;
    self.editor = ace.edit(this.ui.editor[0]);

    // Since the code control is wrapped with a dynamic div, the class elementor-control-tag-area need to be had dynamically to handle the dynamic tag functionality.
    jQuery(self.editor.container).addClass('e-input-style elementor-code-editor elementor-control-tag-area');
    self.editor.setOptions({
      mode: 'ace/mode/' + self.model.attributes.language,
      minLines: 10,
      maxLines: Infinity,
      showGutter: true,
      useWorker: true,
      enableBasicAutocompletion: true,
      enableLiveAutocompletion: true
    });
    if ('dark' === uiTheme || 'auto' === uiTheme && userPrefersDark) {
      self.editor.setTheme('ace/theme/merbivore_soft');
    }
    self.editor.getSession().setUseWrapMode(true);
    elementor.panel.$el.on('resize.aceEditor', self.onResize.bind(this));
    if ('css' === self.model.attributes.language) {
      var selectorCompleter = {
        getCompletions: function getCompletions(editor, session, pos, prefix, callback) {
          var list = [],
            token = session.getTokenAt(pos.row, pos.column);
          if (0 < prefix.length && 'selector'.match(prefix) && 'constant' === token.type) {
            list = [{
              name: 'selector',
              value: 'selector',
              score: 1,
              meta: 'Elementor'
            }];
          }
          callback(null, list);
        }
      };
      langTools.addCompleter(selectorCompleter);
    }
    self.editor.setValue(self.getControlValue(), -1); // -1 =  move cursor to the start

    if (this.isEditable()) {
      self.editor.on('change', function () {
        self.setValue(self.editor.getValue());
      });
    }
    if ('html' === self.model.attributes.language) {
      // Remove the `doctype` annotation
      var session = self.editor.getSession();
      session.on('changeAnnotation', function () {
        var annotations = session.getAnnotations() || [],
          annotationsLength = annotations.length,
          index = annotations.length;
        while (index--) {
          if (/doctype first\. Expected/.test(annotations[index].text)) {
            annotations.splice(index, 1);
          }
        }
        if (annotationsLength > annotations.length) {
          session.setAnnotations(annotations);
        }
      });
    }
  },
  onResize: function onResize() {
    this.editor.resize();
  },
  onDestroy: function onDestroy() {
    elementor.panel.$el.off('resize.aceEditor');
  },
  isEditable: function isEditable() {
    var isEditable = this.model.get('is_editable');
    return undefined !== isEditable ? isEditable : true;
  }
});
module.exports = ControlCodeEditorItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/color.js":
/*!*************************************************!*\
  !*** ../assets/dev/js/editor/controls/color.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _toConsumableArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "../node_modules/@babel/runtime/helpers/toConsumableArray.js"));
var _readOnlyError2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/readOnlyError */ "../node_modules/@babel/runtime/helpers/readOnlyError.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _baseData = _interopRequireDefault(__webpack_require__(/*! ./base-data */ "../assets/dev/js/editor/controls/base-data.js"));
var _colorPicker = _interopRequireDefault(__webpack_require__(/*! ../utils/color-picker */ "../assets/dev/js/editor/utils/color-picker.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, o, e, r) { var p = (0, _get2.default)((0, _getPrototypeOf2.default)(1 & r ? t.prototype : t), o, e); return 2 & r && "function" == typeof p ? function (t) { return p.apply(e, t); } : p; }
var _default = exports["default"] = /*#__PURE__*/function (_ControlBaseDataView) {
  function _default() {
    (0, _classCallCheck2.default)(this, _default);
    return _callSuper(this, _default, arguments);
  }
  (0, _inherits2.default)(_default, _ControlBaseDataView);
  return (0, _createClass2.default)(_default, [{
    key: "ui",
    value: function ui() {
      var ui = _superPropGet(_default, "ui", this, 3)([]);
      ui.pickerContainer = '.elementor-color-picker-placeholder';
      return ui;
    }
  }, {
    key: "applySavedValue",
    value: function applySavedValue() {
      // Gets the current OR default value of the control.
      var currentValue = this.getCurrentValue();
      if (this.colorPicker) {
        // When there is a global set on the control but there is no value/it doesn't exist, don't show a value.
        if (currentValue) {
          var _this$colorPicker$pic;
          // Set the picker color without triggering the 'onChange' event.
          var parsedColor = this.colorPicker.picker._parseLocalColor(currentValue);
          (_this$colorPicker$pic = this.colorPicker.picker).setHSVA.apply(_this$colorPicker$pic, (0, _toConsumableArray2.default)(parsedColor.values).concat([false]));
        } else {
          this.colorPicker.picker._clearColor(true);
        }
      } else {
        this.initPicker();
      }
      this.$el.toggleClass('e-control-color--no-value', !currentValue);
    }
  }, {
    key: "initPicker",
    value: function initPicker() {
      var _this$model$get,
        _this = this;
      var options = {
        picker: {
          el: this.ui.pickerContainer[0],
          default: this.getCurrentValue(),
          components: {
            opacity: this.model.get('alpha')
          },
          defaultRepresentation: 'HEX'
        },
        // Don't create the add button in the Global Settings color pickers.
        addButton: (_this$model$get = this.model.get('global')) === null || _this$model$get === void 0 ? void 0 : _this$model$get.active,
        onChange: function onChange() {
          return _this.onPickerChange();
        },
        onClear: function onClear() {
          return _this.onPickerClear();
        },
        onAddButtonClick: function onAddButtonClick() {
          return _this.onAddGlobalButtonClick();
        },
        onPickerShow: function onPickerShow() {
          return _this.reRoute(true);
        },
        onPickerHide: function onPickerHide() {
          return _this.reRoute(false);
        }
      };
      this.colorPicker = new _colorPicker.default(options);
      this.hidePickerOnPreviewClick();
      this.$pickerButton = jQuery(this.colorPicker.picker.getRoot().button);
      this.addTipsyToPickerButton();
      this.addEyedropper();
      this.$pickerButton.on('click', function () {
        return _this.onPickerButtonClick();
      });
      jQuery(this.colorPicker.picker.getRoot().root).addClass('elementor-control-unit-1 elementor-control-tag-area');
    }
  }, {
    key: "hidePickerOnPreviewClick",
    value: function hidePickerOnPreviewClick() {
      var picker = this.colorPicker.picker;
      var pickerUtils = picker.constructor.utils;

      // Adding to the eventBindings to unbind in the picker's destroy
      picker._eventBindings.push(pickerUtils.on(elementorFrontend.elements.window.document, ['touchstart', 'pointerdown'], function () {
        if (picker.isOpen()) {
          picker.hide();
        }
      }));
    }
  }, {
    key: "addTipsyToPickerButton",
    value: function addTipsyToPickerButton() {
      var _this2 = this;
      this.$pickerButton.tipsy({
        title: function title() {
          var currentValue = _this2.getCurrentValue();

          // If there is a global enabled for the control, but the global has no value.
          if (_this2.getGlobalKey() && !currentValue) {
            currentValue = "".concat(__('Invalid Global Color', 'elementor'));
          }
          return currentValue || '';
        },
        offset: 4,
        gravity: function gravity() {
          return 's';
        }
      });
    }
  }, {
    key: "addEyedropper",
    value: function addEyedropper() {
      var _this3 = this;
      var $colorPicker = jQuery(Marionette.Renderer.render('#tmpl-elementor-control-element-color-picker')),
        $colorPickerToolsContainer = this.colorPicker.$pickerToolsContainer,
        container = this.getOption('container');
      var kit = null;

      // When it's a kit (i.e "Site Settings").
      if ('kit' === container.document.config.type) {
        kit = container.document;
      }

      // Add a tooltip to the Eye Dropper.
      $colorPicker.tipsy({
        title: function title() {
          return __('Color Sampler', 'elementor');
        },
        gravity: 's'
      });
      $colorPicker.on('click', function () {
        $e.run('elements-color-picker/start', {
          container: container,
          kit: kit,
          control: _this3.model.get('name'),
          trigger: $colorPicker[0]
        });
      });
      $colorPickerToolsContainer.append($colorPicker);
    }
  }, {
    key: "getGlobalMeta",
    value: function getGlobalMeta() {
      return {
        commandName: this.getGlobalCommand(),
        key: this.model.get('name'),
        controlType: 'colors',
        route: 'panel/global/global-colors'
      };
    }
  }, {
    key: "getNameAlreadyExistsMessage",
    value: function getNameAlreadyExistsMessage() {
      return '<i class="eicon-info-circle"></i> ' + __('Please note that the same exact color already exists in your Global Colors list. Are you sure you want to create it?', 'elementor');
    }
  }, {
    key: "getConfirmTextMessage",
    value: function getConfirmTextMessage() {
      return __('Are you sure you want to create a new Global Color?', 'elementor');
    }
  }, {
    key: "getAddGlobalConfirmMessage",
    value: function getAddGlobalConfirmMessage(globalColors) {
      var colorTitle = __('New Global Color', 'elementor'),
        currentValue = this.getCurrentValue(),
        $message = jQuery('<div>', {
          class: 'e-global__confirm-message'
        }),
        $messageText = jQuery('<div>', {
          class: 'e-global__confirm-message-text'
        }),
        $inputWrapper = jQuery('<div>', {
          class: 'e-global__confirm-input-wrapper'
        }),
        $colorPreview = this.createColorPreviewBox(currentValue),
        $input = jQuery('<input>', {
          type: 'text',
          name: 'global-name',
          placeholder: colorTitle
        }).val(colorTitle);
      var messageContent;

      // Check if the color already exists in the global colors, and display an appropriate message.
      for (var _i = 0, _Object$values = Object.values(globalColors); _i < _Object$values.length; _i++) {
        var globalColor = _Object$values[_i];
        if (currentValue === globalColor.value) {
          messageContent = this.getNameAlreadyExistsMessage();
          break;
        } else if (colorTitle === globalColor.title) {
          messageContent = this.getConfirmTextMessage();
          break;
        } else {
          messageContent = __('Are you sure you want to create a new Global Color?', 'elementor');
        }
      }
      $messageText.html(messageContent);
      $inputWrapper.append($colorPreview, $input);
      $message.append($messageText, $inputWrapper);
      return $message;
    }
  }, {
    key: "getGlobalCommand",
    value: function getGlobalCommand() {
      return 'globals/colors';
    }

    // The globalData parameter is received from the Data API.
  }, {
    key: "createGlobalItemMarkup",
    value: function createGlobalItemMarkup(globalData) {
      var $color = jQuery('<div>', {
          class: 'e-global__preview-item e-global__color',
          'data-global-id': globalData.id
        }),
        $colorPreview = this.createColorPreviewBox(globalData.value),
        $colorTitle = jQuery('<span>', {
          class: 'e-global__color-title'
        }).html(_.escape(globalData.title)),
        $colorHex = jQuery('<span>', {
          class: 'e-global__color-hex'
        }).html(globalData.value);
      $color.append($colorPreview, $colorTitle, $colorHex);
      return $color;
    }
  }, {
    key: "createColorPreviewBox",
    value: function createColorPreviewBox(color) {
      var $colorPreviewContainer = jQuery('<div>', {
          class: 'e-global__color-preview-container'
        }),
        $colorPreviewColor = jQuery('<div>', {
          class: 'e-global__color-preview-color',
          style: 'background-color: ' + color
        }),
        $colorPreviewBg = jQuery('<div>', {
          class: 'e-global__color-preview-transparent-bg'
        });
      $colorPreviewContainer.append($colorPreviewBg, $colorPreviewColor);
      return $colorPreviewContainer;
    }
  }, {
    key: "getGlobalsList",
    value: function () {
      var _getGlobalsList = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
        var result;
        return _regenerator.default.wrap(function (_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 1;
              return $e.data.get(this.getGlobalCommand());
            case 1:
              result = _context.sent;
              return _context.abrupt("return", result.data);
            case 2:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function getGlobalsList() {
        return _getGlobalsList.apply(this, arguments);
      }
      return getGlobalsList;
    }() // Create the markup for the colors in the global select dropdown.
  }, {
    key: "buildGlobalsList",
    value: function buildGlobalsList(globalColors, $globalPreviewItemsContainer) {
      var _this4 = this;
      Object.values(globalColors).forEach(function (color) {
        if (!color.value) {
          return;
        }
        var $color = _this4.createGlobalItemMarkup(color);
        $globalPreviewItemsContainer.append($color);
      });
    }
  }, {
    key: "onPickerChange",
    value: function onPickerChange() {
      this.setValue(this.colorPicker.picker.getColor().toHEXA().toString());
      if (!this.isCustom) {
        this.triggerMethod('value:type:change');
        this.colorPicker.toggleClearButtonState(true);
        if (this.$el.hasClass('e-control-color--no-value')) {
          this.$el.removeClass('e-control-color--no-value');
        }
        this.isCustom = true;
      }
    }
  }, {
    key: "onPickerClear",
    value: function onPickerClear() {
      this.isCustom = false;

      // Empty the value saved in the control.
      this.setValue('');

      // Adjust the Global select box text according to the cleared value.
      this.triggerMethod('value:type:change');
      this.applySavedValue();
      this.colorPicker.toggleClearButtonState(false);
    }
  }, {
    key: "onPickerButtonClick",
    value: function onPickerButtonClick() {
      if (this.getGlobalKey()) {
        this.triggerMethod('unset:global:value');
      } else if (this.isGlobalActive() && !this.getControlValue() && this.getGlobalDefault()) {
        this.triggerMethod('unlink:global:default');
      }

      // If there is a value in the control, set the clear button to active, if not, deactivate it.
      this.colorPicker.toggleClearButtonState(!!this.getCurrentValue());
    }
  }, {
    key: "onAddGlobalButtonClick",
    value: function onAddGlobalButtonClick() {
      var _this5 = this;
      this.getGlobalsList().then(function (globalsList) {
        _this5.globalsList = globalsList;
        _this5.triggerMethod('add:global:to:list', _this5.getAddGlobalConfirmMessage(globalsList));
      });
    }
  }, {
    key: "activate",
    value: function activate() {
      this.colorPicker.picker.show();
    }
  }, {
    key: "onBeforeDestroy",
    value: function onBeforeDestroy() {
      if (this.colorPicker) {
        this.colorPicker.destroy();
      }
    }
  }]);
}(_baseData.default);

/***/ }),

/***/ "../assets/dev/js/editor/controls/date-time.js":
/*!*****************************************************!*\
  !*** ../assets/dev/js/editor/controls/date-time.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, o, e, r) { var p = (0, _get2.default)((0, _getPrototypeOf2.default)(1 & r ? t.prototype : t), o, e); return 2 & r && "function" == typeof p ? function (t) { return p.apply(e, t); } : p; }
var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js");
var _default = exports["default"] = /*#__PURE__*/function (_ControlBaseDataView) {
  function _default() {
    (0, _classCallCheck2.default)(this, _default);
    return _callSuper(this, _default, arguments);
  }
  (0, _inherits2.default)(_default, _ControlBaseDataView);
  return (0, _createClass2.default)(_default, [{
    key: "onReady",
    value: function onReady() {
      var options = _.extend({
        enableTime: true,
        minuteIncrement: 1
      }, this.model.get('picker_options'));
      this.ui.input.flatpickr(options);
    }
  }, {
    key: "onBaseInputChange",
    value: function onBaseInputChange() {
      var _this$model$get;
      _superPropGet(_default, "onBaseInputChange", this, 3)(arguments);
      if ((_this$model$get = this.model.get('validation')) !== null && _this$model$get !== void 0 && _this$model$get.date_time) {
        this.validateDateTime();
      }
    }
  }, {
    key: "validateDateTime",
    value: function validateDateTime() {
      var _this$model$get$date_ = this.model.get('validation').date_time,
        controlName = _this$model$get$date_.control_name,
        operator = _this$model$get$date_.operator;
      var startDate = this.options.container.settings.get(controlName);
      var endDate = this.ui.input.val();
      if (!startDate || !endDate) {
        return;
      }
      var startDateTimestamp = new Date(startDate).getTime();
      var endDateTimestamp = new Date(endDate).getTime();
      if (elementor.conditions.compare(startDateTimestamp, endDateTimestamp, operator)) {
        this.ui.input.val('');
      }
    }
  }, {
    key: "onBeforeDestroy",
    value: function onBeforeDestroy() {
      this.ui.input.flatpickr().destroy();
    }
  }]);
}(ControlBaseDataView);

/***/ }),

/***/ "../assets/dev/js/editor/controls/dimensions.js":
/*!******************************************************!*\
  !*** ../assets/dev/js/editor/controls/dimensions.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _scrubbing = _interopRequireDefault(__webpack_require__(/*! ./behaviors/scrubbing */ "../assets/dev/js/editor/controls/behaviors/scrubbing.js"));
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var ControlBaseUnitsItemView = __webpack_require__(/*! elementor-controls/base-units */ "../assets/dev/js/editor/controls/base-units.js"),
  ControlDimensionsItemView;
ControlDimensionsItemView = ControlBaseUnitsItemView.extend({
  behaviors: function behaviors() {
    var _this = this;
    return _objectSpread(_objectSpread({}, ControlBaseUnitsItemView.prototype.behaviors.apply(this)), {}, {
      Scrubbing: {
        behaviorClass: _scrubbing.default,
        scrubSettings: {
          intentTime: 800,
          valueModifier: function valueModifier() {
            var currentUnit = _this.getControlValue('unit');
            return ['rem', 'em'].includes(currentUnit) ? 0.1 : 1;
          },
          enhancedNumber: function enhancedNumber() {
            var currentUnit = _this.getControlValue('unit');
            return ['rem', 'em'].includes(currentUnit) ? 0.5 : 10;
          }
        }
      }
    });
  },
  ui: function ui() {
    var ui = ControlBaseUnitsItemView.prototype.ui.apply(this, arguments);
    ui.controls = '.elementor-control-dimension > input:enabled';
    ui.link = 'button.elementor-link-dimensions';
    return ui;
  },
  events: function events() {
    return _.extend(ControlBaseUnitsItemView.prototype.events.apply(this, arguments), {
      'click @ui.link': 'onLinkDimensionsClicked'
    });
  },
  // Default value must be 0, because the CSS generator (in dimensions) expects the 4 dimensions to be filled together (or all are empty).
  defaultDimensionValue: 0,
  initialize: function initialize() {
    ControlBaseUnitsItemView.prototype.initialize.apply(this, arguments);

    // TODO: Need to be in helpers, and not in variable
    this.model.set('allowed_dimensions', this.filterDimensions(this.model.get('allowed_dimensions')));
  },
  getPossibleDimensions: function getPossibleDimensions() {
    return ['top', 'right', 'bottom', 'left'];
  },
  filterDimensions: function filterDimensions(filter) {
    filter = filter || 'all';
    var dimensions = this.getPossibleDimensions();
    if ('all' === filter) {
      return dimensions;
    }
    if (!_.isArray(filter)) {
      if ('horizontal' === filter) {
        filter = ['right', 'left'];
      } else if ('vertical' === filter) {
        filter = ['top', 'bottom'];
      }
    }
    return filter;
  },
  onReady: function onReady() {
    var self = this,
      currentValue = self.getControlValue();
    if (!self.isLinkedDimensions()) {
      self.ui.link.addClass('unlinked');
      self.ui.controls.each(function (index, element) {
        var value = currentValue[element.dataset.setting];
        if (_.isEmpty(value)) {
          value = self.defaultDimensionValue;
        }
        self.$(element).val(value);
      });
    }
    self.fillEmptyDimensions();
  },
  updateDimensionsValue: function updateDimensionsValue() {
    var currentValue = {},
      dimensions = this.getPossibleDimensions(),
      $controls = this.ui.controls,
      defaultDimensionValue = this.defaultDimensionValue;
    dimensions.forEach(function (dimension) {
      var $element = $controls.filter('[data-setting="' + dimension + '"]');
      currentValue[dimension] = $element.length ? $element.val() : defaultDimensionValue;
    });
    this.setValue(currentValue);
  },
  fillEmptyDimensions: function fillEmptyDimensions() {
    var $controls = this.ui.controls,
      defaultDimensionValue = this.defaultDimensionValue;
    if (this.isLinkedDimensions()) {
      return;
    }
    var allowedDimensions = this.model.get('allowed_dimensions'),
      dimensions = this.getPossibleDimensions();
    dimensions.forEach(function (dimension) {
      var $element = $controls.filter('[data-setting="' + dimension + '"]'),
        isAllowedDimension = -1 !== _.indexOf(allowedDimensions, dimension);
      if (isAllowedDimension && $element.length && _.isEmpty($element.val())) {
        $element.val(defaultDimensionValue);
      }
    });
  },
  updateDimensions: function updateDimensions() {
    this.fillEmptyDimensions();
    this.updateDimensionsValue();
  },
  resetDimensions: function resetDimensions() {
    this.ui.controls.val('');
    this.updateDimensionsValue();
  },
  onInputChange: function onInputChange(event) {
    var _event$originalEvent;
    var inputSetting = event.target.dataset.setting;
    if ('unit' === inputSetting) {
      this.resetDimensions();
    }
    if (!_.contains(this.getPossibleDimensions(), inputSetting)) {
      return;
    }

    // When using input with type="number" and the user starts typing `-`, the actual value (`event.target.value`) is
    // an empty string. Since the user probably has the intention to insert a negative value, the methods below will
    // not be triggered. This will prevent updating the input again with an empty string.
    var hasIntentionForNegativeNumber = '-' === (event === null || event === void 0 || (_event$originalEvent = event.originalEvent) === null || _event$originalEvent === void 0 ? void 0 : _event$originalEvent.data) && !event.target.value;
    if (hasIntentionForNegativeNumber) {
      return;
    }
    if (this.isLinkedDimensions()) {
      var $thisControl = this.$(event.target);
      this.ui.controls.val($thisControl.val());
    }
    this.updateDimensions();
  },
  onLinkDimensionsClicked: function onLinkDimensionsClicked(event) {
    event.preventDefault();
    event.stopPropagation();
    this.ui.link.toggleClass('unlinked');
    this.setValue('isLinked', !this.ui.link.hasClass('unlinked'));
    if (this.isLinkedDimensions()) {
      // Set all controls value from the first control.
      this.ui.controls.val(this.ui.controls.eq(0).val());
    }
    this.updateDimensions();
  },
  isLinkedDimensions: function isLinkedDimensions() {
    return this.getControlValue('isLinked');
  },
  updateUnitChoices: function updateUnitChoices() {
    ControlBaseUnitsItemView.prototype.updateUnitChoices.apply(this, arguments);
    var inputType = 'number';
    if (this.isCustomUnit()) {
      inputType = 'text';
    }
    this.ui.controls.attr('type', inputType);
  }
});
module.exports = ControlDimensionsItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/font.js":
/*!************************************************!*\
  !*** ../assets/dev/js/editor/controls/font.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlSelect2View = __webpack_require__(/*! elementor-controls/select2 */ "../assets/dev/js/editor/controls/select2.js");
module.exports = ControlSelect2View.extend({
  $previewContainer: null,
  getSelect2Options: function getSelect2Options() {
    return {
      dir: elementorCommon.config.isRTL ? 'rtl' : 'ltr',
      templateSelection: this.fontPreviewTemplate,
      templateResult: this.fontPreviewTemplate
    };
  },
  onReady: function onReady() {
    var self = this;
    this.ui.select.select2(this.getSelect2Options());
    this.ui.select.on('select2:open', function () {
      self.$previewContainer = jQuery('.select2-results__options[role="tree"]:visible');
      // Load initial?
      setTimeout(function () {
        self.enqueueFontsInView();
      }, 100);

      // On search
      jQuery('input.select2-search__field:visible').on('keyup', function () {
        self.typeStopDetection.action.apply(self);
      });

      // On scroll
      self.$previewContainer.on('scroll', function () {
        self.scrollStopDetection.onScroll.apply(self);
      });
    });
  },
  typeStopDetection: {
    idle: 350,
    timeOut: null,
    action: function action() {
      var parent = this,
        self = this.typeStopDetection;
      clearTimeout(self.timeOut);
      self.timeOut = setTimeout(function () {
        parent.enqueueFontsInView();
      }, self.idle);
    }
  },
  scrollStopDetection: {
    idle: 350,
    timeOut: null,
    onScroll: function onScroll() {
      var parent = this,
        self = this.scrollStopDetection;
      clearTimeout(self.timeOut);
      self.timeOut = setTimeout(function () {
        parent.enqueueFontsInView();
      }, self.idle);
    }
  },
  enqueueFontsInView: function enqueueFontsInView() {
    var containerOffset = this.$previewContainer.offset(),
      top = containerOffset.top,
      bottom = top + this.$previewContainer.innerHeight(),
      fontsInView = [];
    this.$previewContainer.children().find('li:visible').each(function (index, font) {
      var $font = jQuery(font),
        offset = $font.offset();
      if (offset && offset.top > top && offset.top < bottom) {
        fontsInView.push($font);
      }
    });
    fontsInView.forEach(function (font) {
      var fontFamily = jQuery(font).find('span').html();
      elementor.helpers.enqueueFont(fontFamily, 'editor');
    });
  },
  fontPreviewTemplate: function fontPreviewTemplate(state) {
    if (!state.id) {
      return state.text;
    }
    return jQuery('<span>', {
      text: state.text,
      css: {
        'font-family': state.element.value.toString()
      }
    });
  },
  templateHelpers: function templateHelpers() {
    var helpers = ControlSelect2View.prototype.templateHelpers.apply(this, arguments),
      fonts = this.model.get('options');
    helpers.getFontsByGroups = function (groups) {
      var filteredFonts = {};
      _.each(fonts, function (fontType, fontName) {
        if (_.isArray(groups) && _.contains(groups, fontType) || fontType === groups) {
          filteredFonts[fontName] = fontName;
        }
      });
      return filteredFonts;
    };
    return helpers;
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/controls/gallery.js":
/*!***************************************************!*\
  !*** ../assets/dev/js/editor/controls/gallery.js ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var sprintf = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["sprintf"];
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _filesUploadHandler = _interopRequireDefault(__webpack_require__(/*! ../utils/files-upload-handler */ "../assets/dev/js/editor/utils/files-upload-handler.js"));
var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js"),
  ControlMediaItemView;
ControlMediaItemView = ControlBaseDataView.extend({
  ui: function ui() {
    var ui = ControlBaseDataView.prototype.ui.apply(this, arguments);
    ui.addImages = '.elementor-control-gallery-add';
    ui.clearGallery = '.elementor-control-gallery-clear';
    ui.galleryThumbnails = '.elementor-control-gallery-thumbnails';
    ui.status = '.elementor-control-gallery-status-title';
    // eslint-disable-next-line capitalized-comments
    // ui.warnings = '.elementor-control-media__warnings';
    ui.promotions = '.elementor-control-media__promotions';
    ui.promotions_dismiss = '.elementor-control-media__promotions .elementor-control-notice-dismiss';
    ui.promotions_action = '.elementor-control-media__promotions .elementor-control-notice-main-actions button';
    return ui;
  },
  events: function events() {
    return _.extend(ControlBaseDataView.prototype.events.apply(this, arguments), {
      'click @ui.addImages': 'onAddImagesClick',
      'click @ui.clearGallery': 'onClearGalleryClick',
      'click @ui.galleryThumbnails': 'onGalleryThumbnailsClick',
      'click @ui.promotions_dismiss': 'onPromotionDismiss',
      'click @ui.promotions_action': 'onPromotionAction',
      'keyup @ui.galleryThumbnails': 'onGalleryThumbnailsKeyPress'
    });
  },
  onReady: function onReady() {
    this.initRemoveDialog();
  },
  applySavedValue: function applySavedValue() {
    var _this = this;
    return (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
      var images, imagesCount, hasImages, imagesWithoutOptimization, promotionsAlwaysOn, hasPromotions, $galleryThumbnails, attachments;
      return _regenerator.default.wrap(function (_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            images = _this.getControlValue(), imagesCount = images.length, hasImages = !!imagesCount, imagesWithoutOptimization = 0, promotionsAlwaysOn = false;
            hasPromotions = _this.ui.promotions.length && !elementor.config.user.dismissed_editor_notices.includes(_this.getDismissPromotionEventName());
            _this.$el.toggleClass('elementor-gallery-has-images', hasImages).toggleClass('elementor-gallery-empty', !hasImages);
            $galleryThumbnails = _this.ui.galleryThumbnails;
            $galleryThumbnails.empty();

            /* Translators: %s: Selected images count. */
            _this.ui.status.text(hasImages ? sprintf(__('%s Images Selected', 'elementor'), imagesCount) : __('No Images Selected', 'elementor'));
            if (hasPromotions) {
              promotionsAlwaysOn = _this.ui.promotions.find('.elementor-control-notice').data('display') || false;
            }
            if (hasImages) {
              _context.next = 1;
              break;
            }
            return _context.abrupt("return");
          case 1:
            attachments = [];
            _this.getControlValue().forEach(function (image, thumbIndex) {
              var $thumbnail = jQuery('<img>', {
                class: 'elementor-control-gallery-thumbnail',
                src: image.url,
                alt: 'gallery-thumbnail-' + thumbIndex
              });
              $galleryThumbnails.append($thumbnail);
              var handleHints = function handleHints(attachment) {
                var hasAlt = _this.imageHasAlt(attachment);
                if (!hasAlt) {
                  $thumbnail.addClass('unoptimized__image');
                  // eslint-disable-next-line capitalized-comments
                  // imagesWithoutAlt += hasAlt ? 0 : 1;
                }
                if (hasPromotions && _this.imageNotOptimized(attachment)) {
                  imagesWithoutOptimization += 1;
                }
              };
              attachments.push(wp.media.attachment(image.id).fetch().then(handleHints));
            });

            // Ensure all attachments are fetched before updating the warnings
            _context.next = 2;
            return Promise.all(attachments).then(function () {
              // eslint-disable-next-line capitalized-comments
              // this.ui.warnings.toggle( !! imagesWithoutAlt );
              if (hasPromotions) {
                var showHints = promotionsAlwaysOn || !!imagesWithoutOptimization;
                _this.ui.promotions.toggle(showHints);
              }
            });
          case 2:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }))();
  },
  hasImages: function hasImages() {
    return !!this.getControlValue().length;
  },
  imageHasAlt: function imageHasAlt(attachment) {
    var _attachment$alt;
    var attachmentAlt = (attachment === null || attachment === void 0 || (_attachment$alt = attachment.alt) === null || _attachment$alt === void 0 ? void 0 : _attachment$alt.trim()) || '';
    return !!attachmentAlt;
  },
  imageNotOptimized: function imageNotOptimized(attachment) {
    var checks = {
      height: 1080,
      width: 1920,
      filesizeInBytes: 100000
    };
    return Object.keys(checks).some(function (key) {
      var value = attachment[key] || false;
      return value && value > checks[key];
    });
  },
  openFrame: function openFrame(action) {
    this.initFrame(action);
    this.frame.open();

    // Set params to trigger sanitizer
    if (_filesUploadHandler.default.isUploadEnabled('svg')) {
      _filesUploadHandler.default.setUploadTypeCaller(this.frame);
    }
  },
  initFrame: function initFrame(action) {
    var frameStates = {
      create: 'gallery',
      add: 'gallery-library',
      edit: 'gallery-edit'
    };
    var options = {
      frame: 'post',
      multiple: true,
      state: frameStates[action],
      button: {
        text: __('Insert Media', 'elementor')
      }
    };
    if (this.hasImages()) {
      options.selection = this.fetchSelection();
    }
    this.frame = wp.media(options);
    this.addSvgMimeType();

    // When a file is selected, run a callback.
    this.frame.on({
      update: this.select,
      'menu:render:default': this.menuRender,
      'content:render:browse': this.gallerySettings
    }, this);
  },
  addSvgMimeType: function addSvgMimeType() {
    if (!_filesUploadHandler.default.isUploadEnabled('svg')) {
      return;
    }

    // Add the SVG to the currently allowed extensions
    var oldExtensions = _wpPluploadSettings.defaults.filters.mime_types[0].extensions;
    this.frame.on('ready', function () {
      _wpPluploadSettings.defaults.filters.mime_types[0].extensions = oldExtensions + ',svg';
    });

    // Restore allowed upload extensions
    this.frame.on('close', function () {
      _wpPluploadSettings.defaults.filters.mime_types[0].extensions = oldExtensions;
    });
  },
  menuRender: function menuRender(view) {
    view.unset('insert');
    view.unset('featured-image');
  },
  gallerySettings: function gallerySettings(browser) {
    browser.sidebar.on('ready', function () {
      browser.sidebar.unset('gallery');
    });
  },
  fetchSelection: function fetchSelection() {
    var attachments = wp.media.query({
      orderby: 'post__in',
      order: 'ASC',
      type: 'image',
      perPage: -1,
      post__in: _.pluck(this.getControlValue(), 'id')
    });
    return new wp.media.model.Selection(attachments.models, {
      props: attachments.props.toJSON(),
      multiple: true
    });
  },
  /**
   * Callback handler for when an attachment is selected in the media modal.
   * Gets the selected image information, and sets it within the control.
   *
   * @param {Array<*>} selection
   */
  select: function select(selection) {
    var images = [];
    selection.each(function (image) {
      images.push({
        id: image.get('id'),
        url: image.get('url')
      });
    });
    this.setValue(images);
    this.applySavedValue();
  },
  onPromotionDismiss: function onPromotionDismiss() {
    this.dismissPromotion(this.getDismissPromotionEventName());
  },
  getDismissPromotionEventName: function getDismissPromotionEventName() {
    var _$dismissButton$;
    var $promotions = this.ui.promotions;
    var $dismissButton = $promotions.find('.elementor-control-notice-dismiss');
    // Remove listener
    $dismissButton.off('click');
    return ((_$dismissButton$ = $dismissButton[0]) === null || _$dismissButton$ === void 0 || (_$dismissButton$ = _$dismissButton$.dataset) === null || _$dismissButton$ === void 0 ? void 0 : _$dismissButton$.event) || false;
  },
  hidePromotion: function hidePromotion() {
    var eventName = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
    var $promotions = this.ui.promotions;
    $promotions.hide();
    if (!eventName) {
      eventName = this.getDismissPromotionEventName();
    }
    // Prevent opening the same promotion again in current editor session.
    elementor.config.user.dismissed_editor_notices.push(eventName);
  },
  onPromotionAction: function onPromotionAction(event) {
    var _JSON$parse = JSON.parse(event.target.closest('button').dataset.settings),
      _JSON$parse$action_ur = _JSON$parse.action_url,
      actionURL = _JSON$parse$action_ur === void 0 ? null : _JSON$parse$action_ur;
    if (actionURL) {
      window.open(actionURL, '_blank');
    }
    elementorCommon.ajax.addRequest('elementor_image_optimization_campaign', {
      data: {
        source: 'io-editor-gallery-install'
      }
    });
    this.hidePromotion();
  },
  dismissPromotion: function dismissPromotion(eventName) {
    var $promotions = this.ui.promotions;
    $promotions.hide();
    if (eventName) {
      elementorCommon.ajax.addRequest('dismissed_editor_notices', {
        data: {
          dismissId: eventName
        }
      });

      // Prevent opening the same promotion again in current editor session.
      elementor.config.user.dismissed_editor_notices.push(eventName);
    }
  },
  onBeforeDestroy: function onBeforeDestroy() {
    if (this.frame) {
      this.frame.off();
    }
    this.$el.remove();
  },
  clearGallery: function clearGallery() {
    this.setValue([]);
    this.applySavedValue();

    // eslint-disable-next-line capitalized-comments
    // this.ui.warnings.hide();

    if (this.ui.promotions) {
      this.ui.promotions.hide();
    }
  },
  initRemoveDialog: function initRemoveDialog() {
    var removeDialog;
    this.getRemoveDialog = function () {
      if (!removeDialog) {
        removeDialog = elementorCommon.dialogsManager.createWidget('confirm', {
          message: __('Are you sure you want to clear this gallery?', 'elementor'),
          headerMessage: __('Clear gallery', 'elementor'),
          strings: {
            confirm: __('Clear', 'elementor'),
            cancel: __('Cancel', 'elementor')
          },
          defaultOption: 'confirm',
          onConfirm: this.clearGallery.bind(this)
        });
      }
      return removeDialog;
    };
  },
  onAddImagesClick: function onAddImagesClick() {
    this.openFrame(this.hasImages() ? 'add' : 'create');
  },
  onClearGalleryClick: function onClearGalleryClick() {
    this.getRemoveDialog().show();
  },
  onGalleryThumbnailsClick: function onGalleryThumbnailsClick() {
    this.openFrame('edit');
  },
  onGalleryThumbnailsKeyPress: function onGalleryThumbnailsKeyPress(event) {
    var ENTER_KEY = 13,
      SPACE_KEY = 32;
    if (ENTER_KEY === event.which || SPACE_KEY === event.which) {
      this.onGalleryThumbnailsClick(event);
    }
  }
});
module.exports = ControlMediaItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/gaps.js":
/*!************************************************!*\
  !*** ../assets/dev/js/editor/controls/gaps.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js"));
// eslint-disable-next-line prefer-const
var ControlDimensionsView = __webpack_require__(/*! elementor-controls/dimensions */ "../assets/dev/js/editor/controls/dimensions.js"),
  ControlGapItemView;

// eslint-disable-next-line prefer-const
ControlGapItemView = ControlDimensionsView.extend({
  ui: function ui() {
    // eslint-disable-next-line prefer-const
    var ui = ControlDimensionsView.prototype.ui.apply(this, arguments);
    ui.controls = '.elementor-control-gap > input:enabled';
    ui.link = 'button.elementor-link-gaps';
    return ui;
  },
  getPossibleDimensions: function getPossibleDimensions() {
    return ['row', 'column'];
  },
  setValue: function setValue(key, value) {
    var values = this.getControlValue();
    if ('object' === (0, _typeof2.default)(key)) {
      _.each(key, function (internalValue, internalKey) {
        values[internalKey] = internalValue;
      });
    } else {
      values[key] = value;
    }
    var conversion = this.model.get('conversion_map');
    if (conversion && conversion.old_key && conversion.new_key) {
      values[conversion.old_key] = parseInt(values[conversion.new_key]);
    }
    this.setSettingsModel(values);
  },
  getControlValue: function getControlValue() {
    var valuesUpdated = ControlDimensionsView.prototype.getControlValue.apply(this, arguments);
    if (this.shouldUpdateGapsValues(valuesUpdated)) {
      valuesUpdated.column = '' + valuesUpdated.size;
      valuesUpdated.row = '' + valuesUpdated.size;
      valuesUpdated.isLinked = true;
    }
    return valuesUpdated;
  },
  shouldUpdateGapsValues: function shouldUpdateGapsValues(valuesUpdated) {
    return !!valuesUpdated.hasOwnProperty('size') && '' !== valuesUpdated.size && !valuesUpdated.hasOwnProperty('column');
  }
});
module.exports = ControlGapItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/hidden.js":
/*!**************************************************!*\
  !*** ../assets/dev/js/editor/controls/hidden.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _baseData = _interopRequireDefault(__webpack_require__(/*! ./base-data */ "../assets/dev/js/editor/controls/base-data.js"));
module.exports = _baseData.default.extend({}, {
  onPasteStyle: function onPasteStyle() {
    return false;
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/controls/icon.js":
/*!************************************************!*\
  !*** ../assets/dev/js/editor/controls/icon.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlSelect2View = __webpack_require__(/*! elementor-controls/select2 */ "../assets/dev/js/editor/controls/select2.js"),
  ControlIconView;
ControlIconView = ControlSelect2View.extend({
  initialize: function initialize() {
    ControlSelect2View.prototype.initialize.apply(this, arguments);
    this.filterIcons();
  },
  filterIcons: function filterIcons() {
    var icons = this.model.get('options'),
      include = this.model.get('include');
    if (include) {
      var filteredIcons = {};
      _.each(include, function (iconKey) {
        filteredIcons[iconKey] = icons[iconKey];
      });
      this.model.set('options', filteredIcons);
      return;
    }
    var exclude = this.model.get('exclude');
    if (exclude) {
      _.each(exclude, function (iconKey) {
        delete icons[iconKey];
      });
    }
  },
  iconsList: function iconsList(icon) {
    if (!icon.id) {
      return icon.text;
    }
    return jQuery('<span><i class="' + icon.id + '"></i> ' + icon.text + '</span>');
  },
  getSelect2Options: function getSelect2Options() {
    return {
      allowClear: true,
      templateResult: this.iconsList.bind(this),
      templateSelection: this.iconsList.bind(this)
    };
  }
});
module.exports = ControlIconView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/icons.js":
/*!*************************************************!*\
  !*** ../assets/dev/js/editor/controls/icons.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _readOnlyError2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/readOnlyError */ "../node_modules/@babel/runtime/helpers/readOnlyError.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _filesUploadHandler = _interopRequireDefault(__webpack_require__(/*! ../utils/files-upload-handler */ "../assets/dev/js/editor/utils/files-upload-handler.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, o, e, r) { var p = (0, _get2.default)((0, _getPrototypeOf2.default)(1 & r ? t.prototype : t), o, e); return 2 & r && "function" == typeof p ? function (t) { return p.apply(e, t); } : p; }
var ControlMultipleBaseItemView = __webpack_require__(/*! elementor-controls/base-multiple */ "../assets/dev/js/editor/controls/base-multiple.js");
var ControlIconsView = /*#__PURE__*/function (_ControlMultipleBaseI) {
  function ControlIconsView() {
    var _this;
    (0, _classCallCheck2.default)(this, ControlIconsView);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, ControlIconsView, [].concat(args));
    _this.cache = {
      loaded: false,
      dialog: false,
      enableClicked: false,
      fa4Mapping: false,
      migratedFlag: {}
    };
    _this.dataKeys = {
      migratedKey: '__fa4_migrated',
      fa4MigrationFlag: 'fa4compatibility'
    };
    return _this;
  }
  (0, _inherits2.default)(ControlIconsView, _ControlMultipleBaseI);
  return (0, _createClass2.default)(ControlIconsView, [{
    key: "enqueueIconFonts",
    value: function enqueueIconFonts(iconType) {
      var iconSetting = elementor.helpers.getIconLibrarySettings(iconType);
      if (false === iconSetting || !this.isMigrationAllowed()) {
        return;
      }
      if (iconSetting.enqueue) {
        iconSetting.enqueue.forEach(function (assetURL) {
          var versionAddedURL = "".concat(assetURL).concat(iconSetting !== null && iconSetting !== void 0 && iconSetting.ver ? '?ver=' + iconSetting.ver : '');
          elementor.helpers.enqueueEditorStylesheet(versionAddedURL);
          elementor.helpers.enqueuePreviewStylesheet(versionAddedURL);
        });
      }
      if (iconSetting.url) {
        var versionAddedURL = "".concat(iconSetting.url).concat(iconSetting !== null && iconSetting !== void 0 && iconSetting.ver ? '?ver=' + iconSetting.ver : '');
        elementor.helpers.enqueueEditorStylesheet(versionAddedURL);
        elementor.helpers.enqueuePreviewStylesheet(versionAddedURL);
      }
    }
  }, {
    key: "ui",
    value: function ui() {
      var ui = _superPropGet(ControlIconsView, "ui", this, 3)([]),
        skin = this.model.get('skin');
      ui.controlMedia = '.elementor-control-media';
      ui.svgUploader = 'media' === skin ? '.elementor-control-svg-uploader' : '.elementor-control-icons--inline__svg';
      ui.iconPickers = 'media' === skin ? '.elementor-control-icon-picker, .elementor-control-media__preview, .elementor-control-media-upload-button' : '.elementor-control-icons--inline__icon';
      ui.deleteButton = 'media' === skin ? '.elementor-control-media__remove' : '.elementor-control-icons--inline__none';
      ui.previewPlaceholder = '.elementor-control-media__preview';
      ui.previewContainer = '.elementor-control-preview-area';
      ui.inlineIconContainer = '.elementor-control-inline-icon';
      ui.inlineDisplayedIcon = '.elementor-control-icons--inline__displayed-icon';
      ui.radioInputs = '[type="radio"]';
      return ui;
    }
  }, {
    key: "events",
    value: function events() {
      return jQuery.extend(ControlMultipleBaseItemView.prototype.events.apply(this, arguments), {
        'click @ui.iconPickers': 'openPicker',
        'click @ui.svgUploader': 'openFrame',
        'click @ui.radioInputs': 'onClickInput',
        'click @ui.deleteButton': 'deleteIcon'
      });
    }
  }, {
    key: "getControlValue",
    value: function getControlValue() {
      var model = this.model,
        valueToMigrate = this.getValueToMigrate();
      if (!this.isMigrationAllowed()) {
        return valueToMigrate;
      }

      // Bail if no migration flag or no value to migrate
      var value = _superPropGet(ControlIconsView, "getControlValue", this, 3)([]);
      if (!valueToMigrate) {
        return value;
      }
      var controlName = model.get('name');

      // Check if migration had been done and is stored locally
      if (this.cache.migratedFlag[controlName]) {
        return this.cache.migratedFlag[controlName];
      }
      // Check if already migrated
      var didMigration = this.elementSettingsModel.get(this.dataKeys.migratedKey);
      if (didMigration && didMigration[controlName]) {
        return value;
      }

      // Do migration
      return this.migrateFa4toFa5(valueToMigrate);
    }
  }, {
    key: "migrateFa4toFa5",
    value: function migrateFa4toFa5(fa4Value) {
      var fa5Value = elementor.helpers.mapFa4ToFa5(fa4Value);
      this.cache.migratedFlag[this.model.get('name')] = fa5Value;
      this.enqueueIconFonts(fa5Value.library);
      return fa5Value;
    }
  }, {
    key: "setControlAsMigrated",
    value: function setControlAsMigrated(controlName) {
      var didMigration = this.elementSettingsModel.get(this.dataKeys.migratedKey) || {};
      didMigration[controlName] = true;
      this.elementSettingsModel.set(this.dataKeys.migratedKey, didMigration, {
        silent: true
      });
    }
  }, {
    key: "isMigrationAllowed",
    value: function isMigrationAllowed() {
      return !elementor.config.icons_update_needed;
    }
  }, {
    key: "getValueToMigrate",
    value: function getValueToMigrate() {
      var controlToMigrate = this.model.get(this.dataKeys.fa4MigrationFlag);
      if (!controlToMigrate) {
        return false;
      }

      // Check if there is a value to migrate
      var valueToMigrate = this.container.settings.get(controlToMigrate);
      if (valueToMigrate) {
        return valueToMigrate;
      }
      return false;
    }
  }, {
    key: "onReady",
    value: function onReady() {
      var _this2 = this;
      // Is migration allowed from fa4
      if (!this.isMigrationAllowed()) {
        var migrationPopupTrigger = 'media' === this.model.get('skin') ? this.ui.previewContainer[0] : this.ui.inlineIconContainer[0];
        migrationPopupTrigger.addEventListener('click', function (event) {
          // Prevent default to prevent marking the inline icons as selected on click when migration is not allowed
          event.preventDefault();
          event.stopPropagation();
          var onConfirm = function onConfirm() {
            var _elementor$documents$;
            window.location.href = elementor.config.tools_page_link + '&redirect_to_document=' + ((_elementor$documents$ = elementor.documents.getCurrent()) === null || _elementor$documents$ === void 0 ? void 0 : _elementor$documents$.id) + '&_wpnonce=' + elementor.config.tools_page_nonce + '#tab-fontawesome4_migration';
          };
          var enableMigrationDialog = elementor.helpers.getSimpleDialog('elementor-enable-fa5-dialog', __('Elementor\'s New Icon Library', 'elementor'), __('Elementor v2.6 includes an upgrade from Font Awesome 4 to 5. In order to continue using icons, be sure to click "Update".', 'elementor') + ' <a href="https://go.elementor.com/fontawesome-migration/" target="_blank">' + __('Learn More', 'elementor') + '</a>', __('Update', 'elementor'), onConfirm);
          enableMigrationDialog.show();
          return false;
        }, true);
      }
      var controlName = this.model.get('name');
      if (this.cache.migratedFlag[controlName]) {
        this.setControlAsMigrated(controlName);
        setTimeout(function () {
          _this2.setValue(_this2.cache.migratedFlag[controlName]);
        }, 10);
      }
    }
  }, {
    key: "onRender",
    value: function onRender() {
      _superPropGet(ControlIconsView, "onRender", this, 3)([]);
      if (this.isMigrationAllowed()) {
        elementor.iconManager.loadIconLibraries();
      }
    }
  }, {
    key: "initFrame",
    value: function initFrame() {
      var _this3 = this;
      // Set current doc id to attach uploaded images.
      wp.media.view.settings.post.id = elementor.config.document.id;
      this.frame = wp.media({
        button: {
          text: __('Insert Media', 'elementor')
        },
        library: {
          type: ['image/svg+xml']
        },
        states: [new wp.media.controller.Library({
          title: __('Insert Media', 'elementor'),
          library: wp.media.query({
            type: ['image/svg+xml']
          }),
          multiple: false,
          date: false
        })]
      });
      var handleSelect = function handleSelect() {
        return _this3.selectSvg();
      };

      // When a file is selected, run a callback.
      this.frame.on('insert select', handleSelect);
      this.setUploadMimeType(this.frame, 'svg');
    }
  }, {
    key: "setUploadMimeType",
    value: function setUploadMimeType(frame, ext) {
      // Set svg as only allowed upload extensions
      var oldExtensions = _wpPluploadSettings.defaults.filters.mime_types[0].extensions;
      frame.on('ready', function () {
        _wpPluploadSettings.defaults.filters.mime_types[0].extensions = ext;
      });
      this.frame.on('close', function () {
        // Restore allowed upload extensions
        _wpPluploadSettings.defaults.filters.mime_types[0].extensions = oldExtensions;
      });
    }

    /**
     * Callback handler for when an attachment is selected in the media modal.
     * Gets the selected image information, and sets it within the control.
     */
  }, {
    key: "selectSvg",
    value: function selectSvg() {
      this.trigger('before:select');

      // Get the attachment from the modal frame.
      var attachment = this.frame.state().get('selection').first().toJSON();
      if (attachment.url) {
        this.setValue({
          value: {
            url: attachment.url,
            id: attachment.id
          },
          library: 'svg'
        });
        this.applySavedValue();
      }
      this.trigger('after:select');
    }
  }, {
    key: "openFrame",
    value: function openFrame() {
      var _this4 = this;
      if (!_filesUploadHandler.default.isUploadEnabled('svg')) {
        _filesUploadHandler.default.getUnfilteredFilesNotEnabledDialog(function () {
          return _this4.openFrame();
        }).show();
        return false;
      }
      if (!this.frame) {
        this.initFrame();
      }
      this.frame.open();

      // Set params to trigger sanitizer
      _filesUploadHandler.default.setUploadTypeCaller(this.frame);
      var selectedId = this.getControlValue('id');
      if (!selectedId) {
        return;
      }
      var selection = this.frame.state().get('selection');
      selection.add(wp.media.attachment(selectedId));
    }
  }, {
    key: "openPicker",
    value: function openPicker() {
      elementor.iconManager.show({
        view: this
      });
    }
  }, {
    key: "applySavedValue",
    value: function applySavedValue() {
      var _this5 = this;
      var controlValue = this.getControlValue(),
        skin = this.model.get('skin'),
        iconContainer = 'inline' === skin ? this.ui.inlineDisplayedIcon : this.ui.previewPlaceholder,
        disableActiveState = this.model.get('disable_initial_active_state'),
        defaultIcon = this.model.get('default');
      var iconValue = controlValue.value,
        iconType = controlValue.library;
      if (!this.isMigrationAllowed() && !iconValue && this.getValueToMigrate()) {
        iconValue = this.getControlValue();
        iconType = '';
      }
      if ('media' === skin) {
        this.ui.controlMedia.toggleClass('e-media-empty', !iconValue);
      }
      if ('inline' === skin && !disableActiveState || iconType) {
        this.markChecked(iconType);
      }
      if (!iconValue) {
        if ('inline' === skin) {
          this.setDefaultIconLibraryLabel(defaultIcon, iconContainer);
          return;
        }
        this.ui.previewPlaceholder.html('');
        return;
      }
      if ('svg' === iconType && 'inline' !== skin) {
        return elementor.helpers.fetchInlineSvg(iconValue.url, function (data) {
          _this5.ui.previewPlaceholder.html(data);
        });
      }
      if ('media' === skin || 'svg' !== iconType) {
        var previewHTML = '<i class="' + iconValue + '"></i>';
        iconContainer.html(previewHTML);
      }
      this.enqueueIconFonts(iconType);
    }
  }, {
    key: "setDefaultIconLibraryLabel",
    value: function setDefaultIconLibraryLabel(defaultIcon, iconContainer) {
      // Check if the control has a default icon
      if ('' !== defaultIcon.value && 'svg' !== defaultIcon.library) {
        // If the default icon is not an SVG, set the icon-library label's icon to the default icon
        iconContainer.html('<i class="' + defaultIcon.value + '"></i>');
      } else {
        // If (1) the control does NOT have a default icon,
        // OR (2) the control DOES have a default icon BUT the default icon is an SVG,
        // set the default icon-library label's icon to a simple circle
        var skinOptions = this.model.get('skin_settings');
        iconContainer.html('<i class="' + skinOptions.inline.icon.icon + '"></i>');
      }
    }
  }, {
    key: "markChecked",
    value: function markChecked(iconType) {
      this.ui.radioInputs.filter(':checked').prop('checked', false);
      if (!iconType) {
        return this.ui.radioInputs.filter('[value="none"]').prop('checked', true);
      }
      if ('svg' !== iconType) {
        iconType = 'icon';
      }
      this.ui.radioInputs.filter('[value="' + iconType + '"]').prop('checked', true);
    }
  }, {
    key: "onClickInput",
    value: function onClickInput() {
      this.markChecked(this.getControlValue().library);
    }
  }, {
    key: "deleteIcon",
    value: function deleteIcon(event) {
      event.stopPropagation();
      this.setValue({
        value: '',
        library: ''
      });
      this.applySavedValue();
    }
  }, {
    key: "onBeforeDestroy",
    value: function onBeforeDestroy() {
      this.$el.remove();
    }
  }]);
}(ControlMultipleBaseItemView);
module.exports = ControlIconsView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/image-dimensions.js":
/*!************************************************************!*\
  !*** ../assets/dev/js/editor/controls/image-dimensions.js ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _scrubbing = _interopRequireDefault(__webpack_require__(/*! ./behaviors/scrubbing */ "../assets/dev/js/editor/controls/behaviors/scrubbing.js"));
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var ControlMultipleBaseItemView = __webpack_require__(/*! elementor-controls/base-multiple */ "../assets/dev/js/editor/controls/base-multiple.js"),
  ControlImageDimensionsItemView;
ControlImageDimensionsItemView = ControlMultipleBaseItemView.extend({
  behaviors: function behaviors() {
    return _objectSpread(_objectSpread({}, ControlMultipleBaseItemView.prototype.behaviors.apply(this)), {}, {
      Scrubbing: {
        behaviorClass: _scrubbing.default,
        scrubSettings: {
          intentTime: 800
        }
      }
    });
  },
  ui: function ui() {
    return {
      inputWidth: 'input[data-setting="width"]',
      inputHeight: 'input[data-setting="height"]',
      btnApply: 'button.elementor-image-dimensions-apply-button'
    };
  },
  // Override the base events
  events: function events() {
    return {
      'click @ui.btnApply': 'onApplyClicked',
      'keyup @ui.inputWidth': 'onDimensionKeyUp',
      'keyup @ui.inputHeight': 'onDimensionKeyUp'
    };
  },
  onDimensionKeyUp: function onDimensionKeyUp(event) {
    var ENTER_KEY = 13;
    if (ENTER_KEY === event.keyCode) {
      this.onApplyClicked(event);
    }
  },
  onApplyClicked: function onApplyClicked(event) {
    event.preventDefault();
    this.setValue({
      width: this.ui.inputWidth.val(),
      height: this.ui.inputHeight.val()
    });
  }
});
module.exports = ControlImageDimensionsItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/media.js":
/*!*************************************************!*\
  !*** ../assets/dev/js/editor/controls/media.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _filesUploadHandler = _interopRequireDefault(__webpack_require__(/*! ../utils/files-upload-handler */ "../assets/dev/js/editor/utils/files-upload-handler.js"));
var _jsonUploadWarningMessage = __webpack_require__(/*! elementor-utils/json-upload-warning-message */ "../assets/dev/js/utils/json-upload-warning-message.js");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var ControlMultipleBaseItemView = __webpack_require__(/*! elementor-controls/base-multiple */ "../assets/dev/js/editor/controls/base-multiple.js"),
  ControlMediaItemView;
ControlMediaItemView = ControlMultipleBaseItemView.extend({
  ui: function ui() {
    var ui = ControlMultipleBaseItemView.prototype.ui.apply(this, arguments);
    ui.controlMedia = '.elementor-control-media';
    ui.mediaImage = '.elementor-control-media__preview';
    ui.mediaVideo = '.elementor-control-media-video';
    ui.frameOpeners = '.elementor-control-preview-area';
    ui.removeButton = '.elementor-control-media__remove';
    // eslint-disable-next-line capitalized-comments
    // ui.warnings = '.elementor-control-media__warnings';
    ui.promotions = '.elementor-control-media__promotions';
    ui.promotions_dismiss = '.elementor-control-media__promotions .elementor-control-notice-dismiss';
    ui.promotions_action = '.elementor-control-media__promotions .elementor-control-notice-main-actions button';
    ui.fileName = '.elementor-control-media__file__content__info__name';
    ui.mediaInputImageSize = '.e-image-size-select';
    return ui;
  },
  events: function events() {
    return _.extend(ControlMultipleBaseItemView.prototype.events.apply(this, arguments), {
      'click @ui.frameOpeners': 'openFrame',
      'click @ui.removeButton': 'deleteImage',
      'change @ui.mediaInputImageSize': 'onMediaInputImageSizeChange',
      'click @ui.promotions_dismiss': 'onPromotionDismiss',
      'click @ui.promotions_action': 'onPromotionAction'
    });
  },
  getMediaType: function getMediaType() {
    // `get( 'media_type' )` is for BC.
    return this.mediaType || this.model.get('media_type') || this.model.get('media_types')[0];
  },
  /**
   * Get library type for `wp.media` using a given media type.
   *
   * @param {string} mediaType - The media type to get the library for.
   * @return {string} library media type
   */
  getLibraryType: function getLibraryType(mediaType) {
    if (!mediaType) {
      mediaType = this.getMediaType();
    }
    return 'svg' === mediaType ? 'image/svg+xml' : mediaType;
  },
  applySavedValue: function applySavedValue() {
    var _this$getControlPlace,
      _this = this;
    var value = this.getControlValue('url'),
      url = value || ((_this$getControlPlace = this.getControlPlaceholder()) === null || _this$getControlPlace === void 0 ? void 0 : _this$getControlPlace.url),
      attachmentId = this.getControlValue('id'),
      isPlaceholder = !value && url,
      mediaType = this.getMediaType();
    if (['image', 'svg'].includes(mediaType)) {
      this.ui.mediaImage.css('background-image', url ? 'url(' + url + ')' : '');
      if (isPlaceholder) {
        this.ui.mediaImage.css('opacity', 0.5);
      }
    } else if ('video' === mediaType) {
      this.ui.mediaVideo.attr('src', url);
    } else {
      var fileName = url ? url.split('/').pop() : '';
      this.ui.fileName.text(fileName);
    }
    if (this.ui.mediaInputImageSize) {
      var imageSize = this.getControlValue('size');
      if (isPlaceholder) {
        var _this$getControlPlace2;
        imageSize = (_this$getControlPlace2 = this.getControlPlaceholder()) === null || _this$getControlPlace2 === void 0 ? void 0 : _this$getControlPlace2.size;
      }
      this.ui.mediaInputImageSize.val(imageSize).toggleClass('e-select-placeholder', isPlaceholder);
    }
    this.ui.controlMedia.toggleClass('e-media-empty', !value).toggleClass('e-media-empty-placeholder', !value && !isPlaceholder);
    if ('image' === mediaType) {
      if (attachmentId) {
        var dismissPromotionEventName = this.getDismissPromotionEventName();
        var handleHints = function handleHints(attachment) {
          // eslint-disable-next-line capitalized-comments
          // this.ui.warnings.toggle( ! this.imageHasAlt( attachment ) );
          if (_this.ui.promotions.length && !elementor.config.user.dismissed_editor_notices.includes(dismissPromotionEventName)) {
            var alwaysOn = _this.ui.promotions.find('.elementor-control-notice').data('display') || false;
            var showHint = alwaysOn || _this.imageNotOptimized(attachment);
            _this.ui.promotions.toggle(showHint);
          }
        };
        wp.media.attachment(attachmentId).fetch().then(handleHints);
      } else {
        // eslint-disable-next-line capitalized-comments
        // this.ui.warnings.hide();

        // eslint-disable-next-line no-lonely-if
        if (this.ui.promotions.length) {
          this.ui.promotions.hide();
        }
      }
    }
  },
  openFrame: function openFrame(e) {
    var _arguments = arguments,
      _this2 = this;
    return (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
      var _e$target;
      var source, mediaType, selectedId;
      return _regenerator.default.wrap(function (_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            source = _arguments.length > 1 && _arguments[1] !== undefined ? _arguments[1] : null;
            mediaType = (e === null || e === void 0 || (_e$target = e.target) === null || _e$target === void 0 || (_e$target = _e$target.dataset) === null || _e$target === void 0 ? void 0 : _e$target.mediaType) || _this2.getMediaType();
            _this2.mediaType = mediaType;
            if (mediaType) {
              _context.next = 1;
              break;
            }
            return _context.abrupt("return");
          case 1:
            if (_filesUploadHandler.default.isUploadEnabled(mediaType)) {
              _context.next = 2;
              break;
            }
            _filesUploadHandler.default.getUnfilteredFilesNotEnabledDialog(function () {
              return _this2.openFrame(e, 'filter-popup');
            }).show();
            return _context.abrupt("return", false);
          case 2:
            if (!(source !== 'filter-popup' && ['application/json', 'json'].includes(mediaType))) {
              _context.next = 3;
              break;
            }
            _context.next = 3;
            return (0, _jsonUploadWarningMessage.showJsonUploadWarningMessageIfNeeded)({
              introductionMap: window.elementor.config.user.introduction,
              IntroductionClass: window.elementorModules.editor.utils.Introduction
            });
          case 3:
            // If there is no frame, or the current initialized frame contains a different library than
            // the `data-media-type` of the clicked button, (re)initialize the frame.
            if (!_this2.frame || _this2.getLibraryType(mediaType) !== _this2.currentLibraryType) {
              _this2.initFrame();
            }
            _this2.frame.open();

            // Set params to trigger sanitizer
            _filesUploadHandler.default.setUploadTypeCaller(_this2.frame);
            selectedId = _this2.getControlValue('id');
            if (selectedId) {
              _context.next = 4;
              break;
            }
            return _context.abrupt("return");
          case 4:
            _this2.frame.state().get('selection').add(wp.media.attachment(selectedId));
          case 5:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }))();
  },
  deleteImage: function deleteImage(event) {
    event.stopPropagation();
    this.setValue({
      url: '',
      id: ''
    });
    this.applySavedValue();
  },
  imageHasAlt: function imageHasAlt(attachment) {
    var _attachment$alt;
    var attachmentAlt = (attachment === null || attachment === void 0 || (_attachment$alt = attachment.alt) === null || _attachment$alt === void 0 ? void 0 : _attachment$alt.trim()) || '';
    return !!attachmentAlt;
  },
  imageNotOptimized: function imageNotOptimized(attachment) {
    var checks = {
      height: 1080,
      width: 1920,
      filesizeInBytes: 100000
    };
    return Object.keys(checks).some(function (key) {
      var value = attachment[key] || false;
      return value && value > checks[key];
    });
  },
  getDismissPromotionEventName: function getDismissPromotionEventName() {
    var _$dismissButton$;
    var $promotions = this.ui.promotions;
    var $dismissButton = $promotions.find('.elementor-control-notice-dismiss');
    // Remove listener
    $dismissButton.off('click');
    return ((_$dismissButton$ = $dismissButton[0]) === null || _$dismissButton$ === void 0 || (_$dismissButton$ = _$dismissButton$.dataset) === null || _$dismissButton$ === void 0 ? void 0 : _$dismissButton$.event) || false;
  },
  onPromotionDismiss: function onPromotionDismiss() {
    this.dismissPromotion(this.getDismissPromotionEventName());
  },
  onPromotionAction: function onPromotionAction(event) {
    var _JSON$parse = JSON.parse(event.target.closest('button').dataset.settings),
      _JSON$parse$action_ur = _JSON$parse.action_url,
      actionURL = _JSON$parse$action_ur === void 0 ? null : _JSON$parse$action_ur;
    if (actionURL) {
      window.open(actionURL, '_blank');
    }
    this.hidePromotion();
  },
  dismissPromotion: function dismissPromotion(eventName) {
    this.hidePromotion(eventName);
    if (eventName) {
      elementorCommon.ajax.addRequest('dismissed_editor_notices', {
        data: {
          dismissId: eventName
        }
      });
    }
  },
  hidePromotion: function hidePromotion() {
    var eventName = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
    var $promotions = this.ui.promotions;
    $promotions.hide();
    if (!eventName) {
      eventName = this.getDismissPromotionEventName();
    }
    elementorCommon.ajax.addRequest('elementor_image_optimization_campaign', {
      data: {
        source: 'io-editor-image-install'
      }
    });

    // Prevent opening the same promotion again in current editor session.
    elementor.config.user.dismissed_editor_notices.push(eventName);
  },
  onMediaInputImageSizeChange: function onMediaInputImageSizeChange() {
    var _this3 = this;
    if (!this.model.get('has_sizes')) {
      return;
    }
    var currentControlValue = this.getControlValue(),
      placeholder = this.getControlPlaceholder();
    var hasImage = '' !== (currentControlValue === null || currentControlValue === void 0 ? void 0 : currentControlValue.id),
      hasPlaceholder = placeholder === null || placeholder === void 0 ? void 0 : placeholder.id,
      hasValue = hasImage || hasPlaceholder;
    if (!hasValue) {
      return;
    }
    var shouldUpdateFromPlaceholder = hasPlaceholder && !hasImage;
    if (shouldUpdateFromPlaceholder) {
      this.setValue(_objectSpread(_objectSpread({}, placeholder), {}, {
        size: currentControlValue.size
      }));
      if (this.model.get('responsive')) {
        // Render is already calls `applySavedValue`, therefore there's no need for it in this case.
        this.renderWithChildren();
      } else {
        this.applySavedValue();
      }
      this.onMediaInputImageSizeChange();
      return;
    }
    var imageURL;
    elementor.channels.editor.once('imagesManager:detailsReceived', function (data) {
      var _data$currentControlV;
      imageURL = (_data$currentControlV = data[currentControlValue.id]) === null || _data$currentControlV === void 0 ? void 0 : _data$currentControlV[currentControlValue.size];
      if (imageURL) {
        currentControlValue.url = imageURL;
        _this3.setValue(currentControlValue);
      }
    });
    imageURL = elementor.imagesManager.getImageUrl({
      id: currentControlValue.id,
      url: currentControlValue.url,
      size: currentControlValue.size
    });
    if (imageURL) {
      currentControlValue.url = imageURL;
      this.setValue(currentControlValue);
    }
  },
  /**
   * Create a media modal select frame, and store it so the instance can be reused when needed.
   */
  initFrame: function initFrame() {
    var mediaType = this.getMediaType();
    this.currentLibraryType = this.getLibraryType(mediaType);

    // Set current doc id to attach uploaded images.
    wp.media.view.settings.post.id = elementor.config.document.id;
    this.frame = wp.media({
      frame: 'post',
      type: 'image',
      multiple: false,
      states: [new wp.media.controller.Library({
        title: __('Insert Media', 'elementor'),
        library: wp.media.query({
          type: this.currentLibraryType
        }),
        multiple: false,
        date: false
      })]
    });

    // Remove unwanted elements when frame is opened.
    this.frame.on('ready open', this.onFrameReady.bind(this));

    // When a file is selected, run a callback.
    this.frame.on('insert select', this.select.bind(this));
    if (elementorCommon.config.filesUpload.unfilteredFiles) {
      this.setUploadMimeType(this.frame, mediaType);
    }
  },
  /**
   * Hack to remove unwanted elements from modal & Open the `Insert from URL` tab.
   */
  onFrameReady: function onFrameReady() {
    var $frame = this.frame.$el;
    var elementsToRemove = ['#menu-item-insert', '#menu-item-gallery', '#menu-item-playlist', '#menu-item-video-playlist', '.embed-link-settings'];
    $frame.find(elementsToRemove.join(',')).remove();

    // Change the default button text using CSS by passing the text as a variable.
    $frame.css('--button-text', "'".concat(__('Insert Media', 'elementor'), "'"));

    // Remove elements from the URL upload tab.
    $frame.addClass('e-wp-media-elements-removed');
    if ('url' === this.getControlValue('source')) {
      // Go to the url tab.
      $frame.find('#menu-item-embed').trigger('click');

      // Hide the top media tabs ( WordPress does that automatically if a real user clicks the url tab ).
      $frame.addClass('hide-router');

      // Load the image URL.
      this.frame.views.get('.media-frame-content')[0].url.model.set({
        url: this.getControlValue('url'),
        alt: this.getControlValue('alt')
      });
    } else {
      // Go to the upload tab.
      $frame.find('#menu-item-library').trigger('click');
    }
  },
  setUploadMimeType: function setUploadMimeType(frame, ext) {
    // Add unfiltered files to the allowed upload extensions
    var oldExtensions = _wpPluploadSettings.defaults.filters.mime_types[0].extensions;
    frame.on('ready', function () {
      _wpPluploadSettings.defaults.filters.mime_types[0].extensions = 'application/json' === ext ? 'json' : oldExtensions + ',svg';
    });
    this.frame.on('close', function () {
      // Restore allowed upload extensions
      _wpPluploadSettings.defaults.filters.mime_types[0].extensions = oldExtensions;
    });
  },
  /**
   * Callback handler for when an attachment is selected in the media modal.
   * Gets the selected image information, and sets it within the control.
   */
  select: function select() {
    this.trigger('before:select');
    var state = this.frame.state();
    var attachment;
    if ('embed' === state.get('id')) {
      // Insert from URL.
      attachment = {
        url: state.props.get('url'),
        id: '',
        alt: state.props.get('alt'),
        source: 'url'
      };
    } else {
      // Get the attachment from the modal frame.
      attachment = this.frame.state().get('selection').first().toJSON();
      attachment.source = 'library';
    }
    if (attachment.url) {
      this.setValue({
        url: attachment.url,
        id: attachment.id,
        alt: attachment.alt,
        source: attachment.source,
        size: this.model.get('default').size
      });
      if (this.model.get('responsive')) {
        // Render is already calls `applySavedValue`, therefore there's no need for it in this case.
        this.renderWithChildren();
      } else {
        this.applySavedValue();
      }
    }
    this.onMediaInputImageSizeChange();
    this.trigger('after:select');
  },
  onBeforeDestroy: function onBeforeDestroy() {
    this.$el.remove();
  }
});
module.exports = ControlMediaItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/notice.js":
/*!**************************************************!*\
  !*** ../assets/dev/js/editor/controls/notice.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _toConsumableArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "../node_modules/@babel/runtime/helpers/toConsumableArray.js"));
var ControlBaseView = __webpack_require__(/*! elementor-controls/base */ "../assets/dev/js/editor/controls/base.js");
module.exports = ControlBaseView.extend({
  ui: function ui() {
    var ui = ControlBaseView.prototype.ui.apply(this, arguments);
    ui.button = '.elementor-control-notice-dismiss';
    return ui;
  },
  events: {
    'click @ui.button.e-btn-1': 'onButton1Click',
    'click @ui.button.e-btn-2': 'onButton2Click',
    'click @ui.button.elementor-control-notice-dismiss': 'onDismissButtonClick'
  },
  onButton1Click: function onButton1Click() {
    var eventName = this.model.get('event');
    elementor.channels.editor.trigger(eventName, this);
  },
  onButton2Click: function onButton2Click() {
    var eventName = this.model.get('event');
    elementor.channels.editor.trigger(eventName, this);
  },
  getDismissId: function getDismissId() {
    var _this$options, _this$options2, _this$options3;
    var controlName = this.model.get('name');
    var elementType = 'widget' === ((_this$options = this.options) === null || _this$options === void 0 || (_this$options = _this$options.element) === null || _this$options === void 0 || (_this$options = _this$options.model) === null || _this$options === void 0 || (_this$options = _this$options.attributes) === null || _this$options === void 0 ? void 0 : _this$options.elType) ? (_this$options2 = this.options) === null || _this$options2 === void 0 || (_this$options2 = _this$options2.element) === null || _this$options2 === void 0 || (_this$options2 = _this$options2.model) === null || _this$options2 === void 0 || (_this$options2 = _this$options2.attributes) === null || _this$options2 === void 0 ? void 0 : _this$options2.widgetType : (_this$options3 = this.options) === null || _this$options3 === void 0 || (_this$options3 = _this$options3.element) === null || _this$options3 === void 0 || (_this$options3 = _this$options3.model) === null || _this$options3 === void 0 || (_this$options3 = _this$options3.attributes) === null || _this$options3 === void 0 ? void 0 : _this$options3.elType;
    return "".concat(elementType, "-").concat(controlName);
  },
  onDismissButtonClick: function onDismissButtonClick() {
    var _this = this;
    var dismissId = this.getDismissId();
    elementorCommon.ajax.addRequest('dismissed_editor_notices', {
      data: {
        dismissId: dismissId
      },
      success: function success() {
        var _elementor;
        _this.$el.remove();
        var dismissedNotices = (_elementor = elementor) !== null && _elementor !== void 0 && (_elementor = _elementor.config) !== null && _elementor !== void 0 && (_elementor = _elementor.user) !== null && _elementor !== void 0 && _elementor.dismissed_editor_notices ? (0, _toConsumableArray2.default)(elementor.config.user.dismissed_editor_notices) : [];
        elementor.config.user.dismissed_editor_notices = [].concat((0, _toConsumableArray2.default)(dismissedNotices), [dismissId]);
      }
    });
  },
  templateHelpers: function templateHelpers() {
    var _elementor2;
    var controlData = ControlBaseView.prototype.templateHelpers.apply(this, arguments);
    var dismissedNotices = (_elementor2 = elementor) !== null && _elementor2 !== void 0 && (_elementor2 = _elementor2.config) !== null && _elementor2 !== void 0 && (_elementor2 = _elementor2.user) !== null && _elementor2 !== void 0 && _elementor2.dismissed_editor_notices ? (0, _toConsumableArray2.default)(elementor.config.user.dismissed_editor_notices) : [];
    var dismissId = this.getDismissId();
    controlData.data.shouldRenderNotice = !dismissedNotices.includes(dismissId);
    return controlData;
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/controls/number.js":
/*!**************************************************!*\
  !*** ../assets/dev/js/editor/controls/number.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _scrubbing = _interopRequireDefault(__webpack_require__(/*! ./behaviors/scrubbing */ "../assets/dev/js/editor/controls/behaviors/scrubbing.js"));
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js"),
  ControlNumberItemView;
ControlNumberItemView = ControlBaseDataView.extend({
  behaviors: function behaviors() {
    return _objectSpread(_objectSpread({}, ControlBaseDataView.prototype.behaviors.apply(this)), {}, {
      Scrubbing: {
        behaviorClass: _scrubbing.default,
        scrubSettings: {
          intentTime: 800
        }
      }
    });
  },
  registerValidators: function registerValidators() {
    ControlBaseDataView.prototype.registerValidators.apply(this, arguments);
    var validationTerms = {},
      model = this.model;
    ['min', 'max'].forEach(function (term) {
      var termValue = model.get(term);
      if (_.isFinite(termValue)) {
        validationTerms[term] = termValue;
      }
    });
    if (!jQuery.isEmptyObject(validationTerms)) {
      this.addValidator(new this.validatorTypes.Number({
        validationTerms: validationTerms
      }));
    }
  }
});
module.exports = ControlNumberItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/popover-toggle.js":
/*!**********************************************************!*\
  !*** ../assets/dev/js/editor/controls/popover-toggle.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _readOnlyError2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/readOnlyError */ "../node_modules/@babel/runtime/helpers/readOnlyError.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var ControlChooseView = __webpack_require__(/*! elementor-controls/choose */ "../assets/dev/js/editor/controls/choose.js");
var ControlPopoverStarterView = exports["default"] = /*#__PURE__*/function (_ControlChooseView) {
  function ControlPopoverStarterView() {
    (0, _classCallCheck2.default)(this, ControlPopoverStarterView);
    return _callSuper(this, ControlPopoverStarterView, arguments);
  }
  (0, _inherits2.default)(ControlPopoverStarterView, _ControlChooseView);
  return (0, _createClass2.default)(ControlPopoverStarterView, [{
    key: "ui",
    value: function ui() {
      var ui = ControlChooseView.prototype.ui.apply(this, arguments);
      ui.popoverToggle = '.elementor-control-popover-toggle-toggle';
      ui.resetInput = '.elementor-control-popover-toggle-reset';
      return ui;
    }
  }, {
    key: "events",
    value: function events() {
      return _.extend(ControlChooseView.prototype.events.apply(this, arguments), {
        'click @ui.popoverToggle': 'onPopoverToggleClick',
        'click @ui.resetInput': 'onResetInputClick'
      });
    }
  }, {
    key: "onShow",
    value: function onShow() {
      var _this = this;
      var $popover = this.$el.next('.elementor-controls-popover');

      // Attach the current control as a toggle of its popover.
      if ($popover.length) {
        $popover[0].dataset.popoverToggle = "elementor-control-default-".concat(this.model.cid);
        $popover.on('hide', function () {
          return _this.onPopoverHide();
        });
        $popover.attr('data-on-hide', true);
      }
    }
  }, {
    key: "onPopoverHide",
    value: function onPopoverHide() {
      this.reRoute(false);
    }
  }, {
    key: "onResetInputClick",
    value: function onResetInputClick() {
      var globalData = this.model.get('global');
      if (globalData !== null && globalData !== void 0 && globalData.active) {
        this.triggerMethod('value:type:change');
      }
    }
  }, {
    key: "onInputChange",
    value: function onInputChange(event) {
      if (event.currentTarget !== this.ui.popoverToggle[0]) {
        return;
      }

      // If the control has a global value, unset the global.
      if (this.getGlobalKey()) {
        this.triggerMethod('unset:global:value');
      } else if (this.isGlobalActive()) {
        this.triggerMethod('value:type:change');
      }
    }
  }, {
    key: "onPopoverToggleClick",
    value: function onPopoverToggleClick() {
      var _this2 = this;
      if (this.isGlobalActive() && !this.getControlValue() && !this.getGlobalKey() && this.getGlobalDefault()) {
        this.triggerMethod('unlink:global:default');
      }
      var $popover = this.$el.next('.elementor-controls-popover');
      if (!$popover.attr('data-on-hide')) {
        $popover.attr('data-on-hide', true);
        $popover.on('hide', function () {
          return _this2.onPopoverHide();
        });
      }
      if (!$popover.is(':visible')) {
        this.reRoute(true);
      } else {
        $popover.hide();
        $popover.trigger('hide');
      }
    }
  }, {
    key: "activate",
    value: function activate() {
      this.$el.next('.elementor-controls-popover').show();
    }
  }, {
    key: "getGlobalCommand",
    value: function getGlobalCommand() {
      return 'globals/typography';
    }
  }, {
    key: "buildPreviewItemCSS",
    value: function buildPreviewItemCSS(globalValue) {
      var cssObject = {};
      Object.entries(globalValue).forEach(function (_ref) {
        var _ref2 = (0, _slicedToArray2.default)(_ref, 2),
          property = _ref2[0],
          value = _ref2[1];
        // If a control value is empty, ignore it.
        if (!value || '' === value.size) {
          return;
        }
        if (property.startsWith('typography_')) {
          property = property.replace('typography_', '');
        }
        if ('font_family' === property) {
          elementor.helpers.enqueueFont(value, 'editor');
        }
        if ('font_size' === property) {
          var fontSize = 'custom' === value.unit ? value.size : "".concat(value.size).concat(value.unit);
          cssObject.fontSize = "min(".concat(fontSize, ", 28px)");
        } else {
          // Convert the snake case property names into camel case to match their corresponding CSS property names.
          if (property.includes('_')) {
            property = property.replace(/([_][a-z])/g, function (result) {
              return result.toUpperCase().replace('_', '');
            });
          }
          cssObject[property] = value;
        }
      });
      return cssObject;
    }
  }, {
    key: "createGlobalItemMarkup",
    value: function createGlobalItemMarkup(globalData) {
      var $typographyPreview = jQuery('<div>', {
        class: 'e-global__preview-item e-global__typography',
        'data-global-id': globalData.id,
        title: globalData.title
      });
      $typographyPreview.html(_.escape(globalData.title)).css(this.buildPreviewItemCSS(globalData.value));
      return $typographyPreview;
    }
  }, {
    key: "getGlobalMeta",
    value: function getGlobalMeta() {
      return {
        commandName: this.getGlobalCommand(),
        key: this.model.get('name'),
        title: __('New Typography Setting', 'elementor'),
        controlType: 'typography',
        route: 'panel/global/global-typography'
      };
    }
  }, {
    key: "getAddGlobalConfirmMessage",
    value: function getAddGlobalConfirmMessage() {
      var globalData = this.getGlobalMeta(),
        $message = jQuery('<div>', {
          class: 'e-global__confirm-message'
        }),
        $messageText = jQuery('<div>').html(__('Are you sure you want to create a new Global Font setting?', 'elementor')),
        $inputWrapper = jQuery('<div>', {
          class: 'e-global__confirm-input-wrapper'
        }),
        $input = jQuery('<input>', {
          type: 'text',
          name: 'global-name',
          placeholder: globalData.title
        }).val(globalData.title);
      $inputWrapper.append($input);
      $message.append($messageText, $inputWrapper);
      return $message;
    }
  }, {
    key: "getGlobalsList",
    value: function () {
      var _getGlobalsList = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
        var result;
        return _regenerator.default.wrap(function (_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 1;
              return $e.data.get(this.getGlobalCommand());
            case 1:
              result = _context.sent;
              return _context.abrupt("return", result.data);
            case 2:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function getGlobalsList() {
        return _getGlobalsList.apply(this, arguments);
      }
      return getGlobalsList;
    }()
  }, {
    key: "buildGlobalsList",
    value: function buildGlobalsList(globalTypographies, $globalPreviewItemsContainer) {
      var _this3 = this;
      Object.values(globalTypographies).forEach(function (typography) {
        // Only build markup if the typography is valid.
        if (typography) {
          var $typographyPreview = _this3.createGlobalItemMarkup(typography);
          $globalPreviewItemsContainer.append($typographyPreview);
        }
      });
    }
  }, {
    key: "onAddGlobalButtonClick",
    value: function onAddGlobalButtonClick() {
      this.triggerMethod('add:global:to:list', this.getAddGlobalConfirmMessage());
    }
  }]);
}(ControlChooseView);
ControlPopoverStarterView.onPasteStyle = function (control, clipboardValue) {
  return !clipboardValue || clipboardValue === control.return_value;
};

/***/ }),

/***/ "../assets/dev/js/editor/controls/repeater-row.js":
/*!********************************************************!*\
  !*** ../assets/dev/js/editor/controls/repeater-row.js ***!
  \********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var sprintf = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["sprintf"];
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _controlsStack = _interopRequireDefault(__webpack_require__(/*! elementor-views/controls-stack */ "../assets/dev/js/editor/views/controls-stack.js"));
module.exports = Marionette.CompositeView.extend({
  template: Marionette.TemplateCache.get('#tmpl-elementor-repeater-row'),
  className: 'elementor-repeater-fields',
  attributes: {
    role: 'listitem'
  },
  ui: function ui() {
    return {
      duplicateButton: '.elementor-repeater-tool-duplicate',
      editButton: '.elementor-repeater-tool-edit',
      removeButton: '.elementor-repeater-tool-remove',
      itemTitle: '.elementor-repeater-row-item-title'
    };
  },
  behaviors: {
    HandleInnerTabs: {
      behaviorClass: __webpack_require__(/*! elementor-behaviors/inner-tabs */ "../assets/dev/js/editor/elements/views/behaviors/inner-tabs.js")
    }
  },
  triggers: {
    'click @ui.removeButton': 'click:remove',
    'click @ui.duplicateButton': 'click:duplicate',
    'click @ui.itemTitle': 'click:edit'
  },
  modelEvents: {
    change: 'onModelChange'
  },
  templateHelpers: function templateHelpers() {
    return {
      itemIndex: this.getOption('itemIndex'),
      itemActions: this.getOption('itemActions')
    };
  },
  childViewContainer: '.elementor-repeater-row-controls',
  getChildView: function getChildView(item) {
    var controlType = item.get('type');
    return elementor.getControlView(controlType);
  },
  getChildControlView: function getChildControlView(name) {
    return this.getControlViewByModel(this.getControlModel(name));
  },
  getControlViewByModel: function getControlViewByModel(model) {
    return this.children.findByModelCid(model.cid);
  },
  getControlModel: function getControlModel(name) {
    return this.collection.findWhere({
      name: name
    });
  },
  childViewOptions: function childViewOptions() {
    return {
      container: this.options.container
    };
  },
  updateIndex: function updateIndex(newIndex) {
    this.itemIndex = newIndex;
  },
  setTitle: function setTitle() {
    var titleField = this.getOption('titleField');
    var title = '';
    if (titleField) {
      title = Marionette.TemplateCache.prototype.compileTemplate(titleField)(this.model.parseDynamicSettings());
    }
    if (!title) {
      /* Translators: %s: Item Index (number). */
      title = sprintf(__('Item #%s', 'elementor'), this.getOption('itemIndex'));
    }
    this.ui.itemTitle.html(title);
  },
  toggleSort: function toggleSort(enable) {
    this.$el.toggleClass('elementor-repeater-row--disable-sort', !enable);
  },
  initialize: function initialize(options) {
    this.itemIndex = 0;

    // Collection for Controls list
    this.collection = new Backbone.Collection(_.values(elementor.mergeControlsSettings(options.controlFields)));
  },
  onRender: function onRender() {
    this.setTitle();
    _controlsStack.default.handlePopovers(this);
  },
  onModelChange: function onModelChange() {
    if (this.getOption('titleField')) {
      this.setTitle();
    }
  },
  onChildviewResponsiveSwitcherClick: function onChildviewResponsiveSwitcherClick(childView, device) {
    if ('desktop' === device) {
      elementor.getPanelView().getCurrentPageView().$el.toggleClass('elementor-responsive-switchers-open');
    }
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/controls/repeater.js":
/*!****************************************************!*\
  !*** ../assets/dev/js/editor/controls/repeater.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js"),
  RepeaterRowView = __webpack_require__(/*! elementor-controls/repeater-row */ "../assets/dev/js/editor/controls/repeater-row.js"),
  ControlRepeaterItemView;
ControlRepeaterItemView = ControlBaseDataView.extend({
  ui: {
    btnAddRow: '.elementor-repeater-add',
    fieldContainer: '.elementor-repeater-fields-wrapper'
  },
  events: function events() {
    return {
      'click @ui.btnAddRow': 'onButtonAddRowClick',
      'sortstart @ui.fieldContainer': 'onSortStart',
      'sortupdate @ui.fieldContainer': 'onSortUpdate',
      'sortstop @ui.fieldContainer': 'onSortStop'
    };
  },
  childView: RepeaterRowView,
  childViewContainer: '.elementor-repeater-fields-wrapper',
  templateHelpers: function templateHelpers() {
    return {
      itemActions: this.model.get('item_actions'),
      data: _.extend({}, this.model.toJSON(), {
        controlValue: []
      })
    };
  },
  childViewOptions: function childViewOptions(rowModel, index) {
    var elementContainer = this.getOption('container');
    return {
      container: elementContainer.repeaters[this.model.get('name')].children[index],
      controlFields: this.model.get('fields'),
      titleField: this.model.get('title_field'),
      itemActions: this.model.get('item_actions')
    };
  },
  createItemModel: function createItemModel(attrs, options, controlView) {
    options.controls = controlView.model.get('fields');
    return new elementorModules.editor.elements.models.BaseSettings(attrs, options);
  },
  fillCollection: function fillCollection() {
    // TODO: elementSettingsModel is deprecated since 2.8.0.
    var settings = this.container ? this.container.settings : this.elementSettingsModel;
    var controlName = this.model.get('name');
    this.collection = settings.get(controlName);

    // Hack for history redo/undo
    if (!(this.collection instanceof Backbone.Collection)) {
      this.collection = new Backbone.Collection(this.collection, {
        // Use `partial` to supply the `this` as an argument, but not as context
        // the `_` is a place holder for original arguments: `attrs` & `options`
        model: _.partial(this.createItemModel, _, _, this)
      });

      // Set the value silent
      settings.set(controlName, this.collection, {
        silent: true
      });
    }
  },
  initialize: function initialize() {
    ControlBaseDataView.prototype.initialize.apply(this, arguments);
    this.fillCollection();
    this.listenTo(this.collection, 'reset', this.resetContainer.bind(this));
    this.listenTo(this.collection, 'add', this.updateContainer.bind(this));
  },
  editRow: function editRow(rowView) {
    if (this.currentEditableChild) {
      var currentEditable = this.currentEditableChild.getChildViewContainer(this.currentEditableChild);
      currentEditable.removeClass('editable');

      // If the repeater contains TinyMCE editors, fire the `hide` trigger to hide floated toolbars
      currentEditable.find('.elementor-wp-editor').each(function () {
        tinymce.get(this.id).fire('hide');
      });
    }
    if (this.currentEditableChild === rowView) {
      delete this.currentEditableChild;
      return;
    }
    rowView.getChildViewContainer(rowView).addClass('editable');
    this.currentEditableChild = rowView;
    this.updateActiveRow();
  },
  toggleClasses: function toggleClasses() {
    this.toggleMinRowsClass();
    this.toggleMaxRowsClass();
  },
  toggleMaxRowsClass: function toggleMaxRowsClass() {
    var maxItems = this.model.get('max_items');
    if (!maxItems || !Number.isInteger(maxItems)) {
      return;
    }
    this.$el.toggleClass('elementor-repeater-has-maximum-rows', maxItems <= this.collection.length);
  },
  getMinItems: function getMinItems() {
    var minItems = 0;
    if (this.model.get('min_items') && Number.isInteger(this.model.get('min_items'))) {
      minItems = this.model.get('min_items');
    } else if (this.model.get('prevent_empty')) {
      minItems = 1;
    }
    return minItems;
  },
  toggleMinRowsClass: function toggleMinRowsClass() {
    var minItems = this.getMinItems();
    if (!minItems) {
      return;
    }
    this.$el.toggleClass('elementor-repeater-has-minimum-rows', minItems >= this.collection.length);
  },
  updateActiveRow: function updateActiveRow() {
    var activeItemIndex = 1;
    if (this.currentEditableChild) {
      activeItemIndex = this.currentEditableChild.itemIndex;
    }
    this.setEditSetting('activeItemIndex', activeItemIndex);
  },
  updateChildIndexes: function updateChildIndexes() {
    var collection = this.collection;
    this.children.each(function (view) {
      view.updateIndex(collection.indexOf(view.model) + 1);
      view.setTitle();
    });
  },
  getSortableParams: function getSortableParams() {
    return {
      axis: 'y',
      handle: '.elementor-repeater-row-tools',
      items: ' > :not(.elementor-repeater-row--disable-sort)',
      cancel: '' // Elements that do not allow sorting (by default it includs buttons).
    };
  },
  onRender: function onRender() {
    ControlBaseDataView.prototype.onRender.apply(this, arguments);
    if (this.model.get('item_actions').sort) {
      this.ui.fieldContainer.sortable(this.getSortableParams());
    }
    this.toggleClasses();
  },
  onSortStart: function onSortStart(event, ui) {
    ui.item.data('oldIndex', ui.item.index());
  },
  onSortStop: function onSortStop(event, ui) {
    // Reload TinyMCE editors (if exist), it's a bug that TinyMCE content is missing after stop dragging
    var self = this,
      sortedIndex = ui.item.index();
    if (-1 === sortedIndex) {
      return;
    }
    var sortedRowView = self.children.findByIndex(ui.item.index()),
      rowControls = sortedRowView.children._views;
    jQuery.each(rowControls, function () {
      if ('wysiwyg' === this.model.get('type')) {
        sortedRowView.render();
        delete self.currentEditableChild;
        return false;
      }
    });
  },
  onSortUpdate: function onSortUpdate(event, ui) {
    var oldIndex = ui.item.data('oldIndex'),
      newIndex = ui.item.index();
    $e.run('document/repeater/move', {
      container: this.options.container,
      name: this.model.get('name'),
      sourceIndex: oldIndex,
      targetIndex: newIndex
    });
  },
  onAddChild: function onAddChild() {
    this.updateChildIndexes();
    this.updateActiveRow();
    this.toggleClasses();
  },
  /**
   * Update container to ensure that new child elements appear in container children.
   *
   * @param {*} model - Container model.
   */
  updateContainer: function updateContainer(model) {
    var container = this.options.container.repeaters[this.model.get('name')],
      isInChildren = container.children.filter(function (child) {
        return child.id === model.get('_id');
      });
    if (!isInChildren.length) {
      elementorDevTools.deprecation.deprecated('Don\'t add models directly to the repeater.', '3.0.0', '$e.run( \'document/repeater/insert\' )');
      this.options.container.addRepeaterItem(this.model.get('name'), model, model.collection.indexOf(model));
    }
  },
  /**
   * Reset container to ensure that container children are reset on collection reset.
   *
   * @deprecated since 3.0.0, use `$e.run( 'document/repeater/remove' )` instead.
   */
  resetContainer: function resetContainer() {
    elementorDevTools.deprecation.deprecated('Don\'t reset repeater collection directly.', '3.0.0', '$e.run( \'document/repeater/remove\' )');
    this.options.container.repeaters[this.model.get('name')].children = [];
  },
  getDefaults: function getDefaults() {
    var defaults = {};

    // Get default fields.
    _.each(this.model.get('fields'), function (field) {
      defaults[field.name] = field.default;
    });
    return defaults;
  },
  getChildControlView: function getChildControlView(id) {
    return this.getControlViewByModel(this.getControlModel(id));
  },
  getControlViewByModel: function getControlViewByModel(model) {
    return this.children.findByModelCid(model.cid);
  },
  getControlModel: function getControlModel(_id) {
    return this.collection.findWhere({
      _id: _id
    });
  },
  onButtonAddRowClick: function onButtonAddRowClick() {
    var newModel = $e.run('document/repeater/insert', {
      container: this.options.container,
      name: this.model.get('name'),
      model: this.getDefaults()
    });
    var newChild = this.children.findByModel(newModel);
    this.editRow(newChild);
    this.toggleClasses();
  },
  onChildviewClickRemove: function onChildviewClickRemove(childView) {
    if (childView === this.currentEditableChild) {
      delete this.currentEditableChild;
    }
    $e.run('document/repeater/remove', {
      container: this.options.container,
      name: this.model.get('name'),
      index: childView._index
    });
    this.updateActiveRow();
    this.updateChildIndexes();
    this.toggleClasses();
  },
  onChildviewClickDuplicate: function onChildviewClickDuplicate(childView) {
    $e.run('document/repeater/duplicate', {
      container: this.options.container,
      name: this.model.get('name'),
      index: childView._index
    });
    this.toggleClasses();
  },
  onChildviewClickEdit: function onChildviewClickEdit(childView) {
    this.editRow(childView);
  },
  onAfterExternalChange: function onAfterExternalChange() {
    // Update the collection with current value
    this.fillCollection();
    ControlBaseDataView.prototype.onAfterExternalChange.apply(this, arguments);
  }
});
module.exports = ControlRepeaterItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/section.js":
/*!***************************************************!*\
  !*** ../assets/dev/js/editor/controls/section.js ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlBaseView = __webpack_require__(/*! elementor-controls/base */ "../assets/dev/js/editor/controls/base.js"),
  ControlSectionItemView;
ControlSectionItemView = ControlBaseView.extend({
  ui: function ui() {
    var ui = ControlBaseView.prototype.ui.apply(this, arguments);
    ui.heading = '.elementor-panel-heading';
    return ui;
  },
  triggers: {
    click: 'control:section:clicked'
  }
});
module.exports = ControlSectionItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/select.js":
/*!**************************************************!*\
  !*** ../assets/dev/js/editor/controls/select.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js"),
  ControlSelectItemView;
ControlSelectItemView = ControlBaseDataView.extend({
  updatePlaceholder: function updatePlaceholder() {
    var select = this.ui.select;
    if (!select) {
      return;
    }
    var selected = select.find('option:selected');

    // When option with an empty value ('') selected, and it's not the placeholder option,
    // set the selected option to the placeholder.
    if ('' === selected.val() && !selected.hasClass('e-option-placeholder')) {
      selected = select.find('.e-option-placeholder');
      selected.prop('selected', true);
    }
    if (selected.hasClass('e-option-placeholder')) {
      select.addClass('e-select-placeholder');
    } else {
      select.removeClass('e-select-placeholder');
    }
  },
  onReady: function onReady() {
    var placeholder = this.getControlPlaceholder();
    if (placeholder) {
      jQuery('<option>').val('').text(this.model.get('options')[placeholder]).addClass('e-option-placeholder').prependTo(this.ui.select);
    }
    this.updatePlaceholder();
  },
  onInputChange: function onInputChange() {
    this.updatePlaceholder();
  }
}, {
  onPasteStyle: function onPasteStyle(control, clipboardValue) {
    if (control.groups) {
      return control.groups.some(function (group) {
        return ControlSelectItemView.onPasteStyle(group, clipboardValue);
      });
    }
    return undefined !== control.options[clipboardValue];
  }
});
module.exports = ControlSelectItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/select2.js":
/*!***************************************************!*\
  !*** ../assets/dev/js/editor/controls/select2.js ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _select = _interopRequireDefault(__webpack_require__(/*! elementor-editor-utils/select2.js */ "../assets/dev/js/editor/utils/select2.js"));
var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js"),
  ControlSelect2ItemView;
ControlSelect2ItemView = ControlBaseDataView.extend({
  getSelect2Placeholder: function getSelect2Placeholder() {
    return this.ui.select.find("[value=\"".concat(this.getControlPlaceholder(), "\"]")).text() || this.ui.select.children('option:first[value=""]').text();
  },
  getSelect2DefaultOptions: function getSelect2DefaultOptions() {
    var defaultOptions = {
        allowClear: true,
        placeholder: this.getSelect2Placeholder(),
        dir: elementorCommon.config.isRTL ? 'rtl' : 'ltr'
      },
      lockedOptions = this.model.get('lockedOptions');

    // If any non-deletable options are passed, remove the 'x' element from the template for selected items.
    if (lockedOptions) {
      defaultOptions.templateSelection = function (data, container) {
        if (lockedOptions.includes(data.id)) {
          jQuery(container).addClass('e-non-deletable').find('.select2-selection__choice__remove').remove();
        }
        return data.text;
      };
    }
    return defaultOptions;
  },
  getSelect2Options: function getSelect2Options() {
    return jQuery.extend(this.getSelect2DefaultOptions(), this.model.get('select2options'));
  },
  updatePlaceholder: function updatePlaceholder() {
    if (this.getControlPlaceholder()) {
      this.select2Instance.elements.$container.find('.select2-selection__placeholder').addClass('e-select2-placeholder');
    }
  },
  applySavedValue: function applySavedValue() {
    ControlBaseDataView.prototype.applySavedValue.apply(this, arguments);
    var elementSelect2Data = this.ui.select.data('select2');

    // Checking if the element itself was initiated with select2 functionality in case of multiple renders.
    if (!elementSelect2Data) {
      this.select2Instance = new _select.default({
        $element: this.ui.select,
        options: this.getSelect2Options()
      });
      this.updatePlaceholder();
      this.handleLockedOptions();
    } else {
      this.ui.select.trigger('change');
    }
  },
  handleLockedOptions: function handleLockedOptions() {
    var lockedOptions = this.model.get('lockedOptions');
    if (lockedOptions) {
      this.ui.select.on('select2:unselecting', function (event) {
        if (lockedOptions.includes(event.params.args.data.id)) {
          event.preventDefault();
        }
      });
    }
  },
  /**
   * @deprecated since 3.0.0
   */
  onReady: function onReady() {
    elementorDevTools.deprecation.deprecated('onReady()', '3.0.0');
  },
  /**
   * Get Input Value
   *
   * This method is an override of the base method. It is needed because when clearing the Select2 value in single
   * value mode, the library sets that value to `null`, and an empty string is the system's default empty value.
   *
   * @param {*} input current control input
   * @return {*} potentially modified input value
   */
  getInputValue: function getInputValue(input) {
    var _ControlBaseDataView$;
    // eslint-disable-line no-unused-vars
    return (_ControlBaseDataView$ = ControlBaseDataView.prototype.getInputValue.apply(this, arguments)) !== null && _ControlBaseDataView$ !== void 0 ? _ControlBaseDataView$ : '';
  },
  onBaseInputChange: function onBaseInputChange() {
    ControlBaseDataView.prototype.onBaseInputChange.apply(this, arguments);
    this.updatePlaceholder();
  },
  onBeforeDestroy: function onBeforeDestroy() {
    // We always destroy the select2 instance because there are cases where the DOM element's data cache
    // itself has been destroyed but the select2 instance on it still exists
    this.select2Instance.destroy();
    this.$el.remove();
  }
});
module.exports = ControlSelect2ItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/slider.js":
/*!**************************************************!*\
  !*** ../assets/dev/js/editor/controls/slider.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _helpers = __webpack_require__(/*! elementor-editor-utils/helpers */ "../assets/dev/js/editor/utils/helpers.js");
var ControlBaseUnitsItemView = __webpack_require__(/*! elementor-controls/base-units */ "../assets/dev/js/editor/controls/base-units.js"),
  ControlSliderItemView;
ControlSliderItemView = ControlBaseUnitsItemView.extend({
  ui: function ui() {
    var ui = ControlBaseUnitsItemView.prototype.ui.apply(this, arguments);
    ui.slider = '.elementor-slider';
    return ui;
  },
  templateHelpers: function templateHelpers() {
    var templateHelpers = ControlBaseUnitsItemView.prototype.templateHelpers.apply(this, arguments);
    templateHelpers.isMultiple = this.isMultiple();
    return templateHelpers;
  },
  isMultiple: function isMultiple() {
    var sizes = this.getControlValue('sizes');
    return !jQuery.isEmptyObject(sizes);
  },
  initSlider: function initSlider() {
    // Slider does not exist in tests.
    if (!this.ui.slider[0]) {
      return;
    }
    if (this.isCustomUnit()) {
      return;
    }
    this.destroySlider();
    var isMultiple = this.isMultiple(),
      unitRange = elementorCommon.helpers.cloneObject(this.getCurrentRange()),
      step = unitRange.step;
    var sizes = this.getSize();
    if (isMultiple) {
      sizes = Object.values(sizes);
    } else {
      sizes = [sizes];

      // Make sure the value is a number, because the slider can't handle strings.
      sizes[0] = parseFloat(sizes[0]) || 0;
      this.ui.input.attr(unitRange);
    }
    delete unitRange.step;
    var tooltips;
    var self = this;
    if (isMultiple) {
      tooltips = [];
      sizes.forEach(function () {
        return tooltips.push({
          to: function to(value) {
            return value + self.getControlValue('unit');
          }
        });
      });
    }
    var sliderInstance = noUiSlider.create(this.ui.slider[0], {
      start: sizes,
      range: unitRange,
      step: step,
      tooltips: tooltips,
      connect: isMultiple,
      format: {
        to: function to(value) {
          return Math.round(value * 1000) / 1000;
        },
        from: function from(value) {
          return +value;
        }
      }
    });
    sliderInstance.on('slide', this.onSlideChange.bind(this));
  },
  applySavedValue: function applySavedValue() {
    ControlBaseUnitsItemView.prototype.applySavedValue.apply(this, arguments);
    // Slider does not exist in tests.
    if (this.isSliderInitialized()) {
      this.ui.slider[0].noUiSlider.set(this.getSize());
    }
  },
  isSliderInitialized: function isSliderInitialized() {
    return this.ui.slider[0] && this.ui.slider[0].noUiSlider;
  },
  getSize: function getSize() {
    var _this$getControlPlace, _this$model$get;
    var property = this.isMultiple() ? 'sizes' : 'size',
      value = this.getControlValue(property);
    return value || ((_this$getControlPlace = this.getControlPlaceholder()) === null || _this$getControlPlace === void 0 ? void 0 : _this$getControlPlace[property]) || ((_this$model$get = this.model.get('default')) === null || _this$model$get === void 0 ? void 0 : _this$model$get[property]);
  },
  resetSize: function resetSize() {
    if (this.isMultiple()) {
      this.setValue('sizes', {});
    } else {
      this.setValue('size', '');
    }
    this.initSlider();
  },
  destroySlider: function destroySlider() {
    // Slider does not exist in tests.
    if (this.ui.slider[0] && this.ui.slider[0].noUiSlider) {
      this.ui.slider[0].noUiSlider.destroy();
    }
  },
  onReady: function onReady() {
    if (this.isMultiple()) {
      this.$el.addClass('elementor-control-type-slider--multiple elementor-control-type-slider--handles-' + this.model.get('handles'));
    }
    this.initSlider();
  },
  onSlideChange: function onSlideChange(values, index) {
    if (this.isMultiple()) {
      var sizes = elementorCommon.helpers.cloneObject(this.getSize()),
        key = Object.keys(sizes)[index];
      sizes[key] = values[index];
      this.setValue('sizes', sizes);
    } else {
      this.setValue('size', values[0]);
      this.ui.input.val(values[0]);
    }
  },
  onInputChange: function onInputChange(event) {
    var dataChanged = event.currentTarget.dataset.setting;
    if ('size' === dataChanged && this.isSliderInitialized()) {
      this.ui.slider[0].noUiSlider.set(this.getSize());
    } else if ('unit' === dataChanged) {
      this.handleUnitChange();
    }
  },
  handleUnitChange: function handleUnitChange() {
    if (!this.isCustomUnit()) {
      this.resetSize();
    }
    this.maybeDoFractionToCustomConversions();
  },
  updateUnitChoices: function updateUnitChoices() {
    ControlBaseUnitsItemView.prototype.updateUnitChoices.apply(this, arguments);
    var inputType = 'number';
    if (this.isCustomUnit()) {
      inputType = 'text';
      this.destroySlider();
    } else {
      this.initSlider();
    }
    if (!this.isMultiple()) {
      this.ui.input.attr('type', inputType);
    }
  },
  maybeDoFractionToCustomConversions: function maybeDoFractionToCustomConversions() {
    var _this$getControlPlace2, _this$model$get2;
    if (this.isMultiple()) {
      return;
    }

    /*
    We want our code to run only when the user switched from 'fr' to 'custom'.
    But currently we do not have the previous state, so we won't know the user was previously on 'fr'.
    So we make the assumption that if the control only has two units ('fr' and 'custom'), and we
    are switching to custom now, then we can run our conversion logic.
    In future, we might want to investigate a way to build some kind of 'previous state cache' to know
    where we switched from.
    */
    var sizeUnits = this.model.get('size_units'),
      isFrToCustom = 2 === (sizeUnits === null || sizeUnits === void 0 ? void 0 : sizeUnits.length) && sizeUnits.includes('fr') && sizeUnits.includes('custom');
    if (!isFrToCustom) {
      return;
    }
    var currentSize = this.getSize(),
      alreadyConverted = 'string' === typeof currentSize && currentSize.includes('fr');
    if (alreadyConverted) {
      return;
    }
    var sizeValue = this.isCustomUnit() ? (0, _helpers.convertSizeToFrString)(currentSize) : ((_this$getControlPlace2 = this.getControlPlaceholder()) === null || _this$getControlPlace2 === void 0 ? void 0 : _this$getControlPlace2.size) || ((_this$model$get2 = this.model.get('default')) === null || _this$model$get2 === void 0 ? void 0 : _this$model$get2.size);
    this.setValue('size', sizeValue);
    this.render();
  },
  onBeforeDestroy: function onBeforeDestroy() {
    this.destroySlider();
    this.$el.remove();
  },
  onDeviceModeChange: function onDeviceModeChange() {
    var _this = this;
    var currentDeviceMode = elementor.channels.deviceMode.request('currentMode'),
      isMobile = 'mobile' === currentDeviceMode,
      isMobileValue = this.model.get('name').includes('_mobile'),
      hasDefault = this.model.get('default'),
      shouldRunConversion = isMobile && isMobileValue && hasDefault && this.isCustomUnit();
    if (shouldRunConversion) {
      setTimeout(function () {
        _this.maybeDoFractionToCustomConversions();
      });
    }
  }
});
module.exports = ControlSliderItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/structure.js":
/*!*****************************************************!*\
  !*** ../assets/dev/js/editor/controls/structure.js ***!
  \*****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js"),
  ControlStructureItemView;
ControlStructureItemView = ControlBaseDataView.extend({
  ui: function ui() {
    var ui = ControlBaseDataView.prototype.ui.apply(this, arguments);
    ui.resetStructure = '.elementor-control-structure-reset';
    return ui;
  },
  events: function events() {
    return _.extend(ControlBaseDataView.prototype.events.apply(this, arguments), {
      'click @ui.resetStructure': 'onResetStructureClick'
    });
  },
  templateHelpers: function templateHelpers() {
    var helpers = ControlBaseDataView.prototype.templateHelpers.apply(this, arguments);
    helpers.getMorePresets = this.getMorePresets.bind(this);
    return helpers;
  },
  getCurrentEditedSection: function getCurrentEditedSection() {
    var editor = elementor.getPanelView().getCurrentPageView();
    return editor.getOption('editedElementView');
  },
  getMorePresets: function getMorePresets() {
    var parsedStructure = elementor.presetsFactory.getParsedStructure(this.getControlValue());
    return elementor.presetsFactory.getPresets(parsedStructure.columnsCount);
  },
  onResetStructureClick: function onResetStructureClick() {
    this.getCurrentEditedSection().resetColumnsCustomSize();
  }
});
module.exports = ControlStructureItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/switcher.js":
/*!****************************************************!*\
  !*** ../assets/dev/js/editor/controls/switcher.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js");
module.exports = ControlBaseDataView.extend({
  setInputValue: function setInputValue(input, value) {
    this.$(input).prop('checked', this.model.get('return_value') === value);
  }
}, {
  onPasteStyle: function onPasteStyle(control, clipboardValue) {
    return !clipboardValue || clipboardValue === control.return_value;
  }
});

/***/ }),

/***/ "../assets/dev/js/editor/controls/tab.js":
/*!***********************************************!*\
  !*** ../assets/dev/js/editor/controls/tab.js ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlBaseView = __webpack_require__(/*! elementor-controls/base */ "../assets/dev/js/editor/controls/base.js"),
  ControlTabItemView;
ControlTabItemView = ControlBaseView.extend({
  triggers: {
    click: {
      event: 'control:tab:clicked',
      stopPropagation: false
    }
  }
});
module.exports = ControlTabItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/url.js":
/*!***********************************************!*\
  !*** ../assets/dev/js/editor/controls/url.js ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _readOnlyError2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/readOnlyError */ "../node_modules/@babel/runtime/helpers/readOnlyError.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, o, e, r) { var p = (0, _get2.default)((0, _getPrototypeOf2.default)(1 & r ? t.prototype : t), o, e); return 2 & r && "function" == typeof p ? function (t) { return p.apply(e, t); } : p; }
var BaseMultiple = __webpack_require__(/*! elementor-controls/base-multiple */ "../assets/dev/js/editor/controls/base-multiple.js");
var URL = /*#__PURE__*/function (_BaseMultiple) {
  function URL() {
    (0, _classCallCheck2.default)(this, URL);
    return _callSuper(this, URL, arguments);
  }
  (0, _inherits2.default)(URL, _BaseMultiple);
  return (0, _createClass2.default)(URL, [{
    key: "ui",
    value: function ui() {
      var ui = _superPropGet(URL, "ui", this, 3)([]);
      ui.mainInput = '.elementor-input';
      ui.moreOptionsToggle = '.elementor-control-url-more';
      ui.moreOptions = '.elementor-control-url-more-options';
      return ui;
    }
  }, {
    key: "events",
    value: function events() {
      var events = _superPropGet(URL, "events", this, 3)([]);
      events['click @ui.moreOptionsToggle'] = 'onMoreOptionsToggleClick';
      return events;
    }
  }, {
    key: "autoComplete",
    value: function autoComplete() {
      var _this = this;
      var $mainInput = this.ui.mainInput,
        positionBase = elementorCommon.config.isRTL ? 'right' : 'left';
      var last, cache;

      // Based on /wp-includes/js/tinymce/plugins/wplink/plugin.js.
      $mainInput.autocomplete({
        source: function source(request, response) {
          if (!_this.options.model.attributes.autocomplete) {
            return;
          }
          if (last === request.term) {
            response(cache);
            return;
          }
          if (/^https?:/.test(request.term) || request.term.indexOf('.') !== -1) {
            return response();
          }

          // Show Spinner.
          $mainInput.prev().show();
          jQuery.post(window.ajaxurl, {
            editor: 'elementor',
            action: 'wp-link-ajax',
            page: 1,
            search: request.term,
            _ajax_linking_nonce: jQuery('#_ajax_linking_nonce').val()
          }, function (data) {
            cache = data;
            response(data);
          }, 'json').always(function () {
            return $mainInput.prev().hide();
          });
          last = request.term;
        },
        focus: function focus(event) {
          /*
           * Don't empty the URL input field, when using the arrow keys to
           * highlight items. See api.jqueryui.com/autocomplete/#event-focus
           */
          event.preventDefault();
        },
        select: function select(event, ui) {
          $mainInput.val(ui.item.permalink);
          _this.setValue('url', ui.item.permalink);
          return false;
        },
        open: function open(event) {
          jQuery(event.target).data('uiAutocomplete').menu.activeMenu.addClass('elementor-autocomplete-menu');
        },
        minLength: 2,
        position: {
          my: positionBase + ' top+2',
          at: positionBase + ' bottom'
        }
      });

      // The `_renderItem` cannot be override via the arguments.
      $mainInput.autocomplete('instance')._renderItem = function (ul, item) {
        var fallbackTitle = window.wpLinkL10n ? window.wpLinkL10n.noTitle : '',
          title = item.title ? item.title : fallbackTitle;
        return jQuery('<li role="option" id="mce-wp-autocomplete-' + item.ID + '">').append('<span>' + title + '</span>&nbsp;<span class="elementor-autocomplete-item-info">' + item.info + '</span>').appendTo(ul);
      };
    }
  }, {
    key: "onReady",
    value: function onReady() {
      this.autoComplete();
    }
  }, {
    key: "onMoreOptionsToggleClick",
    value: function onMoreOptionsToggleClick() {
      this.ui.moreOptions.slideToggle();
    }
  }, {
    key: "onBeforeDestroy",
    value: function onBeforeDestroy() {
      if (this.ui.mainInput.data('autocomplete')) {
        this.ui.mainInput.autocomplete('destroy');
      }
      this.$el.remove();
    }
  }]);
}(BaseMultiple);
module.exports = URL;

/***/ }),

/***/ "../assets/dev/js/editor/controls/visual-choice.js":
/*!*********************************************************!*\
  !*** ../assets/dev/js/editor/controls/visual-choice.js ***!
  \*********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js"),
  ControlVisualChoiceItemView;
ControlVisualChoiceItemView = ControlBaseDataView.extend({
  ui: function ui() {
    var ui = ControlBaseDataView.prototype.ui.apply(this, arguments);
    ui.inputs = '[type="radio"]';
    return ui;
  },
  events: function events() {
    return _.extend(ControlBaseDataView.prototype.events.apply(this, arguments), {
      'mousedown label': 'onMouseDownLabel',
      'click @ui.inputs': 'onClickInput',
      'change @ui.inputs': 'onBaseInputChange'
    });
  },
  updatePlaceholder: function updatePlaceholder() {
    var placeholder = this.getControlPlaceholder();
    if (!this.getControlValue() && placeholder) {
      // Find the input which has value equals to the placeholder (which is the parent's value),
      // and add it a placeholder class, to indicate which value is selected in the parent.
      this.ui.inputs.filter("[value=\"".concat(this.getControlPlaceholder(), "\"]")).addClass('e-visual-choice-placeholder');
    } else {
      this.ui.inputs.removeClass('e-visual-choice-placeholder');
    }
  },
  onReady: function onReady() {
    this.updatePlaceholder();
  },
  applySavedValue: function applySavedValue() {
    var currentValue = this.getControlValue();
    if (currentValue) {
      this.ui.inputs.filter('[value="' + currentValue + '"]').prop('checked', true);
    } else {
      this.ui.inputs.filter(':checked').prop('checked', false);
    }
  },
  onMouseDownLabel: function onMouseDownLabel(event) {
    var $clickedLabel = this.$(event.currentTarget),
      $selectedInput = this.$('#' + $clickedLabel.attr('for'));
    $selectedInput.data('checked', $selectedInput.prop('checked'));
  },
  onClickInput: function onClickInput(event) {
    if (!this.model.get('toggle')) {
      return;
    }
    var $selectedInput = this.$(event.currentTarget);
    if ($selectedInput.data('checked')) {
      $selectedInput.prop('checked', false).trigger('change');
    }
  },
  onBaseInputChange: function onBaseInputChange() {
    ControlBaseDataView.prototype.onBaseInputChange.apply(this, arguments);
    this.updatePlaceholder();
  }
}, {
  onPasteStyle: function onPasteStyle(control, clipboardValue) {
    return '' === clipboardValue || undefined !== control.options[clipboardValue];
  }
});
module.exports = ControlVisualChoiceItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/wp_widget.js":
/*!*****************************************************!*\
  !*** ../assets/dev/js/editor/controls/wp_widget.js ***!
  \*****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js"),
  ControlWPWidgetItemView;
ControlWPWidgetItemView = ControlBaseDataView.extend({
  ui: function ui() {
    var ui = ControlBaseDataView.prototype.ui.apply(this, arguments);
    ui.form = 'form';
    ui.loading = '.wp-widget-form-loading';
    return ui;
  },
  events: function events() {
    return {
      'keyup @ui.form :input': 'onFormChanged',
      'change @ui.form :input': 'onFormChanged'
    };
  },
  onFormChanged: function onFormChanged() {
    var idBase = 'widget-' + this.model.get('id_base'),
      settings = this.ui.form.elementorSerializeObject()[idBase].REPLACE_TO_ID;
    this.setValue(settings);
  },
  onReady: function onReady() {
    var self = this;
    elementorCommon.ajax.addRequest('editor_get_wp_widget_form', {
      data: {
        // Fake Widget ID
        id: self.model.cid,
        widget_type: self.model.get('widget'),
        data: self.container.settings.toJSON()
      },
      success: function success(data) {
        self.ui.form.html(data);
        // WP >= 4.8
        if (wp.textWidgets) {
          self.ui.form.addClass('open');
          var event = new jQuery.Event('widget-added');
          wp.textWidgets.handleWidgetAdded(event, self.ui.form);
          wp.mediaWidgets.handleWidgetAdded(event, self.ui.form);

          // WP >= 4.9
          if (wp.customHtmlWidgets) {
            wp.customHtmlWidgets.handleWidgetAdded(event, self.ui.form);
          }
        }
        var widgetType = self.model.get('widget');
        elementor.hooks.doAction("panel/widgets/".concat(widgetType, "/controls/wp_widget/loaded"), self);
      }
    });
  }
});
module.exports = ControlWPWidgetItemView;

/***/ }),

/***/ "../assets/dev/js/editor/controls/wysiwyg.js":
/*!***************************************************!*\
  !*** ../assets/dev/js/editor/controls/wysiwyg.js ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ControlBaseDataView = __webpack_require__(/*! elementor-controls/base-data */ "../assets/dev/js/editor/controls/base-data.js"),
  ControlWysiwygItemView;
ControlWysiwygItemView = ControlBaseDataView.extend({
  editor: null,
  ui: function ui() {
    var ui = ControlBaseDataView.prototype.ui.apply(this, arguments);
    jQuery.extend(ui, {
      inputWrapper: '.elementor-control-input-wrapper'
    });
    return ui;
  },
  events: function events() {
    return _.extend(ControlBaseDataView.prototype.events.apply(this, arguments), {
      'keyup textarea.elementor-wp-editor': 'onBaseInputChange'
    });
  },
  // List of buttons to move {buttonToMove: afterButton}
  buttons: {
    addToBasic: {
      underline: 'italic'
    },
    addToAdvanced: {},
    moveToAdvanced: {
      blockquote: 'removeformat',
      alignleft: 'blockquote',
      aligncenter: 'alignleft',
      alignright: 'aligncenter'
    },
    moveToBasic: {},
    removeFromBasic: ['unlink', 'wp_more'],
    removeFromAdvanced: []
  },
  initialize: function initialize() {
    ControlBaseDataView.prototype.initialize.apply(this, arguments);
    var self = this;
    self.editorID = 'elementorwpeditor' + self.cid;

    // Wait a cycle before initializing the editors.
    _.defer(function () {
      if (self.isDestroyed) {
        return;
      }

      // Initialize QuickTags, and set as the default mode.
      quicktags({
        buttons: 'strong,em,del,link,img,close',
        id: self.editorID
      });
      if (elementor.config.rich_editing_enabled) {
        switchEditors.go(self.editorID, 'tmce');
      }
      delete QTags.instances[0];
    });
    if (!elementor.config.rich_editing_enabled) {
      self.$el.addClass('elementor-rich-editing-disabled');
      return;
    }
    var editorConfig = {
      id: self.editorID,
      selector: '#' + self.editorID,
      setup: function setup(editor) {
        self.editor = editor;
      }
    };
    tinyMCEPreInit.mceInit[self.editorID] = _.extend(_.clone(tinyMCEPreInit.mceInit.elementorwpeditor), editorConfig);
    if (!elementor.config.tinymceHasCustomConfig) {
      self.rearrangeButtons();
    }
  },
  applySavedValue: function applySavedValue() {
    if (!this.editor) {
      return;
    }
    var controlValue = this.getControlValue();
    this.editor.setContent(controlValue);

    // Update also the plain textarea
    jQuery('#' + this.editorID).val(controlValue);
  },
  saveEditor: function saveEditor() {
    this.setValue(this.editor.getContent());
  },
  moveButtons: function moveButtons(buttonsToMove, from, to) {
    if (!to) {
      to = from;
      from = null;
    }
    _.each(buttonsToMove, function (afterButton, button) {
      var afterButtonIndex = to.indexOf(afterButton);
      if (from) {
        var buttonIndex = from.indexOf(button);
        if (-1 === buttonIndex) {
          throw new ReferenceError('Trying to move non-existing button `' + button + '`');
        }
        from.splice(buttonIndex, 1);
      }
      if (-1 === afterButtonIndex) {
        throw new ReferenceError('Trying to move button after non-existing button `' + afterButton + '`');
      }
      to.splice(afterButtonIndex + 1, 0, button);
    });
  },
  rearrangeButtons: function rearrangeButtons() {
    var editorProps = tinyMCEPreInit.mceInit[this.editorID],
      editorBasicToolbarButtons = editorProps.toolbar1.split(','),
      editorAdvancedToolbarButtons = editorProps.toolbar2.split(',');
    editorBasicToolbarButtons = _.difference(editorBasicToolbarButtons, this.buttons.removeFromBasic);
    editorAdvancedToolbarButtons = _.difference(editorAdvancedToolbarButtons, this.buttons.removeFromAdvanced);
    this.moveButtons(this.buttons.moveToBasic, editorAdvancedToolbarButtons, editorBasicToolbarButtons);
    this.moveButtons(this.buttons.moveToAdvanced, editorBasicToolbarButtons, editorAdvancedToolbarButtons);
    this.moveButtons(this.buttons.addToBasic, editorBasicToolbarButtons);
    this.moveButtons(this.buttons.addToAdvanced, editorAdvancedToolbarButtons);
    editorProps.toolbar1 = editorBasicToolbarButtons.join(',');
    editorProps.toolbar2 = editorAdvancedToolbarButtons.join(',');
  },
  onReady: function onReady() {
    var _this = this;
    var $editor = jQuery(elementor.config.wp_editor.replace(/elementorwpeditor/g, this.editorID).replace('%%EDITORCONTENT%%', ''));
    $editor.find('.wp-editor-area').text(this.getControlValue());
    $editor.find(".wp-editor-tabs").addClass('elementor-control-dynamic-switcher-wrapper');
    this.ui.inputWrapper.html($editor);
    setTimeout(function () {
      if (!_this.isDestroyed && _this.editor) {
        _this.editor.on('keyup change undo redo', _this.saveEditor.bind(_this));
      }
    }, 100);
  },
  onBeforeDestroy: function onBeforeDestroy() {
    // Remove TinyMCE and QuickTags instances
    delete QTags.instances[this.editorID];
    if (!elementor.config.rich_editing_enabled) {
      return;
    }
    tinymce.EditorManager.execCommand('mceRemoveEditor', true, this.editorID);

    // Cleanup PreInit data
    delete tinyMCEPreInit.mceInit[this.editorID];
    delete tinyMCEPreInit.qtInit[this.editorID];
  }
});
module.exports = ControlWysiwygItemView;

/***/ }),

/***/ "../assets/dev/js/editor/data/globals/base/create-base.js":
/*!****************************************************************!*\
  !*** ../assets/dev/js/editor/data/globals/base/create-base.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var CreateBase = exports["default"] = /*#__PURE__*/function (_$e$modules$editor$Co) {
  function CreateBase() {
    (0, _classCallCheck2.default)(this, CreateBase);
    return _callSuper(this, CreateBase, arguments);
  }
  (0, _inherits2.default)(CreateBase, _$e$modules$editor$Co);
  return (0, _createClass2.default)(CreateBase, [{
    key: "validateArgs",
    value: function validateArgs() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      this.requireContainer(args);
      this.requireArgumentType('setting', 'string', args);
      this.requireArgumentType('title', 'string', args);
    }
  }]);
}($e.modules.editor.CommandContainerBase);

/***/ }),

/***/ "../assets/dev/js/editor/data/globals/colors/commands/create.js":
/*!**********************************************************************!*\
  !*** ../assets/dev/js/editor/data/globals/colors/commands/create.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Create = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _createBase = _interopRequireDefault(__webpack_require__(/*! elementor-editor/data/globals/base/create-base */ "../assets/dev/js/editor/data/globals/base/create-base.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Create = exports.Create = /*#__PURE__*/function (_CreateBase) {
  function Create() {
    (0, _classCallCheck2.default)(this, Create);
    return _callSuper(this, Create, arguments);
  }
  (0, _inherits2.default)(Create, _CreateBase);
  return (0, _createClass2.default)(Create, [{
    key: "apply",
    value: function apply() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var container = args.container,
        setting = args.setting,
        title = args.title,
        controls = container.controls;
      var result = false;
      if (!controls[setting]) {
        throw new Error("Invalid setting: control '".concat(setting, "', not found."));
      }

      // `args.id` used by tests.
      var id = args.id || elementorCommon.helpers.getUniqueId();
      result = $e.data.create("globals/colors?id=".concat(id), {
        title: title,
        value: container.settings.get(setting)
      });
      return result;
    }
  }]);
}(_createBase.default);

/***/ }),

/***/ "../assets/dev/js/editor/data/globals/colors/commands/index.js":
/*!*********************************************************************!*\
  !*** ../assets/dev/js/editor/data/globals/colors/commands/index.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Create", ({
  enumerable: true,
  get: function get() {
    return _create.Create;
  }
}));
var _create = __webpack_require__(/*! ./create */ "../assets/dev/js/editor/data/globals/colors/commands/create.js");

/***/ }),

/***/ "../assets/dev/js/editor/data/globals/colors/component.js":
/*!****************************************************************!*\
  !*** ../assets/dev/js/editor/data/globals/colors/component.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _componentBase = _interopRequireDefault(__webpack_require__(/*! elementor-api/modules/component-base */ "../modules/web-cli/assets/js/modules/component-base.js"));
var commands = _interopRequireWildcard(__webpack_require__(/*! ./commands/ */ "../assets/dev/js/editor/data/globals/colors/commands/index.js"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Component = exports["default"] = /*#__PURE__*/function (_ComponentBase) {
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _callSuper(this, Component, arguments);
  }
  (0, _inherits2.default)(Component, _ComponentBase);
  return (0, _createClass2.default)(Component, [{
    key: "getNamespace",
    value: function getNamespace() {
      return 'globals/colors';
    }
  }, {
    key: "defaultCommands",
    value: function defaultCommands() {
      return this.importCommands(commands);
    }
  }]);
}(_componentBase.default);

/***/ }),

/***/ "../assets/dev/js/editor/data/globals/commands/data/colors.js":
/*!********************************************************************!*\
  !*** ../assets/dev/js/editor/data/globals/commands/data/colors.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Colors = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Colors = exports.Colors = /*#__PURE__*/function (_$e$modules$CommandDa) {
  function Colors() {
    (0, _classCallCheck2.default)(this, Colors);
    return _callSuper(this, Colors, arguments);
  }
  (0, _inherits2.default)(Colors, _$e$modules$CommandDa);
  return (0, _createClass2.default)(Colors, null, [{
    key: "getEndpointFormat",
    value: function getEndpointFormat() {
      return 'globals/colors/{id}';
    }
  }]);
}($e.modules.CommandData);
var _default = exports["default"] = Colors;

/***/ }),

/***/ "../assets/dev/js/editor/data/globals/commands/data/index.js":
/*!*******************************************************************!*\
  !*** ../assets/dev/js/editor/data/globals/commands/data/index.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Colors", ({
  enumerable: true,
  get: function get() {
    return _colors.Colors;
  }
}));
exports.Index = void 0;
Object.defineProperty(exports, "Typography", ({
  enumerable: true,
  get: function get() {
    return _typography.Typography;
  }
}));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _colors = __webpack_require__(/*! ./colors */ "../assets/dev/js/editor/data/globals/commands/data/colors.js");
var _typography = __webpack_require__(/*! ./typography */ "../assets/dev/js/editor/data/globals/commands/data/typography.js");
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } // Alphabetical order
// TODO: Remove - Move to into base, Possible to handle using ComponentData.
var Index = exports.Index = /*#__PURE__*/function (_$e$modules$CommandDa) {
  function Index() {
    (0, _classCallCheck2.default)(this, Index);
    return _callSuper(this, Index, arguments);
  }
  (0, _inherits2.default)(Index, _$e$modules$CommandDa);
  return (0, _createClass2.default)(Index, null, [{
    key: "getEndpointFormat",
    value: function getEndpointFormat() {
      // Format 'globals/index' to 'globals'.
      return 'globals';
    }
  }]);
}($e.modules.CommandData);

/***/ }),

/***/ "../assets/dev/js/editor/data/globals/commands/data/typography.js":
/*!************************************************************************!*\
  !*** ../assets/dev/js/editor/data/globals/commands/data/typography.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Typography = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Typography = exports.Typography = /*#__PURE__*/function (_$e$modules$CommandDa) {
  function Typography() {
    (0, _classCallCheck2.default)(this, Typography);
    return _callSuper(this, Typography, arguments);
  }
  (0, _inherits2.default)(Typography, _$e$modules$CommandDa);
  return (0, _createClass2.default)(Typography, null, [{
    key: "getEndpointFormat",
    value: function getEndpointFormat() {
      return 'globals/typography/{id}';
    }
  }]);
}($e.modules.CommandData);
var _default = exports["default"] = Typography;

/***/ }),

/***/ "../assets/dev/js/editor/data/globals/component.js":
/*!*********************************************************!*\
  !*** ../assets/dev/js/editor/data/globals/component.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _componentBase = _interopRequireDefault(__webpack_require__(/*! elementor-api/modules/component-base */ "../modules/web-cli/assets/js/modules/component-base.js"));
var _component = _interopRequireDefault(__webpack_require__(/*! ./typography/component */ "../assets/dev/js/editor/data/globals/typography/component.js"));
var _component2 = _interopRequireDefault(__webpack_require__(/*! ./colors/component */ "../assets/dev/js/editor/data/globals/colors/component.js"));
var commandsData = _interopRequireWildcard(__webpack_require__(/*! ./commands/data/ */ "../assets/dev/js/editor/data/globals/commands/data/index.js"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, o, e, r) { var p = (0, _get2.default)((0, _getPrototypeOf2.default)(1 & r ? t.prototype : t), o, e); return 2 & r && "function" == typeof p ? function (t) { return p.apply(e, t); } : p; }
var Component = exports["default"] = /*#__PURE__*/function (_ComponentBase) {
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _callSuper(this, Component, arguments);
  }
  (0, _inherits2.default)(Component, _ComponentBase);
  return (0, _createClass2.default)(Component, [{
    key: "__construct",
    value: function __construct() {
      var _this = this;
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      _superPropGet(Component, "__construct", this, 3)([args]);
      elementorCommon.elements.$window.on('elementor:loaded', function () {
        return _this.refreshGlobalData();
      });
    }
  }, {
    key: "getNamespace",
    value: function getNamespace() {
      return 'globals';
    }
  }, {
    key: "registerAPI",
    value: function registerAPI() {
      $e.components.register(new _component.default({
        manager: this
      }));
      $e.components.register(new _component2.default({
        manager: this
      }));
      _superPropGet(Component, "registerAPI", this, 3)([]);
    }
  }, {
    key: "defaultData",
    value: function defaultData() {
      return this.importCommands(commandsData);
    }
  }, {
    key: "refreshGlobalData",
    value: function refreshGlobalData() {
      $e.data.deleteCache($e.components.get('globals'), 'globals/index');
    }
  }]);
}(_componentBase.default);

/***/ }),

/***/ "../assets/dev/js/editor/data/globals/typography/commands/create.js":
/*!**************************************************************************!*\
  !*** ../assets/dev/js/editor/data/globals/typography/commands/create.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Create = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _createBase = _interopRequireDefault(__webpack_require__(/*! elementor-editor/data/globals/base/create-base */ "../assets/dev/js/editor/data/globals/base/create-base.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Create = exports.Create = /*#__PURE__*/function (_CreateBase) {
  function Create() {
    (0, _classCallCheck2.default)(this, Create);
    return _callSuper(this, Create, arguments);
  }
  (0, _inherits2.default)(Create, _CreateBase);
  return (0, _createClass2.default)(Create, [{
    key: "apply",
    value: function apply() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var container = args.container,
        setting = args.setting,
        title = args.title,
        controls = container.controls,
        availableControls = {};
      var result = false,
        groupPrefix = '';
      if (controls[setting] && controls[setting].groupPrefix) {
        groupPrefix = controls[setting].groupPrefix;
      } else {
        throw new Error("Invalid setting: control '".concat(setting, "', not found."));
      }
      if (groupPrefix) {
        Object.entries(controls).forEach(function (_ref) {
          var _ref2 = (0, _slicedToArray2.default)(_ref, 1),
            key = _ref2[0];
          if (key.includes(groupPrefix)) {
            // Get values but remove defaults.
            var value = container.settings.get(key),
              defaultValue = container.controls[key].default;
            if (!_.isEqual(value, defaultValue)) {
              availableControls[key.replace(groupPrefix, elementor.config.kit_config.typography_prefix)] = container.settings.get(key);
            }
          }
        });
      }
      if (Object.values(availableControls).length) {
        var id = elementorCommon.helpers.getUniqueId();
        result = $e.data.create("globals/typography?id=".concat(id), {
          title: title,
          value: availableControls
        });
      }
      return result;
    }
  }]);
}(_createBase.default);

/***/ }),

/***/ "../assets/dev/js/editor/data/globals/typography/commands/index.js":
/*!*************************************************************************!*\
  !*** ../assets/dev/js/editor/data/globals/typography/commands/index.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Create", ({
  enumerable: true,
  get: function get() {
    return _create.Create;
  }
}));
var _create = __webpack_require__(/*! ./create */ "../assets/dev/js/editor/data/globals/typography/commands/create.js");

/***/ }),

/***/ "../assets/dev/js/editor/data/globals/typography/component.js":
/*!********************************************************************!*\
  !*** ../assets/dev/js/editor/data/globals/typography/component.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _componentBase = _interopRequireDefault(__webpack_require__(/*! elementor-api/modules/component-base */ "../modules/web-cli/assets/js/modules/component-base.js"));
var commands = _interopRequireWildcard(__webpack_require__(/*! ./commands/ */ "../assets/dev/js/editor/data/globals/typography/commands/index.js"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, o, e, r) { var p = (0, _get2.default)((0, _getPrototypeOf2.default)(1 & r ? t.prototype : t), o, e); return 2 & r && "function" == typeof p ? function (t) { return p.apply(e, t); } : p; }
var Component = exports["default"] = /*#__PURE__*/function (_ComponentBase) {
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _callSuper(this, Component, arguments);
  }
  (0, _inherits2.default)(Component, _ComponentBase);
  return (0, _createClass2.default)(Component, [{
    key: "__construct",
    value: function __construct() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      _superPropGet(Component, "__construct", this, 3)([args]);
    }
  }, {
    key: "getNamespace",
    value: function getNamespace() {
      return 'globals/typography';
    }
  }, {
    key: "defaultCommands",
    value: function defaultCommands() {
      return this.importCommands(commands);
    }
  }]);
}(_componentBase.default);

/***/ }),

/***/ "../assets/dev/js/editor/document/command-bases/command-disable-enable.js":
/*!********************************************************************************!*\
  !*** ../assets/dev/js/editor/document/command-bases/command-disable-enable.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _commandHistoryBase = _interopRequireDefault(__webpack_require__(/*! ./command-history-base */ "../assets/dev/js/editor/document/command-bases/command-history-base.js"));
var _settings = _interopRequireDefault(__webpack_require__(/*! elementor-document/elements/commands/settings */ "../assets/dev/js/editor/document/elements/commands/settings.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, o, e, r) { var p = (0, _get2.default)((0, _getPrototypeOf2.default)(1 & r ? t.prototype : t), o, e); return 2 & r && "function" == typeof p ? function (t) { return p.apply(e, t); } : p; }
/**
 * The class serve as base for commands who needs the 'enable/disable' behavior.
 */
var CommandDisableEnable = exports["default"] = /*#__PURE__*/function (_CommandHistoryBase) {
  function CommandDisableEnable() {
    (0, _classCallCheck2.default)(this, CommandDisableEnable);
    return _callSuper(this, CommandDisableEnable, arguments);
  }
  (0, _inherits2.default)(CommandDisableEnable, _CommandHistoryBase);
  return (0, _createClass2.default)(CommandDisableEnable, [{
    key: "initialize",
    value: function initialize(args) {
      /**
       * Which command is running.
       *
       * @type {string}
       */
      this.type = this.command === this.constructor.getEnableCommand() ? 'enable' : 'disable';

      // Override default logic, since getHistory() depends on `this.type`.
      _superPropGet(CommandDisableEnable, "initialize", this, 3)([args]);
    }
  }, {
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
      this.requireArgumentConstructor('settings', Object, args);
    }
  }, {
    key: "getHistory",
    value: function getHistory(args) {
      var settings = args.settings,
        _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers,
        changes = {};
      containers.forEach(function (container) {
        var id = container.id;
        if (!changes[id]) {
          changes[id] = {};
        }
        changes[id] = settings;
      });
      var subTitle = elementor.translate(this.constructor.getName()) + ' ' + _settings.default.getSubTitle(args),
        type = this.type;
      return {
        containers: containers,
        subTitle: subTitle,
        data: {
          changes: changes,
          command: this.command
        },
        type: type,
        restore: this.constructor.restore
      };
    }
  }], [{
    key: "getName",
    value: function getName() {
      elementorModules.ForceMethodImplementation();
    }

    // eslint-disable-next-line jsdoc/require-returns-check
    /**
     * @return {string} Full enable command.
     */
  }, {
    key: "getEnableCommand",
    value: function getEnableCommand() {
      elementorModules.ForceMethodImplementation();
    }

    // eslint-disable-next-line jsdoc/require-returns-check
    /**
     * @return {string} Full disable command.
     */
  }, {
    key: "getDisableCommand",
    value: function getDisableCommand() {
      elementorModules.ForceMethodImplementation();
    }
  }, {
    key: "restore",
    value: function restore(historyItem, isRedo) {
      var data = historyItem.get('data'),
        CommandClass = $e.commands.getCommandClass(data.command);

      // Upon `disable` command toggle `isRedo`.
      if (CommandClass.getDisableCommand() === data.command) {
        isRedo = !isRedo;
      }
      historyItem.get('containers').forEach(function (container) {
        var settings = data.changes[container.id],
          toggle = isRedo ? CommandClass.getEnableCommand() : CommandClass.getDisableCommand();
        $e.run(toggle, {
          container: container,
          settings: settings
        });
        container.panel.refresh();
      });
    }
  }]);
}(_commandHistoryBase.default);

/***/ }),

/***/ "../assets/dev/js/editor/document/command-bases/command-history-base.js":
/*!******************************************************************************!*\
  !*** ../assets/dev/js/editor/document/command-bases/command-history-base.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _commandContainerBase = _interopRequireDefault(__webpack_require__(/*! elementor-editor/command-bases/command-container-base */ "../assets/dev/js/editor/command-bases/command-container-base.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, o, e, r) { var p = (0, _get2.default)((0, _getPrototypeOf2.default)(1 & r ? t.prototype : t), o, e); return 2 & r && "function" == typeof p ? function (t) { return p.apply(e, t); } : p; }
/**
 * @name $e.modules.editor.document.CommandHistoryBase
 */
var CommandHistoryBase = exports["default"] = /*#__PURE__*/function (_CommandContainerBase) {
  function CommandHistoryBase() {
    (0, _classCallCheck2.default)(this, CommandHistoryBase);
    return _callSuper(this, CommandHistoryBase, arguments);
  }
  (0, _inherits2.default)(CommandHistoryBase, _CommandContainerBase);
  return (0, _createClass2.default)(CommandHistoryBase, [{
    key: "initialize",
    value: function initialize() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var _args$options = args.options,
        options = _args$options === void 0 ? {} : _args$options,
        _options$useHistory = options.useHistory,
        useHistory = _options$useHistory === void 0 ? true : _options$useHistory;
      if (useHistory) {
        /**
         * Get History from child command.
         *
         * @type {{}|boolean}
         */
        this.history = this.getHistory(args);

        /**
         * @type {number|boolean}
         */
        this.historyId = false;
      }
    }

    // eslint-disable-next-line jsdoc/require-returns-check
    /**
     * Function getHistory().
     *
     * Get history object from child, do nothing if it false.
     *
     * @param {*} [args={}]
     *
     * @return {({}|boolean)} history object
     */
  }, {
    key: "getHistory",
    value: function getHistory() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      // eslint-disable-line no-unused-vars
      elementorModules.ForceMethodImplementation();
    }

    /**
     * Function isHistoryActive().
     *
     * Return `elementor.documents.getCurrent().history.getActive()`.
     *
     * @return {boolean} is history active
     */
  }, {
    key: "isHistoryActive",
    value: function isHistoryActive() {
      return elementor.documents.getCurrent().history.getActive();
    }
  }, {
    key: "onBeforeRun",
    value: function onBeforeRun(args) {
      _superPropGet(CommandHistoryBase, "onBeforeRun", this, 3)([args]);
      if (this.history && this.isHistoryActive()) {
        this.historyId = $e.internal('document/history/start-log', this.history);
      }
    }
  }, {
    key: "onAfterRun",
    value: function onAfterRun(args, result) {
      _superPropGet(CommandHistoryBase, "onAfterRun", this, 3)([args, result]);
      if (this.history && this.isHistoryActive()) {
        $e.internal('document/history/end-log', {
          id: this.historyId
        });
      }
    }
  }, {
    key: "onAfterApply",
    value: function onAfterApply() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var result = arguments.length > 1 ? arguments[1] : undefined;
      _superPropGet(CommandHistoryBase, "onAfterApply", this, 3)([args, result]);
      if (this.isDataChanged()) {
        $e.internal('document/save/set-is-modified', {
          status: true
        });
      }
    }
  }, {
    key: "onCatchApply",
    value: function onCatchApply(e) {
      // Rollback history on failure.
      if (e instanceof $e.modules.HookBreak && this.historyId) {
        $e.internal('document/history/delete-log', {
          id: this.historyId
        });
      }
      _superPropGet(CommandHistoryBase, "onCatchApply", this, 3)([e]);
    }
  }, {
    key: "isDataChanged",
    value: function isDataChanged() {
      // All the commands who use history are commands that changing the data.
      return true;
    }
  }], [{
    key: "getInstanceType",
    value: function getInstanceType() {
      return 'CommandHistoryBase';
    }
  }]);
}(_commandContainerBase.default);

/***/ }),

/***/ "../assets/dev/js/editor/document/component.js":
/*!*****************************************************!*\
  !*** ../assets/dev/js/editor/document/component.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _componentBase = _interopRequireDefault(__webpack_require__(/*! elementor-api/modules/component-base */ "../modules/web-cli/assets/js/modules/component-base.js"));
var components = _interopRequireWildcard(__webpack_require__(/*! ./ */ "../assets/dev/js/editor/document/index.js"));
var hooks = _interopRequireWildcard(__webpack_require__(/*! ./hooks/ */ "../assets/dev/js/editor/document/hooks/index.js"));
var uiStates = _interopRequireWildcard(__webpack_require__(/*! ./ui-states */ "../assets/dev/js/editor/document/ui-states/index.js"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, o, e, r) { var p = (0, _get2.default)((0, _getPrototypeOf2.default)(1 & r ? t.prototype : t), o, e); return 2 & r && "function" == typeof p ? function (t) { return p.apply(e, t); } : p; }
var Component = exports["default"] = /*#__PURE__*/function (_ComponentBase) {
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _callSuper(this, Component, arguments);
  }
  (0, _inherits2.default)(Component, _ComponentBase);
  return (0, _createClass2.default)(Component, [{
    key: "getNamespace",
    value: function getNamespace() {
      return 'document';
    }
  }, {
    key: "registerAPI",
    value: function registerAPI() {
      Object.values(components).forEach(function (ComponentClass) {
        return $e.components.register(new ComponentClass());
      });
      _superPropGet(Component, "registerAPI", this, 3)([]);
    }
  }, {
    key: "defaultCommands",
    value: function defaultCommands() {
      return {
        // Example: ( args ) => ( new Commands.Example( args ).run() ),
      };
    }
  }, {
    key: "defaultHooks",
    value: function defaultHooks() {
      return this.importHooks(hooks);
    }
  }, {
    key: "defaultUiStates",
    value: function defaultUiStates() {
      return this.importUiStates(uiStates);
    }
  }, {
    key: "defaultUtils",
    value: function defaultUtils() {
      var _this = this;
      return {
        findViewRecursive: function findViewRecursive(parent, key, value) {
          var multiple = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
          var found = [];
          for (var x in parent._views) {
            var view = parent._views[x];
            if (value === view.model.get(key)) {
              found.push(view);
              if (!multiple) {
                return found;
              }
            }
            if (view.children) {
              var views = _this.utils.findViewRecursive(view.children, key, value, multiple);
              if (views.length) {
                found = found.concat(views);
                if (!multiple) {
                  return found;
                }
              }
            }
          }
          return found;
        },
        findViewById: function findViewById(id) {
          var elements = _this.utils.findViewRecursive(elementor.getPreviewView().children, 'id', id, false);
          return elements ? elements[0] : false;
        },
        findContainerById: function findContainerById(id) {
          var result = _this.utils.findViewById(id);
          if (result) {
            result = result.getContainer();
          }
          return result;
        }
      };
    }
  }]);
}(_componentBase.default);

/***/ }),

/***/ "../assets/dev/js/editor/document/dynamic/commands/base/disable-enable.js":
/*!********************************************************************************!*\
  !*** ../assets/dev/js/editor/document/dynamic/commands/base/disable-enable.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _commandDisableEnable = _interopRequireDefault(__webpack_require__(/*! elementor-document/command-bases/command-disable-enable */ "../assets/dev/js/editor/document/command-bases/command-disable-enable.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var DisableEnable = exports["default"] = /*#__PURE__*/function (_CommandDisableEnable) {
  function DisableEnable() {
    (0, _classCallCheck2.default)(this, DisableEnable);
    return _callSuper(this, DisableEnable, arguments);
  }
  (0, _inherits2.default)(DisableEnable, _CommandDisableEnable);
  return (0, _createClass2.default)(DisableEnable, [{
    key: "getTitle",
    value: function getTitle() {
      return __('Dynamic');
    }
  }], [{
    key: "getName",
    value: function getName() {
      return 'Dynamic';
    }
  }, {
    key: "getEnableCommand",
    value: function getEnableCommand() {
      return 'document/dynamic/enable';
    }
  }, {
    key: "getDisableCommand",
    value: function getDisableCommand() {
      return 'document/dynamic/disable';
    }
  }]);
}(_commandDisableEnable.default);

/***/ }),

/***/ "../assets/dev/js/editor/document/dynamic/commands/disable.js":
/*!********************************************************************!*\
  !*** ../assets/dev/js/editor/document/dynamic/commands/disable.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Disable = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _disableEnable = _interopRequireDefault(__webpack_require__(/*! ./base/disable-enable */ "../assets/dev/js/editor/document/dynamic/commands/base/disable-enable.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Disable = exports.Disable = /*#__PURE__*/function (_DisableEnable) {
  function Disable() {
    (0, _classCallCheck2.default)(this, Disable);
    return _callSuper(this, Disable, arguments);
  }
  (0, _inherits2.default)(Disable, _DisableEnable);
  return (0, _createClass2.default)(Disable, [{
    key: "apply",
    value: function apply(args) {
      var settings = args.settings,
        _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers;
      containers.forEach(function (container) {
        container = container.lookup();
        Object.keys(settings).forEach(function (setting) {
          container.dynamic.unset(setting);
        });
        $e.internal('document/elements/set-settings', {
          container: container,
          settings: {
            __dynamic__: container.dynamic.toJSON()
          }
        });
      });
    }
  }]);
}(_disableEnable.default);
var _default = exports["default"] = Disable;

/***/ }),

/***/ "../assets/dev/js/editor/document/dynamic/commands/enable.js":
/*!*******************************************************************!*\
  !*** ../assets/dev/js/editor/document/dynamic/commands/enable.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Enable = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _disableEnable = _interopRequireDefault(__webpack_require__(/*! ./base/disable-enable */ "../assets/dev/js/editor/document/dynamic/commands/base/disable-enable.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Enable = exports.Enable = /*#__PURE__*/function (_DisableEnable) {
  function Enable() {
    (0, _classCallCheck2.default)(this, Enable);
    return _callSuper(this, Enable, arguments);
  }
  (0, _inherits2.default)(Enable, _DisableEnable);
  return (0, _createClass2.default)(Enable, [{
    key: "apply",
    value: function apply(args) {
      var settings = args.settings,
        _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers;
      containers.forEach(function (container) {
        container = container.lookup();
        container.dynamic.set(settings);
        $e.internal('document/elements/set-settings', {
          container: container,
          settings: {
            __dynamic__: container.dynamic.toJSON()
          }
        });
      });
    }
  }]);
}(_disableEnable.default);
var _default = exports["default"] = Enable;

/***/ }),

/***/ "../assets/dev/js/editor/document/dynamic/commands/index.js":
/*!******************************************************************!*\
  !*** ../assets/dev/js/editor/document/dynamic/commands/index.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Disable", ({
  enumerable: true,
  get: function get() {
    return _disable.Disable;
  }
}));
Object.defineProperty(exports, "Enable", ({
  enumerable: true,
  get: function get() {
    return _enable.Enable;
  }
}));
Object.defineProperty(exports, "Settings", ({
  enumerable: true,
  get: function get() {
    return _settings.Settings;
  }
}));
var _disable = __webpack_require__(/*! ./disable */ "../assets/dev/js/editor/document/dynamic/commands/disable.js");
var _enable = __webpack_require__(/*! ./enable */ "../assets/dev/js/editor/document/dynamic/commands/enable.js");
var _settings = __webpack_require__(/*! ./settings */ "../assets/dev/js/editor/document/dynamic/commands/settings.js");

/***/ }),

/***/ "../assets/dev/js/editor/document/dynamic/commands/settings.js":
/*!*********************************************************************!*\
  !*** ../assets/dev/js/editor/document/dynamic/commands/settings.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Settings = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _settings = _interopRequireDefault(__webpack_require__(/*! elementor-document/elements/commands/settings */ "../assets/dev/js/editor/document/elements/commands/settings.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/**
 * The difference between 'document/elements/settings` and `document/dynamic/settings` is:
 * that `document/elements/settings` apply settings to `container.settings` and `document/dynamic/settings` affect
 * `container.settings.__dynamic__`, also clearing the dynamic if `args.settings` is empty.
 */
var Settings = exports.Settings = /*#__PURE__*/function (_$e$modules$editor$do) {
  function Settings() {
    (0, _classCallCheck2.default)(this, Settings);
    return _callSuper(this, Settings, arguments);
  }
  (0, _inherits2.default)(Settings, _$e$modules$editor$do);
  return (0, _createClass2.default)(Settings, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
      this.requireArgumentConstructor('settings', Object, args);
    }
  }, {
    key: "getHistory",
    value: function getHistory(args) {
      var settings = args.settings,
        _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers,
        changes = {};
      containers.forEach(function (container) {
        var id = container.id;
        if (!changes[id]) {
          changes[id] = {};
        }
        changes[id] = {
          old: container.dynamic.toJSON(),
          new: settings
        };
      });
      var subTitle = _settings.default.getSubTitle(args);
      return {
        containers: containers,
        subTitle: subTitle,
        data: {
          changes: changes
        },
        type: 'change',
        restore: this.constructor.restore
      };
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var settings = args.settings,
        _args$containers2 = args.containers,
        containers = _args$containers2 === void 0 ? [args.container] : _args$containers2;
      containers.forEach(function (container) {
        container = container.lookup();
        if (!Object.keys(settings).length) {
          container.dynamic.clear();
        } else {
          container.dynamic.set(settings);
        }
        $e.internal('document/elements/set-settings', {
          container: container,
          settings: {
            __dynamic__: container.dynamic.toJSON()
          }
        });
      });
    }
  }], [{
    key: "restore",
    value: function restore(historyItem, isRedo) {
      var data = historyItem.get('data');
      historyItem.get('containers').forEach(function (container) {
        var changes = data.changes[container.id];
        $e.run('document/dynamic/settings', {
          container: container,
          settings: isRedo ? changes.new : changes.old
        });
        container.panel.refresh();
      });
    }
  }]);
}($e.modules.editor.document.CommandHistoryDebounceBase);
var _default = exports["default"] = Settings;

/***/ }),

/***/ "../assets/dev/js/editor/document/dynamic/component.js":
/*!*************************************************************!*\
  !*** ../assets/dev/js/editor/document/dynamic/component.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _componentBase = _interopRequireDefault(__webpack_require__(/*! elementor-api/modules/component-base */ "../modules/web-cli/assets/js/modules/component-base.js"));
var commands = _interopRequireWildcard(__webpack_require__(/*! ./commands/ */ "../assets/dev/js/editor/document/dynamic/commands/index.js"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Component = exports["default"] = /*#__PURE__*/function (_ComponentBase) {
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _callSuper(this, Component, arguments);
  }
  (0, _inherits2.default)(Component, _ComponentBase);
  return (0, _createClass2.default)(Component, [{
    key: "getNamespace",
    value: function getNamespace() {
      return 'document/dynamic';
    }
  }, {
    key: "defaultCommands",
    value: function defaultCommands() {
      return this.importCommands(commands);
    }
  }]);
}(_componentBase.default);

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands-internal/index.js":
/*!****************************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands-internal/index.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "SetSettings", ({
  enumerable: true,
  get: function get() {
    return _setSettings.SetSettings;
  }
}));
var _setSettings = __webpack_require__(/*! ./set-settings */ "../assets/dev/js/editor/document/elements/commands-internal/set-settings.js");

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands-internal/set-settings.js":
/*!***********************************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands-internal/set-settings.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.SetSettings = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var SetSettings = exports.SetSettings = /*#__PURE__*/function (_$e$modules$editor$Co) {
  function SetSettings() {
    (0, _classCallCheck2.default)(this, SetSettings);
    return _callSuper(this, SetSettings, arguments);
  }
  (0, _inherits2.default)(SetSettings, _$e$modules$editor$Co);
  return (0, _createClass2.default)(SetSettings, [{
    key: "validateArgs",
    value: function validateArgs() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      this.requireContainer(args);
      this.requireArgumentType('settings', 'object', args);
      if ('undefined' !== typeof args.render && 'undefined' !== typeof args.renderUI) {
        throw new Error('Args: `render` and `renderUI` cannot be applied together.');
      }
    }
  }, {
    key: "apply",
    value: function apply() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers,
        settings = args.settings,
        _args$options = args.options,
        options = _args$options === void 0 ? {} : _args$options,
        external = options.external,
        _options$render = options.render,
        render = _options$render === void 0 ? true : _options$render,
        _options$renderUI = options.renderUI,
        renderUI = _options$renderUI === void 0 ? false : _options$renderUI;
      containers.forEach(function (container) {
        if (external) {
          container.settings.setExternalChange(settings);
        } else {
          container.settings.set(settings);
        }
        if (renderUI) {
          container.renderUI();
        } else if (render) {
          container.render();
        }
      });
    }
  }]);
}($e.modules.editor.CommandContainerInternalBase);
var _default = exports["default"] = SetSettings;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/copy-all.js":
/*!**********************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/copy-all.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.CopyAll = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var CopyAll = exports.CopyAll = /*#__PURE__*/function (_$e$modules$CommandBa) {
  function CopyAll() {
    (0, _classCallCheck2.default)(this, CopyAll);
    return _callSuper(this, CopyAll, arguments);
  }
  (0, _inherits2.default)(CopyAll, _$e$modules$CommandBa);
  return (0, _createClass2.default)(CopyAll, [{
    key: "apply",
    value: function apply() {
      $e.run('document/elements/copy', {
        containers: Object.values(elementor.getPreviewView().children._views).map(function (view) {
          return view.getContainer();
        })
      });
    }
  }]);
}($e.modules.CommandBase);
var _default = exports["default"] = CopyAll;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/copy.js":
/*!******************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/copy.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Copy = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Copy = exports.Copy = /*#__PURE__*/function (_$e$modules$editor$Co) {
  function Copy() {
    (0, _classCallCheck2.default)(this, Copy);
    return _callSuper(this, Copy, arguments);
  }
  (0, _inherits2.default)(Copy, _$e$modules$editor$Co);
  return (0, _createClass2.default)(Copy, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var _args$storageKey = args.storageKey,
        storageKey = _args$storageKey === void 0 ? 'clipboard' : _args$storageKey,
        _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers;
      if (!elementor.selection.isSameType()) {
        elementor.notifications.showToast({
          message: __('That didn’t work. Try copying one kind of element at a time.', 'elementor'),
          buttons: [{
            name: 'got_it',
            text: __('Got it', 'elementor')
          }]
        });
        return false;
      }
      var elements = elementor.getPreviewView().$el.find('.elementor-element');
      var elementsData = containers.sort(function (first, second) {
        return elements.index(first.view.el) - elements.index(second.view.el);
      }).map(function (container) {
        return container.model.toJSON({
          copyHtmlCache: true
        });
      });
      var storageData = {
        type: 'elementor',
        siteurl: elementorCommon.config.urls.rest,
        elements: elementsData
      };
      elementorCommon.storage.set(storageKey, storageData);

      // TODO: Use package for clipboard saving
      var clipboard = document.createElement('textarea');
      clipboard.value = JSON.stringify(storageData);
      document.body.appendChild(clipboard);
      clipboard.select();
      document.execCommand('copy');
      document.body.removeChild(clipboard);
    }
  }]);
}($e.modules.editor.CommandContainerBase);
var _default = exports["default"] = Copy;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/create.js":
/*!********************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/create.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Create = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Create = exports.Create = /*#__PURE__*/function (_$e$modules$editor$do) {
  function Create() {
    (0, _classCallCheck2.default)(this, Create);
    return _callSuper(this, Create, arguments);
  }
  (0, _inherits2.default)(Create, _$e$modules$editor$do);
  return (0, _createClass2.default)(Create, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);

      // Avoid Backbone model & etc.
      this.requireArgumentConstructor('model', Object, args);
    }
  }, {
    key: "getHistory",
    value: function getHistory(args) {
      var model = args.model,
        _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers;
      return {
        containers: containers,
        model: model,
        type: 'add',
        title: elementor.helpers.getModelLabel(model)
      };
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var _this = this;
      var model = args.model,
        _args$options = args.options,
        options = _args$options === void 0 ? {} : _args$options,
        _args$containers2 = args.containers,
        containers = _args$containers2 === void 0 ? [args.container] : _args$containers2;
      var result = [];
      containers.forEach(function (container) {
        container = container.lookup();
        var createdContainer = container.view.addElement(model, options).getContainer();
        result.push(createdContainer);

        /**
         * Acknowledge history of each created item, because we cannot pass the elements when they do not exist
         * in getHistory().
         */
        if (_this.isHistoryActive()) {
          $e.internal('document/history/log-sub-item', {
            container: container,
            type: 'sub-add',
            restore: _this.constructor.restore,
            options: options,
            data: {
              containerToRestore: createdContainer,
              modelToRestore: createdContainer.model.toJSON()
            }
          });
        }
      });
      if (1 === result.length) {
        result = result[0];
      }
      return result;
    }
  }], [{
    key: "restore",
    value: function restore(historyItem, isRedo) {
      var data = historyItem.get('data'),
        container = historyItem.get('container'),
        options = historyItem.get('options') || {};

      // No clone when restoring. e.g: duplicate will generate unique ids while restoring.
      if (options.clone) {
        options.clone = false;
      }
      if (isRedo) {
        $e.run('document/elements/create', {
          container: container,
          model: data.modelToRestore,
          options: options
        });
      } else {
        $e.run('document/elements/delete', {
          container: data.containerToRestore
        });
      }
    }
  }]);
}($e.modules.editor.document.CommandHistoryBase);
var _default = exports["default"] = Create;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/delete.js":
/*!********************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/delete.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Delete = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Delete = exports.Delete = /*#__PURE__*/function (_$e$modules$editor$do) {
  function Delete() {
    (0, _classCallCheck2.default)(this, Delete);
    return _callSuper(this, Delete, arguments);
  }
  (0, _inherits2.default)(Delete, _$e$modules$editor$do);
  return (0, _createClass2.default)(Delete, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
    }
  }, {
    key: "getHistory",
    value: function getHistory(args) {
      var _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers;
      return {
        containers: containers,
        type: 'remove'
      };
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var _this = this;
      var _args$containers2 = args.containers,
        containers = _args$containers2 === void 0 ? [args.container] : _args$containers2;
      containers.forEach(function (container) {
        container = container.lookup();
        if (_this.isHistoryActive()) {
          $e.internal('document/history/log-sub-item', {
            container: container,
            type: 'sub-remove',
            restore: _this.constructor.restore,
            data: {
              model: container.model.toJSON(),
              parent: container.parent,
              at: container.view._index
            }
          });
        }
        _this.deselectRecursive(container.model.get('id'));
        container.model.destroy();
        container.panel.refresh();
      });
      if (1 === containers.length) {
        return containers[0];
      }
      return containers;
    }
  }, {
    key: "deselectRecursive",
    value: function deselectRecursive(id) {
      var _this2 = this;
      var container = elementor.getContainer(id);
      if (elementor.selection.has(container)) {
        $e.run('document/elements/deselect', {
          container: container
        });
      }
      container === null || container === void 0 || container.model.get('elements').forEach(function (childModel) {
        _this2.deselectRecursive(childModel.get('id'));
      });
    }
  }], [{
    key: "restore",
    value: function restore(historyItem, isRedo) {
      var container = historyItem.get('container'),
        data = historyItem.get('data');
      if (isRedo) {
        $e.run('document/elements/delete', {
          container: container
        });
      } else {
        $e.run('document/elements/create', {
          container: data.parent,
          model: data.model,
          options: {
            at: data.at
          }
        });
      }
    }
  }]);
}($e.modules.editor.document.CommandHistoryBase);
var _default = exports["default"] = Delete;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/deselect-all.js":
/*!**************************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/deselect-all.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.DeselectAll = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var DeselectAll = exports.DeselectAll = /*#__PURE__*/function (_$e$modules$CommandBa) {
  function DeselectAll() {
    (0, _classCallCheck2.default)(this, DeselectAll);
    return _callSuper(this, DeselectAll, arguments);
  }
  (0, _inherits2.default)(DeselectAll, _$e$modules$CommandBa);
  return (0, _createClass2.default)(DeselectAll, [{
    key: "apply",
    value: function apply() {
      elementor.selection.remove([], true);
    }
  }]);
}($e.modules.CommandBase);
var _default = exports["default"] = DeselectAll;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/deselect.js":
/*!**********************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/deselect.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Deselect = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Deselect = exports.Deselect = /*#__PURE__*/function (_$e$modules$editor$Co) {
  function Deselect() {
    (0, _classCallCheck2.default)(this, Deselect);
    return _callSuper(this, Deselect, arguments);
  }
  (0, _inherits2.default)(Deselect, _$e$modules$editor$Co);
  return (0, _createClass2.default)(Deselect, [{
    key: "validateArgs",
    value: function validateArgs() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      if (!args.all) {
        this.requireContainer(args);
      }
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers,
        _args$all = args.all,
        all = _args$all === void 0 ? false : _args$all;
      elementor.selection.remove(containers, all);
    }
  }]);
}($e.modules.editor.CommandContainerBase);
var _default = exports["default"] = Deselect;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/duplicate.js":
/*!***********************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/duplicate.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Duplicate = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Duplicate = exports.Duplicate = /*#__PURE__*/function (_$e$modules$editor$do) {
  function Duplicate() {
    (0, _classCallCheck2.default)(this, Duplicate);
    return _callSuper(this, Duplicate, arguments);
  }
  (0, _inherits2.default)(Duplicate, _$e$modules$editor$do);
  return (0, _createClass2.default)(Duplicate, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
    }
  }, {
    key: "getHistory",
    value: function getHistory(args) {
      var _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers;
      return {
        containers: containers,
        type: 'duplicate'
      };
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var _args$containers2 = args.containers,
        containers = _args$containers2 === void 0 ? [args.container] : _args$containers2,
        _args$options = args.options,
        options = _args$options === void 0 ? {} : _args$options,
        result = [];
      var at = containers[containers.length - 1].view._index;
      if (!elementor.selection.isSameType()) {
        elementor.notifications.showToast({
          message: __('That didn’t work. Try duplicating one kind of element at a time.', 'elementor'),
          buttons: [{
            name: 'got_it',
            text: __('Got it', 'elementor')
          }]
        });
        return false;
      }
      containers.forEach(function (container) {
        var parent = container.parent;
        result.push($e.run('document/elements/create', {
          container: parent,
          model: container.model.toJSON(),
          options: _objectSpread(_objectSpread({}, options), {}, {
            at: ++at,
            clone: true
          })
        }));
      });
      if (1 === result.length) {
        return result[0];
      }
      return result;
    }
  }]);
}($e.modules.editor.document.CommandHistoryBase);
var _default = exports["default"] = Duplicate;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/empty.js":
/*!*******************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/empty.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Empty = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Empty = exports.Empty = /*#__PURE__*/function (_$e$modules$editor$do) {
  function Empty() {
    (0, _classCallCheck2.default)(this, Empty);
    return _callSuper(this, Empty, arguments);
  }
  (0, _inherits2.default)(Empty, _$e$modules$editor$do);
  return (0, _createClass2.default)(Empty, [{
    key: "getHistory",
    value: function getHistory(args) {
      if (args.force) {
        return {
          type: 'remove',
          title: __('All Content', 'elementor'),
          data: elementor.elements ? elementor.elements.toJSON() : null,
          restore: this.constructor.restore
        };
      }
      return false;
    }
  }, {
    key: "apply",
    value: function apply(args) {
      if (args.force && elementor.elements) {
        elementor.elements.reset();
        elementor.getPreviewContainer().panel.closeEditor();
        return;
      }
      elementor.getClearPageDialog().show();
    }
  }, {
    key: "isDataChanged",
    value: function isDataChanged() {
      return this.args.force;
    }
  }], [{
    key: "restore",
    value: function restore(historyItem, isRedo) {
      if (isRedo) {
        $e.run('document/elements/empty', {
          force: true
        });
      } else {
        var data = historyItem.get('data');
        if (data) {
          elementor.getPreviewView().addChildModel(data);
        }
        $e.internal('document/save/set-is-modified', {
          status: true
        });
      }
    }
  }]);
}($e.modules.editor.document.CommandHistoryBase);
var _default = exports["default"] = Empty;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/import.js":
/*!********************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/import.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Import = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Import = exports.Import = /*#__PURE__*/function (_$e$modules$editor$do) {
  function Import() {
    (0, _classCallCheck2.default)(this, Import);
    return _callSuper(this, Import, arguments);
  }
  (0, _inherits2.default)(Import, _$e$modules$editor$do);
  return (0, _createClass2.default)(Import, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireArgumentInstance('model', Backbone.Model, args);
      this.requireArgumentConstructor('data', Object, args);
      if (args.containers) {
        throw new TypeError('Multi containers are not supported');
      }
      if (args.container) {
        this.requireContainer();
      }
    }
  }, {
    key: "getHistory",
    value: function getHistory(args) {
      var model = args.model;
      return {
        type: 'add',
        title: __('Template', 'elementor'),
        subTitle: model.get('title')
      };
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var data = args.data,
        _args$options = args.options,
        options = _args$options === void 0 ? args.options || {} : _args$options,
        _args$container = args.container,
        container = _args$container === void 0 ? args.container || elementor.getPreviewContainer() : _args$container,
        result = [];
      var at = isNaN(options.at) ? container.view.collection.length : options.at;

      // Each `data.content`.
      Object.values(data.content).forEach(function (model) {
        result.push($e.run('document/elements/create', {
          container: container,
          model: model,
          options: Object.assign(options, {
            at: at
          })
        }));
        at++;
      });
      if (options.withPageSettings) {
        $e.run('document/elements/settings', {
          container: elementor.settings.page.getEditedView().getContainer(),
          settings: data.page_settings,
          options: {
            external: true
          }
        });
      }
      return result;
    }
  }]);
}($e.modules.editor.document.CommandHistoryBase);
var _default = exports["default"] = Import;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/index.js":
/*!*******************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/index.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Copy", ({
  enumerable: true,
  get: function get() {
    return _copy.Copy;
  }
}));
Object.defineProperty(exports, "CopyAll", ({
  enumerable: true,
  get: function get() {
    return _copyAll.CopyAll;
  }
}));
Object.defineProperty(exports, "Create", ({
  enumerable: true,
  get: function get() {
    return _create.Create;
  }
}));
Object.defineProperty(exports, "Delete", ({
  enumerable: true,
  get: function get() {
    return _delete.Delete;
  }
}));
Object.defineProperty(exports, "Deselect", ({
  enumerable: true,
  get: function get() {
    return _deselect.Deselect;
  }
}));
Object.defineProperty(exports, "DeselectAll", ({
  enumerable: true,
  get: function get() {
    return _deselectAll.DeselectAll;
  }
}));
Object.defineProperty(exports, "Duplicate", ({
  enumerable: true,
  get: function get() {
    return _duplicate.Duplicate;
  }
}));
Object.defineProperty(exports, "Empty", ({
  enumerable: true,
  get: function get() {
    return _empty.Empty;
  }
}));
Object.defineProperty(exports, "Import", ({
  enumerable: true,
  get: function get() {
    return _import.Import;
  }
}));
Object.defineProperty(exports, "Move", ({
  enumerable: true,
  get: function get() {
    return _move.Move;
  }
}));
Object.defineProperty(exports, "Paste", ({
  enumerable: true,
  get: function get() {
    return _paste.Paste;
  }
}));
Object.defineProperty(exports, "PasteArea", ({
  enumerable: true,
  get: function get() {
    return _pasteArea.PasteArea;
  }
}));
Object.defineProperty(exports, "PasteStyle", ({
  enumerable: true,
  get: function get() {
    return _pasteStyle.PasteStyle;
  }
}));
Object.defineProperty(exports, "ResetSettings", ({
  enumerable: true,
  get: function get() {
    return _resetSettings.ResetSettings;
  }
}));
Object.defineProperty(exports, "ResetStyle", ({
  enumerable: true,
  get: function get() {
    return _resetStyle.ResetStyle;
  }
}));
Object.defineProperty(exports, "Select", ({
  enumerable: true,
  get: function get() {
    return _select.Select;
  }
}));
Object.defineProperty(exports, "SelectAll", ({
  enumerable: true,
  get: function get() {
    return _selectAll.SelectAll;
  }
}));
Object.defineProperty(exports, "Settings", ({
  enumerable: true,
  get: function get() {
    return _settings.Settings;
  }
}));
Object.defineProperty(exports, "ToggleSelection", ({
  enumerable: true,
  get: function get() {
    return _toggleSelection.ToggleSelection;
  }
}));
var _copy = __webpack_require__(/*! ./copy */ "../assets/dev/js/editor/document/elements/commands/copy.js");
var _copyAll = __webpack_require__(/*! ./copy-all */ "../assets/dev/js/editor/document/elements/commands/copy-all.js");
var _create = __webpack_require__(/*! ./create */ "../assets/dev/js/editor/document/elements/commands/create.js");
var _delete = __webpack_require__(/*! ./delete */ "../assets/dev/js/editor/document/elements/commands/delete.js");
var _deselect = __webpack_require__(/*! ./deselect */ "../assets/dev/js/editor/document/elements/commands/deselect.js");
var _deselectAll = __webpack_require__(/*! ./deselect-all */ "../assets/dev/js/editor/document/elements/commands/deselect-all.js");
var _duplicate = __webpack_require__(/*! ./duplicate */ "../assets/dev/js/editor/document/elements/commands/duplicate.js");
var _empty = __webpack_require__(/*! ./empty */ "../assets/dev/js/editor/document/elements/commands/empty.js");
var _import = __webpack_require__(/*! ./import */ "../assets/dev/js/editor/document/elements/commands/import.js");
var _paste = __webpack_require__(/*! ./paste */ "../assets/dev/js/editor/document/elements/commands/paste.js");
var _pasteArea = __webpack_require__(/*! ./paste-area */ "../assets/dev/js/editor/document/elements/commands/paste-area.js");
var _move = __webpack_require__(/*! ./move */ "../assets/dev/js/editor/document/elements/commands/move.js");
var _pasteStyle = __webpack_require__(/*! ./paste-style */ "../assets/dev/js/editor/document/elements/commands/paste-style.js");
var _resetSettings = __webpack_require__(/*! ./reset-settings */ "../assets/dev/js/editor/document/elements/commands/reset-settings.js");
var _resetStyle = __webpack_require__(/*! ./reset-style */ "../assets/dev/js/editor/document/elements/commands/reset-style.js");
var _select = __webpack_require__(/*! ./select */ "../assets/dev/js/editor/document/elements/commands/select.js");
var _selectAll = __webpack_require__(/*! ./select-all */ "../assets/dev/js/editor/document/elements/commands/select-all.js");
var _settings = __webpack_require__(/*! ./settings */ "../assets/dev/js/editor/document/elements/commands/settings.js");
var _toggleSelection = __webpack_require__(/*! ./toggle-selection */ "../assets/dev/js/editor/document/elements/commands/toggle-selection.js");

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/move.js":
/*!******************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/move.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Move = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Move = exports.Move = /*#__PURE__*/function (_$e$modules$editor$do) {
  function Move() {
    (0, _classCallCheck2.default)(this, Move);
    return _callSuper(this, Move, arguments);
  }
  (0, _inherits2.default)(Move, _$e$modules$editor$do);
  return (0, _createClass2.default)(Move, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
      this.requireArgumentInstance('target', elementorModules.editor.Container, args);
    }
  }, {
    key: "getHistory",
    value: function getHistory(args) {
      var _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers;
      return {
        containers: containers,
        type: 'move'
      };
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var target = args.target,
        _args$options = args.options,
        options = _args$options === void 0 ? {} : _args$options,
        _args$containers2 = args.containers,
        containers = _args$containers2 === void 0 ? [args.container] : _args$containers2,
        reCreate = [];
      containers.forEach(function (container) {
        reCreate.push(container.model.toJSON());
        $e.run('document/elements/delete', {
          container: container
        });
      });
      var count = 0;
      var result = [];
      reCreate.forEach(function (model) {
        // If multiple fix position.
        if (Object.prototype.hasOwnProperty.call(options, 'at') && reCreate.length > 1) {
          if (0 !== count) {
            options.at += count;
          }
        }
        var newContainer = $e.run('document/elements/create', {
          container: target,
          model: model,
          options: options
        });
        result.push(newContainer);
        count++;
      });
      if (1 === result.length) {
        return result[0];
      }
      return result;
    }
  }]);
}($e.modules.editor.document.CommandHistoryBase);
var _default = exports["default"] = Move;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/paste-area.js":
/*!************************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/paste-area.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.PasteArea = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _environment = _interopRequireDefault(__webpack_require__(/*! elementor-common/utils/environment */ "../core/common/assets/js/utils/environment.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var PasteArea = exports.PasteArea = /*#__PURE__*/function (_$e$modules$editor$do) {
  function PasteArea() {
    (0, _classCallCheck2.default)(this, PasteArea);
    return _callSuper(this, PasteArea, arguments);
  }
  (0, _inherits2.default)(PasteArea, _$e$modules$editor$do);
  return (0, _createClass2.default)(PasteArea, [{
    key: "getHistory",
    value: function getHistory() {
      return false;
    }
  }, {
    key: "getDialog",
    value: function getDialog() {
      var _this = this;
      if (this.dialog) {
        return this.dialog;
      }
      var $messageContainer = jQuery('<div>', {
        class: 'e-dialog-description'
      }).html(__('To paste the element from your other site.', 'elementor'));
      var $inputArea = jQuery('<input>', {
        id: 'elementor-paste-area-dialog__input',
        type: 'text'
      }).attr('autocomplete', 'off').on('keypress', function (event) {
        event.preventDefault();
      }).on('blur', function () {
        _.defer(function () {
          return $inputArea.trigger('focus');
        });
      }).on('paste', /*#__PURE__*/function () {
        var _ref = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(event) {
          var $widgetContent, retVal;
          return _regenerator.default.wrap(function (_context) {
            while (1) switch (_context.prev = _context.next) {
              case 0:
                event.preventDefault();
                $widgetContent = _this.getDialog().getElements('widgetContent');
                $widgetContent.addClass('e-state-loading');
                _context.next = 1;
                return $e.run('document/ui/paste', {
                  container: _this.container,
                  storageType: 'rawdata',
                  data: event.originalEvent.clipboardData.getData('text'),
                  options: _this.options
                });
              case 1:
                retVal = _context.sent;
                $widgetContent.removeClass('e-state-loading');
                if (!retVal) {
                  _context.next = 2;
                  break;
                }
                _this.dialog.hide();
                return _context.abrupt("return");
              case 2:
                $errorArea.show();
              case 3:
              case "end":
                return _context.stop();
            }
          }, _callee);
        }));
        return function (_x) {
          return _ref.apply(this, arguments);
        };
      }());
      var $errorArea = jQuery('<div>', {
        id: 'elementor-paste-area-dialog__error',
        style: "display: none"
      }).html(__('Make sure that both sites are updated to last version of Elementor and have enabled the features relevant to the copied element before trying again.', 'elementor'));
      var $loadingArea = jQuery('<i>', {
        class: 'eicon-loading eicon-animation-spin'
      });
      $messageContainer.append($inputArea).append($errorArea).append($loadingArea);
      var ctrlLabel = _environment.default.mac ? '&#8984;' : 'Ctrl';
      this.dialog = elementorCommon.dialogsManager.createWidget('lightbox', {
        id: 'elementor-paste-area-dialog',
        headerMessage: "".concat(ctrlLabel, " + V"),
        message: $messageContainer,
        position: {
          my: 'center center',
          at: 'center center'
        },
        closeButton: true,
        closeButtonOptions: {
          iconClass: 'eicon-close'
        },
        onShow: function onShow() {
          $inputArea.trigger('focus');
          _this.getDialog().getElements('widgetContent').on('click', function () {
            $inputArea.trigger('focus');
          });
        }
      });
      return this.dialog;
    }
  }, {
    key: "apply",
    value: function apply(args) {
      this.container = args.container;
      if (args.options) {
        this.options = args.options;
      }
      this.getDialog().show();
    }
  }]);
}($e.modules.editor.document.CommandHistoryBase);
(0, _defineProperty2.default)(PasteArea, "dialog", null);
(0, _defineProperty2.default)(PasteArea, "container", null);
(0, _defineProperty2.default)(PasteArea, "options", {});
var _default = exports["default"] = PasteArea;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/paste-style.js":
/*!*************************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/paste-style.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.PasteStyle = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _typeof2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/**
 * @typedef {import('../../../container/container')} Container
 */
var PasteStyle = exports.PasteStyle = /*#__PURE__*/function (_$e$modules$editor$do) {
  function PasteStyle() {
    (0, _classCallCheck2.default)(this, PasteStyle);
    return _callSuper(this, PasteStyle, arguments);
  }
  (0, _inherits2.default)(PasteStyle, _$e$modules$editor$do);
  return (0, _createClass2.default)(PasteStyle, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);

      // Validate if storage have data.
      var _args$storageKey = args.storageKey,
        storageKey = _args$storageKey === void 0 ? 'clipboard' : _args$storageKey,
        storageData = elementorCommon.storage.get(storageKey);
      this.requireArgumentType('storageData', 'object', {
        storageData: storageData
      });
    }
  }, {
    key: "validateControls",
    value: function validateControls(source, target) {
      var result = true;

      // Cannot use `_.isEmpty()` does not pass paste style test.
      if (null === source || null === target || undefined === source || undefined === target || 'object' === (0, _typeof2.default)(source) ^ 'object' === (0, _typeof2.default)(target)) {
        result = false;
      }
      return result;
    }
  }, {
    key: "getHistory",
    value: function getHistory(args) {
      var _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers;
      return {
        containers: containers,
        type: 'paste_style'
      };
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var _storageData$elements;
      var _args$containers2 = args.containers,
        containers = _args$containers2 === void 0 ? [args.container] : _args$containers2,
        _args$storageKey2 = args.storageKey,
        storageKey = _args$storageKey2 === void 0 ? 'clipboard' : _args$storageKey2,
        storageData = elementorCommon.storage.get(storageKey);
      if (!storageData || !(storageData !== null && storageData !== void 0 && (_storageData$elements = storageData.elements) !== null && _storageData$elements !== void 0 && _storageData$elements.length) || 'elementor' !== (storageData === null || storageData === void 0 ? void 0 : storageData.type)) {
        return false;
      }
      this.applyPasteStyleData(containers, storageData.elements);
    }
  }, {
    key: "applyPasteStyleData",
    value: function applyPasteStyleData(containers, data) {
      var _this = this;
      containers.forEach(function (targetContainer) {
        var targetSettings = targetContainer.settings,
          targetSettingsAttributes = targetSettings.attributes,
          targetControls = targetSettings.controls,
          diffSettings = {},
          addExtraControls = function addExtraControls(sourceSettings, extraType) {
            if (sourceSettings[extraType]) {
              Object.entries(sourceSettings[extraType]).forEach(function (_ref) {
                var _ref2 = (0, _slicedToArray2.default)(_ref, 2),
                  controlName = _ref2[0],
                  value = _ref2[1];
                var control = targetControls[controlName];
                if (targetContainer.view.isStyleTransferControl(control)) {
                  diffSettings[extraType] = diffSettings[extraType] || {};
                  diffSettings[extraType][controlName] = value;
                }
              });
            }
          };
        data.forEach(function (sourceModel) {
          var sourceSettings = sourceModel.settings;
          addExtraControls(sourceSettings, '__globals__');
          addExtraControls(sourceSettings, '__dynamic__');
          Object.entries(targetControls).forEach(function (_ref3) {
            var _ref4 = (0, _slicedToArray2.default)(_ref3, 2),
              controlName = _ref4[0],
              control = _ref4[1];
            if (!targetContainer.view.isStyleTransferControl(control)) {
              return;
            }
            var controlSourceValue = sourceSettings[controlName],
              controlTargetValue = targetSettingsAttributes[controlName];
            if (!_this.validateControls(controlSourceValue, controlTargetValue)) {
              return;
            }
            if ('object' === (0, _typeof2.default)(controlSourceValue)) {
              // eslint-disable-next-line array-callback-return
              var isEqual = Object.keys(controlSourceValue).some(function (propertyKey) {
                if (controlSourceValue[propertyKey] !== controlTargetValue[propertyKey]) {
                  return false;
                }
              });
              if (isEqual) {
                return;
              }
            }
            if (controlSourceValue === controlTargetValue || !elementor.getControlView(control.type).onPasteStyle(control, controlSourceValue)) {
              return;
            }
            diffSettings[controlName] = controlSourceValue;
          });
          _this.pasteStyle(targetContainer, diffSettings);
        });
      });
    }

    /**
     * @param {Container} targetContainer
     * @param {{}}        settings
     */
  }, {
    key: "pasteStyle",
    value: function pasteStyle(targetContainer, settings) {
      var globals = settings.__globals__;
      if (globals) {
        delete settings.__globals__;
      }
      $e.run('document/elements/settings', {
        container: targetContainer,
        settings: settings,
        options: {
          external: true,
          render: false
        }
      });
      if (globals) {
        $e.run('document/globals/settings', {
          container: targetContainer,
          settings: globals,
          options: {
            external: true,
            render: false
          }
        });
        targetContainer.panel.refresh();
      }
      targetContainer.render();
    }
  }]);
}($e.modules.editor.document.CommandHistoryBase);
var _default = exports["default"] = PasteStyle;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/paste.js":
/*!*******************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/paste.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Paste = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Paste = exports.Paste = /*#__PURE__*/function (_$e$modules$editor$do) {
  function Paste() {
    (0, _classCallCheck2.default)(this, Paste);
    return _callSuper(this, Paste, arguments);
  }
  (0, _inherits2.default)(Paste, _$e$modules$editor$do);
  return (0, _createClass2.default)(Paste, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
    }
  }, {
    key: "getHistory",
    value: function getHistory() {
      return {
        type: 'paste',
        title: __('Elements', 'elementor')
      };
    }
  }, {
    key: "getStorageData",
    value: function getStorageData(args) {
      var _args$storageType = args.storageType,
        storageType = _args$storageType === void 0 ? 'localstorage' : _args$storageType,
        _args$storageKey = args.storageKey,
        storageKey = _args$storageKey === void 0 ? 'clipboard' : _args$storageKey,
        _args$data = args.data,
        data = _args$data === void 0 ? '' : _args$data;
      if ('localstorage' === storageType) {
        return elementorCommon.storage.get(storageKey) || {};
      }
      try {
        return JSON.parse(data) || {};
      } catch (e) {
        return {};
      }
    }
  }, {
    key: "apply",
    value: function () {
      var _apply = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(args) {
        var _storageData$elements;
        var at, _args$rebuild, rebuild, _args$containers, containers, _args$options, options, storageData, storageDataElements, result, _t;
        return _regenerator.default.wrap(function (_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              at = args.at, _args$rebuild = args.rebuild, rebuild = _args$rebuild === void 0 ? false : _args$rebuild, _args$containers = args.containers, containers = _args$containers === void 0 ? [args.container] : _args$containers, _args$options = args.options, options = _args$options === void 0 ? {} : _args$options, storageData = this.getStorageData(args);
              if (!(!storageData || !(storageData !== null && storageData !== void 0 && (_storageData$elements = storageData.elements) !== null && _storageData$elements !== void 0 && _storageData$elements.length) || 'elementor' !== (storageData === null || storageData === void 0 ? void 0 : storageData.type))) {
                _context.next = 1;
                break;
              }
              return _context.abrupt("return", false);
            case 1:
              storageDataElements = storageData.elements;
              if (!(storageData.siteurl !== elementorCommon.config.urls.rest)) {
                _context.next = 5;
                break;
              }
              _context.prev = 2;
              _context.next = 3;
              return new Promise(function (resolve, reject) {
                return elementorCommon.ajax.addRequest('import_from_json', {
                  data: {
                    elements: JSON.stringify(storageDataElements)
                  },
                  success: resolve,
                  error: reject
                });
              });
            case 3:
              storageDataElements = _context.sent;
              _context.next = 5;
              break;
            case 4:
              _context.prev = 4;
              _t = _context["catch"](2);
              return _context.abrupt("return", false);
            case 5:
              result = []; // Paste on "Add Section" area.
              if (rebuild) {
                result = this.rebuild(containers, storageDataElements, at);
              } else {
                if (undefined !== at) {
                  options.at = at;
                }
                result.push(this.pasteTo(containers, storageDataElements, options));
              }
              if (!(1 === result.length)) {
                _context.next = 6;
                break;
              }
              return _context.abrupt("return", result[0]);
            case 6:
              return _context.abrupt("return", result);
            case 7:
            case "end":
              return _context.stop();
          }
        }, _callee, this, [[2, 4]]);
      }));
      function apply(_x) {
        return _apply.apply(this, arguments);
      }
      return apply;
    }()
  }, {
    key: "rebuild",
    value: function rebuild(containers, data, at) {
      var _this = this;
      // Paste at each target.
      var result = [];
      containers.forEach(function (targetContainer) {
        var createNewElementAtTheBottomOfThePage = 'undefined' === typeof at;
        var index = createNewElementAtTheBottomOfThePage ? targetContainer.view.collection.length : at;
        data.forEach(function (model) {
          switch (model.elType) {
            case 'container':
              {
                // Push the cloned container to the 'document'.
                result.push(_this.pasteTo([targetContainer], [model], {
                  at: createNewElementAtTheBottomOfThePage ? ++index : index
                }));
              }
              break;
            case 'section':
              {
                // If is inner create section for `inner-section`.
                if (model.isInner) {
                  var section = $e.run('document/elements/create', {
                    container: targetContainer,
                    model: {
                      elType: 'section'
                    },
                    columns: 1,
                    options: {
                      at: index,
                      edit: false
                    }
                  });

                  // `targetContainer` = first column at `section`.
                  targetContainer = section.view.children.findByIndex(0).getContainer();
                }

                // Will be not affected by hook since it always have `model.elements`.
                result.push(_this.pasteTo([targetContainer], [model], {
                  at: index,
                  edit: false
                }));
                index++;
              }
              break;
            case 'column':
              {
                // Next code changed from original since `_checkIsEmpty()` was removed.
                var _section = $e.run('document/elements/create', {
                  container: targetContainer,
                  model: {
                    elType: 'section'
                  },
                  columns: 0,
                  // Section with no columns.
                  options: {
                    at: ++index,
                    edit: false
                  }
                });
                result.push(_this.pasteTo([_section], [model]));
              }
              break;
            default:
              {
                // The 'default' case is widget.
                var target;
                if ('section' === targetContainer.model.get('elType')) {
                  // On trying to paste widget on section, the paste should be at the first column.
                  target = [targetContainer.view.children.findByIndex(0).getContainer()];
                } else if ('container' === targetContainer.model.get('elType')) {
                  target = [targetContainer];
                } else if (elementorCommon.config.experimentalFeatures.container) {
                  // If the container experiment is active, create a new wrapper container.
                  target = $e.run('document/elements/create', {
                    container: targetContainer,
                    model: {
                      elType: 'container'
                    },
                    options: {
                      at: createNewElementAtTheBottomOfThePage ? ++index : index
                    }
                  });
                  target = [target];
                } else {
                  // Else, create section with one column for the element.
                  var _section2 = $e.run('document/elements/create', {
                    container: targetContainer,
                    model: {
                      elType: 'section'
                    },
                    columns: 1,
                    options: {
                      at: createNewElementAtTheBottomOfThePage ? ++index : index
                    }
                  });

                  // Create the element inside the column that just was created.
                  target = [_section2.view.children.first().getContainer()];
                }
                result.push(_this.pasteTo(target, [model]));
              }
          }
        });
      });
      return result;
    }
  }, {
    key: "pasteTo",
    value: function pasteTo(targetContainers, models) {
      var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      options = Object.assign({
        at: null,
        clone: true
      }, options);
      var result = [];
      models.forEach(function (model) {
        result.push($e.run('document/elements/create', {
          containers: targetContainers,
          model: model,
          options: options
        }));

        // On paste sections, increase the `at` for every section.
        if (null !== options.at) {
          options.at++;
        }
      });
      if (1 === result.length) {
        return result[0];
      }
      return result;
    }
  }]);
}($e.modules.editor.document.CommandHistoryBase);
var _default = exports["default"] = Paste;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/reset-settings.js":
/*!****************************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/reset-settings.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.ResetSettings = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var ResetSettings = exports.ResetSettings = /*#__PURE__*/function (_$e$modules$editor$do) {
  function ResetSettings() {
    (0, _classCallCheck2.default)(this, ResetSettings);
    return _callSuper(this, ResetSettings, arguments);
  }
  (0, _inherits2.default)(ResetSettings, _$e$modules$editor$do);
  return (0, _createClass2.default)(ResetSettings, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
    }
  }, {
    key: "getHistory",
    value: function getHistory(args) {
      var _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers;
      return {
        containers: containers,
        type: 'reset_settings'
      };
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var _args$containers2 = args.containers,
        containers = _args$containers2 === void 0 ? [args.container] : _args$containers2,
        _args$options = args.options,
        options = _args$options === void 0 ? {} : _args$options,
        _args$settings = args.settings,
        settings = _args$settings === void 0 ? [] : _args$settings;
      containers.forEach(function (container) {
        var controls = Object.entries(container.settings.controls),
          defaultValues = {};
        controls.forEach(function (_ref) {
          var _ref2 = (0, _slicedToArray2.default)(_ref, 2),
            controlName = _ref2[0],
            control = _ref2[1];
          // If settings were specific, restore only them.
          if (settings && settings.length) {
            if (!settings.find(function (key) {
              return key === controlName;
            })) {
              return;
            }
          }
          defaultValues[controlName] = control.default;
        });
        defaultValues.__globals__ = {};
        $e.run('document/elements/settings', {
          container: container,
          options: options,
          settings: defaultValues
        });
        container.render();
      });
    }
  }]);
}($e.modules.editor.document.CommandHistoryBase);
var _default = exports["default"] = ResetSettings;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/reset-style.js":
/*!*************************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/reset-style.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.ResetStyle = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var ResetStyle = exports.ResetStyle = /*#__PURE__*/function (_$e$modules$editor$do) {
  function ResetStyle() {
    (0, _classCallCheck2.default)(this, ResetStyle);
    return _callSuper(this, ResetStyle, arguments);
  }
  (0, _inherits2.default)(ResetStyle, _$e$modules$editor$do);
  return (0, _createClass2.default)(ResetStyle, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
    }
  }, {
    key: "getHistory",
    value: function getHistory(args) {
      var _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers;
      return {
        containers: containers,
        type: 'reset_style'
      };
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var _args$containers2 = args.containers,
        containers = _args$containers2 === void 0 ? [args.container] : _args$containers2;
      containers.forEach(function (container) {
        var controls = container.settings.controls,
          settingsKeys = [];
        container.view.allowRender = false;
        Object.entries(controls).forEach(function (_ref) {
          var _ref2 = (0, _slicedToArray2.default)(_ref, 2),
            controlName = _ref2[0],
            control = _ref2[1];
          if (!container.view.isStyleTransferControl(control)) {
            return;
          }
          settingsKeys.push(controlName);
        });
        $e.run('document/elements/reset-settings', {
          container: container,
          settings: settingsKeys,
          options: {
            external: true
          }
        });
        container.view.allowRender = true;
        container.render();
      });
    }
  }]);
}($e.modules.editor.document.CommandHistoryBase);
var _default = exports["default"] = ResetStyle;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/select-all.js":
/*!************************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/select-all.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.SelectAll = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var SelectAll = exports.SelectAll = /*#__PURE__*/function (_$e$modules$CommandBa) {
  function SelectAll() {
    (0, _classCallCheck2.default)(this, SelectAll);
    return _callSuper(this, SelectAll, arguments);
  }
  (0, _inherits2.default)(SelectAll, _$e$modules$CommandBa);
  return (0, _createClass2.default)(SelectAll, [{
    key: "apply",
    value: function apply() {
      elementor.selection.add(this.flattenContainersList(
      // The selection mechanism keeps selected elements in a single-dimension object. Therefore, In order to
      // select all document elements, we should convert them into a flatten, single-dimension array.
      elementor.elementsModel.get('elements').map(function (element) {
        return elementor.getContainer(element.id);
      })));
    }

    /**
     * Recursively iterate over all container children and make a flatten array of their instances.
     *
     * @param {*} containers
     * @return {*[]} flattened array of container children
     */
  }, {
    key: "flattenContainersList",
    value: function flattenContainersList() {
      var containers = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var flatten = [];
      var _iterator = _createForOfIteratorHelper(containers),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var container = _step.value;
          flatten.push(container);
          if (container.children.length) {
            flatten = flatten.concat(this.flattenContainersList(container.children));
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      return flatten;
    }
  }]);
}($e.modules.CommandBase);
var _default = exports["default"] = SelectAll;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/select.js":
/*!********************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/select.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Select = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Select = exports.Select = /*#__PURE__*/function (_$e$modules$editor$Co) {
  function Select() {
    (0, _classCallCheck2.default)(this, Select);
    return _callSuper(this, Select, arguments);
  }
  (0, _inherits2.default)(Select, _$e$modules$editor$Co);
  return (0, _createClass2.default)(Select, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers,
        _args$append = args.append,
        append = _args$append === void 0 ? false : _args$append;
      elementor.selection.add(containers, append);
    }
  }]);
}($e.modules.editor.CommandContainerBase);
var _default = exports["default"] = Select;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/settings.js":
/*!**********************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/settings.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Settings = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/**
 * @typedef {import('../../../container/container')} Container
 */
var Settings = exports.Settings = /*#__PURE__*/function (_$e$modules$editor$do) {
  function Settings() {
    (0, _classCallCheck2.default)(this, Settings);
    return _callSuper(this, Settings, arguments);
  }
  (0, _inherits2.default)(Settings, _$e$modules$editor$do);
  return (0, _createClass2.default)(Settings, [{
    key: "addToHistory",
    value:
    /**
     * Function addToHistory().
     *
     * @param {Container} container
     * @param {{}}        newSettings
     * @param {{}}        oldSettings
     */
    function addToHistory(container, newSettings, oldSettings) {
      var changes = (0, _defineProperty2.default)({}, container.id, {
          old: oldSettings,
          new: newSettings
        }),
        historyItem = {
          containers: [container],
          data: {
            changes: changes
          },
          type: 'change',
          restore: Settings.restore
        };
      $e.internal('document/history/add-transaction', historyItem);
    }
  }, {
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
      this.requireArgumentConstructor('settings', Object, args);
    }
  }, {
    key: "getHistory",
    value: function getHistory(args) {
      var _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers,
        subTitle = this.constructor.getSubTitle(args);
      return {
        containers: containers,
        subTitle: subTitle,
        type: 'change'
      };
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var _this = this;
      var _args$containers2 = args.containers,
        containers = _args$containers2 === void 0 ? [args.container] : _args$containers2,
        _args$settings = args.settings,
        settings = _args$settings === void 0 ? {} : _args$settings,
        _args$isMultiSettings = args.isMultiSettings,
        isMultiSettings = _args$isMultiSettings === void 0 ? false : _args$isMultiSettings,
        _args$options = args.options,
        options = _args$options === void 0 ? {} : _args$options;
      containers.forEach(function (container) {
        container = container.lookup();
        /**
         * Settings support multi settings for each container, eg use:
         * settings: { '{ container-id }': { someSettingKey: someSettingValue } } etc.
         */
        var newSettings = isMultiSettings ? settings[container.id] : settings,
          oldSettings = container.settings.toJSON();

        // Clear old oldValues.
        container.oldValues = {};

        // Set oldValues, For each setting is about to change save setting value.
        Object.keys(newSettings).forEach(function (key) {
          container.oldValues[key] = oldSettings[key];
        });

        // If history active, add history transaction with old and new settings.
        if (_this.isHistoryActive()) {
          _this.addToHistory(container, newSettings, container.oldValues);
        }
        $e.internal('document/elements/set-settings', {
          container: container,
          options: options,
          settings: newSettings
        });
      });
    }
  }], [{
    key: "getSubTitle",
    value:
    /**
     * Function getSubTitle().
     *
     * Get sub title by container.
     *
     * @param {{}} args
     *
     * @return {string} sub title
     */
    function getSubTitle(args) {
      var _args$containers3 = args.containers,
        containers = _args$containers3 === void 0 ? [args.container] : _args$containers3,
        _args$settings2 = args.settings,
        settings = _args$settings2 === void 0 ? {} : _args$settings2,
        isMultiSettings = args.isMultiSettings,
        settingsKeys = Object.keys(settings),
        controls = containers[0].controls,
        firstSettingKey = settingsKeys[0];
      var result = '';
      if (!isMultiSettings && 1 === settingsKeys.length && controls && controls[firstSettingKey]) {
        result = controls[firstSettingKey].label;
      }
      return result;
    }

    /**
     * Function restore().
     *
     * Redo/Restore.
     *
     * @param {{}}      historyItem
     * @param {boolean} isRedo
     */
  }, {
    key: "restore",
    value: function restore(historyItem, isRedo) {
      var data = historyItem.get('data');
      historyItem.get('containers').forEach(function (/* Container */container) {
        var changes = data.changes[container.id];
        $e.run('document/elements/settings', {
          container: container,
          settings: isRedo ? changes.new : changes.old,
          options: {
            external: true
          }
        });
      });
    }
  }]);
}($e.modules.editor.document.CommandHistoryDebounceBase);
var _default = exports["default"] = Settings;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/commands/toggle-selection.js":
/*!******************************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/commands/toggle-selection.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.ToggleSelection = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var ToggleSelection = exports.ToggleSelection = /*#__PURE__*/function (_$e$modules$editor$Co) {
  function ToggleSelection() {
    (0, _classCallCheck2.default)(this, ToggleSelection);
    return _callSuper(this, ToggleSelection, arguments);
  }
  (0, _inherits2.default)(ToggleSelection, _$e$modules$editor$Co);
  return (0, _createClass2.default)(ToggleSelection, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers,
        _args$append = args.append,
        append = _args$append === void 0 ? false : _args$append;
      containers.forEach(function (container) {
        $e.run(elementor.selection.has(container) && append ? 'document/elements/deselect' : 'document/elements/select', args);
      });
    }
  }]);
}($e.modules.editor.CommandContainerBase);
var _default = exports["default"] = ToggleSelection;

/***/ }),

/***/ "../assets/dev/js/editor/document/elements/component.js":
/*!**************************************************************!*\
  !*** ../assets/dev/js/editor/document/elements/component.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _componentBase = _interopRequireDefault(__webpack_require__(/*! elementor-api/modules/component-base */ "../modules/web-cli/assets/js/modules/component-base.js"));
var commands = _interopRequireWildcard(__webpack_require__(/*! ./commands/ */ "../assets/dev/js/editor/document/elements/commands/index.js"));
var commandsInternal = _interopRequireWildcard(__webpack_require__(/*! ./commands-internal/ */ "../assets/dev/js/editor/document/elements/commands-internal/index.js"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Component = exports["default"] = /*#__PURE__*/function (_ComponentBase) {
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _callSuper(this, Component, arguments);
  }
  (0, _inherits2.default)(Component, _ComponentBase);
  return (0, _createClass2.default)(Component, [{
    key: "getNamespace",
    value: function getNamespace() {
      return 'document/elements';
    }
  }, {
    key: "defaultCommands",
    value: function defaultCommands() {
      return this.importCommands(commands);
    }
  }, {
    key: "defaultCommandsInternal",
    value: function defaultCommandsInternal() {
      return this.importCommands(commandsInternal);
    }
  }, {
    key: "defaultUtils",
    value: function defaultUtils() {
      var _this = this;
      return {
        isValidChild: function isValidChild(childModel, parentModel) {
          return parentModel.isValidChild(childModel);
        },
        isValidGrandChild: function isValidGrandChild(childModel, targetContainer) {
          var result;
          var childElType = childModel.get('elType');
          switch (targetContainer.model.get('elType')) {
            case 'document':
              result = true;
              break;
            case 'section':
              result = 'widget' === childElType;
              break;
            default:
              result = false;
          }
          return result;
        },
        isSameElement: function isSameElement(sourceModel, targetContainer) {
          var targetElType = targetContainer.model.get('elType'),
            sourceElType = sourceModel.get('elType');
          if (targetElType !== sourceElType) {
            return false;
          }
          if ('column' === targetElType && 'column' === sourceElType) {
            return true;
          }
          return targetContainer.model.get('isInner') === sourceModel.get('isInner');
        },
        getPasteOptions: function getPasteOptions(sourceModel, targetContainer) {
          var result = {};
          result.isValidChild = targetContainer.model.isValidChild(sourceModel);
          result.isSameElement = _this.utils.isSameElement(sourceModel, targetContainer);
          result.isValidGrandChild = _this.utils.isValidGrandChild(sourceModel, targetContainer);
          return result;
        },
        isPasteEnabled: function isPasteEnabled(targetContainer) {
          var _storage$elements;
          var storage = elementorCommon.storage.get('clipboard');

          // No storage? no paste.
          if (!storage || !(storage !== null && storage !== void 0 && (_storage$elements = storage.elements) !== null && _storage$elements !== void 0 && _storage$elements.length) || 'elementor' !== (storage === null || storage === void 0 ? void 0 : storage.type)) {
            return false;
          }
          if (!(storage.elements[0] instanceof Backbone.Model)) {
            storage.elements[0] = new Backbone.Model(storage.elements[0]);
          }
          var pasteOptions = _this.utils.getPasteOptions(storage.elements[0], targetContainer);
          return Object.values(pasteOptions).some(function (opt) {
            return !!opt;
          });
        },
        allowAddingWidgets: function allowAddingWidgets() {
          var _elementor$config$doc;
          return (_elementor$config$doc = elementor.config.document.panel.allow_adding_widgets) !== null && _elementor$config$doc !== void 0 ? _elementor$config$doc : true;
        },
        showNavigator: function showNavigator() {
          var _elementor$config$doc2;
          return (_elementor$config$doc2 = elementor.config.document.panel.show_navigator) !== null && _elementor$config$doc2 !== void 0 ? _elementor$config$doc2 : true;
        },
        showCopyAndShareButton: function showCopyAndShareButton() {
          var _elementor$config$doc3;
          return (_elementor$config$doc3 = elementor.config.document.panel.show_copy_and_share) !== null && _elementor$config$doc3 !== void 0 ? _elementor$config$doc3 : false;
        },
        getTitleForLibraryClose: function getTitleForLibraryClose() {
          var _elementor$config$doc4;
          return (_elementor$config$doc4 = elementor.config.document.panel.library_close_title) !== null && _elementor$config$doc4 !== void 0 ? _elementor$config$doc4 : '';
        },
        getTitleForPublishButton: function getTitleForPublishButton() {
          var _elementor$config$doc5;
          return (_elementor$config$doc5 = elementor.config.document.panel.publish_button_title) !== null && _elementor$config$doc5 !== void 0 ? _elementor$config$doc5 : '';
        }
      };
    }
  }]);
}(_componentBase.default);

/***/ }),

/***/ "../assets/dev/js/editor/document/globals/commands/base/disable-enable.js":
/*!********************************************************************************!*\
  !*** ../assets/dev/js/editor/document/globals/commands/base/disable-enable.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _commandDisableEnable = _interopRequireDefault(__webpack_require__(/*! elementor-document/command-bases/command-disable-enable */ "../assets/dev/js/editor/document/command-bases/command-disable-enable.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var DisableEnable = exports["default"] = /*#__PURE__*/function (_CommandDisableEnable) {
  function DisableEnable() {
    (0, _classCallCheck2.default)(this, DisableEnable);
    return _callSuper(this, DisableEnable, arguments);
  }
  (0, _inherits2.default)(DisableEnable, _CommandDisableEnable);
  return (0, _createClass2.default)(DisableEnable, [{
    key: "getTitle",
    value: function getTitle() {
      return __('Global');
    }
  }], [{
    key: "getName",
    value: function getName() {
      return 'Global';
    }
  }, {
    key: "getEnableCommand",
    value: function getEnableCommand() {
      return 'document/globals/enable';
    }
  }, {
    key: "getDisableCommand",
    value: function getDisableCommand() {
      return 'document/globals/disable';
    }
  }]);
}(_commandDisableEnable.default);

/***/ }),

/***/ "../assets/dev/js/editor/document/globals/commands/disable.js":
/*!********************************************************************!*\
  !*** ../assets/dev/js/editor/document/globals/commands/disable.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Disable = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _disableEnable = _interopRequireDefault(__webpack_require__(/*! ./base/disable-enable */ "../assets/dev/js/editor/document/globals/commands/base/disable-enable.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
// TODO: Disable is the only command that extends DisableEnable which is async.
var Disable = exports.Disable = /*#__PURE__*/function (_DisableEnable) {
  function Disable() {
    (0, _classCallCheck2.default)(this, Disable);
    return _callSuper(this, Disable, arguments);
  }
  (0, _inherits2.default)(Disable, _DisableEnable);
  return (0, _createClass2.default)(Disable, [{
    key: "apply",
    value: function () {
      var _apply = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee3(args) {
        var settings, _args$containers, containers, _args$options, options, all;
        return _regenerator.default.wrap(function (_context3) {
          while (1) switch (_context3.prev = _context3.next) {
            case 0:
              settings = args.settings, _args$containers = args.containers, containers = _args$containers === void 0 ? [args.container] : _args$containers, _args$options = args.options, options = _args$options === void 0 ? {} : _args$options;
              all = containers.map(/*#__PURE__*/function () {
                var _ref = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee2(/* Container */container) {
                  var promises;
                  return _regenerator.default.wrap(function (_context2) {
                    while (1) switch (_context2.prev = _context2.next) {
                      case 0:
                        container = container.lookup();
                        promises = []; // TODO rename `options.restore` => `options.unlink`.
                        if (!options.restore) {
                          _context2.next = 1;
                          break;
                        }
                        promises = Object.entries(container.globals.attributes).map(/*#__PURE__*/function () {
                          var _ref3 = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(_ref2) {
                            var _ref4, globalKey, globalValue;
                            return _regenerator.default.wrap(function (_context) {
                              while (1) switch (_context.prev = _context.next) {
                                case 0:
                                  _ref4 = (0, _slicedToArray2.default)(_ref2, 2), globalKey = _ref4[0], globalValue = _ref4[1];
                                  if (globalValue) {
                                    _context.next = 1;
                                    break;
                                  }
                                  return _context.abrupt("return");
                                case 1:
                                  return _context.abrupt("return", $e.run('document/globals/unlink', {
                                    container: container,
                                    options: {
                                      external: true
                                    },
                                    globalValue: globalValue,
                                    setting: globalKey
                                  }));
                                case 2:
                                case "end":
                                  return _context.stop();
                              }
                            }, _callee);
                          }));
                          return function (_x3) {
                            return _ref3.apply(this, arguments);
                          };
                        }());
                        _context2.next = 1;
                        return Promise.all(promises);
                      case 1:
                        // Clear globals.
                        Object.keys(settings).forEach(function (setting) {
                          return container.globals.set(setting, '');
                        });
                        $e.internal('document/elements/set-settings', {
                          container: container,
                          settings: {
                            __globals__: container.globals.toJSON()
                          },
                          options: {
                            renderUI: true
                          }
                        });
                      case 2:
                      case "end":
                        return _context2.stop();
                    }
                  }, _callee2);
                }));
                return function (_x2) {
                  return _ref.apply(this, arguments);
                };
              }());
              _context3.next = 1;
              return Promise.all(all);
            case 1:
            case "end":
              return _context3.stop();
          }
        }, _callee3);
      }));
      function apply(_x) {
        return _apply.apply(this, arguments);
      }
      return apply;
    }()
  }]);
}(_disableEnable.default);
var _default = exports["default"] = Disable;

/***/ }),

/***/ "../assets/dev/js/editor/document/globals/commands/enable.js":
/*!*******************************************************************!*\
  !*** ../assets/dev/js/editor/document/globals/commands/enable.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Enable = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _disableEnable = _interopRequireDefault(__webpack_require__(/*! ./base/disable-enable */ "../assets/dev/js/editor/document/globals/commands/base/disable-enable.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
// Run when a global control value is chosen while the active value is custom.
var Enable = exports.Enable = /*#__PURE__*/function (_DisableEnable) {
  function Enable() {
    (0, _classCallCheck2.default)(this, Enable);
    return _callSuper(this, Enable, arguments);
  }
  (0, _inherits2.default)(Enable, _DisableEnable);
  return (0, _createClass2.default)(Enable, [{
    key: "apply",
    value: function apply(args) {
      var settings = args.settings,
        _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers;
      containers.forEach(function (container) {
        container = container.lookup();
        container.globals.set(settings);
        $e.internal('document/elements/set-settings', {
          container: container,
          settings: {
            __globals__: container.globals.toJSON()
          },
          options: {
            renderUI: true
          }
        });

        // Clear custom local settings.
        Object.values(container.getGroupRelatedControls(settings)).forEach(function (control) {
          container.settings.set(control.name, control.default);
        });
      });
    }
  }]);
}(_disableEnable.default);
var _default = exports["default"] = Enable;

/***/ }),

/***/ "../assets/dev/js/editor/document/globals/commands/index.js":
/*!******************************************************************!*\
  !*** ../assets/dev/js/editor/document/globals/commands/index.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Disable", ({
  enumerable: true,
  get: function get() {
    return _disable.Disable;
  }
}));
Object.defineProperty(exports, "Enable", ({
  enumerable: true,
  get: function get() {
    return _enable.Enable;
  }
}));
Object.defineProperty(exports, "Settings", ({
  enumerable: true,
  get: function get() {
    return _settings.Settings;
  }
}));
Object.defineProperty(exports, "Unlink", ({
  enumerable: true,
  get: function get() {
    return _unlink.Unlink;
  }
}));
var _disable = __webpack_require__(/*! ./disable */ "../assets/dev/js/editor/document/globals/commands/disable.js");
var _enable = __webpack_require__(/*! ./enable */ "../assets/dev/js/editor/document/globals/commands/enable.js");
var _settings = __webpack_require__(/*! ./settings */ "../assets/dev/js/editor/document/globals/commands/settings.js");
var _unlink = __webpack_require__(/*! ./unlink */ "../assets/dev/js/editor/document/globals/commands/unlink.js");

/***/ }),

/***/ "../assets/dev/js/editor/document/globals/commands/settings.js":
/*!*********************************************************************!*\
  !*** ../assets/dev/js/editor/document/globals/commands/settings.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Settings = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _settings = _interopRequireDefault(__webpack_require__(/*! elementor-document/elements/commands/settings */ "../assets/dev/js/editor/document/elements/commands/settings.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Settings = exports.Settings = /*#__PURE__*/function (_$e$modules$editor$do) {
  function Settings() {
    (0, _classCallCheck2.default)(this, Settings);
    return _callSuper(this, Settings, arguments);
  }
  (0, _inherits2.default)(Settings, _$e$modules$editor$do);
  return (0, _createClass2.default)(Settings, [{
    key: "validateArgs",
    value: function validateArgs(args) {
      this.requireContainer(args);
      this.requireArgumentConstructor('settings', Object, args);
    }
  }, {
    key: "getHistory",
    value: function getHistory(args) {
      var settings = args.settings,
        _args$containers = args.containers,
        containers = _args$containers === void 0 ? [args.container] : _args$containers,
        changes = {};
      containers.forEach(function (container) {
        var id = container.id;
        if (!changes[id]) {
          changes[id] = {};
        }
        changes[id] = {
          old: container.globals.toJSON(),
          new: settings
        };
      });
      var subTitle = _settings.default.getSubTitle(args);
      return {
        containers: containers,
        subTitle: subTitle,
        data: {
          changes: changes
        },
        type: 'change',
        restore: this.constructor.restore
      };
    }
  }, {
    key: "apply",
    value: function apply(args) {
      var settings = args.settings,
        _args$containers2 = args.containers,
        containers = _args$containers2 === void 0 ? [args.container] : _args$containers2,
        _args$options = args.options,
        options = _args$options === void 0 ? {} : _args$options;
      containers.forEach(function (container) {
        container = container.lookup();
        if (!Object.keys(settings).length) {
          container.globals.clear();
        } else {
          container.globals.set(settings);
        }
        $e.internal('document/elements/set-settings', {
          container: container,
          options: options,
          settings: {
            __globals__: container.globals.toJSON()
          }
        });
      });
    }
  }], [{
    key: "restore",
    value: function restore(historyItem, isRedo) {
      var data = historyItem.get('data');
      historyItem.get('containers').forEach(function (container) {
        var changes = data.changes[container.id];
        $e.run('document/globals/settings', {
          container: container,
          settings: isRedo ? changes.new : changes.old
        });
        container.panel.refresh();
      });
    }
  }]);
}($e.modules.editor.document.CommandHistoryDebounceBase);
var _default = exports["default"] = Settings;

/***/ }),

/***/ "../assets/dev/js/editor/document/globals/commands/unlink.js":
/*!*******************************************************************!*\
  !*** ../assets/dev/js/editor/document/globals/commands/unlink.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Unlink = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
// TODO: Add dev-tools CSS to see if widget have globals.
var Unlink = exports.Unlink = /*#__PURE__*/function (_$e$modules$editor$Co) {
  function Unlink() {
    (0, _classCallCheck2.default)(this, Unlink);
    return _callSuper(this, Unlink, arguments);
  }
  (0, _inherits2.default)(Unlink, _$e$modules$editor$Co);
  return (0, _createClass2.default)(Unlink, [{
    key: "validateArgs",
    value: function validateArgs() {
      var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      this.requireContainer(args);
      this.requireArgumentType('setting', 'string', args);
      this.requireArgumentType('globalValue', 'string', args);

      // TODO: validate global value is command format.
    }
  }, {
    key: "apply",
    value: function () {
      var _apply = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee2(args) {
        var _args$containers, containers, setting, globalValue, _args$options, options, localSettings;
        return _regenerator.default.wrap(function (_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              _args$containers = args.containers, containers = _args$containers === void 0 ? [args.container] : _args$containers, setting = args.setting, globalValue = args.globalValue, _args$options = args.options, options = _args$options === void 0 ? {} : _args$options, localSettings = {};
              _context2.next = 1;
              return Promise.all(containers.map(/*#__PURE__*/function () {
                var _ref = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(/* Container */container) {
                  var result, _container$controls$s, value, groupPrefix;
                  return _regenerator.default.wrap(function (_context) {
                    while (1) switch (_context.prev = _context.next) {
                      case 0:
                        _context.next = 1;
                        return $e.data.get(globalValue);
                      case 1:
                        result = _context.sent;
                        if (result) {
                          // Prepare global value to mapping.
                          value = result.data.value, groupPrefix = (_container$controls$s = container.controls[setting]) === null || _container$controls$s === void 0 ? void 0 : _container$controls$s.groupPrefix;
                          if (groupPrefix) {
                            Object.entries(value).forEach(function (_ref2) {
                              var _ref3 = (0, _slicedToArray2.default)(_ref2, 2),
                                dataKey = _ref3[0],
                                dataValue = _ref3[1];
                              dataKey = dataKey.replace(elementor.config.kit_config.typography_prefix, groupPrefix);
                              localSettings[dataKey] = dataValue;
                            });
                          } else {
                            localSettings[setting] = value;
                          }
                        }
                        return _context.abrupt("return", Promise.resolve());
                      case 2:
                      case "end":
                        return _context.stop();
                    }
                  }, _callee);
                }));
                return function (_x2) {
                  return _ref.apply(this, arguments);
                };
              }()));
            case 1:
              // Restore globals settings as custom local settings.
              if (Object.keys(localSettings).length) {
                $e.run('document/elements/settings', {
                  containers: containers,
                  options: options,
                  settings: localSettings
                });
              }
            case 2:
            case "end":
              return _context2.stop();
          }
        }, _callee2);
      }));
      function apply(_x) {
        return _apply.apply(this, arguments);
      }
      return apply;
    }()
  }]);
}($e.modules.editor.CommandContainerBase);
var _default = exports["default"] = Unlink;

/***/ }),

/***/ "../assets/dev/js/editor/document/globals/component.js":
/*!*************************************************************!*\
  !*** ../assets/dev/js/editor/document/globals/component.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _componentBase = _interopRequireDefault(__webpack_require__(/*! elementor-api/modules/component-base */ "../modules/web-cli/assets/js/modules/component-base.js"));
var commands = _interopRequireWildcard(__webpack_require__(/*! ./commands/ */ "../assets/dev/js/editor/document/globals/commands/index.js"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Component = exports["default"] = /*#__PURE__*/function (_ComponentBase) {
  function Component() {
    (0, _classCallCheck2.default)(this, Component);
    return _callSuper(this, Component, arguments);
  }
  (0, _inherits2.default)(Component, _ComponentBase);
  return (0, _createClass2.default)(Component, [{
    key: "getNamespace",
    value: function getNamespace() {
      return 'document/globals';
    }
  }, {
    key: "defaultCommands",
    value: function defaultCommands() {
      return this.importCommands(commands);
    }
  }]);
}(_componentBase.default);

/***/ }),

/***/ "../assets/dev/js/editor/document/helper-bc.js":
/*!*****************************************************!*\
  !*** ../assets/dev/js/editor/document/helper-bc.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var BackwardsCompatibility = exports["default"] = /*#__PURE__*/function () {
  function BackwardsCompatibility() {
    (0, _classCallCheck2.default)(this, BackwardsCompatibility);
  }
  return (0, _createClass2.default)(BackwardsCompatibility, null, [{
    key: "findViewRecursive",
    value:
    /**
     * @param {*}        parent
     * @param {string}   key
     * @param {string}   value
     * @param {boolean=} multiple
     * @deprecated since 2.9.0, use `$e.components.get( 'document' ).utils.findViewRecursive( parent, key, value, multiple )` instead.
     */
    function findViewRecursive(parent, key, value) {
      var multiple = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
      elementorDevTools.deprecation.deprecated('findViewRecursive()', '2.9.0', "$e.components.get( 'document' ).utils.findViewRecursive( parent, key, value, multiple )");
      return $e.components.get('document').utils.findViewRecursive(parent, key, value, multiple);
    }

    /**
     * @param {string} id - View ID.
     * @deprecated since 2.9.0, use `$e.components.get( 'document' ).utils.findViewById( id )` instead.
     */
  }, {
    key: "findViewById",
    value: function findViewById(id) {
      elementorDevTools.deprecation.deprecated('findViewById( id )', '2.9.0', "$e.components.get( 'document' ).utils.findViewById( id )");
      return $e.components.get('document').utils.findViewById(id);
    }

    /**
     * @param {string} id - Container ID.
     * @deprecated since 2.9.0, use `$e.components.get( 'document' ).utils.findContainerById( id )` instead.
     */
  }, {
    key: "findContainerById",
    value: function findContainerById(id) {
      elementorDevTools.deprecation.deprecated('findContainerById( id )', '2.9.0', "$e.components.get( 'document' ).utils.findContainerById( id )");
      return $e.components.get('document').utils.findContainerById(id);
    }

    /**
     * @param {*} childModel
     * @param {*} parentModel
     * @deprecated since 3.4.0, use `parentModel.isValidChild( childModel )` instead.
     */
  }, {
    key: "isValidChild",
    value: function isValidChild(childModel, parentModel) {
      elementorDevTools.deprecation.deprecated('isValidChild( childModel, parentModel )', '3.4.0', 'parentModel.isValidChild( childModel )');
      return parentModel.isValidChild(childModel);
    }

    /**
     * @param {*} childModel
     * @param {*} targetContainer
     * @deprecated since 3.4.0, use `$e.components.get( 'document/elements' ).utils.isValidGrandChild( childModel, targetContainer )` instead.
     */
  }, {
    key: "isValidGrandChild",
    value: function isValidGrandChild(childModel, targetContainer) {
      elementorDevTools.deprecation.deprecated('isValidGrandChild( childModel, targetContainer )', '3.4.0', "$e.components.get( 'document/elements' ).utils.isValidGrandChild( childModel, targetContainer )");
      return $e.components.get('document/elements').utils.isValidGrandChild(childModel, targetContainer);
    }

    /**
     * @param {*} sourceModel
     * @param {*} targetContainer
     * @deprecated since 3.4.0, use `$e.components.get( 'document/elements' ).utils.isSameElement( sourceModel, targetContainer )` instead.
     */
  }, {
    key: "isSameElement",
    value: function isSameElement(sourceModel, targetContainer) {
      elementorDevTools.deprecation.deprecated('isSameElement( sourceModel, targetContainer )', '3.4.0', "$e.components.get( 'document/elements' ).utils.isSameElement( sourceModel, targetContainer )");
      return $e.components.get('document/elements').utils.isSameElement(sourceModel, targetContainer);
    }

    /**
     * @param {*} sourceModel
     * @param {*} targetContainer
     * @deprecated since 3.4.0, use `$e.components.get( 'document/elements' ).utils.getPasteOptions( sourceModel, targetContainer )` instead.
     */
  }, {
    key: "getPasteOptions",
    value: function getPasteOptions(sourceModel, targetContainer) {
      elementorDevTools.deprecation.deprecated('getPasteOptions( sourceModel, targetContainer )', '3.4.0', "$e.components.get( 'document/elements' ).utils.getPasteOptions( sourceModel, targetContainer )");
      return $e.components.get('document/elements').utils.getPasteOptions(sourceModel, targetContainer);
    }

    /**
     * @param {*} targetContainer
     * @deprecated since 3.4.0, use `$e.components.get( 'document/elements' ).utils.isPasteEnabled( targetContainer )` instead.
     */
  }, {
    key: "isPasteEnabled",
    value: function isPasteEnabled(targetContainer) {
      elementorDevTools.deprecation.deprecated('isPasteEnabled( targetContainer )', '3.4.0', "$e.components.get( 'document/elements' ).utils.isPasteEnabled( targetContainer )");
      return $e.components.get('document/elements').utils.isPasteEnabled(targetContainer);
    }
  }]);
}();

/***/ }),

/***/ "../assets/dev/js/editor/document/history/commands/base/command-history-internal-base.js":
/*!***********************************************************************************************!*\
  !*** ../assets/dev/js/editor/document/history/commands/base/command-history-internal-base.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, o, e, r) { var p = (0, _get2.default)((0, _getPrototypeOf2.default)(1 & r ? t.prototype : t), o, e); return 2 & r && "function" == typeof p ? function (t) { return p.apply(e, t); } : p; }
/**
 * @typedef {import ('elementor/modules/history/assets/js/module')} HistoryManager
 */
var CommandHistoryInternalBase = exports["default"] = /*#__PURE__*/function (_$e$modules$editor$Co) {
  function CommandHistoryInternalBase() {
    (0, _classCallCheck2.default)(this, CommandHistoryInternalBase);
    return _callSuper(this, CommandHistoryInternalBase, arguments);
  }
  (0, _inherits2.default)(CommandHistoryInternalBase, _$e$modules$editor$Co);
  return (0, _createClass2.default)(CommandHistoryInternalBase, [{
    key: "initialize",
    value: function initialize(args) {
      _superPropGet(CommandHistoryInternalBase, "initialize", this, 3)([args]);

      /**
       * @type {HistoryManager}
       */
      this.history = elementor.documents.getCurrent().history;
    }
  }]);
}($e.modules.editor.CommandContainerInternalBase);

/***/ }),

/***/ "../assets/dev/js/editor/document/history/commands/do.js":
/*!***************************************************************!*\
  !*** ../assets/dev/js/editor/document/history/commands/do.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.Do = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Do = exports.Do = /*#__PURE__*/function (_$e$modules$CommandBa) {
  function Do() {
    (0, _classCallCheck2.default)(this, Do);
    return _callSuper(this, Do, arguments);
  }
  (0, _inherits2.default)(Do, _$e$modules$CommandBa);
  return (0, _createClass2.default)(Do, [{
    key: "apply",
    value: function apply(args) {
      var index = args.index;
      return elementor.documents.getCurrent().history.doItem(index);
    }
  }]);
}($e.modules.CommandBase);
var _default = exports["default"] = Do;

/***/ }),

/***/ "../assets/dev/js/editor/document/history/commands/index.js":
/*!******************************************************************!*\
  !*** ../assets/dev/js/editor/document/history/commands/index.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Do", ({
  enumerable: true,
  get: function get() {
    return _do.Do;
  }
}));
Object.defineProperty(exports, "Redo", ({
  enumerable: true,
  get: function get() {
    return _redo.Redo;
  }
}));
Object.defineProperty(exports, "Undo", ({
  enumerable: true,
  get: function get() {
    return _undo.Undo;
  }
}));
Object.defineProperty(exports, "UndoAll", ({
  enumerable: true,
  get: function get() {
    return _undoAll.UndoAll;
  }
}));
var _do = __webpack_require__(/*! ./do */ "../assets/dev/js/editor/document/history/commands/do.js");
var _redo = __webpack_require__(/*! ./redo */ "../assets/dev/js/editor/document/history/commands/redo.js");
var _undo = __webpack_require__(/*! ./undo */ "../assets/dev/js/editor/document/history/commands/undo.js");
var _undoAll = __webpack_require__(/*! ./undo-all */ "../assets/dev/js/editor/document/history/commands/undo-all.js");

/***/ }),

/***/ "../assets/dev/js/editor/document/history/commands/internal/add-transaction.js":
/*!*************************************************************************************!*\
  !*** ../assets/dev/js/editor/document/history/commands/internal/add-transaction.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.AddTransaction = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "../node_modules/@babel/runtime/helpers/get.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _commandHistoryInternalBase = _interopRequireDefault(__webpack_require__(/*! ../base/command-history-internal-base */ "../assets/dev/js/editor/document/history/commands/base/command-history-internal-base.js"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Refle