<!DOCTYPE HTML>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
    <link rel="icon" href="<?php echo e(asset('web/media/logos/favicon.ico')); ?>" type="image/png">
    <title><?php echo e(getLogInUser()->hasRole('client') ? 'Client' : ''); ?> Transactions PDF</title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/css/invoice-pdf.css')); ?>" rel="stylesheet" type="text/css" />
    <style>
        .custom-font-size-pdf {
            font-size: 11px !important;
        }

        .table thead th {
            font-size: 13px !important;
        }
        .text-center{
            text-align: center;
        }
        h4{
            font-size: 20px !important;
        }
        body {
          font-family: "Lato", DejaVu Sans, sans-serif;
          font-size: 14px;
        }
        *{
            margin-top: 0;
        }
        th, td {
            border:1px solid lightgray;
            padding:10px;
        }
        th{
            text-align: left;
        }
        .table{
            margin:auto;
            width: 100%;
        }
        .head-title{
            margin-top:25px;
        }
        table {
          width: 100%;
          border-collapse: collapse;
        }
    </style>
</head>

<body>
    <div class="d-flex align-items-center justify-content-center mb-4">
        <h4 class="text-center head-title"><?php echo e(getLogInUser()->hasRole('client') ? 'Client' : ''); ?> Transactions Export Data</h4>
    </div>
    <table class="table table-bordered border-primary">
        <thead>
            <tr>
                <?php if(getLogInUser()->hasRole('admin')): ?>

                    <th style="width: 9%"><b>Transaction ID</b></th>
                <?php endif; ?>
                <th style="width: 14%"><b>Payment Date</b></th>

                <th style="width: 12%"><b>Invoice ID</b></th>
                <?php if(getLogInUser()->hasRole('admin')): ?>
                    <th style="width: 20%"><b>Client Name</b></th>
                <?php endif; ?>
                <th style="width: 20%;"><b>Payment Amount</b></th>
                <th style="width: 11%"><b>Payment Method</b></th>
                <th style="width: 14%"><b>Payment Status</b></th>

            </tr>
        </thead>
        <tbody>
            <?php if(count($payments) > 0): ?>
                <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="custom-font-size-pdf">
                        <?php if(getLogInUser()->hasRole('admin')): ?>

                            <td><?php echo e($payment->transaction_id ?? 'N/A'); ?></td>

                        <?php endif; ?>
                        <td><?php echo e(\Carbon\Carbon::parse($payment->payment_date)->translatedFormat(currentDateFormat())); ?>

                            <?php echo e(\Carbon\Carbon::parse($payment->payment_date)->isoFormat('hh:mm A')); ?></td>
                        <td><?php echo e($payment->invoice->invoice_id); ?></td>
                        <?php if(getLogInUser()->hasRole('admin')): ?>
                            <td><?php echo e($payment->invoice->client->user->full_name); ?></td>
                        <?php endif; ?>
                        <td class="right-align">
                            <?php echo e(getInvoiceCurrencyAmount($payment->amount, $payment->invoice->currency_id, true)); ?></td>
                            
                        <td><?php echo e(!empty($payment->payment_mode) ? \App\Models\Payment::PAYMENT_MODE[$payment->payment_mode] : ''); ?>

                        </td>
                        
                        <?php if($payment->is_approved == \App\Models\Payment::APPROVED && $payment->payment_mode == 1): ?>
                            <td><?php echo e(\App\Models\Payment::PAID); ?></td>
                        <?php elseif($payment->is_approved == \App\Models\Payment::PENDING && $payment->payment_mode == 1): ?>
                            <td><?php echo e(\App\Models\Payment::PROCESSING); ?></td>
                        <?php elseif($payment->is_approved == \App\Models\Payment::REJECTED && $payment->payment_mode == 1): ?>
                            <td><?php echo e(\App\Models\Payment::DENIED); ?></td>
                        <?php else: ?>
                            <td><?php echo e(\App\Models\Payment::PAID); ?></td>
                        <?php endif; ?>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <tr>
                    <td class="text-center" colspan="<?php echo e(getLogInUser()->hasRole('admin') ? 8 : 5); ?>">
                        <?php echo e(__('messages.no_records_found')); ?></td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\invoices\resources\views/transactions/export_transactions_pdf.blade.php ENDPATH**/ ?>