<!DOCTYPE HTML>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
    <link rel="icon" href="<?php echo e(asset('web/media/logos/favicon.ico')); ?>" type="image/png">
    <title><?php echo e(__('messages.quote.quote_pdf')); ?></title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/css/invoice-pdf.css')); ?>" rel="stylesheet" type="text/css" />
    <style>
        * {
            font-family: DejaVu Sans, Arial, "Helvetica", Arial, "Liberation Sans", sans-serif;
            line-height: 1.5;
            margin: 0;
            padding: 0;
        }

        @page {
            margin: 0 !important;
            padding: 0 !important;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        .w-100 {
            width: 100%;
        }

        <?php if(getCurrencySymbol() == '€'): ?>
            .euroCurrency {
                font-family: Arial, "Helvetica", Arial, "Liberation Sans", sans-serif;
            }
        <?php endif; ?>

        @import url(https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap);
        @import url(https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;500;600;700&display=swap);
        @import url(https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap);

        .invoice-header {
            text-align: left;
            margin-top: 3rem;
            margin-bottom: 2rem;
        }

        .border-top {
            border-top: 1px solid #83b130 !important;
        }

        .border-bottom {
            border-bottom: 1px solid #83b130 !important;
        }

        .border-bottom-gray {
            border-bottom: 1px solid #c0c0c0 !important;
        }

        .border-0 {
            border: 0px solid white !important;
        }

        .product-table,
        .total-table {
            margin: 0;
        }

        .product-table tr th,
        .product-table tr td,
        .total-table tr th,
        .total-table tr td {
            border: 0px solid white !important;
            padding: 6px 0 !important;
        }

        .text-end {
            text-align: right !important;
        }

        .companylogo {
            text-align: left;
            margin: 0;
            padding: 0;
        }

        .invoice-header-inner {
            text-align: right;
        }

        .invoice-header-inner h3 {
            margin: 0;
            padding: 0;
        }

        .details-section {
            margin-bottom: 3rem;
        }

        .invoice-header p {
            color: #555;
            font-size: 16px;
            margin: 5px 0;
        }

        .text-color {
            color: #999999;
        }

        .invoice-date {
            padding: 15px 0;
            border-top: 1px solid #c0c0c0;
            border-right: 1px solid #c0c0c0;
            border-bottom: 1px solid #c0c0c0;
        }

        .billedto {
            padding: 15px 20px;
            border-top: 1px solid #c0c0c0;
            border-right: 1px solid #c0c0c0;
            border-bottom: 1px solid #c0c0c0;
        }

        .from {
            padding: 15px 20px;
            border-top: 1px solid #c0c0c0;
            border-left: 1px solid #c0c0c0;
            border-bottom: 1px solid #c0c0c0;
        }

        .notes-terms {
            margin-top: 3rem;
            padding: 0 15px;
        }

        .regards {
            margin-top: 2rem;
            padding: 0 15px;
        }

        body {
            font-family: "Lato", DejaVu Sans, sans-serif;
            padding: 30px;
            font-size: 14px;
        }

        .font-color-gray {
            color: #7a7a7a;
        }

        .main-heading {
            font-size: 34px;
            font-weight: bold;
            text-transform: uppercase;
        }

        .header-right {
            text-align: right;
            vertical-align: top;
        }

        .logo,
        .company-name {
            margin-bottom: 8px;
            margin-left: 15px;
        }

        .font-weight-bold {
            font-weight: bold;
        }

        .address {
            margin-top: 60px;
        }

        .address tr:first-child td {
            padding-bottom: 10px;
        }

        .d-items-table {
            width: 100%;
            border: 0;
            border-collapse: collapse;
            margin-top: 40px;
        }

        .d-items-table thead {
            background: #2f353a;
            color: #fff;
        }

        .d-items-table td,
        .d-items-table th {
            padding: 8px;
            font-size: 14px;
            border-bottom: 1px solid #ccc;
            text-align: left;
            vertical-align: top;
        }

        .d-invoice-footer {
            margin-top: 15px;
            width: 80%;
            float: right;
            text-align: right;
        }

        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 40px;
        }

        .items-table td,
        .items-table th {
            padding: 8px;
            font-size: 14px;
            text-align: left;
            vertical-align: top;
        }

        .invoice-footer {
            margin-top: 15px;
            width: 100%;
            text-align: right;
        }

        .number-align {
            text-align: right !important;
        }

        .invoice-currency-symbol {
            font-family: "DejaVu Sans";
        }

        .vertical-align-top {
            vertical-align: text-top;
        }

        .tu {
            text-transform: uppercase;
        }

        .l-col-66 {
            width: 100%;
        }

        .thank {
            font-size: 45px;
            line-height: 1.2em;
            text-align: center;
            font-style: italic;
            padding-right: 25px;
        }

        .to-font-size {
            font-size: 15px;
        }

        .from-font-size {
            font-size: 15px;
        }

        .right-align {
            text-align: right !important;
        }

        .border-b {
            border-bottom: 1px solid #000000;
        }

        .border-t {
            border-top: 1px solid #000000;
        }

        .bg-black {
            background-color: #000000;
        }

        .bg-gray {
            background-color: #eaebec;
        }

        .bg-gray-100 {
            background-color: #f2f2f2;
        }

        .bg-danger {
            background-color: #d71920;
        }

        .bg-purple {
            background-color: #b57ebf;
        }

        .text-purple {
            color: #b57ebf;
        }

        .border-b-gray {
            border-bottom: 1px solid #bbbdbf;
        }

        .text-end {
            text-align: right !important;
        }

        .ps-5rem {
            padding-left: 5rem;
        }

        .header-section {
            position: relative !important;
            overflow: hidden;
        }

        .header-section::after {
            position: absolute;
            content: "";
            width: 116% !important;
            height: 100%;
            background-color: white;
            top: 0;
            left: -53px;
            transform: skew(35deg);
            z-index: 0;
        }

        .header-section table {
            position: relative;
            z-index: 2;
        }

        .header-section .invoice-text {
            position: relative !important;
        }

        .header-section .invoice-text::after {
            position: absolute;
            content: "";
            width: 26%;
            height: 100%;
            background-color: white;
            top: 0;
            left: 93%;
            transform: skew(35deg);
        }

        .istanbul-template {
            font-family: "Open Sans", sans-serif;
        }

        .istanbul-template strong {
            font-weight: bold;
        }

        .istanbul-template .invoice-header .heading-text {
            position: relative;
            z-index: 2;
        }

        .istanbul-template .invoice-table {
            border-bottom: 0.5px solid #c6c6c6;
            font-family: "Inter", sans-serif;
        }

        .istanbul-template .invoice-table thead {
            background-color: #fb5c3a;
            color: white;
        }

        .istanbul-template .bottom-line {
            height: 30px;
            width: 100%;
            background-color: #fb3f01;
            position: relative;
            overflow: hidden;
        }

        .istanbul-template .bottom-line::after {
            position: absolute;
            content: "";
            width: 62%;
            height: 100%;
            background-color: #0e1c45;
            top: 0;
            left: -15px;
            transform: skew(35deg);
            z-index: 0;
        }

        .font-gray-900 {
            color: #1a1c21 !important;
        }

        .font-gray-600 {
            color: #5e6470 !important;
        }

        .font-orange {
            color: #fb3f01;
        }

        .border-top-gray {
            border-top: 1px solid #c6c6c6;
        }

        .z-10 {
            z-index: 10;
        }

        .px-10 {
            padding-left: 40px;
            padding-right: 40px;
        }

        .h-25px {
            height: 20px;
        }

        .h-125px {
            height: 100px;
        }

        .mumbai-template {
            font-family: "Open Sans", sans-serif;
            background-color: #000 !important;
        }

        .mumbai-template .top-border {
            width: 100%;
            height: 10px;
            background-color: #3f478b;
        }

        .mumbai-template .bottom-border {
            width: 100%;
            height: 15px;
            background-color: #3f478b;
        }

        .mumbai-template .heading-text {
            background-color: #3f478b;
        }

        .mumbai-template .invoice-table {
            font-family: "Inter", sans-serif;
            border-bottom: 0.5px solid #c6c6c6;
        }

        .mumbai-template .invoice-table thead {
            background-color: #3f478b;
            color: white;
        }

        .mumbai-template .invoice-table thead th:first-child {
            border-top-left-radius: 6px;
            border-bottom-left-radius: 6px;
        }

        .mumbai-template .invoice-table thead th:last-child {
            border-top-right-radius: 6px;
            border-bottom-right-radius: 6px;
        }

        .mumbai-template .invoice-table tbody tr:nth-child(even) {
            background-color: #ededed;
        }

        .mumbai-template .total-amount {
            background-color: #3f478b;
            color: white;
            border-radius: 6px;
        }

        .mumbai-template .total-amount td:first-child {
            border-top-left-radius: 6px;
            border-bottom-left-radius: 6px;
        }

        .mumbai-template .total-amount td:last-child {
            border-top-right-radius: 6px;
            border-bottom-right-radius: 6px;
        }

        .text-indigo {
            color: #3f478b;
        }

        .hongkong-template {
            font-family: "Open Sans", sans-serif;
            font-size: 12px;
            font-weight: medium;
        }

        .hongkong-template strong {
            font-weight: bold;
        }

        .hongkong-template .invoice-header .heading-text {
            position: relative;
        }

        .hongkong-template .invoice-header .heading-text h1 {
            color: #008fff;
            position: relative;
        }

        .hongkong-template .invoice-table {
            font-family: "Inter", sans-serif;
            border-bottom: 0.5px solid #c6c6c6;
        }

        .hongkong-template .invoice-table thead {
            background-color: #008fff;
            color: white;
            border: 1px solid transparent;
            overflow: hidden;
        }

        .hongkong-template .invoice-table thead th:first-child {
            border-top-left-radius: 6px;
            border-bottom-left-radius: 6px;
        }

        .hongkong-template .invoice-table thead th:last-child {
            border-top-right-radius: 6px;
            border-bottom-right-radius: 6px;
        }

        .hongkong-template .invoice-table tbody tr:nth-child(even) {
            background-color: #ededed;
        }

        .hongkong-template .total-amount {
            background-color: #008fff;
            color: white;
            border-radius: 6px;
        }

        .hongkong-template .total-amount td:first-child {
            border-top-left-radius: 6px;
            border-bottom-left-radius: 6px;
        }

        .hongkong-template .total-amount td:last-child {
            border-top-right-radius: 6px;
            border-bottom-right-radius: 6px;
        }

        .text-yellow {
            color: #f18a1b;
        }

        .text-gray-600 {
            color: #6d6e70;
        }

        .tokyo-template {
            font-family: "Open Sans", sans-serif;
        }

        .tokyo-template strong {
            font-weight: bold;
        }

        .tokyo-template .heading-text h1 {
            font-size: 36px;
            font-weight: 400;
            letter-spacing: 4px;
        }

        @media (max-width: 424px) {
            .tokyo-template .heading-text h1 {
                font-size: 24px;
            }
        }

        .tokyo-template .invoice-table thead {
            text-transform: uppercase;
            background-color: #363b45;
            color: white;
        }

        .tokyo-template .invoice-table thead tr th {
            padding: 10px;
        }

        .tokyo-template .invoice-table tbody tr td {
            border-bottom: 0.5px solid #bbbdbf;
            padding: 10px;
        }

        .tokyo-template .invoice-table tbody tr td:nth-child(1) {
            width: 5%;
        }

        .tokyo-template .invoice-table tbody tr td:nth-child(2) {
            width: 60%;
        }

        .tokyo-template .invoice-table tbody tr td:nth-child(1),
        .tokyo-template .invoice-table tbody tr td:nth-child(4),
        .tokyo-template .invoice-table tbody tr td:nth-child(6) {
            background-color: #eaebec;
        }

        .tokyo-template .total-amount {
            border-top: 1px solid #363b45;
        }

        .font-dark-gray {
            color: #363b45;
        }

        .paris-template {
            font-family: "Inter", sans-serif;
            font-size: 12px;
        }

        .paris-template .heading-text {
            padding: 0;
        }

        .paris-template .heading-text h1 {
            font-size: 36px;
            font-weight: 700;
            letter-spacing: 4px;
            display: inline-block;
        }

        @media (max-width: 496px) {
            .paris-template .heading-text h1 {
                font-size: 24px;
            }
        }

        @media (max-width: 424px) {
            .paris-template .heading-text h1 {
                font-size: 24px;
            }
        }

        .paris-template .invoice-table {
            font-family: "Inter", sans-serif;
            border-bottom: 0.5px solid #c6c6c6;
        }

        .paris-template .invoice-table thead {
            background-color: #fab806;
            color: white;
        }

        .paris-template .invoice-table tbody tr:nth-child(even) {
            background-color: #ededed;
        }

        .p-10px {
            padding: 10px;
        }

        .font-black-900 {
            color: #242424;
        }

        .fw-6 {
            font-weight: bolder;
        }

        .text-yellow-500 {
            color: #fab806;
        }

        .text-green {
            color: #9dc23b;
        }

        .bg-light {
            background-color: #f8f9fa;
        }

        .img-logo {
            max-width: 100px;
            max-height: 66px;
        }

        @media (max-width: 424px) {
            .img-logo {
                max-width: 75px;
            }
        }

        .w-10 {
            width: 10%;
        }

        .w-30 {
            width: 30% !important;
        }

        .py-10 {
            padding-top: 2.5rem !important;
            padding-bottom: 2.5rem !important;
        }


        .py-2 {
            /* padding-top: 15px !important; */
            padding-bottom: 10px !important;
        }

        .pe-10 {
            padding-right: 2.5rem !important;
        }

        .ps-sm-10 {
            padding-left: 2.5rem !important;
        }

        .fs-5 {
            font-size: 0.938rem !important;
        }

        .my-4 {
            margin-top: 1.5rem !important;
        }

        .pt-2 {
            padding-top: 20px !important;
        }

        .pt-1 {
            padding-top: 10px !important;
        }

        .py-1 {
            padding-top: 10px !important;
            padding-bottom: 10px !important;
        }

        .py-5 {
            padding-top: 5px !important;
            padding-bottom: 5px !important;
        }

        .px-2 {
            padding-left: 10px !important;
            padding-right: 10px !important;
        }

        .p-2 {
            padding: 10px !important;
        }

        .text-white {
            color: #fff !important;
        }

        .bg-white {
            background-color: #fff !important;
        }

        .m-0 {
            margin: 0 !important;
        }

        .p-0 {
            padding: 0 !important;
        }

        .px-4 {
            padding-left: 1.5rem !important;
            padding-right: 1.5rem !important;
        }

        .py-4 {
            padding-top: 1.5rem !important;
            padding-bottom: 1.5rem !important;
        }

        .pb-3 {
            padding-bottom: 1rem !important;
        }

        .mb-10 {
            margin-bottom: 2.5rem !important;
        }

        .mb-2 {
            margin-bottom: 10px !important;
        }

        .mb-1 {
            margin-bottom: 5px !important;
        }

        .text-start {
            text-align: left !important;
        }

        .my-5 {
            margin-top: 2.5rem !important;
            margin-bottom: 2.5rem !important;
        }

        @media only screen and (max-width: 640px) {
            .client-preview {
                zoom: 1;
            }
        }

        .preview-main {
            flex: 3;
        }
    </style>
</head>

<body style="padding: 0rem 2rem;">
    <?php $styleCss = 'style'; ?>
    <div class="preview-main client-preview mumbai-template">
        <div class="d" id="boxes">
            <div class="d-inner">
                <div class="top-border" style="background-color: <?php echo e($invoice_template_color); ?>;"></div>
                <div style="background-color: <?php echo e($invoice_template_color); ?>;">
                    <table class="pb-10 bg-white w-100 m-0" style="overflow:hidden;">
                        <tr>
                            <td class="p-0 m-0" style="width:66%; overflow:hidden !important;  ">
                                <div class="bg-white" style=" border-top-right-radius:30px; padding:24.5px;">
                                    <img width="100px" height="66px" src="<?php echo e(getPDFLogoUrl()); ?>" class="img-logo"
                                        alt="logo">
                                </div>
                            </td>
                            <td class="bg-white p-0 m-0"
                                style="width:33%;border-bottom-left-radius:30px; overflow:hidden;">
                                <div class="text-end p-4 pt-10"
                                    style=" background-color: <?php echo e($invoice_template_color); ?>;">
                                    <h1 class="m-0 pt-4 text-white pe-2"
                                        style=" font-size: 40px; font-weight:700; letter-spacing: 4px;">
                                        <?php echo e(__('messages.quote.quote_name')); ?></h1>
                                </div>
                            </td>
                        </tr>
                    </table>
                    <div class="px-4 py-4 bg-white" style="margin-right:10px;">
                        <div class="pb-3">
                            <table class="w-100">
                                <tbody>
                                    <tr style="vertical-align:top;">
                                        <td width="33.33%">
                                            <p class="fs-6 mb-2 font-gray-900">
                                                <strong><?php echo e(__('messages.common.to') . ':'); ?></strong>
                                            </p>
                                            <p class=" mb-1 font-color-gray fs-6">
                                                <?php echo e(__('messages.common.name') . ':'); ?>

                                                <span class="font-gray-900"><?php echo e($client->user->full_name); ?></span>
                                            </p>
                                            <p class=" mb-1 font-color-gray fs-6">
                                                <?php echo e(__('messages.common.email') . ':'); ?>

                                                <span class="font-gray-900"><?php echo e($client->user->email); ?></span>
                                            </p>
                                            <p class=" mb-1  font-color-gray fs-6">
                                                <?php echo e(__('messages.common.address') . ':'); ?>

                                                <span class="font-gray-900"><?php echo e($client->address); ?> </span>
                                            </p>
                                            <?php if(!empty($client->vat_no)): ?>
                                                <p class=" mb-1  font-color-gray fs-6">
                                                    <?php echo e(getVatNoLabel() . ':'); ?>

                                                    <span class="font-gray-900"><?php echo e($client->vat_no); ?> </span>
                                                </p>
                                            <?php endif; ?>
                                        </td>
                                        <td width="33.33%">
                                            <p class="fs-6 mb-2 font-gray-900">
                                                <strong><?php echo e(__('messages.common.from') . ':'); ?></strong>
                                            </p>
                                            <p class="mb-1 font-color-gray fw-bold fs-6">
                                                <?php echo e(__('messages.setting.company_name') . ':'); ?>&nbsp; <span
                                                    class="font-gray-900"><?php echo $setting['company_name']; ?></span></p>
                                            <p class=" mb-1 font-color-gray fw-bold fs-6">
                                                <?php echo e(__('messages.common.address') . ':'); ?>&nbsp; <span
                                                    class="font-gray-900"><?php echo $setting['company_address']; ?></span></p>
                                            <?php if(isset($setting['show_additional_address_in_invoice']) && $setting['show_additional_address_in_invoice'] == 1): ?>
                                                <p class=" m-0 font-color-gray fs-6">
                                                    <?php echo e($setting['zipcode'] . ', ' . $setting['city'] . ', ' . $setting['state'] . ', ' . $setting['country']); ?>

                                                </p>
                                            <?php endif; ?>
                                            <p class=" mb-1 font-color-gray  fw-bold fs-6">
                                                <?php echo e(__('messages.user.phone') . ':'); ?>&nbsp; <span
                                                    class="font-gray-900"><?php echo e($setting['company_phone']); ?></span></p>
                                            <?php if(isset($setting['show_additional_address_in_invoice']) && $setting['show_additional_address_in_invoice'] == 1): ?>
                                                <p class="mb-1 font-color-gray  fw-bold fs-6">
                                                    <strong><?php echo e(__('messages.invoice.fax_no') . ':'); ?>&nbsp;</strong><span
                                                        class="font-gray-900"><?php echo e($setting['fax_no']); ?></span>
                                                <p>
                                            <?php endif; ?>
                                            <?php if(!empty($setting['gst_no'])): ?>
                                                <p class="mb-1 font-color-gray fs-6">
                                                    <?php echo e(getVatNoLabel() . ':'); ?>

                                                    <span class="font-gray-900"><?php echo e($setting['gst_no']); ?> </span>
                                                </p>
                                            <?php endif; ?>
                                        </td>
                                        <td width="33.33%" class="text-end pt-7">
                                            <p class="mb-1 text-gray-600 fs-6"><strong
                                                    class="font-gray-900"><?php echo e(__('messages.quote.quote_id') . ':'); ?>

                                                </strong>#<?php echo e($quote->quote_id); ?>

                                            </p>
                                            <p class="mb-1 text-gray-600 fs-6"><strong
                                                    class="font-gray-900"><?php echo e(__('messages.quote.quote_date') . ':'); ?>

                                                </strong><?php echo e(\Carbon\Carbon::parse($quote->quote_date)->translatedFormat(currentDateFormat())); ?>

                                            </p>
                                            <p class="mb-1 text-gray-600 fs-6"><strong
                                                    class="font-gray-900"><?php echo e(__('messages.quote.due_date') . ':'); ?>&nbsp;
                                                </strong><?php echo e(\Carbon\Carbon::parse($quote->due_date)->translatedFormat(currentDateFormat())); ?>

                                            </p>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="overflow-auto">
                            <table class="invoice-table w-100">
                                <thead style="background-color: <?php echo e($invoice_template_color); ?>;">
                                    <tr>
                                        <th class="py-1 px-2 text-uppercase text-start" style="width:5% !important;">#
                                        </th>
                                        <th class="in-w-2 text-uppercase text-start">
                                            <?php echo e(__('messages.product.product')); ?>

                                        </th>
                                        <th class="text-center text-uppercase" style="width:9% !important;">
                                            <?php echo e(__('messages.invoice.qty')); ?>

                                        </th>
                                        <th class="text-center  text-nowrap text-uppercase"
                                            style="width:15% !important;">
                                            <?php echo e(__('messages.product.unit_price')); ?></th>
                                        <th class="text-center  text-nowrap text-uppercase"
                                            style="width:15% !important;">
                                            <?php echo e(__('messages.invoice.tax') . '(in %)'); ?>

                                        </th>
                                        <th class="text-end px-2 text-nowrap text-uppercase"
                                            style="width:14% !important;">
                                            <?php echo e(__('messages.invoice.amount')); ?>

                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if(isset($quote) && !empty($quote)): ?>
                                        <?php $__currentLoopData = $quote->quoteItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $quoteItems): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td class="p-2" style="width:5%;">
                                                    <span><?php echo e($key + 1); ?></span>
                                                </td>
                                                <td class="p-2 in-w-2">
                                                    <p class="fw-bold mb-0">
                                                        <?php echo e(isset($quoteItems->product->name) ? $quoteItems->product->name : $quoteItems->product_name ?? __('messages.common.n/a')); ?>

                                                    </p>
                                                    <?php if(
                                                        !empty($quoteItems->product->description) &&
                                                            (isset($setting['show_product_description']) && $setting['show_product_description'] == 1)): ?>
                                                        <span
                                                            style="font-size: 12px; word-break: break-all"><?php echo e($quoteItems->product->description); ?></span>
                                                    <?php endif; ?>
                                                </td>
                                                <td class="p-2 text-center">
                                                    <?php echo e(number_format($quoteItems->quantity, 2)); ?>

                                                </td>
                                                <td class="p-2 text-center text-nowrap euroCurrency">
                                                    <?php echo e(isset($quoteItems->price) ? getCurrencyAmount($quoteItems->price, true) : __('messages.common.n/a')); ?>

                                                </td>
                                                <td class="p-2 text-center">
                                                    <?php $__currentLoopData = $quoteItems->quoteItemTax; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $keys => $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php echo e($tax->tax ?? '--'); ?>

                                                        <?php if(!$loop->last): ?>
                                                            ,
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </td>
                                                <td class="p-2 text-end text-nowrap euroCurrency">
                                                    <?php echo e(isset($quoteItems->total) ? getCurrencyAmount($quoteItems->total, true) : __('messages.common.n/a')); ?>

                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="my-5">
                            <table class="w-100">
                                <tr>
                                    <td style="vertical-align:bottom; width:60%;">
                                    </td>
                                    <td style="vertical-align:top; width:40%;">
                                        <table class="w-100">
                                            <tbody>
                                                <tr>
                                                    <td class="py-5 px-2">
                                                        <strong><?php echo e(__('messages.quote.amount') . ':'); ?></strong>
                                                    </td>
                                                    <td class="text-nowrap text-end font-gray-600 py-5 px-2 fw-bold">
                                                        <?php echo e(getCurrencyAmount($quote->amount, true)); ?>

                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="py-5 px-2">
                                                        <strong><?php echo e(__('messages.quote.discount') . ':'); ?></strong>
                                                    </td>
                                                    <td class="text-end font-gray-600 py-5 px-2 fw-bold">
                                                        <?php if($quote->discount == 0): ?>
                                                            <span><?php echo e(__('messages.common.n/a')); ?></span>
                                                        <?php else: ?>
                                                            <?php if(isset($quote) && $quote->discount_type == \App\Models\Quote::FIXED): ?>
                                                                <b
                                                                    class="euroCurrency"><?php echo e(isset($quote->discount) ? getCurrencyAmount($quote->discount, true) : __('messages.common.n/a')); ?></b>
                                                            <?php else: ?>
                                                                <?php echo e($quote->discount); ?><span
                                                                    <?php echo e($styleCss); ?>="font-family: DejaVu Sans">&#37;</span>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <?php
                                                        $itemTaxesAmount = $quote->amount + array_sum($totalTax);
                                                        $quoteTaxesAmount =
                                                            ($itemTaxesAmount * $quote->qouteTaxes->sum('value')) / 100;
                                                        $totalTaxes = array_sum($totalTax) + $quoteTaxesAmount;
                                                    ?>
                                                    <td class="py-1 px-2">
                                                        <strong><?php echo e(__('messages.invoice.tax') . ':'); ?></strong>
                                                    </td>
                                                    <td class="text-end font-gray-600 py-1 px-2 fw-bold">
                                                        <?php echo numberFormat($totalTaxes) != 0
                                                            ? '<b class="euroCurrency">' . getCurrencyAmount($totalTaxes, true) . '</b>'
                                                            : __('messages.common.n/a'); ?>

                                                    </td>
                                                </tr>
                                            </tbody>
                                            <tfoot class="total-amount"
                                                <?php echo e($styleCss); ?>="background-color: <?php echo e($invoice_template_color); ?>;">
                                                <tr>
                                                    <td class="p-2">
                                                        <strong><?php echo e(__('messages.quote.total') . ':'); ?></strong>
                                                    </td>
                                                    <td class="text-nowrap text-end p-2">
                                                        <strong><?php echo e(getCurrencyAmount($quote->final_amount, true)); ?></strong>
                                                    </td>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </div>
                        <div class="mt-20">
                            <div class="position-relative">
                                <div class="mb-5">
                                    <h4 class="font-gray-900 mb5"><b><?php echo e(__('messages.client.notes') . ':'); ?></b></h4>
                                    <p class="font-gray-600"
                                        style="word-break: break-word; overflow-wrap: break-word; white-space: normal; display: block;">
                                        <?php echo nl2br($quote->note ?? __('messages.common.n/a')); ?>

                                    </p>
                                </div>
                                <div class="w-75">
                                    <h4 class="font-gray-900 mb5">
                                        <b><?php echo e(__('messages.invoice.terms') . ':'); ?></b>
                                    </h4>
                                    <p class="font-gray-600 mb-0"
                                        style="word-break: break-word; overflow-wrap: break-word; white-space: normal; display: block;">
                                        <?php echo nl2br($quote->term ?? __('messages.common.n/a')); ?></p>
                                </div>
                                <div class="text-end">
                                    <h2 class="text-indigo mt-2"
                                        <?php echo e($styleCss); ?>="color:<?php echo e($invoice_template_color); ?>">
                                        <b><?php echo e(__('messages.setting.regards') . ':'); ?></b>
                                    </h2>
                                    <p class="fs-6 mb-0"><b> <?php echo e(getAppName()); ?></b></p>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div>
                        <table class="bg-white w-100">
                            <tr>
                                <td class="p-0 h-25px" style="width:80% !important; overflow:hidden;">
                                    <div class="bg-white h-25px"
                                        style=" border-bottom-right-radius:30px; padding:26px;">
                                    </div>
                                </td>
                                <td class="bg-white p-0 h-25px"
                                    style="width:20%; border-top-left-radius:35px; overflow:hidden;">
                                    <div class="text-end h-25px"
                                        style="background-color: <?php echo e($invoice_template_color); ?>;  padding:26px;">
                                    </div>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="bottom-border" style="background-color: <?php echo e($invoice_template_color); ?>;"></div>
                </div>
            </div>
        </div>
    </div>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\invoices\resources\views/quotes/quote_template_pdf/mumbaiTemplate.blade.php ENDPATH**/ ?>